/*******************************************************************
* Creation Date: 02/03/2017   
*   WI_SID_2015q4_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'WI_SID_2015q4_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AMONTH                         10-  11
 ATYPE                          12-  13
 AWEEKEND                       14-  15
 BILLTYPE                       16-  19 (A)
 CPT1                           20-  24 (A)
 CPT2                           25-  29 (A)
 CPT3                           30-  34 (A)
 CPT4                           35-  39 (A)
 CPT5                           40-  44 (A)
 CPT6                           45-  49 (A)
 CPT7                           50-  54 (A)
 CPT8                           55-  59 (A)
 CPT9                           60-  64 (A)
 CPT10                          65-  69 (A)
 CPT11                          70-  74 (A)
 CPT12                          75-  79 (A)
 CPT13                          80-  84 (A)
 CPT14                          85-  89 (A)
 CPT15                          90-  94 (A)
 CPT16                          95-  99 (A)
 CPT17                         100- 104 (A)
 CPT18                         105- 109 (A)
 CPT19                         110- 114 (A)
 CPT20                         115- 119 (A)
 CPT21                         120- 124 (A)
 CPT22                         125- 129 (A)
 CPT23                         130- 134 (A)
 CPT24                         135- 139 (A)
 CPT25                         140- 144 (A)
 CPT26                         145- 149 (A)
 CPT27                         150- 154 (A)
 CPT28                         155- 159 (A)
 CPT29                         160- 164 (A)
 CPT30                         165- 169 (A)
 CPT31                         170- 174 (A)
 CPT32                         175- 179 (A)
 CPT33                         180- 184 (A)
 CPT34                         185- 189 (A)
 CPT35                         190- 194 (A)
 CPT36                         195- 199 (A)
 CPT37                         200- 204 (A)
 CPT38                         205- 209 (A)
 CPT39                         210- 214 (A)
 CPT40                         215- 219 (A)
 CPT41                         220- 224 (A)
 CPT42                         225- 229 (A)
 CPT43                         230- 234 (A)
 CPT44                         235- 239 (A)
 CPT45                         240- 244 (A)
 CPT46                         245- 249 (A)
 CPT47                         250- 254 (A)
 CPT48                         255- 259 (A)
 CPT49                         260- 264 (A)
 CPT50                         265- 269 (A)
 CPT51                         270- 274 (A)
 CPT52                         275- 279 (A)
 CPT53                         280- 284 (A)
 CPTCCS1                       285- 287
 CPTCCS2                       288- 290
 CPTCCS3                       291- 293
 CPTCCS4                       294- 296
 CPTCCS5                       297- 299
 CPTCCS6                       300- 302
 CPTCCS7                       303- 305
 CPTCCS8                       306- 308
 CPTCCS9                       309- 311
 CPTCCS10                      312- 314
 CPTCCS11                      315- 317
 CPTCCS12                      318- 320
 CPTCCS13                      321- 323
 CPTCCS14                      324- 326
 CPTCCS15                      327- 329
 CPTCCS16                      330- 332
 CPTCCS17                      333- 335
 CPTCCS18                      336- 338
 CPTCCS19                      339- 341
 CPTCCS20                      342- 344
 CPTCCS21                      345- 347
 CPTCCS22                      348- 350
 CPTCCS23                      351- 353
 CPTCCS24                      354- 356
 CPTCCS25                      357- 359
 CPTCCS26                      360- 362
 CPTCCS27                      363- 365
 CPTCCS28                      366- 368
 CPTCCS29                      369- 371
 CPTCCS30                      372- 374
 CPTCCS31                      375- 377
 CPTCCS32                      378- 380
 CPTCCS33                      381- 383
 CPTCCS34                      384- 386
 CPTCCS35                      387- 389
 CPTCCS36                      390- 392
 CPTCCS37                      393- 395
 CPTCCS38                      396- 398
 CPTCCS39                      399- 401
 CPTCCS40                      402- 404
 CPTCCS41                      405- 407
 CPTCCS42                      408- 410
 CPTCCS43                      411- 413
 CPTCCS44                      414- 416
 CPTCCS45                      417- 419
 CPTCCS46                      420- 422
 CPTCCS47                      423- 425
 CPTCCS48                      426- 428
 CPTCCS49                      429- 431
 CPTCCS50                      432- 434
 CPTCCS51                      435- 437
 CPTCCS52                      438- 440
 CPTCCS53                      441- 443
 DaysToEvent                   444- 449
 DIED                          450- 451
 DISP_X                        452- 453 (A)
 DISPUB04                      454- 455
 DISPUNIFORM                   456- 457
 DMONTH                        458- 459
 DQTR                          460- 461
 DRG                           462- 464
 DRG_NoPOA                     465- 467
 DRG32                         468- 470
 DRGVER                        471- 472
 DSHOSPID                      473- 489 (A)
 DXPOA1                        490     (A)
 DXPOA2                        491     (A)
 DXPOA3                        492     (A)
 DXPOA4                        493     (A)
 DXPOA5                        494     (A)
 DXPOA6                        495     (A)
 DXPOA7                        496     (A)
 DXPOA8                        497     (A)
 DXPOA9                        498     (A)
 DXPOA10                       499     (A)
 DXPOA11                       500     (A)
 DXPOA12                       501     (A)
 DXPOA13                       502     (A)
 DXPOA14                       503     (A)
 DXPOA15                       504     (A)
 DXPOA16                       505     (A)
 DXPOA17                       506     (A)
 DXPOA18                       507     (A)
 DXPOA19                       508     (A)
 DXPOA20                       509     (A)
 DXPOA21                       510     (A)
 DXPOA22                       511     (A)
 DXPOA23                       512     (A)
 DXPOA24                       513     (A)
 DXPOA25                       514     (A)
 DXPOA26                       515     (A)
 DXPOA27                       516     (A)
 DXPOA28                       517     (A)
 DXPOA29                       518     (A)
 DXPOA30                       519     (A)
 DXPOA31                       520     (A)
 DXPOA32                       521     (A)
 DXPOA33                       522     (A)
 DXPOA34                       523     (A)
 DXPOA35                       524     (A)
 DXPOA36                       525     (A)
 DXPOA37                       526     (A)
 DXPOA38                       527     (A)
 DXPOA39                       528     (A)
 DXPOA40                       529     (A)
 DXPOA41                       530     (A)
 DXPOA42                       531     (A)
 DXPOA43                       532     (A)
 DXPOA44                       533     (A)
 DXPOA45                       534     (A)
 DXPOA46                       535     (A)
 DXPOA47                       536     (A)
 DXPOA48                       537     (A)
 DXPOA49                       538     (A)
 DXPOA50                       539     (A)
 DXPOA51                       540     (A)
 DXPOA52                       541     (A)
 DXPOA53                       542     (A)
 DXPOA54                       543     (A)
 DXPOA55                       544     (A)
 DXPOA56                       545     (A)
 DXPOA57                       546     (A)
 DXPOA58                       547     (A)
 DXPOA59                       548     (A)
 DXPOA60                       549     (A)
 DXPOA61                       550     (A)
 DXPOA62                       551     (A)
 DXPOA63                       552     (A)
 DXPOA64                       553     (A)
 DXPOA65                       554     (A)
 DXPOA66                       555     (A)
 DXPOA67                       556     (A)
 DXVER                         557- 559
 E_POA1                        560     (A)
 E_POA2                        561     (A)
 E_POA3                        562     (A)
 E_POA4                        563     (A)
 E_POA5                        564     (A)
 E_POA6                        565     (A)
 E_POA7                        566     (A)
 E_POA8                        567     (A)
 E_POA9                        568     (A)
 FEMALE                        569- 570
 HCUP_ED                       571- 572
 HCUP_OS                       573- 574
 HISPANIC                      575- 576
 HISPANIC_X                    577     (A)
 Homeless                      578- 579
 HOSP_NPI                      580- 589 (A)
 HOSPST                        590- 591 (A)
 I10_DX_Admitting              592- 598 (A)
 I10_DX1                       599- 605 (A)
 I10_DX2                       606- 612 (A)
 I10_DX3                       613- 619 (A)
 I10_DX4                       620- 626 (A)
 I10_DX5                       627- 633 (A)
 I10_DX6                       634- 640 (A)
 I10_DX7                       641- 647 (A)
 I10_DX8                       648- 654 (A)
 I10_DX9                       655- 661 (A)
 I10_DX10                      662- 668 (A)
 I10_DX11                      669- 675 (A)
 I10_DX12                      676- 682 (A)
 I10_DX13                      683- 689 (A)
 I10_DX14                      690- 696 (A)
 I10_DX15                      697- 703 (A)
 I10_DX16                      704- 710 (A)
 I10_DX17                      711- 717 (A)
 I10_DX18                      718- 724 (A)
 I10_DX19                      725- 731 (A)
 I10_DX20                      732- 738 (A)
 I10_DX21                      739- 745 (A)
 I10_DX22                      746- 752 (A)
 I10_DX23                      753- 759 (A)
 I10_DX24                      760- 766 (A)
 I10_DX25                      767- 773 (A)
 I10_DX26                      774- 780 (A)
 I10_DX27                      781- 787 (A)
 I10_DX28                      788- 794 (A)
 I10_DX29                      795- 801 (A)
 I10_DX30                      802- 808 (A)
 I10_DX31                      809- 815 (A)
 I10_DX32                      816- 822 (A)
 I10_DX33                      823- 829 (A)
 I10_DX34                      830- 836 (A)
 I10_DX35                      837- 843 (A)
 I10_DX36                      844- 850 (A)
 I10_DX37                      851- 857 (A)
 I10_DX38                      858- 864 (A)
 I10_DX39                      865- 871 (A)
 I10_DX40                      872- 878 (A)
 I10_DX41                      879- 885 (A)
 I10_DX42                      886- 892 (A)
 I10_DX43                      893- 899 (A)
 I10_DX44                      900- 906 (A)
 I10_DX45                      907- 913 (A)
 I10_DX46                      914- 920 (A)
 I10_DX47                      921- 927 (A)
 I10_DX48                      928- 934 (A)
 I10_DX49                      935- 941 (A)
 I10_DX50                      942- 948 (A)
 I10_DX51                      949- 955 (A)
 I10_DX52                      956- 962 (A)
 I10_DX53                      963- 969 (A)
 I10_DX54                      970- 976 (A)
 I10_DX55                      977- 983 (A)
 I10_DX56                      984- 990 (A)
 I10_DX57                      991- 997 (A)
 I10_DX58                      998-1004 (A)
 I10_DX59                     1005-1011 (A)
 I10_DX60                     1012-1018 (A)
 I10_DX61                     1019-1025 (A)
 I10_DX62                     1026-1032 (A)
 I10_DX63                     1033-1039 (A)
 I10_DX64                     1040-1046 (A)
 I10_DX65                     1047-1053 (A)
 I10_DX66                     1054-1060 (A)
 I10_DX67                     1061-1067 (A)
 I10_DXCCS1                   1068-1071
 I10_DXCCS2                   1072-1075
 I10_DXCCS3                   1076-1079
 I10_DXCCS4                   1080-1083
 I10_DXCCS5                   1084-1087
 I10_DXCCS6                   1088-1091
 I10_DXCCS7                   1092-1095
 I10_DXCCS8                   1096-1099
 I10_DXCCS9                   1100-1103
 I10_DXCCS10                  1104-1107
 I10_DXCCS11                  1108-1111
 I10_DXCCS12                  1112-1115
 I10_DXCCS13                  1116-1119
 I10_DXCCS14                  1120-1123
 I10_DXCCS15                  1124-1127
 I10_DXCCS16                  1128-1131
 I10_DXCCS17                  1132-1135
 I10_DXCCS18                  1136-1139
 I10_DXCCS19                  1140-1143
 I10_DXCCS20                  1144-1147
 I10_DXCCS21                  1148-1151
 I10_DXCCS22                  1152-1155
 I10_DXCCS23                  1156-1159
 I10_DXCCS24                  1160-1163
 I10_DXCCS25                  1164-1167
 I10_DXCCS26                  1168-1171
 I10_DXCCS27                  1172-1175
 I10_DXCCS28                  1176-1179
 I10_DXCCS29                  1180-1183
 I10_DXCCS30                  1184-1187
 I10_DXCCS31                  1188-1191
 I10_DXCCS32                  1192-1195
 I10_DXCCS33                  1196-1199
 I10_DXCCS34                  1200-1203
 I10_DXCCS35                  1204-1207
 I10_DXCCS36                  1208-1211
 I10_DXCCS37                  1212-1215
 I10_DXCCS38                  1216-1219
 I10_DXCCS39                  1220-1223
 I10_DXCCS40                  1224-1227
 I10_DXCCS41                  1228-1231
 I10_DXCCS42                  1232-1235
 I10_DXCCS43                  1236-1239
 I10_DXCCS44                  1240-1243
 I10_DXCCS45                  1244-1247
 I10_DXCCS46                  1248-1251
 I10_DXCCS47                  1252-1255
 I10_DXCCS48                  1256-1259
 I10_DXCCS49                  1260-1263
 I10_DXCCS50                  1264-1267
 I10_DXCCS51                  1268-1271
 I10_DXCCS52                  1272-1275
 I10_DXCCS53                  1276-1279
 I10_DXCCS54                  1280-1283
 I10_DXCCS55                  1284-1287
 I10_DXCCS56                  1288-1291
 I10_DXCCS57                  1292-1295
 I10_DXCCS58                  1296-1299
 I10_DXCCS59                  1300-1303
 I10_DXCCS60                  1304-1307
 I10_DXCCS61                  1308-1311
 I10_DXCCS62                  1312-1315
 I10_DXCCS63                  1316-1319
 I10_DXCCS64                  1320-1323
 I10_DXCCS65                  1324-1327
 I10_DXCCS66                  1328-1331
 I10_DXCCS67                  1332-1335
 I10_ECAUSE1                  1336-1342 (A)
 I10_ECAUSE2                  1343-1349 (A)
 I10_ECAUSE3                  1350-1356 (A)
 I10_ECAUSE4                  1357-1363 (A)
 I10_ECAUSE5                  1364-1370 (A)
 I10_ECAUSE6                  1371-1377 (A)
 I10_ECAUSE7                  1378-1384 (A)
 I10_ECAUSE8                  1385-1391 (A)
 I10_ECAUSE9                  1392-1398 (A)
 I10_ECauseCCS1               1399-1402
 I10_ECauseCCS2               1403-1406
 I10_ECauseCCS3               1407-1410
 I10_ECauseCCS4               1411-1414
 I10_ECauseCCS5               1415-1418
 I10_ECauseCCS6               1419-1422
 I10_ECauseCCS7               1423-1426
 I10_ECauseCCS8               1427-1430
 I10_ECauseCCS9               1431-1434
 I10_HOSPBRTH                 1435-1437
 I10_NCHRONIC                 1438-1440
 I10_NDX                      1441-1443
 I10_NECAUSE                  1444-1445
 I10_NEOMAT                   1446-1447
 I10_NPR                      1448-1450
 I10_ORPROC                   1451-1452
 I10_PR1                      1453-1459 (A)
 I10_PR2                      1460-1466 (A)
 I10_PR3                      1467-1473 (A)
 I10_PR4                      1474-1480 (A)
 I10_PR5                      1481-1487 (A)
 I10_PR6                      1488-1494 (A)
 I10_PR7                      1495-1501 (A)
 I10_PR8                      1502-1508 (A)
 I10_PR9                      1509-1515 (A)
 I10_PR10                     1516-1522 (A)
 I10_PR11                     1523-1529 (A)
 I10_PR12                     1530-1536 (A)
 I10_PR13                     1537-1543 (A)
 I10_PR14                     1544-1550 (A)
 I10_PR15                     1551-1557 (A)
 I10_PR16                     1558-1564 (A)
 I10_PR17                     1565-1571 (A)
 I10_PR18                     1572-1578 (A)
 I10_PR19                     1579-1585 (A)
 I10_PR20                     1586-1592 (A)
 I10_PR21                     1593-1599 (A)
 I10_PR22                     1600-1606 (A)
 I10_PR23                     1607-1613 (A)
 I10_PR24                     1614-1620 (A)
 I10_PR25                     1621-1627 (A)
 I10_PR26                     1628-1634 (A)
 I10_PR27                     1635-1641 (A)
 I10_PR28                     1642-1648 (A)
 I10_PR29                     1649-1655 (A)
 I10_PR30                     1656-1662 (A)
 I10_PR31                     1663-1669 (A)
 I10_PR32                     1670-1676 (A)
 I10_PR33                     1677-1683 (A)
 I10_PR34                     1684-1690 (A)
 I10_PR35                     1691-1697 (A)
 I10_PR36                     1698-1704 (A)
 I10_PR37                     1705-1711 (A)
 I10_PR38                     1712-1718 (A)
 I10_PR39                     1719-1725 (A)
 I10_PR40                     1726-1732 (A)
 I10_PR41                     1733-1739 (A)
 I10_PR42                     1740-1746 (A)
 I10_PR43                     1747-1753 (A)
 I10_PR44                     1754-1760 (A)
 I10_PR45                     1761-1767 (A)
 I10_PR46                     1768-1774 (A)
 I10_PR47                     1775-1781 (A)
 I10_PR48                     1782-1788 (A)
 I10_PR49                     1789-1795 (A)
 I10_PR50                     1796-1802 (A)
 I10_PRCCS1                   1803-1805
 I10_PRCCS2                   1806-1808
 I10_PRCCS3                   1809-1811
 I10_PRCCS4                   1812-1814
 I10_PRCCS5                   1815-1817
 I10_PRCCS6                   1818-1820
 I10_PRCCS7                   1821-1823
 I10_PRCCS8                   1824-1826
 I10_PRCCS9                   1827-1829
 I10_PRCCS10                  1830-1832
 I10_PRCCS11                  1833-1835
 I10_PRCCS12                  1836-1838
 I10_PRCCS13                  1839-1841
 I10_PRCCS14                  1842-1844
 I10_PRCCS15                  1845-1847
 I10_PRCCS16                  1848-1850
 I10_PRCCS17                  1851-1853
 I10_PRCCS18                  1854-1856
 I10_PRCCS19                  1857-1859
 I10_PRCCS20                  1860-1862
 I10_PRCCS21                  1863-1865
 I10_PRCCS22                  1866-1868
 I10_PRCCS23                  1869-1871
 I10_PRCCS24                  1872-1874
 I10_PRCCS25                  1875-1877
 I10_PRCCS26                  1878-1880
 I10_PRCCS27                  1881-1883
 I10_PRCCS28                  1884-1886
 I10_PRCCS29                  1887-1889
 I10_PRCCS30                  1890-1892
 I10_PRCCS31                  1893-1895
 I10_PRCCS32                  1896-1898
 I10_PRCCS33                  1899-1901
 I10_PRCCS34                  1902-1904
 I10_PRCCS35                  1905-1907
 I10_PRCCS36                  1908-1910
 I10_PRCCS37                  1911-1913
 I10_PRCCS38                  1914-1916
 I10_PRCCS39                  1917-1919
 I10_PRCCS40                  1920-1922
 I10_PRCCS41                  1923-1925
 I10_PRCCS42                  1926-1928
 I10_PRCCS43                  1929-1931
 I10_PRCCS44                  1932-1934
 I10_PRCCS45                  1935-1937
 I10_PRCCS46                  1938-1940
 I10_PRCCS47                  1941-1943
 I10_PRCCS48                  1944-1946
 I10_PRCCS49                  1947-1949
 I10_PRCCS50                  1950-1952
 I10_PROCTYPE                 1953-1955
 I10_SERVICELINE              1956-1957
 KEY                          1958-1972
 LOS                          1973-1977
 LOS_X                        1978-1983
 MDC                          1984-1985
 MDC_NoPOA                    1986-1987
 MDC32                        1988-1989
 MDSPEC1                      1990-1992 (A)
 MDSPEC2                      1993-1995 (A)
 MEDINCSTQ                    1996-1997
 MRN_R                        1998-2006
 NCPT                         2007-2010
 OS_TIME                      2011-2021
 PAY1                         2022-2023
 PAY1_X                       2024-2028 (A)
 PAY2                         2029-2030
 PAY2_X                       2031-2035 (A)
 PL_CBSA                      2036-2038
 PL_NCHS                      2039-2040
 PL_RUCC                      2041-2042
 PL_UIC                       2043-2044
 PL_UR_CAT4                   2045-2046
 POA_Disch_Edit1              2047-2048
 POA_Disch_Edit2              2049-2050
 POA_Hosp_Edit1               2051-2052
 POA_Hosp_Edit2               2053-2054
 POA_Hosp_Edit3               2055-2056
 POA_Hosp_Edit3_Value         2057-2064
 PointOfOrigin_X              2065     (A)
 PointOfOriginUB04            2066     (A)
 PRDAY1                       2067-2071
 PRVER                        2072-2074
 PSTATE                       2075-2076 (A)
 PSTCO2                       2077-2081
 RACE                         2082-2083
 RACE_X                       2084-2085 (A)
 TOTCHG                       2086-2095
 TOTCHG_X                     2096-2110
 TRAN_IN                      2111-2112
 TRAN_OUT                     2113-2114
 VisitLink                    2115-2123
 YEAR                         2124-2127
 ZIP                          2128-2132 (A)
 ZIP3                         2133-2135 (A)
 ZIPINC_QRTL                  2136-2138
 AYEAR                        2139-2142
 BMONTH                       2143-2144
 BYEAR                        2145-2148
 PRMONTH1                     2149-2150
 PRYEAR1                      2151-2154.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 DaysToEvent                  (F8.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRG32                        (F3.0) /
 DRGVER                       (F3.0) /
 DXVER                        (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_DXCCS1                   (F4.0) /
 I10_DXCCS2                   (F4.0) /
 I10_DXCCS3                   (F4.0) /
 I10_DXCCS4                   (F4.0) /
 I10_DXCCS5                   (F4.0) /
 I10_DXCCS6                   (F4.0) /
 I10_DXCCS7                   (F4.0) /
 I10_DXCCS8                   (F4.0) /
 I10_DXCCS9                   (F4.0) /
 I10_DXCCS10                  (F4.0) /
 I10_DXCCS11                  (F4.0) /
 I10_DXCCS12                  (F4.0) /
 I10_DXCCS13                  (F4.0) /
 I10_DXCCS14                  (F4.0) /
 I10_DXCCS15                  (F4.0) /
 I10_DXCCS16                  (F4.0) /
 I10_DXCCS17                  (F4.0) /
 I10_DXCCS18                  (F4.0) /
 I10_DXCCS19                  (F4.0) /
 I10_DXCCS20                  (F4.0) /
 I10_DXCCS21                  (F4.0) /
 I10_DXCCS22                  (F4.0) /
 I10_DXCCS23                  (F4.0) /
 I10_DXCCS24                  (F4.0) /
 I10_DXCCS25                  (F4.0) /
 I10_DXCCS26                  (F4.0) /
 I10_DXCCS27                  (F4.0) /
 I10_DXCCS28                  (F4.0) /
 I10_DXCCS29                  (F4.0) /
 I10_DXCCS30                  (F4.0) /
 I10_DXCCS31                  (F4.0) /
 I10_DXCCS32                  (F4.0) /
 I10_DXCCS33                  (F4.0) /
 I10_DXCCS34                  (F4.0) /
 I10_DXCCS35                  (F4.0) /
 I10_DXCCS36                  (F4.0) /
 I10_DXCCS37                  (F4.0) /
 I10_DXCCS38                  (F4.0) /
 I10_DXCCS39                  (F4.0) /
 I10_DXCCS40                  (F4.0) /
 I10_DXCCS41                  (F4.0) /
 I10_DXCCS42                  (F4.0) /
 I10_DXCCS43                  (F4.0) /
 I10_DXCCS44                  (F4.0) /
 I10_DXCCS45                  (F4.0) /
 I10_DXCCS46                  (F4.0) /
 I10_DXCCS47                  (F4.0) /
 I10_DXCCS48                  (F4.0) /
 I10_DXCCS49                  (F4.0) /
 I10_DXCCS50                  (F4.0) /
 I10_DXCCS51                  (F4.0) /
 I10_DXCCS52                  (F4.0) /
 I10_DXCCS53                  (F4.0) /
 I10_DXCCS54                  (F4.0) /
 I10_DXCCS55                  (F4.0) /
 I10_DXCCS56                  (F4.0) /
 I10_DXCCS57                  (F4.0) /
 I10_DXCCS58                  (F4.0) /
 I10_DXCCS59                  (F4.0) /
 I10_DXCCS60                  (F4.0) /
 I10_DXCCS61                  (F4.0) /
 I10_DXCCS62                  (F4.0) /
 I10_DXCCS63                  (F4.0) /
 I10_DXCCS64                  (F4.0) /
 I10_DXCCS65                  (F4.0) /
 I10_DXCCS66                  (F4.0) /
 I10_DXCCS67                  (F4.0) /
 I10_ECauseCCS1               (F3.0) /
 I10_ECauseCCS2               (F3.0) /
 I10_ECauseCCS3               (F3.0) /
 I10_ECauseCCS4               (F3.0) /
 I10_ECauseCCS5               (F3.0) /
 I10_ECauseCCS6               (F3.0) /
 I10_ECauseCCS7               (F3.0) /
 I10_ECauseCCS8               (F3.0) /
 I10_ECauseCCS9               (F3.0) /
 I10_HOSPBRTH                 (F3.0) /
 I10_NCHRONIC                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NECAUSE                  (F3.0) /
 I10_NEOMAT                   (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PRCCS1                   (F3.0) /
 I10_PRCCS2                   (F3.0) /
 I10_PRCCS3                   (F3.0) /
 I10_PRCCS4                   (F3.0) /
 I10_PRCCS5                   (F3.0) /
 I10_PRCCS6                   (F3.0) /
 I10_PRCCS7                   (F3.0) /
 I10_PRCCS8                   (F3.0) /
 I10_PRCCS9                   (F3.0) /
 I10_PRCCS10                  (F3.0) /
 I10_PRCCS11                  (F3.0) /
 I10_PRCCS12                  (F3.0) /
 I10_PRCCS13                  (F3.0) /
 I10_PRCCS14                  (F3.0) /
 I10_PRCCS15                  (F3.0) /
 I10_PRCCS16                  (F3.0) /
 I10_PRCCS17                  (F3.0) /
 I10_PRCCS18                  (F3.0) /
 I10_PRCCS19                  (F3.0) /
 I10_PRCCS20                  (F3.0) /
 I10_PRCCS21                  (F3.0) /
 I10_PRCCS22                  (F3.0) /
 I10_PRCCS23                  (F3.0) /
 I10_PRCCS24                  (F3.0) /
 I10_PRCCS25                  (F3.0) /
 I10_PRCCS26                  (F3.0) /
 I10_PRCCS27                  (F3.0) /
 I10_PRCCS28                  (F3.0) /
 I10_PRCCS29                  (F3.0) /
 I10_PRCCS30                  (F3.0) /
 I10_PRCCS31                  (F3.0) /
 I10_PRCCS32                  (F3.0) /
 I10_PRCCS33                  (F3.0) /
 I10_PRCCS34                  (F3.0) /
 I10_PRCCS35                  (F3.0) /
 I10_PRCCS36                  (F3.0) /
 I10_PRCCS37                  (F3.0) /
 I10_PRCCS38                  (F3.0) /
 I10_PRCCS39                  (F3.0) /
 I10_PRCCS40                  (F3.0) /
 I10_PRCCS41                  (F3.0) /
 I10_PRCCS42                  (F3.0) /
 I10_PRCCS43                  (F3.0) /
 I10_PRCCS44                  (F3.0) /
 I10_PRCCS45                  (F3.0) /
 I10_PRCCS46                  (F3.0) /
 I10_PRCCS47                  (F3.0) /
 I10_PRCCS48                  (F3.0) /
 I10_PRCCS49                  (F3.0) /
 I10_PRCCS50                  (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDC32                        (F3.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRVER                        (F3.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRYEAR1                      (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 DaysToEvent                  "Days from 'start date' to admission"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRG32                        "DRG, version 32"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 DXPOA34                      "Diagnosis 34, present on admission indicator"
 DXPOA35                      "Diagnosis 35, present on admission indicator"
 DXPOA36                      "Diagnosis 36, present on admission indicator"
 DXPOA37                      "Diagnosis 37, present on admission indicator"
 DXPOA38                      "Diagnosis 38, present on admission indicator"
 DXPOA39                      "Diagnosis 39, present on admission indicator"
 DXPOA40                      "Diagnosis 40, present on admission indicator"
 DXPOA41                      "Diagnosis 41, present on admission indicator"
 DXPOA42                      "Diagnosis 42, present on admission indicator"
 DXPOA43                      "Diagnosis 43, present on admission indicator"
 DXPOA44                      "Diagnosis 44, present on admission indicator"
 DXPOA45                      "Diagnosis 45, present on admission indicator"
 DXPOA46                      "Diagnosis 46, present on admission indicator"
 DXPOA47                      "Diagnosis 47, present on admission indicator"
 DXPOA48                      "Diagnosis 48, present on admission indicator"
 DXPOA49                      "Diagnosis 49, present on admission indicator"
 DXPOA50                      "Diagnosis 50, present on admission indicator"
 DXPOA51                      "Diagnosis 51, present on admission indicator"
 DXPOA52                      "Diagnosis 52, present on admission indicator"
 DXPOA53                      "Diagnosis 53, present on admission indicator"
 DXPOA54                      "Diagnosis 54, present on admission indicator"
 DXPOA55                      "Diagnosis 55, present on admission indicator"
 DXPOA56                      "Diagnosis 56, present on admission indicator"
 DXPOA57                      "Diagnosis 57, present on admission indicator"
 DXPOA58                      "Diagnosis 58, present on admission indicator"
 DXPOA59                      "Diagnosis 59, present on admission indicator"
 DXPOA60                      "Diagnosis 60, present on admission indicator"
 DXPOA61                      "Diagnosis 61, present on admission indicator"
 DXPOA62                      "Diagnosis 62, present on admission indicator"
 DXPOA63                      "Diagnosis 63, present on admission indicator"
 DXPOA64                      "Diagnosis 64, present on admission indicator"
 DXPOA65                      "Diagnosis 65, present on admission indicator"
 DXPOA66                      "Diagnosis 66, present on admission indicator"
 DXPOA67                      "Diagnosis 67, present on admission indicator"
 DXVER                        "Diagnosis Version"
 E_POA1                       "E Cause 1, present on admission indicator"
 E_POA2                       "E Cause 2, present on admission indicator"
 E_POA3                       "E Cause 3, present on admission indicator"
 E_POA4                       "E Cause 4, present on admission indicator"
 E_POA5                       "E Cause 5, present on admission indicator"
 E_POA6                       "E Cause 6, present on admission indicator"
 E_POA7                       "E Cause 7, present on admission indicator"
 E_POA8                       "E Cause 8, present on admission indicator"
 E_POA9                       "E Cause 9, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSP_NPI                     "Hospital NPI"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_DX37                     "ICD-10-CM Diagnosis 37"
 I10_DX38                     "ICD-10-CM Diagnosis 38"
 I10_DX39                     "ICD-10-CM Diagnosis 39"
 I10_DX40                     "ICD-10-CM Diagnosis 40"
 I10_DX41                     "ICD-10-CM Diagnosis 41"
 I10_DX42                     "ICD-10-CM Diagnosis 42"
 I10_DX43                     "ICD-10-CM Diagnosis 43"
 I10_DX44                     "ICD-10-CM Diagnosis 44"
 I10_DX45                     "ICD-10-CM Diagnosis 45"
 I10_DX46                     "ICD-10-CM Diagnosis 46"
 I10_DX47                     "ICD-10-CM Diagnosis 47"
 I10_DX48                     "ICD-10-CM Diagnosis 48"
 I10_DX49                     "ICD-10-CM Diagnosis 49"
 I10_DX50                     "ICD-10-CM Diagnosis 50"
 I10_DX51                     "ICD-10-CM Diagnosis 51"
 I10_DX52                     "ICD-10-CM Diagnosis 52"
 I10_DX53                     "ICD-10-CM Diagnosis 53"
 I10_DX54                     "ICD-10-CM Diagnosis 54"
 I10_DX55                     "ICD-10-CM Diagnosis 55"
 I10_DX56                     "ICD-10-CM Diagnosis 56"
 I10_DX57                     "ICD-10-CM Diagnosis 57"
 I10_DX58                     "ICD-10-CM Diagnosis 58"
 I10_DX59                     "ICD-10-CM Diagnosis 59"
 I10_DX60                     "ICD-10-CM Diagnosis 60"
 I10_DX61                     "ICD-10-CM Diagnosis 61"
 I10_DX62                     "ICD-10-CM Diagnosis 62"
 I10_DX63                     "ICD-10-CM Diagnosis 63"
 I10_DX64                     "ICD-10-CM Diagnosis 64"
 I10_DX65                     "ICD-10-CM Diagnosis 65"
 I10_DX66                     "ICD-10-CM Diagnosis 66"
 I10_DX67                     "ICD-10-CM Diagnosis 67"
 I10_DXCCS1                   "ICD-10-CM CCS: diagnosis 1"
 I10_DXCCS2                   "ICD-10-CM CCS: diagnosis 2"
 I10_DXCCS3                   "ICD-10-CM CCS: diagnosis 3"
 I10_DXCCS4                   "ICD-10-CM CCS: diagnosis 4"
 I10_DXCCS5                   "ICD-10-CM CCS: diagnosis 5"
 I10_DXCCS6                   "ICD-10-CM CCS: diagnosis 6"
 I10_DXCCS7                   "ICD-10-CM CCS: diagnosis 7"
 I10_DXCCS8                   "ICD-10-CM CCS: diagnosis 8"
 I10_DXCCS9                   "ICD-10-CM CCS: diagnosis 9"
 I10_DXCCS10                  "ICD-10-CM CCS: diagnosis 10"
 I10_DXCCS11                  "ICD-10-CM CCS: diagnosis 11"
 I10_DXCCS12                  "ICD-10-CM CCS: diagnosis 12"
 I10_DXCCS13                  "ICD-10-CM CCS: diagnosis 13"
 I10_DXCCS14                  "ICD-10-CM CCS: diagnosis 14"
 I10_DXCCS15                  "ICD-10-CM CCS: diagnosis 15"
 I10_DXCCS16                  "ICD-10-CM CCS: diagnosis 16"
 I10_DXCCS17                  "ICD-10-CM CCS: diagnosis 17"
 I10_DXCCS18                  "ICD-10-CM CCS: diagnosis 18"
 I10_DXCCS19                  "ICD-10-CM CCS: diagnosis 19"
 I10_DXCCS20                  "ICD-10-CM CCS: diagnosis 20"
 I10_DXCCS21                  "ICD-10-CM CCS: diagnosis 21"
 I10_DXCCS22                  "ICD-10-CM CCS: diagnosis 22"
 I10_DXCCS23                  "ICD-10-CM CCS: diagnosis 23"
 I10_DXCCS24                  "ICD-10-CM CCS: diagnosis 24"
 I10_DXCCS25                  "ICD-10-CM CCS: diagnosis 25"
 I10_DXCCS26                  "ICD-10-CM CCS: diagnosis 26"
 I10_DXCCS27                  "ICD-10-CM CCS: diagnosis 27"
 I10_DXCCS28                  "ICD-10-CM CCS: diagnosis 28"
 I10_DXCCS29                  "ICD-10-CM CCS: diagnosis 29"
 I10_DXCCS30                  "ICD-10-CM CCS: diagnosis 30"
 I10_DXCCS31                  "ICD-10-CM CCS: diagnosis 31"
 I10_DXCCS32                  "ICD-10-CM CCS: diagnosis 32"
 I10_DXCCS33                  "ICD-10-CM CCS: diagnosis 33"
 I10_DXCCS34                  "ICD-10-CM CCS: diagnosis 34"
 I10_DXCCS35                  "ICD-10-CM CCS: diagnosis 35"
 I10_DXCCS36                  "ICD-10-CM CCS: diagnosis 36"
 I10_DXCCS37                  "ICD-10-CM CCS: diagnosis 37"
 I10_DXCCS38                  "ICD-10-CM CCS: diagnosis 38"
 I10_DXCCS39                  "ICD-10-CM CCS: diagnosis 39"
 I10_DXCCS40                  "ICD-10-CM CCS: diagnosis 40"
 I10_DXCCS41                  "ICD-10-CM CCS: diagnosis 41"
 I10_DXCCS42                  "ICD-10-CM CCS: diagnosis 42"
 I10_DXCCS43                  "ICD-10-CM CCS: diagnosis 43"
 I10_DXCCS44                  "ICD-10-CM CCS: diagnosis 44"
 I10_DXCCS45                  "ICD-10-CM CCS: diagnosis 45"
 I10_DXCCS46                  "ICD-10-CM CCS: diagnosis 46"
 I10_DXCCS47                  "ICD-10-CM CCS: diagnosis 47"
 I10_DXCCS48                  "ICD-10-CM CCS: diagnosis 48"
 I10_DXCCS49                  "ICD-10-CM CCS: diagnosis 49"
 I10_DXCCS50                  "ICD-10-CM CCS: diagnosis 50"
 I10_DXCCS51                  "ICD-10-CM CCS: diagnosis 51"
 I10_DXCCS52                  "ICD-10-CM CCS: diagnosis 52"
 I10_DXCCS53                  "ICD-10-CM CCS: diagnosis 53"
 I10_DXCCS54                  "ICD-10-CM CCS: diagnosis 54"
 I10_DXCCS55                  "ICD-10-CM CCS: diagnosis 55"
 I10_DXCCS56                  "ICD-10-CM CCS: diagnosis 56"
 I10_DXCCS57                  "ICD-10-CM CCS: diagnosis 57"
 I10_DXCCS58                  "ICD-10-CM CCS: diagnosis 58"
 I10_DXCCS59                  "ICD-10-CM CCS: diagnosis 59"
 I10_DXCCS60                  "ICD-10-CM CCS: diagnosis 60"
 I10_DXCCS61                  "ICD-10-CM CCS: diagnosis 61"
 I10_DXCCS62                  "ICD-10-CM CCS: diagnosis 62"
 I10_DXCCS63                  "ICD-10-CM CCS: diagnosis 63"
 I10_DXCCS64                  "ICD-10-CM CCS: diagnosis 64"
 I10_DXCCS65                  "ICD-10-CM CCS: diagnosis 65"
 I10_DXCCS66                  "ICD-10-CM CCS: diagnosis 66"
 I10_DXCCS67                  "ICD-10-CM CCS: diagnosis 67"
 I10_ECAUSE1                  "ICD-10-CM E Cause 1"
 I10_ECAUSE2                  "ICD-10-CM E Cause 2"
 I10_ECAUSE3                  "ICD-10-CM E Cause 3"
 I10_ECAUSE4                  "ICD-10-CM E Cause 4"
 I10_ECAUSE5                  "ICD-10-CM E Cause 5"
 I10_ECAUSE6                  "ICD-10-CM E Cause 6"
 I10_ECAUSE7                  "ICD-10-CM E Cause 7"
 I10_ECAUSE8                  "ICD-10-CM E Cause 8"
 I10_ECAUSE9                  "ICD-10-CM E Cause 9"
 I10_ECauseCCS1               "ICD-10-CM CCS: E Cause 1"
 I10_ECauseCCS2               "ICD-10-CM CCS: E Cause 2"
 I10_ECauseCCS3               "ICD-10-CM CCS: E Cause 3"
 I10_ECauseCCS4               "ICD-10-CM CCS: E Cause 4"
 I10_ECauseCCS5               "ICD-10-CM CCS: E Cause 5"
 I10_ECauseCCS6               "ICD-10-CM CCS: E Cause 6"
 I10_ECauseCCS7               "ICD-10-CM CCS: E Cause 7"
 I10_ECauseCCS8               "ICD-10-CM CCS: E Cause 8"
 I10_ECauseCCS9               "ICD-10-CM CCS: E Cause 9"
 I10_HOSPBRTH                 "ICD-10-CM Indicator of birth in this hospital"
 I10_NCHRONIC                 "ICD-10-CM Number of chronic conditions"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NECAUSE                  "ICD-10-CM Number of E Causes on this record"
 I10_NEOMAT                   "ICD-10-CM/PCS Neonatal and/or maternal I10_DX and/or I10_PR"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PR26                     "ICD-10-PCS Procedure 26"
 I10_PR27                     "ICD-10-PCS Procedure 27"
 I10_PR28                     "ICD-10-PCS Procedure 28"
 I10_PR29                     "ICD-10-PCS Procedure 29"
 I10_PR30                     "ICD-10-PCS Procedure 30"
 I10_PR31                     "ICD-10-PCS Procedure 31"
 I10_PR32                     "ICD-10-PCS Procedure 32"
 I10_PR33                     "ICD-10-PCS Procedure 33"
 I10_PR34                     "ICD-10-PCS Procedure 34"
 I10_PR35                     "ICD-10-PCS Procedure 35"
 I10_PR36                     "ICD-10-PCS Procedure 36"
 I10_PR37                     "ICD-10-PCS Procedure 37"
 I10_PR38                     "ICD-10-PCS Procedure 38"
 I10_PR39                     "ICD-10-PCS Procedure 39"
 I10_PR40                     "ICD-10-PCS Procedure 40"
 I10_PR41                     "ICD-10-PCS Procedure 41"
 I10_PR42                     "ICD-10-PCS Procedure 42"
 I10_PR43                     "ICD-10-PCS Procedure 43"
 I10_PR44                     "ICD-10-PCS Procedure 44"
 I10_PR45                     "ICD-10-PCS Procedure 45"
 I10_PR46                     "ICD-10-PCS Procedure 46"
 I10_PR47                     "ICD-10-PCS Procedure 47"
 I10_PR48                     "ICD-10-PCS Procedure 48"
 I10_PR49                     "ICD-10-PCS Procedure 49"
 I10_PR50                     "ICD-10-PCS Procedure 50"
 I10_PRCCS1                   "ICD-10-PCS CCS: procedure 1"
 I10_PRCCS2                   "ICD-10-PCS CCS: procedure 2"
 I10_PRCCS3                   "ICD-10-PCS CCS: procedure 3"
 I10_PRCCS4                   "ICD-10-PCS CCS: procedure 4"
 I10_PRCCS5                   "ICD-10-PCS CCS: procedure 5"
 I10_PRCCS6                   "ICD-10-PCS CCS: procedure 6"
 I10_PRCCS7                   "ICD-10-PCS CCS: procedure 7"
 I10_PRCCS8                   "ICD-10-PCS CCS: procedure 8"
 I10_PRCCS9                   "ICD-10-PCS CCS: procedure 9"
 I10_PRCCS10                  "ICD-10-PCS CCS: procedure 10"
 I10_PRCCS11                  "ICD-10-PCS CCS: procedure 11"
 I10_PRCCS12                  "ICD-10-PCS CCS: procedure 12"
 I10_PRCCS13                  "ICD-10-PCS CCS: procedure 13"
 I10_PRCCS14                  "ICD-10-PCS CCS: procedure 14"
 I10_PRCCS15                  "ICD-10-PCS CCS: procedure 15"
 I10_PRCCS16                  "ICD-10-PCS CCS: procedure 16"
 I10_PRCCS17                  "ICD-10-PCS CCS: procedure 17"
 I10_PRCCS18                  "ICD-10-PCS CCS: procedure 18"
 I10_PRCCS19                  "ICD-10-PCS CCS: procedure 19"
 I10_PRCCS20                  "ICD-10-PCS CCS: procedure 20"
 I10_PRCCS21                  "ICD-10-PCS CCS: procedure 21"
 I10_PRCCS22                  "ICD-10-PCS CCS: procedure 22"
 I10_PRCCS23                  "ICD-10-PCS CCS: procedure 23"
 I10_PRCCS24                  "ICD-10-PCS CCS: procedure 24"
 I10_PRCCS25                  "ICD-10-PCS CCS: procedure 25"
 I10_PRCCS26                  "ICD-10-PCS CCS: procedure 26"
 I10_PRCCS27                  "ICD-10-PCS CCS: procedure 27"
 I10_PRCCS28                  "ICD-10-PCS CCS: procedure 28"
 I10_PRCCS29                  "ICD-10-PCS CCS: procedure 29"
 I10_PRCCS30                  "ICD-10-PCS CCS: procedure 30"
 I10_PRCCS31                  "ICD-10-PCS CCS: procedure 31"
 I10_PRCCS32                  "ICD-10-PCS CCS: procedure 32"
 I10_PRCCS33                  "ICD-10-PCS CCS: procedure 33"
 I10_PRCCS34                  "ICD-10-PCS CCS: procedure 34"
 I10_PRCCS35                  "ICD-10-PCS CCS: procedure 35"
 I10_PRCCS36                  "ICD-10-PCS CCS: procedure 36"
 I10_PRCCS37                  "ICD-10-PCS CCS: procedure 37"
 I10_PRCCS38                  "ICD-10-PCS CCS: procedure 38"
 I10_PRCCS39                  "ICD-10-PCS CCS: procedure 39"
 I10_PRCCS40                  "ICD-10-PCS CCS: procedure 40"
 I10_PRCCS41                  "ICD-10-PCS CCS: procedure 41"
 I10_PRCCS42                  "ICD-10-PCS CCS: procedure 42"
 I10_PRCCS43                  "ICD-10-PCS CCS: procedure 43"
 I10_PRCCS44                  "ICD-10-PCS CCS: procedure 44"
 I10_PRCCS45                  "ICD-10-PCS CCS: procedure 45"
 I10_PRCCS46                  "ICD-10-PCS CCS: procedure 46"
 I10_PRCCS47                  "ICD-10-PCS CCS: procedure 47"
 I10_PRCCS48                  "ICD-10-PCS CCS: procedure 48"
 I10_PRCCS49                  "ICD-10-PCS CCS: procedure 49"
 I10_PRCCS50                  "ICD-10-PCS CCS: procedure 50"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDC32                        "MDC, version 32"
 MDSPEC1                      "Physician 1 specialty (as received from source)"
 MDSPEC2                      "Physician 2 specialty (as received from source)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2
"Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1
"Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2
"Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value
"Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRYEAR1                      "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG32
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS58
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS59
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS60
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS61
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS62
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS63
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS64
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS65
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS66
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_DXCCS67
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_ECauseCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE I10_HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NECAUSE
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC32
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'WI_SID_2015q4_CORE.SAV' /COMPRESSED.
