/*******************************************************************
*   OR_SID_2008_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'OR_SID_2008_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 BWT                       16-  19
 DIED                      20-  21
 DISPUB04                  22-  23
 DISPUNIF                  24-  25
 DISP_X                    26-  27 (A)
 DNR                       28-  29
 DQTR                      30-  31
 DRG                       32-  34
 DRG24                     35-  37
 DRGVER                    38-  39
 DRG_NoPO                  40-  42
 DSHOSPID                  43-  55 (A)
 DX1                       56-  60 (A)
 DX2                       61-  65 (A)
 DX3                       66-  70 (A)
 DX4                       71-  75 (A)
 DX5                       76-  80 (A)
 DX6                       81-  85 (A)
 DX7                       86-  90 (A)
 DX8                       91-  95 (A)
 DX9                       96- 100 (A)
 DX10                     101- 105 (A)
 DX11                     106- 110 (A)
 DX12                     111- 115 (A)
 DX13                     116- 120 (A)
 DX14                     121- 125 (A)
 DX15                     126- 130 (A)
 DX16                     131- 135 (A)
 DX17                     136- 140 (A)
 DX18                     141- 145 (A)
 DX19                     146- 150 (A)
 DX20                     151- 155 (A)
 DX21                     156- 160 (A)
 DX22                     161- 165 (A)
 DX23                     166- 170 (A)
 DX24                     171- 175 (A)
 DX25                     176- 180 (A)
 DXCCS1                   181- 184
 DXCCS2                   185- 188
 DXCCS3                   189- 192
 DXCCS4                   193- 196
 DXCCS5                   197- 200
 DXCCS6                   201- 204
 DXCCS7                   205- 208
 DXCCS8                   209- 212
 DXCCS9                   213- 216
 DXCCS10                  217- 220
 DXCCS11                  221- 224
 DXCCS12                  225- 228
 DXCCS13                  229- 232
 DXCCS14                  233- 236
 DXCCS15                  237- 240
 DXCCS16                  241- 244
 DXCCS17                  245- 248
 DXCCS18                  249- 252
 DXCCS19                  253- 256
 DXCCS20                  257- 260
 DXCCS21                  261- 264
 DXCCS22                  265- 268
 DXCCS23                  269- 272
 DXCCS24                  273- 276
 DXCCS25                  277- 280
 DXPOA1                   281     (A)
 DXPOA2                   282     (A)
 DXPOA3                   283     (A)
 DXPOA4                   284     (A)
 DXPOA5                   285     (A)
 DXPOA6                   286     (A)
 DXPOA7                   287     (A)
 DXPOA8                   288     (A)
 DXPOA9                   289     (A)
 DXPOA10                  290     (A)
 DXPOA11                  291     (A)
 DXPOA12                  292     (A)
 DXPOA13                  293     (A)
 DXPOA14                  294     (A)
 DXPOA15                  295     (A)
 DXPOA16                  296     (A)
 DXPOA17                  297     (A)
 DXPOA18                  298     (A)
 DXPOA19                  299     (A)
 DXPOA20                  300     (A)
 DXPOA21                  301     (A)
 DXPOA22                  302     (A)
 DXPOA23                  303     (A)
 DXPOA24                  304     (A)
 DXPOA25                  305     (A)
 ECODE1                   306- 310 (A)
 ECODE2                   311- 315 (A)
 ECODE3                   316- 320 (A)
 ECODE4                   321- 325 (A)
 ECODE5                   326- 330 (A)
 ECODE6                   331- 335 (A)
 ECODE7                   336- 340 (A)
 ECODE8                   341- 345 (A)
 E_CCS1                   346- 349
 E_CCS2                   350- 353
 E_CCS3                   354- 357
 E_CCS4                   358- 361
 E_CCS5                   362- 365
 E_CCS6                   366- 369
 E_CCS7                   370- 373
 E_CCS8                   374- 377
 FEMALE                   378- 379
 HCUP_ED                  380- 381
 HCUP_OS                  382- 383
 HISPANIC                 384- 385 (A)
 HOSPBRTH                 386- 388
 HOSPST                   389- 390 (A)
 KEY                      391- 404
 LOS                      405- 409
 LOS_X                    410- 415
 MDC                      416- 417
 MDC24                    418- 419
 MEDINCST                 420- 421
 NDX                      422- 423
 NECODE                   424- 425
 NEOMAT                   426- 427
 NPR                      428- 429
 PAY1                     430- 431
 PAY1_X                   432- 440 (A)
 PAY2                     441- 442
 PAY2_X                   443- 451 (A)
 PAY3_X                   452- 460 (A)
 PL_CBSA                  461- 463
 PL_MSA19                 464- 466
 PL_NCHS2                 467- 468
 PL_RUCA1                 469- 470
 PL_RUCA2                 471- 474
 PL_RUCA4                 475- 476
 PL_RUCC2                 477- 478
 PL_UIC20                 479- 480
 PL_UR_CA                 481- 482
 PR1                      483- 486 (A)
 PR2                      487- 490 (A)
 PR3                      491- 494 (A)
 PR4                      495- 498 (A)
 PR5                      499- 502 (A)
 PR6                      503- 506 (A)
 PR7                      507- 510 (A)
 PR8                      511- 514 (A)
 PR9                      515- 518 (A)
 PR10                     519- 522 (A)
 PR11                     523- 526 (A)
 PR12                     527- 530 (A)
 PR13                     531- 534 (A)
 PR14                     535- 538 (A)
 PR15                     539- 542 (A)
 PR16                     543- 546 (A)
 PR17                     547- 550 (A)
 PR18                     551- 554 (A)
 PR19                     555- 558 (A)
 PR20                     559- 562 (A)
 PR21                     563- 566 (A)
 PR22                     567- 570 (A)
 PR23                     571- 574 (A)
 PR24                     575- 578 (A)
 PR25                     579- 582 (A)
 PRCCS1                   583- 585
 PRCCS2                   586- 588
 PRCCS3                   589- 591
 PRCCS4                   592- 594
 PRCCS5                   595- 597
 PRCCS6                   598- 600
 PRCCS7                   601- 603
 PRCCS8                   604- 606
 PRCCS9                   607- 609
 PRCCS10                  610- 612
 PRCCS11                  613- 615
 PRCCS12                  616- 618
 PRCCS13                  619- 621
 PRCCS14                  622- 624
 PRCCS15                  625- 627
 PRCCS16                  628- 630
 PRCCS17                  631- 633
 PRCCS18                  634- 636
 PRCCS19                  637- 639
 PRCCS20                  640- 642
 PRCCS21                  643- 645
 PRCCS22                  646- 648
 PRCCS23                  649- 651
 PRCCS24                  652- 654
 PRCCS25                  655- 657
 PRDAY1                   658- 662
 PRDAY2                   663- 667
 PRDAY3                   668- 672
 PRDAY4                   673- 677
 PRDAY5                   678- 682
 PRDAY6                   683- 687
 PRDAY7                   688- 692
 PRDAY8                   693- 697
 PRDAY9                   698- 702
 PRDAY10                  703- 707
 PRDAY11                  708- 712
 PRDAY12                  713- 717
 PRDAY13                  718- 722
 PRDAY14                  723- 727
 PRDAY15                  728- 732
 PRDAY16                  733- 737
 PRDAY17                  738- 742
 PRDAY18                  743- 747
 PRDAY19                  748- 752
 PRDAY20                  753- 757
 PRDAY21                  758- 762
 PRDAY22                  763- 767
 PRDAY23                  768- 772
 PRDAY24                  773- 777
 PRDAY25                  778- 782
 PROCTYPE                 783- 785
 PSTATE                   786- 787 (A)
 PSTCO2                   788- 792
 POFOUB04                 793     (A)
 POFO_X                   794- 795 (A)
 RACE                     796- 797
 TOTCHG                   798- 807
 TOTCHG_X                 808- 822
 YEAR                     823- 826
 ZIPINC_Q                 827- 829
 ZIP                      830- 834 (A)
 AYEAR                    835- 838
 DMONTH                   839- 840
 BMONTH                   841- 842
 BYEAR                    843- 846
 PRMNTH1                  847- 848
 PRMNTH2                  849- 850
 PRMNTH3                  851- 852
 PRMNTH4                  853- 854
 PRMNTH5                  855- 856
 PRMNTH6                  857- 858
 PRMNTH7                  859- 860
 PRMNTH8                  861- 862
 PRMNTH9                  863- 864
 PRMNTH10                 865- 866
 PRMNTH11                 867- 868
 PRMNTH12                 869- 870
 PRMNTH13                 871- 872
 PRMNTH14                 873- 874
 PRMNTH15                 875- 876
 PRMNTH16                 877- 878
 PRMNTH17                 879- 880
 PRMNTH18                 881- 882
 PRMNTH19                 883- 884
 PRMNTH20                 885- 886
 PRMNTH21                 887- 888
 PRMNTH22                 889- 890
 PRMNTH23                 891- 892
 PRMNTH24                 893- 894
 PRMNTH25                 895- 896
 PRYEAR1                  897- 900
 PRYEAR2                  901- 904
 PRYEAR3                  905- 908
 PRYEAR4                  909- 912
 PRYEAR5                  913- 916
 PRYEAR6                  917- 920
 PRYEAR7                  921- 924
 PRYEAR8                  925- 928
 PRYEAR9                  929- 932
 PRYEAR10                 933- 936
 PRYEAR11                 937- 940
 PRYEAR12                 941- 944
 PRYEAR13                 945- 948
 PRYEAR14                 949- 952
 PRYEAR15                 953- 956
 PRYEAR16                 957- 960
 PRYEAR17                 961- 964
 PRYEAR18                 965- 968
 PRYEAR19                 969- 972
 PRYEAR20                 973- 976
 PRYEAR21                 977- 980
 PRYEAR22                 981- 984
 PRYEAR23                 985- 988
 PRYEAR24                 989- 992
 PRYEAR25                 993- 996.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DNR                     (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPO                (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MEDINCST                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA1                (F3.0) /
 PL_RUCA2                (F4.1) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRMNTH21                (F3.0) /
 PRMNTH22                (F3.0) /
 PRMNTH23                (F3.0) /
 PRMNTH24                (F3.0) /
 PRMNTH25                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BWT       "Birth weight in grams"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DNR       "Do not resuscitate indicator"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG24     "DRG, version 24"
 DRGVER    "DRG grouper version used on discharge date"
 DRG_NoPO  "DRG in use on discharge date, calculated without POA"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DX21      "Diagnosis 21"
 DX22      "Diagnosis 22"
 DX23      "Diagnosis 23"
 DX24      "Diagnosis 24"
 DX25      "Diagnosis 25"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 DXCCS21   "CCS: diagnosis 21"
 DXCCS22   "CCS: diagnosis 22"
 DXCCS23   "CCS: diagnosis 23"
 DXCCS24   "CCS: diagnosis 24"
 DXCCS25   "CCS: diagnosis 25"
 DXPOA1    "Diagnosis 1, present on admission indicator"
 DXPOA2    "Diagnosis 2, present on admission indicator"
 DXPOA3    "Diagnosis 3, present on admission indicator"
 DXPOA4    "Diagnosis 4, present on admission indicator"
 DXPOA5    "Diagnosis 5, present on admission indicator"
 DXPOA6    "Diagnosis 6, present on admission indicator"
 DXPOA7    "Diagnosis 7, present on admission indicator"
 DXPOA8    "Diagnosis 8, present on admission indicator"
 DXPOA9    "Diagnosis 9, present on admission indicator"
 DXPOA10   "Diagnosis 10, present on admission indicator"
 DXPOA11   "Diagnosis 11, present on admission indicator"
 DXPOA12   "Diagnosis 12, present on admission indicator"
 DXPOA13   "Diagnosis 13, present on admission indicator"
 DXPOA14   "Diagnosis 14, present on admission indicator"
 DXPOA15   "Diagnosis 15, present on admission indicator"
 DXPOA16   "Diagnosis 16, present on admission indicator"
 DXPOA17   "Diagnosis 17, present on admission indicator"
 DXPOA18   "Diagnosis 18, present on admission indicator"
 DXPOA19   "Diagnosis 19, present on admission indicator"
 DXPOA20   "Diagnosis 20, present on admission indicator"
 DXPOA21   "Diagnosis 21, present on admission indicator"
 DXPOA22   "Diagnosis 22, present on admission indicator"
 DXPOA23   "Diagnosis 23, present on admission indicator"
 DXPOA24   "Diagnosis 24, present on admission indicator"
 DXPOA25   "Diagnosis 25, present on admission indicator"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC24     "MDC, version 24"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PAY3_X    "Tertiary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2  "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PR21      "Procedure 21"
 PR22      "Procedure 22"
 PR23      "Procedure 23"
 PR24      "Procedure 24"
 PR25      "Procedure 25"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRCCS21   "CCS: procedure 21"
 PRCCS22   "CCS: procedure 22"
 PRCCS23   "CCS: procedure 23"
 PRCCS24   "CCS: procedure 24"
 PRCCS25   "CCS: procedure 25"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PRDAY21   "Number of days from admission to PR21"
 PRDAY22   "Number of days from admission to PR22"
 PRDAY23   "Number of days from admission to PR23"
 PRDAY24   "Number of days from admission to PR24"
 PRDAY25   "Number of days from admission to PR25"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 POFO_X    "Point of origin for admission or visit, as received from source"
 RACE      "Race (uniform)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRMNTH21  "Month of procedure 21"
 PRMNTH22  "Month of procedure 22"
 PRMNTH23  "Month of procedure 23"
 PRMNTH24  "Month of procedure 24"
 PRMNTH25  "Month of procedure 25"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20"
 PRYEAR21  "Year of procedure 21"
 PRYEAR22  "Year of procedure 22"
 PRYEAR23  "Year of procedure 23"
 PRYEAR24  "Year of procedure 24"
 PRYEAR25  "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPO
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'OR_SID_2008_CORE.SAV' /COMPRESSED.
