/*******************************************************************
*   OR_SID_2000_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL CONVERT THE ASCII             
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'OR_SID_2000_CORE.ASC' FIXED / 
 KEY                  1- 14
 AGE                 15- 17
 AGEDAY              18- 20
 AGEMONTH            21- 23
 AMONTH              24- 25
 ASOURCE             26- 27
 ASOURCE_            28- 29 (A)
 ATYPE               30- 31
 AWEEKEND            32- 33
 DIED                34- 35
 DISP_X              36- 37 (A)
 DISPUB92            38- 39
 DISPUNIF            40- 41
 DQTR                42- 43
 DRG                 44- 46
 DRG18               47- 49
 DRGVER              50- 51
 DSHOSPID            52- 64 (A)
 DX1                 65- 69 (A)
 DX2                 70- 74 (A)
 DX3                 75- 79 (A)
 DX4                 80- 84 (A)
 DX5                 85- 89 (A)
 DX6                 90- 94 (A)
 DX7                 95- 99 (A)
 DX8                100-104 (A)
 DX9                105-109 (A)
 DX10               110-114 (A)
 DX11               115-119 (A)
 DXCCS1             120-123
 DXCCS2             124-127
 DXCCS3             128-131
 DXCCS4             132-135
 DXCCS5             136-139
 DXCCS6             140-143
 DXCCS7             144-147
 DXCCS8             148-151
 DXCCS9             152-155
 DXCCS10            156-159
 DXCCS11            160-163
 FEMALE             164-165
 HOSPST             166-167 (A)
 LOS                168-172
 LOS_X              173-178
 MDC                179-180
 MDC18              181-182
 NDX                183-184
 NEOMAT             185-186
 NPR                187-188
 PAY1               189-190
 PAY2               191-192
 PAY1_X             193 (A)
 PAY2_X             194 (A)
 PAY3_X             195 (A)
 PR1                196-199 (A)
 PR2                200-203 (A)
 PR3                204-207 (A)
 PR4                208-211 (A)
 PR5                212-215 (A)
 PR6                216-219 (A)
 PRCCS1             220-222
 PRCCS2             223-225
 PRCCS3             226-228
 PRCCS4             229-231
 PRCCS5             232-234
 PRCCS6             235-237
 PRDAY1             238-240
 PRDAY2             241-243
 PRDAY3             244-246
 PRDAY4             247-249
 PRDAY5             250-252
 PRDAY6             253-255
 RDRG               256-259 (A)
 TOTCHG             260-269
 TOTCHG_X           270-284
 YEAR               285-288
 ZIP                289-293 (A)
 AYEAR              294-297
 DMONTH             298-299
 BMONTH             300-301
 BYEAR              302-305
 PRMNTH1            306-307
 PRMNTH2            308-309
 PRMNTH3            310-311
 PRMNTH4            312-313
 PRMNTH5            314-315
 PRMNTH6            316-317
 PRYEAR1            318-321
 PRYEAR2            322-325
 PRYEAR3            326-329
 PRYEAR4            330-333
 PRYEAR5            334-337
 PRYEAR6            338-341.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 AGEMONTH            (F3.0) /
 AMONTH              (F3.0) /
 ASOURCE             (F3.0) /
 ATYPE               (F3.0) /
 AWEEKEND            (F3.0) /
 DIED                (F3.0) /
 DISPUB92            (F3.0) /
 DISPUNIF            (F3.0) /
 DQTR                (F3.0) /
 DRG                 (F3.0) /
 DRG18               (F3.0) /
 DRGVER              (F3.0) /
 DXCCS1              (F4.0) /
 DXCCS2              (F4.0) /
 DXCCS3              (F4.0) /
 DXCCS4              (F4.0) /
 DXCCS5              (F4.0) /
 DXCCS6              (F4.0) /
 DXCCS7              (F4.0) /
 DXCCS8              (F4.0) /
 DXCCS9              (F4.0) /
 DXCCS10             (F4.0) /
 DXCCS11             (F4.0) /
 FEMALE              (F3.0) /
 LOS                 (F4.0) /
 LOS_X               (F4.0) /
 MDC                 (F3.0) /
 MDC18               (F3.0) /
 NDX                 (F3.0) /
 NEOMAT              (F3.0) /
 NPR                 (F3.0) /
 PAY1                (F3.0) /
 PAY2                (F3.0) /
 PRCCS1              (F3.0) /
 PRCCS2              (F3.0) /
 PRCCS3              (F3.0) /
 PRCCS4              (F3.0) /
 PRCCS5              (F3.0) /
 PRCCS6              (F3.0) /
 PRDAY1              (F4.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 TOTCHG              (F6.0) /
 TOTCHG_X            (F7.2) /
 YEAR                (F3.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRMNTH4             (F3.0) /
 PRMNTH5             (F3.0) /
 PRMNTH6             (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) /
 PRYEAR4             (F3.0) /
 PRYEAR5             (F3.0) /
 PRYEAR6             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY          "HCUP record identifier"
 AGE          "Age in years at admission"
 AGEDAY       "Age in days (when age < 1 year)"
 AGEMONTH     "Age in months (when age < 11 years)"
 AMONTH       "Admission month"
 ASOURCE      "Admission source (uniform)"
 ASOURCE_     "Admission source (as received from source)"
 ATYPE        "Admission type"
 AWEEKEND     "Admission day is a weekend"
 DIED         "Died during hospitalization"
 DISP_X       "Disposition of patient (as received from source)"
 DISPUB92     "Disposition of patient (UB-92 standard coding)"
 DISPUNIF     "Disposition of patient (uniform)"
 DQTR         "Discharge quarter"
 DRG          "DRG in effect on discharge date"
 DRG18        "DRG, version 18"
 DRGVER       "DRG grouper version used on discharge date"
 DSHOSPID     "Data source hospital identifier"
 DX1          "Principal diagnosis"
 DX2          "Diagnosis 2"
 DX3          "Diagnosis 3"
 DX4          "Diagnosis 4"
 DX5          "Diagnosis 5"
 DX6          "Diagnosis 6"
 DX7          "Diagnosis 7"
 DX8          "Diagnosis 8"
 DX9          "Diagnosis 9"
 DX10         "Diagnosis 10"
 DX11         "Diagnosis 11"
 DXCCS1       "CCS: principal diagnosis"
 DXCCS2       "CCS: diagnosis 2"
 DXCCS3       "CCS: diagnosis 3"
 DXCCS4       "CCS: diagnosis 4"
 DXCCS5       "CCS: diagnosis 5"
 DXCCS6       "CCS: diagnosis 6"
 DXCCS7       "CCS: diagnosis 7"
 DXCCS8       "CCS: diagnosis 8"
 DXCCS9       "CCS: diagnosis 9"
 DXCCS10      "CCS: diagnosis 10"
 DXCCS11      "CCS: diagnosis 11"
 FEMALE       "Indicator of sex"
 HOSPST       "Hospital state postal code"
 LOS          "Length of stay (cleaned)"
 LOS_X        "Length of stay (as received from source)"
 MDC          "MDC in effect on discharge date"
 MDC18        "MDC, version 18"
 NDX          "Number of diagnoses on this record"
 NEOMAT       "Neonatal and/or maternal DX and/or PR"
 NPR          "Number of procedures on this record"
 PAY1         "Primary expected payer (uniform)"
 PAY2         "Secondary expected payer (uniform)"
 PAY1_X       "Primary expected payer (as received from source)"
 PAY2_X       "Secondary expected payer (as received from source)"
 PAY3_X       "Tertiary expected payer (as received from source)"
 PR1          "Principal procedure"
 PR2          "Procedure 2"
 PR3          "Procedure 3"
 PR4          "Procedure 4"
 PR5          "Procedure 5"
 PR6          "Procedure 6"
 PRCCS1       "CCS: principal procedure"
 PRCCS2       "CCS: procedure 2"
 PRCCS3       "CCS: procedure 3"
 PRCCS4       "CCS: procedure 4"
 PRCCS5       "CCS: procedure 5"
 PRCCS6       "CCS: procedure 6"
 PRDAY1       "Number of days from admission to PR1"
 PRDAY2       "Number of days from admission to PR2"
 PRDAY3       "Number of days from admission to PR3"
 PRDAY4       "Number of days from admission to PR4"
 PRDAY5       "Number of days from admission to PR5"
 PRDAY6       "Number of days from admission to PR6"
 RDRG         "Refined DRG"
 TOTCHG       "Total charges (cleaned)"
 TOTCHG_X     "Total charges (as received from source)"
 YEAR         "Calendar year"
 ZIP          "Patient zip code"
 AYEAR        "Admission year"
 DMONTH       "Discharge month"
 BMONTH       "Birth month"
 BYEAR        "Birth year"
 PRMNTH1      "Month of procedure 1"
 PRMNTH2      "Month of procedure 2"
 PRMNTH3      "Month of procedure 3"
 PRMNTH4      "Month of procedure 4"
 PRMNTH5      "Month of procedure 5"
 PRMNTH6      "Month of procedure 6"
 PRYEAR1      "Year of procedure 1"
 PRYEAR2      "Year of procedure 2"
 PRYEAR3      "Year of procedure 3"
 PRYEAR4      "Year of procedure 4"
 PRYEAR5      "Year of procedure 5"
 PRYEAR6      "Year of procedure 6".


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'OR_SID_2000_CORE.SAV' /COMPRESSED.
