/*******************************************************************
* Creation Date: 04/27/2021   
*   NJ_SID_2019_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SID_2019_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 BWT                            24-  27
 CPT1                           28-  32 (A)
 CPT2                           33-  37 (A)
 CPT3                           38-  42 (A)
 CPT4                           43-  47 (A)
 CPT5                           48-  52 (A)
 CPT6                           53-  57 (A)
 CPT7                           58-  62 (A)
 CPT8                           63-  67 (A)
 CPT9                           68-  72 (A)
 CPT10                          73-  77 (A)
 CPT11                          78-  82 (A)
 CPT12                          83-  87 (A)
 CPT13                          88-  92 (A)
 CPT14                          93-  97 (A)
 CPT15                          98- 102 (A)
 CPT16                         103- 107 (A)
 CPT17                         108- 112 (A)
 CPT18                         113- 117 (A)
 CPT19                         118- 122 (A)
 CPT20                         123- 127 (A)
 CPT21                         128- 132 (A)
 CPT22                         133- 137 (A)
 CPT23                         138- 142 (A)
 CPT24                         143- 147 (A)
 CPT25                         148- 152 (A)
 CPT26                         153- 157 (A)
 CPT27                         158- 162 (A)
 CPT28                         163- 167 (A)
 CPT29                         168- 172 (A)
 CPT30                         173- 177 (A)
 CPT31                         178- 182 (A)
 CPT32                         183- 187 (A)
 CPT33                         188- 192 (A)
 CPT34                         193- 197 (A)
 CPT35                         198- 202 (A)
 CPT36                         203- 207 (A)
 CPT37                         208- 212 (A)
 CPT38                         213- 217 (A)
 CPT39                         218- 222 (A)
 CPT40                         223- 227 (A)
 CPT41                         228- 232 (A)
 CPT42                         233- 237 (A)
 CPT43                         238- 242 (A)
 CPT44                         243- 247 (A)
 CPT45                         248- 252 (A)
 CPT46                         253- 257 (A)
 CPT47                         258- 262 (A)
 CPT48                         263- 267 (A)
 CPT49                         268- 272 (A)
 CPT50                         273- 277 (A)
 CPT51                         278- 282 (A)
 CPT52                         283- 287 (A)
 CPT53                         288- 292 (A)
 CPT54                         293- 297 (A)
 CPT55                         298- 302 (A)
 CPT56                         303- 307 (A)
 CPT57                         308- 312 (A)
 CPT58                         313- 317 (A)
 CPT59                         318- 322 (A)
 CPT60                         323- 327 (A)
 CPT61                         328- 332 (A)
 CPT62                         333- 337 (A)
 CPT63                         338- 342 (A)
 CPT64                         343- 347 (A)
 CPT65                         348- 352 (A)
 CPT66                         353- 357 (A)
 CPT67                         358- 362 (A)
 CPT68                         363- 367 (A)
 CPT69                         368- 372 (A)
 CPT70                         373- 377 (A)
 CPT71                         378- 382 (A)
 CPT72                         383- 387 (A)
 CPT73                         388- 392 (A)
 CPT74                         393- 397 (A)
 CPT75                         398- 402 (A)
 CPT76                         403- 407 (A)
 CPT77                         408- 412 (A)
 CPT78                         413- 417 (A)
 CPT79                         418- 422 (A)
 CPT80                         423- 427 (A)
 CPT81                         428- 432 (A)
 CPT82                         433- 437 (A)
 CPT83                         438- 442 (A)
 CPT84                         443- 447 (A)
 CPT85                         448- 452 (A)
 CPT86                         453- 457 (A)
 CPT87                         458- 462 (A)
 CPT88                         463- 467 (A)
 CPT89                         468- 472 (A)
 CPT90                         473- 477 (A)
 CPT91                         478- 482 (A)
 CPT92                         483- 487 (A)
 CPT93                         488- 492 (A)
 CPT94                         493- 497 (A)
 CPT95                         498- 502 (A)
 CPT96                         503- 507 (A)
 CPT97                         508- 512 (A)
 CPT98                         513- 517 (A)
 CPT99                         518- 522 (A)
 CPT100                        523- 527 (A)
 CPTCCS1                       528- 530
 CPTCCS2                       531- 533
 CPTCCS3                       534- 536
 CPTCCS4                       537- 539
 CPTCCS5                       540- 542
 CPTCCS6                       543- 545
 CPTCCS7                       546- 548
 CPTCCS8                       549- 551
 CPTCCS9                       552- 554
 CPTCCS10                      555- 557
 CPTCCS11                      558- 560
 CPTCCS12                      561- 563
 CPTCCS13                      564- 566
 CPTCCS14                      567- 569
 CPTCCS15                      570- 572
 CPTCCS16                      573- 575
 CPTCCS17                      576- 578
 CPTCCS18                      579- 581
 CPTCCS19                      582- 584
 CPTCCS20                      585- 587
 CPTCCS21                      588- 590
 CPTCCS22                      591- 593
 CPTCCS23                      594- 596
 CPTCCS24                      597- 599
 CPTCCS25                      600- 602
 CPTCCS26                      603- 605
 CPTCCS27                      606- 608
 CPTCCS28                      609- 611
 CPTCCS29                      612- 614
 CPTCCS30                      615- 617
 CPTCCS31                      618- 620
 CPTCCS32                      621- 623
 CPTCCS33                      624- 626
 CPTCCS34                      627- 629
 CPTCCS35                      630- 632
 CPTCCS36                      633- 635
 CPTCCS37                      636- 638
 CPTCCS38                      639- 641
 CPTCCS39                      642- 644
 CPTCCS40                      645- 647
 CPTCCS41                      648- 650
 CPTCCS42                      651- 653
 CPTCCS43                      654- 656
 CPTCCS44                      657- 659
 CPTCCS45                      660- 662
 CPTCCS46                      663- 665
 CPTCCS47                      666- 668
 CPTCCS48                      669- 671
 CPTCCS49                      672- 674
 CPTCCS50                      675- 677
 CPTCCS51                      678- 680
 CPTCCS52                      681- 683
 CPTCCS53                      684- 686
 CPTCCS54                      687- 689
 CPTCCS55                      690- 692
 CPTCCS56                      693- 695
 CPTCCS57                      696- 698
 CPTCCS58                      699- 701
 CPTCCS59                      702- 704
 CPTCCS60                      705- 707
 CPTCCS61                      708- 710
 CPTCCS62                      711- 713
 CPTCCS63                      714- 716
 CPTCCS64                      717- 719
 CPTCCS65                      720- 722
 CPTCCS66                      723- 725
 CPTCCS67                      726- 728
 CPTCCS68                      729- 731
 CPTCCS69                      732- 734
 CPTCCS70                      735- 737
 CPTCCS71                      738- 740
 CPTCCS72                      741- 743
 CPTCCS73                      744- 746
 CPTCCS74                      747- 749
 CPTCCS75                      750- 752
 CPTCCS76                      753- 755
 CPTCCS77                      756- 758
 CPTCCS78                      759- 761
 CPTCCS79                      762- 764
 CPTCCS80                      765- 767
 CPTCCS81                      768- 770
 CPTCCS82                      771- 773
 CPTCCS83                      774- 776
 CPTCCS84                      777- 779
 CPTCCS85                      780- 782
 CPTCCS86                      783- 785
 CPTCCS87                      786- 788
 CPTCCS88                      789- 791
 CPTCCS89                      792- 794
 CPTCCS90                      795- 797
 CPTCCS91                      798- 800
 CPTCCS92                      801- 803
 CPTCCS93                      804- 806
 CPTCCS94                      807- 809
 CPTCCS95                      810- 812
 CPTCCS96                      813- 815
 CPTCCS97                      816- 818
 CPTCCS98                      819- 821
 CPTCCS99                      822- 824
 CPTCCS100                     825- 827
 CPTM1_1                       828- 829 (A)
 CPTM1_2                       830- 831 (A)
 CPTM1_3                       832- 833 (A)
 CPTM1_4                       834- 835 (A)
 CPTM1_5                       836- 837 (A)
 CPTM1_6                       838- 839 (A)
 CPTM1_7                       840- 841 (A)
 CPTM1_8                       842- 843 (A)
 CPTM1_9                       844- 845 (A)
 CPTM1_10                      846- 847 (A)
 CPTM1_11                      848- 849 (A)
 CPTM1_12                      850- 851 (A)
 CPTM1_13                      852- 853 (A)
 CPTM1_14                      854- 855 (A)
 CPTM1_15                      856- 857 (A)
 CPTM1_16                      858- 859 (A)
 CPTM1_17                      860- 861 (A)
 CPTM1_18                      862- 863 (A)
 CPTM1_19                      864- 865 (A)
 CPTM1_20                      866- 867 (A)
 CPTM1_21                      868- 869 (A)
 CPTM1_22                      870- 871 (A)
 CPTM1_23                      872- 873 (A)
 CPTM1_24                      874- 875 (A)
 CPTM1_25                      876- 877 (A)
 CPTM1_26                      878- 879 (A)
 CPTM1_27                      880- 881 (A)
 CPTM1_28                      882- 883 (A)
 CPTM1_29                      884- 885 (A)
 CPTM1_30                      886- 887 (A)
 CPTM1_31                      888- 889 (A)
 CPTM1_32                      890- 891 (A)
 CPTM1_33                      892- 893 (A)
 CPTM1_34                      894- 895 (A)
 CPTM1_35                      896- 897 (A)
 CPTM1_36                      898- 899 (A)
 CPTM1_37                      900- 901 (A)
 CPTM1_38                      902- 903 (A)
 CPTM1_39                      904- 905 (A)
 CPTM1_40                      906- 907 (A)
 CPTM1_41                      908- 909 (A)
 CPTM1_42                      910- 911 (A)
 CPTM1_43                      912- 913 (A)
 CPTM1_44                      914- 915 (A)
 CPTM1_45                      916- 917 (A)
 CPTM1_46                      918- 919 (A)
 CPTM1_47                      920- 921 (A)
 CPTM1_48                      922- 923 (A)
 CPTM1_49                      924- 925 (A)
 CPTM1_50                      926- 927 (A)
 CPTM1_51                      928- 929 (A)
 CPTM1_52                      930- 931 (A)
 CPTM1_53                      932- 933 (A)
 CPTM1_54                      934- 935 (A)
 CPTM1_55                      936- 937 (A)
 CPTM1_56                      938- 939 (A)
 CPTM1_57                      940- 941 (A)
 CPTM1_58                      942- 943 (A)
 CPTM1_59                      944- 945 (A)
 CPTM1_60                      946- 947 (A)
 CPTM1_61                      948- 949 (A)
 CPTM1_62                      950- 951 (A)
 CPTM1_63                      952- 953 (A)
 CPTM1_64                      954- 955 (A)
 CPTM1_65                      956- 957 (A)
 CPTM1_66                      958- 959 (A)
 CPTM1_67                      960- 961 (A)
 CPTM1_68                      962- 963 (A)
 CPTM1_69                      964- 965 (A)
 CPTM1_70                      966- 967 (A)
 CPTM1_71                      968- 969 (A)
 CPTM1_72                      970- 971 (A)
 CPTM1_73                      972- 973 (A)
 CPTM1_74                      974- 975 (A)
 CPTM1_75                      976- 977 (A)
 CPTM1_76                      978- 979 (A)
 CPTM1_77                      980- 981 (A)
 CPTM1_78                      982- 983 (A)
 CPTM1_79                      984- 985 (A)
 CPTM1_80                      986- 987 (A)
 CPTM1_81                      988- 989 (A)
 CPTM1_82                      990- 991 (A)
 CPTM1_83                      992- 993 (A)
 CPTM1_84                      994- 995 (A)
 CPTM1_85                      996- 997 (A)
 CPTM1_86                      998- 999 (A)
 CPTM1_87                     1000-1001 (A)
 CPTM1_88                     1002-1003 (A)
 CPTM1_89                     1004-1005 (A)
 CPTM1_90                     1006-1007 (A)
 CPTM1_91                     1008-1009 (A)
 CPTM1_92                     1010-1011 (A)
 CPTM1_93                     1012-1013 (A)
 CPTM1_94                     1014-1015 (A)
 CPTM1_95                     1016-1017 (A)
 CPTM1_96                     1018-1019 (A)
 CPTM1_97                     1020-1021 (A)
 CPTM1_98                     1022-1023 (A)
 CPTM1_99                     1024-1025 (A)
 CPTM1_100                    1026-1027 (A)
 CPTM2_1                      1028-1029 (A)
 CPTM2_2                      1030-1031 (A)
 CPTM2_3                      1032-1033 (A)
 CPTM2_4                      1034-1035 (A)
 CPTM2_5                      1036-1037 (A)
 CPTM2_6                      1038-1039 (A)
 CPTM2_7                      1040-1041 (A)
 CPTM2_8                      1042-1043 (A)
 CPTM2_9                      1044-1045 (A)
 CPTM2_10                     1046-1047 (A)
 CPTM2_11                     1048-1049 (A)
 CPTM2_12                     1050-1051 (A)
 CPTM2_13                     1052-1053 (A)
 CPTM2_14                     1054-1055 (A)
 CPTM2_15                     1056-1057 (A)
 CPTM2_16                     1058-1059 (A)
 CPTM2_17                     1060-1061 (A)
 CPTM2_18                     1062-1063 (A)
 CPTM2_19                     1064-1065 (A)
 CPTM2_20                     1066-1067 (A)
 CPTM2_21                     1068-1069 (A)
 CPTM2_22                     1070-1071 (A)
 CPTM2_23                     1072-1073 (A)
 CPTM2_24                     1074-1075 (A)
 CPTM2_25                     1076-1077 (A)
 CPTM2_26                     1078-1079 (A)
 CPTM2_27                     1080-1081 (A)
 CPTM2_28                     1082-1083 (A)
 CPTM2_29                     1084-1085 (A)
 CPTM2_30                     1086-1087 (A)
 CPTM2_31                     1088-1089 (A)
 CPTM2_32                     1090-1091 (A)
 CPTM2_33                     1092-1093 (A)
 CPTM2_34                     1094-1095 (A)
 CPTM2_35                     1096-1097 (A)
 CPTM2_36                     1098-1099 (A)
 CPTM2_37                     1100-1101 (A)
 CPTM2_38                     1102-1103 (A)
 CPTM2_39                     1104-1105 (A)
 CPTM2_40                     1106-1107 (A)
 CPTM2_41                     1108-1109 (A)
 CPTM2_42                     1110-1111 (A)
 CPTM2_43                     1112-1113 (A)
 CPTM2_44                     1114-1115 (A)
 CPTM2_45                     1116-1117 (A)
 CPTM2_46                     1118-1119 (A)
 CPTM2_47                     1120-1121 (A)
 CPTM2_48                     1122-1123 (A)
 CPTM2_49                     1124-1125 (A)
 CPTM2_50                     1126-1127 (A)
 CPTM2_51                     1128-1129 (A)
 CPTM2_52                     1130-1131 (A)
 CPTM2_53                     1132-1133 (A)
 CPTM2_54                     1134-1135 (A)
 CPTM2_55                     1136-1137 (A)
 CPTM2_56                     1138-1139 (A)
 CPTM2_57                     1140-1141 (A)
 CPTM2_58                     1142-1143 (A)
 CPTM2_59                     1144-1145 (A)
 CPTM2_60                     1146-1147 (A)
 CPTM2_61                     1148-1149 (A)
 CPTM2_62                     1150-1151 (A)
 CPTM2_63                     1152-1153 (A)
 CPTM2_64                     1154-1155 (A)
 CPTM2_65                     1156-1157 (A)
 CPTM2_66                     1158-1159 (A)
 CPTM2_67                     1160-1161 (A)
 CPTM2_68                     1162-1163 (A)
 CPTM2_69                     1164-1165 (A)
 CPTM2_70                     1166-1167 (A)
 CPTM2_71                     1168-1169 (A)
 CPTM2_72                     1170-1171 (A)
 CPTM2_73                     1172-1173 (A)
 CPTM2_74                     1174-1175 (A)
 CPTM2_75                     1176-1177 (A)
 CPTM2_76                     1178-1179 (A)
 CPTM2_77                     1180-1181 (A)
 CPTM2_78                     1182-1183 (A)
 CPTM2_79                     1184-1185 (A)
 CPTM2_80                     1186-1187 (A)
 CPTM2_81                     1188-1189 (A)
 CPTM2_82                     1190-1191 (A)
 CPTM2_83                     1192-1193 (A)
 CPTM2_84                     1194-1195 (A)
 CPTM2_85                     1196-1197 (A)
 CPTM2_86                     1198-1199 (A)
 CPTM2_87                     1200-1201 (A)
 CPTM2_88                     1202-1203 (A)
 CPTM2_89                     1204-1205 (A)
 CPTM2_90                     1206-1207 (A)
 CPTM2_91                     1208-1209 (A)
 CPTM2_92                     1210-1211 (A)
 CPTM2_93                     1212-1213 (A)
 CPTM2_94                     1214-1215 (A)
 CPTM2_95                     1216-1217 (A)
 CPTM2_96                     1218-1219 (A)
 CPTM2_97                     1220-1221 (A)
 CPTM2_98                     1222-1223 (A)
 CPTM2_99                     1224-1225 (A)
 CPTM2_100                    1226-1227 (A)
 DHOUR                        1228-1231
 DIED                         1232-1233
 DISP_X                       1234-1235 (A)
 DISPUB04                     1236-1237
 DISPUNIFORM                  1238-1239
 DMONTH                       1240-1241
 DNR                          1242-1243
 DQTR                         1244-1245
 DRG                          1246-1248
 DRG_NoPOA                    1249-1251
 DRGVER                       1252-1253
 DSHOSPID                     1254-1270 (A)
 DXPOA1                       1271     (A)
 DXPOA2                       1272     (A)
 DXPOA3                       1273     (A)
 DXPOA4                       1274     (A)
 DXPOA5                       1275     (A)
 DXPOA6                       1276     (A)
 DXPOA7                       1277     (A)
 DXPOA8                       1278     (A)
 DXPOA9                       1279     (A)
 DXPOA10                      1280     (A)
 DXPOA11                      1281     (A)
 DXPOA12                      1282     (A)
 DXPOA13                      1283     (A)
 DXPOA14                      1284     (A)
 DXPOA15                      1285     (A)
 DXPOA16                      1286     (A)
 DXPOA17                      1287     (A)
 DXPOA18                      1288     (A)
 DXPOA19                      1289     (A)
 DXPOA20                      1290     (A)
 DXPOA21                      1291     (A)
 DXPOA22                      1292     (A)
 DXPOA23                      1293     (A)
 DXPOA24                      1294     (A)
 DXPOA25                      1295     (A)
 DXPOA26                      1296     (A)
 DXPOA27                      1297     (A)
 DXPOA28                      1298     (A)
 DXPOA29                      1299     (A)
 DXPOA30                      1300     (A)
 DXPOA31                      1301     (A)
 DXPOA32                      1302     (A)
 DXPOA33                      1303     (A)
 FEMALE                       1304-1305
 HCUP_ED                      1306-1307
 HCUP_OS                      1308-1309
 HISPANIC                     1310-1311
 HISPANIC_X                   1312-1316 (A)
 Homeless                     1317-1318
 HOSPST                       1319-1320 (A)
 I10_BIRTH                    1321-1322
 I10_DELIVERY                 1323-1324
 I10_DX_Admitting             1325-1331 (A)
 I10_DX1                      1332-1338 (A)
 I10_DX2                      1339-1345 (A)
 I10_DX3                      1346-1352 (A)
 I10_DX4                      1353-1359 (A)
 I10_DX5                      1360-1366 (A)
 I10_DX6                      1367-1373 (A)
 I10_DX7                      1374-1380 (A)
 I10_DX8                      1381-1387 (A)
 I10_DX9                      1388-1394 (A)
 I10_DX10                     1395-1401 (A)
 I10_DX11                     1402-1408 (A)
 I10_DX12                     1409-1415 (A)
 I10_DX13                     1416-1422 (A)
 I10_DX14                     1423-1429 (A)
 I10_DX15                     1430-1436 (A)
 I10_DX16                     1437-1443 (A)
 I10_DX17                     1444-1450 (A)
 I10_DX18                     1451-1457 (A)
 I10_DX19                     1458-1464 (A)
 I10_DX20                     1465-1471 (A)
 I10_DX21                     1472-1478 (A)
 I10_DX22                     1479-1485 (A)
 I10_DX23                     1486-1492 (A)
 I10_DX24                     1493-1499 (A)
 I10_DX25                     1500-1506 (A)
 I10_DX26                     1507-1513 (A)
 I10_DX27                     1514-1520 (A)
 I10_DX28                     1521-1527 (A)
 I10_DX29                     1528-1534 (A)
 I10_DX30                     1535-1541 (A)
 I10_DX31                     1542-1548 (A)
 I10_DX32                     1549-1555 (A)
 I10_DX33                     1556-1562 (A)
 I10_NDX                      1563-1565
 I10_NPR                      1566-1568
 I10_ORPROC                   1569-1570
 I10_PR1                      1571-1577 (A)
 I10_PR2                      1578-1584 (A)
 I10_PR3                      1585-1591 (A)
 I10_PR4                      1592-1598 (A)
 I10_PR5                      1599-1605 (A)
 I10_PR6                      1606-1612 (A)
 I10_PR7                      1613-1619 (A)
 I10_PR8                      1620-1626 (A)
 I10_PR9                      1627-1633 (A)
 I10_PR10                     1634-1640 (A)
 I10_PR11                     1641-1647 (A)
 I10_PR12                     1648-1654 (A)
 I10_PR13                     1655-1661 (A)
 I10_PR14                     1662-1668 (A)
 I10_PR15                     1669-1675 (A)
 I10_PR16                     1676-1682 (A)
 I10_PR17                     1683-1689 (A)
 I10_PR18                     1690-1696 (A)
 I10_PR19                     1697-1703 (A)
 I10_PR20                     1704-1710 (A)
 I10_PR21                     1711-1717 (A)
 I10_PR22                     1718-1724 (A)
 I10_PR23                     1725-1731 (A)
 I10_PR24                     1732-1738 (A)
 I10_PR25                     1739-1745 (A)
 I10_PROCTYPE                 1746-1748
 I10_SERVICELINE              1749-1750
 KEY                          1751-1765
 LOS                          1766-1770
 LOS_X                        1771-1776
 MARITALSTATUS_X              1777     (A)
 MARITALSTATUSUB04            1778     (A)
 MDC                          1779-1780
 MDC_NoPOA                    1781-1782
 MDNUM1_R                     1783-1791
 MDNUM2_R                     1792-1800
 MEDINCSTQ                    1801-1802
 MOMNUM_R                     1803-1811
 MRN_R                        1812-1820
 NCPT                         1821-1824
 OS_TIME                      1825-1835
 P7EDSRC_X                    1836-1837 (A)
 PAY1                         1838-1839
 PAY1_X                       1840-1849 (A)
 PAY2                         1850-1851
 PAY2_X                       1852-1861 (A)
 PAY3                         1862-1863
 PAY3_X                       1864-1873 (A)
 PL_CBSA                      1874-1876
 PL_NCHS                      1877-1878
 PL_RUCC                      1879-1880
 PL_UIC                       1881-1882
 PL_UR_CAT4                   1883-1884
 POA_Disch_Edit1              1885-1886
 POA_Disch_Edit2              1887-1888
 POA_Hosp_Edit1               1889-1890
 POA_Hosp_Edit2               1891-1892
 POA_Hosp_Edit3               1893-1894
 POA_Hosp_Edit3_Value         1895-1902
 PointOfOrigin_X              1903     (A)
 PointOfOriginUB04            1904     (A)
 PRDAY1                       1905-1909
 PRDAY2                       1910-1914
 PRDAY3                       1915-1919
 PRDAY4                       1920-1924
 PRDAY5                       1925-1929
 PRDAY6                       1930-1934
 PRDAY7                       1935-1939
 PRDAY8                       1940-1944
 PRDAY9                       1945-1949
 PRDAY10                      1950-1954
 PRDAY11                      1955-1959
 PRDAY12                      1960-1964
 PRDAY13                      1965-1969
 PRDAY14                      1970-1974
 PRDAY15                      1975-1979
 PRDAY16                      1980-1984
 PRDAY17                      1985-1989
 PRDAY18                      1990-1994
 PRDAY19                      1995-1999
 PRDAY20                      2000-2004
 PRDAY21                      2005-2009
 PRDAY22                      2010-2014
 PRDAY23                      2015-2019
 PRDAY24                      2020-2024
 PRDAY25                      2025-2029
 PrimLang                     2030-2032 (A)
 PSTATE                       2033-2034 (A)
 PSTATE_GEO                   2035-2036 (A)
 PSTCO                        2037-2041
 PSTCO_GEO                    2042-2046
 RACE                         2047-2048
 RACE_EDIT                    2049-2050
 RACE_X                       2051-2055 (A)
 READMIT                      2056-2057
 TOTCHG                       2058-2067
 TOTCHG_X                     2068-2082
 TRAN_IN                      2083-2084
 TRAN_OUT                     2085-2086
 YEAR                         2087-2090
 ZIP                          2091-2095 (A)
 ZIP3                         2096-2098 (A)
 ZIPINC_QRTL                  2099-2101
 TOWN                         2102-2105 (A)
 AYEAR                        2106-2109
 BMONTH                       2110-2111
 BYEAR                        2112-2115
 PRMONTH1                     2116-2117
 PRMONTH2                     2118-2119
 PRMONTH3                     2120-2121
 PRMONTH4                     2122-2123
 PRMONTH5                     2124-2125
 PRMONTH6                     2126-2127
 PRMONTH7                     2128-2129
 PRMONTH8                     2130-2131
 PRMONTH9                     2132-2133
 PRMONTH10                    2134-2135
 PRMONTH11                    2136-2137
 PRMONTH12                    2138-2139
 PRMONTH13                    2140-2141
 PRMONTH14                    2142-2143
 PRMONTH15                    2144-2145
 PRMONTH16                    2146-2147
 PRMONTH17                    2148-2149
 PRMONTH18                    2150-2151
 PRMONTH19                    2152-2153
 PRMONTH20                    2154-2155
 PRMONTH21                    2156-2157
 PRMONTH22                    2158-2159
 PRMONTH23                    2160-2161
 PRMONTH24                    2162-2163
 PRMONTH25                    2164-2165
 PRYEAR1                      2166-2169
 PRYEAR2                      2170-2173
 PRYEAR3                      2174-2177
 PRYEAR4                      2178-2181
 PRYEAR5                      2182-2185
 PRYEAR6                      2186-2189
 PRYEAR7                      2190-2193
 PRYEAR8                      2194-2197
 PRYEAR9                      2198-2201
 PRYEAR10                     2202-2205
 PRYEAR11                     2206-2209
 PRYEAR12                     2210-2213
 PRYEAR13                     2214-2217
 PRYEAR14                     2218-2221
 PRYEAR15                     2222-2225
 PRYEAR16                     2226-2229
 PRYEAR17                     2230-2233
 PRYEAR18                     2234-2237
 PRYEAR19                     2238-2241
 PRYEAR20                     2242-2245
 PRYEAR21                     2246-2249
 PRYEAR22                     2250-2253
 PRYEAR23                     2254-2257
 PRYEAR24                     2258-2261
 PRYEAR25                     2262-2265.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 Homeless                     (F3.0) /
 I10_BIRTH                    (F3.0) /
 I10_DELIVERY                 (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_ORPROC                   (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 I10_SERVICELINE              (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MOMNUM_R                     (F5.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PRDAY22                      (F4.0) /
 PRDAY23                      (F4.0) /
 PRDAY24                      (F4.0) /
 PRDAY25                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO_GEO                    (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 READMIT                      (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRMONTH22                    (F3.0) /
 PRMONTH23                    (F3.0) /
 PRMONTH24                    (F3.0) /
 PRMONTH25                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) /
 PRYEAR22                     (F3.0) /
 PRYEAR23                     (F3.0) /
 PRYEAR24                     (F3.0) /
 PRYEAR25                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM1_51                     "First CPT-4/HCPCS modifier 51"
 CPTM1_52                     "First CPT-4/HCPCS modifier 52"
 CPTM1_53                     "First CPT-4/HCPCS modifier 53"
 CPTM1_54                     "First CPT-4/HCPCS modifier 54"
 CPTM1_55                     "First CPT-4/HCPCS modifier 55"
 CPTM1_56                     "First CPT-4/HCPCS modifier 56"
 CPTM1_57                     "First CPT-4/HCPCS modifier 57"
 CPTM1_58                     "First CPT-4/HCPCS modifier 58"
 CPTM1_59                     "First CPT-4/HCPCS modifier 59"
 CPTM1_60                     "First CPT-4/HCPCS modifier 60"
 CPTM1_61                     "First CPT-4/HCPCS modifier 61"
 CPTM1_62                     "First CPT-4/HCPCS modifier 62"
 CPTM1_63                     "First CPT-4/HCPCS modifier 63"
 CPTM1_64                     "First CPT-4/HCPCS modifier 64"
 CPTM1_65                     "First CPT-4/HCPCS modifier 65"
 CPTM1_66                     "First CPT-4/HCPCS modifier 66"
 CPTM1_67                     "First CPT-4/HCPCS modifier 67"
 CPTM1_68                     "First CPT-4/HCPCS modifier 68"
 CPTM1_69                     "First CPT-4/HCPCS modifier 69"
 CPTM1_70                     "First CPT-4/HCPCS modifier 70"
 CPTM1_71                     "First CPT-4/HCPCS modifier 71"
 CPTM1_72                     "First CPT-4/HCPCS modifier 72"
 CPTM1_73                     "First CPT-4/HCPCS modifier 73"
 CPTM1_74                     "First CPT-4/HCPCS modifier 74"
 CPTM1_75                     "First CPT-4/HCPCS modifier 75"
 CPTM1_76                     "First CPT-4/HCPCS modifier 76"
 CPTM1_77                     "First CPT-4/HCPCS modifier 77"
 CPTM1_78                     "First CPT-4/HCPCS modifier 78"
 CPTM1_79                     "First CPT-4/HCPCS modifier 79"
 CPTM1_80                     "First CPT-4/HCPCS modifier 80"
 CPTM1_81                     "First CPT-4/HCPCS modifier 81"
 CPTM1_82                     "First CPT-4/HCPCS modifier 82"
 CPTM1_83                     "First CPT-4/HCPCS modifier 83"
 CPTM1_84                     "First CPT-4/HCPCS modifier 84"
 CPTM1_85                     "First CPT-4/HCPCS modifier 85"
 CPTM1_86                     "First CPT-4/HCPCS modifier 86"
 CPTM1_87                     "First CPT-4/HCPCS modifier 87"
 CPTM1_88                     "First CPT-4/HCPCS modifier 88"
 CPTM1_89                     "First CPT-4/HCPCS modifier 89"
 CPTM1_90                     "First CPT-4/HCPCS modifier 90"
 CPTM1_91                     "First CPT-4/HCPCS modifier 91"
 CPTM1_92                     "First CPT-4/HCPCS modifier 92"
 CPTM1_93                     "First CPT-4/HCPCS modifier 93"
 CPTM1_94                     "First CPT-4/HCPCS modifier 94"
 CPTM1_95                     "First CPT-4/HCPCS modifier 95"
 CPTM1_96                     "First CPT-4/HCPCS modifier 96"
 CPTM1_97                     "First CPT-4/HCPCS modifier 97"
 CPTM1_98                     "First CPT-4/HCPCS modifier 98"
 CPTM1_99                     "First CPT-4/HCPCS modifier 99"
 CPTM1_100                    "First CPT-4/HCPCS modifier 100"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 CPTM2_51                     "Second CPT-4/HCPCS modifier 51"
 CPTM2_52                     "Second CPT-4/HCPCS modifier 52"
 CPTM2_53                     "Second CPT-4/HCPCS modifier 53"
 CPTM2_54                     "Second CPT-4/HCPCS modifier 54"
 CPTM2_55                     "Second CPT-4/HCPCS modifier 55"
 CPTM2_56                     "Second CPT-4/HCPCS modifier 56"
 CPTM2_57                     "Second CPT-4/HCPCS modifier 57"
 CPTM2_58                     "Second CPT-4/HCPCS modifier 58"
 CPTM2_59                     "Second CPT-4/HCPCS modifier 59"
 CPTM2_60                     "Second CPT-4/HCPCS modifier 60"
 CPTM2_61                     "Second CPT-4/HCPCS modifier 61"
 CPTM2_62                     "Second CPT-4/HCPCS modifier 62"
 CPTM2_63                     "Second CPT-4/HCPCS modifier 63"
 CPTM2_64                     "Second CPT-4/HCPCS modifier 64"
 CPTM2_65                     "Second CPT-4/HCPCS modifier 65"
 CPTM2_66                     "Second CPT-4/HCPCS modifier 66"
 CPTM2_67                     "Second CPT-4/HCPCS modifier 67"
 CPTM2_68                     "Second CPT-4/HCPCS modifier 68"
 CPTM2_69                     "Second CPT-4/HCPCS modifier 69"
 CPTM2_70                     "Second CPT-4/HCPCS modifier 70"
 CPTM2_71                     "Second CPT-4/HCPCS modifier 71"
 CPTM2_72                     "Second CPT-4/HCPCS modifier 72"
 CPTM2_73                     "Second CPT-4/HCPCS modifier 73"
 CPTM2_74                     "Second CPT-4/HCPCS modifier 74"
 CPTM2_75                     "Second CPT-4/HCPCS modifier 75"
 CPTM2_76                     "Second CPT-4/HCPCS modifier 76"
 CPTM2_77                     "Second CPT-4/HCPCS modifier 77"
 CPTM2_78                     "Second CPT-4/HCPCS modifier 78"
 CPTM2_79                     "Second CPT-4/HCPCS modifier 79"
 CPTM2_80                     "Second CPT-4/HCPCS modifier 80"
 CPTM2_81                     "Second CPT-4/HCPCS modifier 81"
 CPTM2_82                     "Second CPT-4/HCPCS modifier 82"
 CPTM2_83                     "Second CPT-4/HCPCS modifier 83"
 CPTM2_84                     "Second CPT-4/HCPCS modifier 84"
 CPTM2_85                     "Second CPT-4/HCPCS modifier 85"
 CPTM2_86                     "Second CPT-4/HCPCS modifier 86"
 CPTM2_87                     "Second CPT-4/HCPCS modifier 87"
 CPTM2_88                     "Second CPT-4/HCPCS modifier 88"
 CPTM2_89                     "Second CPT-4/HCPCS modifier 89"
 CPTM2_90                     "Second CPT-4/HCPCS modifier 90"
 CPTM2_91                     "Second CPT-4/HCPCS modifier 91"
 CPTM2_92                     "Second CPT-4/HCPCS modifier 92"
 CPTM2_93                     "Second CPT-4/HCPCS modifier 93"
 CPTM2_94                     "Second CPT-4/HCPCS modifier 94"
 CPTM2_95                     "Second CPT-4/HCPCS modifier 95"
 CPTM2_96                     "Second CPT-4/HCPCS modifier 96"
 CPTM2_97                     "Second CPT-4/HCPCS modifier 97"
 CPTM2_98                     "Second CPT-4/HCPCS modifier 98"
 CPTM2_99                     "Second CPT-4/HCPCS modifier 99"
 CPTM2_100                    "Second CPT-4/HCPCS modifier 100"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 DXPOA31                      "Diagnosis 31, present on admission indicator"
 DXPOA32                      "Diagnosis 32, present on admission indicator"
 DXPOA33                      "Diagnosis 33, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 Homeless                     "Indicator that patient is homeless"
 HOSPST                       "Hospital state postal code"
 I10_BIRTH                    "ICD-10-CM Birth Indicator"
 I10_DELIVERY                 "ICD-10-CM Delivery Indicator"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_ORPROC                   "ICD-10-PCS Major operating room procedure indicator"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PR22                     "ICD-10-PCS Procedure 22"
 I10_PR23                     "ICD-10-PCS Procedure 23"
 I10_PR24                     "ICD-10-PCS Procedure 24"
 I10_PR25                     "ICD-10-PCS Procedure 25"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 I10_SERVICELINE              "ICD-10-CM/PCS Hospital Service Line"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                     "Mother's number (re-identified)"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PRDAY22                      "Number of days from admission to I10_PR22"
 PRDAY23                      "Number of days from admission to I10_PR23"
 PRDAY24                      "Number of days from admission to I10_PR24"
 PRDAY25                      "Number of days from admission to I10_PR25"
 PrimLang                     "Primary language of patient"
 PSTATE                       "Patient State postal code"
 PSTATE_GEO                   "Patient State postal code assigned from ZIP Code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO_GEO                    "Counties assigned based on ZIP Code geographic centroids"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 READMIT                      "Readmission"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 TOWN                         "Patient town of residence (as received from source)"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRMONTH22                    "Month of procedure 22"
 PRMONTH23                    "Month of procedure 23"
 PRMONTH24                    "Month of procedure 24"
 PRMONTH25                    "Month of procedure 25"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21"
 PRYEAR22                     "Year of procedure 22"
 PRYEAR23                     "Year of procedure 23"
 PRYEAR24                     "Year of procedure 24"
 PRYEAR25                     "Year of procedure 25" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BIRTH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_DELIVERY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_SERVICELINE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO_GEO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NJ_SID_2019_CORE.SAV' /COMPRESSED.
