/*******************************************************************
*   FL_SID_2012_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY AHAL FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'FL_SID_2012_AHAL.ASC' FIXED SKIP=2 / 
 AHAID                      1-   7 (A)
 DSHOSPID                   8-  24 (A)
 HOSPID                    25-  29
 HOSPST                    30-  31 (A)
 YEAR                      32-  35
 HFIPSSTCO                 36-  40.


***  Specify write formats  ***.
FORMATS
 HOSPID                  (F4.0) /
 YEAR                    (F3.0) /
 HFIPSSTCO               (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID                   "AHA hospital identifier with the leading 6"
 DSHOSPID                "Data source hospital identifier"
 HOSPID                  "HCUP hospital identification number"
 HOSPST                  "Hospital state postal code"
 YEAR                    "Calendar year"
 HFIPSSTCO               "Hospital FIPS state/county code" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE HFIPSSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'FL_SID_2012_AHAL.SAV' /COMPRESSED.
