/*******************************************************************
* Creation Date: 10/09/2020   
*   AR_SID_2018_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'AR_SID_2018_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 APGAR1                         16-  17
 APGAR5                         18-  19
 ATYPE                          20-  21
 AWEEKEND                       22-  23
 BILLTYPE                       24-  27 (A)
 BWT                            28-  31
 CPT1                           32-  36 (A)
 CPT2                           37-  41 (A)
 CPT3                           42-  46 (A)
 CPT4                           47-  51 (A)
 CPT5                           52-  56 (A)
 CPT6                           57-  61 (A)
 CPT7                           62-  66 (A)
 CPT8                           67-  71 (A)
 CPT9                           72-  76 (A)
 CPT10                          77-  81 (A)
 CPT11                          82-  86 (A)
 CPT12                          87-  91 (A)
 CPT13                          92-  96 (A)
 CPT14                          97- 101 (A)
 CPT15                         102- 106 (A)
 CPT16                         107- 111 (A)
 CPT17                         112- 116 (A)
 CPT18                         117- 121 (A)
 CPT19                         122- 126 (A)
 CPT20                         127- 131 (A)
 CPT21                         132- 136 (A)
 CPT22                         137- 141 (A)
 CPT23                         142- 146 (A)
 CPT24                         147- 151 (A)
 CPT25                         152- 156 (A)
 CPT26                         157- 161 (A)
 CPT27                         162- 166 (A)
 CPT28                         167- 171 (A)
 CPT29                         172- 176 (A)
 CPT30                         177- 181 (A)
 CPT31                         182- 186 (A)
 CPT32                         187- 191 (A)
 CPT33                         192- 196 (A)
 CPT34                         197- 201 (A)
 CPT35                         202- 206 (A)
 CPT36                         207- 211 (A)
 CPT37                         212- 216 (A)
 CPT38                         217- 221 (A)
 CPT39                         222- 226 (A)
 CPT40                         227- 231 (A)
 CPT41                         232- 236 (A)
 CPT42                         237- 241 (A)
 CPT43                         242- 246 (A)
 CPT44                         247- 251 (A)
 CPT45                         252- 256 (A)
 CPT46                         257- 261 (A)
 CPT47                         262- 266 (A)
 CPT48                         267- 271 (A)
 CPT49                         272- 276 (A)
 CPT50                         277- 281 (A)
 CPT51                         282- 286 (A)
 CPT52                         287- 291 (A)
 CPT53                         292- 296 (A)
 CPT54                         297- 301 (A)
 CPT55                         302- 306 (A)
 CPT56                         307- 311 (A)
 CPT57                         312- 316 (A)
 CPT58                         317- 321 (A)
 CPT59                         322- 326 (A)
 CPT60                         327- 331 (A)
 CPT61                         332- 336 (A)
 CPT62                         337- 341 (A)
 CPT63                         342- 346 (A)
 CPT64                         347- 351 (A)
 CPT65                         352- 356 (A)
 CPT66                         357- 361 (A)
 CPT67                         362- 366 (A)
 CPT68                         367- 371 (A)
 CPT69                         372- 376 (A)
 CPT70                         377- 381 (A)
 CPT71                         382- 386 (A)
 CPT72                         387- 391 (A)
 CPT73                         392- 396 (A)
 CPT74                         397- 401 (A)
 CPT75                         402- 406 (A)
 CPT76                         407- 411 (A)
 CPT77                         412- 416 (A)
 CPT78                         417- 421 (A)
 CPT79                         422- 426 (A)
 CPT80                         427- 431 (A)
 CPT81                         432- 436 (A)
 CPT82                         437- 441 (A)
 CPT83                         442- 446 (A)
 CPT84                         447- 451 (A)
 CPT85                         452- 456 (A)
 CPT86                         457- 461 (A)
 CPT87                         462- 466 (A)
 CPT88                         467- 471 (A)
 CPT89                         472- 476 (A)
 CPT90                         477- 481 (A)
 CPT91                         482- 486 (A)
 CPT92                         487- 491 (A)
 CPT93                         492- 496 (A)
 CPT94                         497- 501 (A)
 CPT95                         502- 506 (A)
 CPT96                         507- 511 (A)
 CPT97                         512- 516 (A)
 CPT98                         517- 521 (A)
 CPT99                         522- 526 (A)
 CPT100                        527- 531 (A)
 CPT101                        532- 536 (A)
 CPT102                        537- 541 (A)
 CPT103                        542- 546 (A)
 CPT104                        547- 551 (A)
 CPT105                        552- 556 (A)
 CPT106                        557- 561 (A)
 CPT107                        562- 566 (A)
 CPT108                        567- 571 (A)
 CPT109                        572- 576 (A)
 CPT110                        577- 581 (A)
 CPT111                        582- 586 (A)
 CPT112                        587- 591 (A)
 CPT113                        592- 596 (A)
 CPT114                        597- 601 (A)
 CPT115                        602- 606 (A)
 CPT116                        607- 611 (A)
 CPT117                        612- 616 (A)
 CPT118                        617- 621 (A)
 CPT119                        622- 626 (A)
 CPT120                        627- 631 (A)
 CPT121                        632- 636 (A)
 CPT122                        637- 641 (A)
 CPT123                        642- 646 (A)
 CPT124                        647- 651 (A)
 CPT125                        652- 656 (A)
 CPT126                        657- 661 (A)
 CPT127                        662- 666 (A)
 CPT128                        667- 671 (A)
 CPT129                        672- 676 (A)
 CPT130                        677- 681 (A)
 CPT131                        682- 686 (A)
 CPT132                        687- 691 (A)
 CPT133                        692- 696 (A)
 CPT134                        697- 701 (A)
 CPT135                        702- 706 (A)
 CPT136                        707- 711 (A)
 CPT137                        712- 716 (A)
 CPT138                        717- 721 (A)
 CPT139                        722- 726 (A)
 CPT140                        727- 731 (A)
 CPT141                        732- 736 (A)
 CPT142                        737- 741 (A)
 CPT143                        742- 746 (A)
 CPT144                        747- 751 (A)
 CPT145                        752- 756 (A)
 CPT146                        757- 761 (A)
 CPT147                        762- 766 (A)
 CPT148                        767- 771 (A)
 CPT149                        772- 776 (A)
 CPT150                        777- 781 (A)
 CPT151                        782- 786 (A)
 CPT152                        787- 791 (A)
 CPT153                        792- 796 (A)
 CPT154                        797- 801 (A)
 CPT155                        802- 806 (A)
 CPT156                        807- 811 (A)
 CPT157                        812- 816 (A)
 CPT158                        817- 821 (A)
 CPT159                        822- 826 (A)
 CPT160                        827- 831 (A)
 CPT161                        832- 836 (A)
 CPT162                        837- 841 (A)
 CPT163                        842- 846 (A)
 CPT164                        847- 851 (A)
 CPT165                        852- 856 (A)
 CPTCCS1                       857- 859
 CPTCCS2                       860- 862
 CPTCCS3                       863- 865
 CPTCCS4                       866- 868
 CPTCCS5                       869- 871
 CPTCCS6                       872- 874
 CPTCCS7                       875- 877
 CPTCCS8                       878- 880
 CPTCCS9                       881- 883
 CPTCCS10                      884- 886
 CPTCCS11                      887- 889
 CPTCCS12                      890- 892
 CPTCCS13                      893- 895
 CPTCCS14                      896- 898
 CPTCCS15                      899- 901
 CPTCCS16                      902- 904
 CPTCCS17                      905- 907
 CPTCCS18                      908- 910
 CPTCCS19                      911- 913
 CPTCCS20                      914- 916
 CPTCCS21                      917- 919
 CPTCCS22                      920- 922
 CPTCCS23                      923- 925
 CPTCCS24                      926- 928
 CPTCCS25                      929- 931
 CPTCCS26                      932- 934
 CPTCCS27                      935- 937
 CPTCCS28                      938- 940
 CPTCCS29                      941- 943
 CPTCCS30                      944- 946
 CPTCCS31                      947- 949
 CPTCCS32                      950- 952
 CPTCCS33                      953- 955
 CPTCCS34                      956- 958
 CPTCCS35                      959- 961
 CPTCCS36                      962- 964
 CPTCCS37                      965- 967
 CPTCCS38                      968- 970
 CPTCCS39                      971- 973
 CPTCCS40                      974- 976
 CPTCCS41                      977- 979
 CPTCCS42                      980- 982
 CPTCCS43                      983- 985
 CPTCCS44                      986- 988
 CPTCCS45                      989- 991
 CPTCCS46                      992- 994
 CPTCCS47                      995- 997
 CPTCCS48                      998-1000
 CPTCCS49                     1001-1003
 CPTCCS50                     1004-1006
 CPTCCS51                     1007-1009
 CPTCCS52                     1010-1012
 CPTCCS53                     1013-1015
 CPTCCS54                     1016-1018
 CPTCCS55                     1019-1021
 CPTCCS56                     1022-1024
 CPTCCS57                     1025-1027
 CPTCCS58                     1028-1030
 CPTCCS59                     1031-1033
 CPTCCS60                     1034-1036
 CPTCCS61                     1037-1039
 CPTCCS62                     1040-1042
 CPTCCS63                     1043-1045
 CPTCCS64                     1046-1048
 CPTCCS65                     1049-1051
 CPTCCS66                     1052-1054
 CPTCCS67                     1055-1057
 CPTCCS68                     1058-1060
 CPTCCS69                     1061-1063
 CPTCCS70                     1064-1066
 CPTCCS71                     1067-1069
 CPTCCS72                     1070-1072
 CPTCCS73                     1073-1075
 CPTCCS74                     1076-1078
 CPTCCS75                     1079-1081
 CPTCCS76                     1082-1084
 CPTCCS77                     1085-1087
 CPTCCS78                     1088-1090
 CPTCCS79                     1091-1093
 CPTCCS80                     1094-1096
 CPTCCS81                     1097-1099
 CPTCCS82                     1100-1102
 CPTCCS83                     1103-1105
 CPTCCS84                     1106-1108
 CPTCCS85                     1109-1111
 CPTCCS86                     1112-1114
 CPTCCS87                     1115-1117
 CPTCCS88                     1118-1120
 CPTCCS89                     1121-1123
 CPTCCS90                     1124-1126
 CPTCCS91                     1127-1129
 CPTCCS92                     1130-1132
 CPTCCS93                     1133-1135
 CPTCCS94                     1136-1138
 CPTCCS95                     1139-1141
 CPTCCS96                     1142-1144
 CPTCCS97                     1145-1147
 CPTCCS98                     1148-1150
 CPTCCS99                     1151-1153
 CPTCCS100                    1154-1156
 CPTCCS101                    1157-1159
 CPTCCS102                    1160-1162
 CPTCCS103                    1163-1165
 CPTCCS104                    1166-1168
 CPTCCS105                    1169-1171
 CPTCCS106                    1172-1174
 CPTCCS107                    1175-1177
 CPTCCS108                    1178-1180
 CPTCCS109                    1181-1183
 CPTCCS110                    1184-1186
 CPTCCS111                    1187-1189
 CPTCCS112                    1190-1192
 CPTCCS113                    1193-1195
 CPTCCS114                    1196-1198
 CPTCCS115                    1199-1201
 CPTCCS116                    1202-1204
 CPTCCS117                    1205-1207
 CPTCCS118                    1208-1210
 CPTCCS119                    1211-1213
 CPTCCS120                    1214-1216
 CPTCCS121                    1217-1219
 CPTCCS122                    1220-1222
 CPTCCS123                    1223-1225
 CPTCCS124                    1226-1228
 CPTCCS125                    1229-1231
 CPTCCS126                    1232-1234
 CPTCCS127                    1235-1237
 CPTCCS128                    1238-1240
 CPTCCS129                    1241-1243
 CPTCCS130                    1244-1246
 CPTCCS131                    1247-1249
 CPTCCS132                    1250-1252
 CPTCCS133                    1253-1255
 CPTCCS134                    1256-1258
 CPTCCS135                    1259-1261
 CPTCCS136                    1262-1264
 CPTCCS137                    1265-1267
 CPTCCS138                    1268-1270
 CPTCCS139                    1271-1273
 CPTCCS140                    1274-1276
 CPTCCS141                    1277-1279
 CPTCCS142                    1280-1282
 CPTCCS143                    1283-1285
 CPTCCS144                    1286-1288
 CPTCCS145                    1289-1291
 CPTCCS146                    1292-1294
 CPTCCS147                    1295-1297
 CPTCCS148                    1298-1300
 CPTCCS149                    1301-1303
 CPTCCS150                    1304-1306
 CPTCCS151                    1307-1309
 CPTCCS152                    1310-1312
 CPTCCS153                    1313-1315
 CPTCCS154                    1316-1318
 CPTCCS155                    1319-1321
 CPTCCS156                    1322-1324
 CPTCCS157                    1325-1327
 CPTCCS158                    1328-1330
 CPTCCS159                    1331-1333
 CPTCCS160                    1334-1336
 CPTCCS161                    1337-1339
 CPTCCS162                    1340-1342
 CPTCCS163                    1343-1345
 CPTCCS164                    1346-1348
 CPTCCS165                    1349-1351
 CPTDAY1                      1352-1354
 CPTDAY2                      1355-1357
 CPTDAY3                      1358-1360
 CPTDAY4                      1361-1363
 CPTDAY5                      1364-1366
 CPTDAY6                      1367-1369
 CPTDAY7                      1370-1372
 CPTDAY8                      1373-1375
 CPTDAY9                      1376-1378
 CPTDAY10                     1379-1381
 CPTDAY11                     1382-1384
 CPTDAY12                     1385-1387
 CPTDAY13                     1388-1390
 CPTDAY14                     1391-1393
 CPTDAY15                     1394-1396
 CPTDAY16                     1397-1399
 CPTDAY17                     1400-1402
 CPTDAY18                     1403-1405
 CPTDAY19                     1406-1408
 CPTDAY20                     1409-1411
 CPTDAY21                     1412-1414
 DaysToEvent                  1415-1420
 DHOUR                        1421-1424
 DIED                         1425-1426
 DISP_X                       1427-1428 (A)
 DISPUB04                     1429-1430
 DISPUNIFORM                  1431-1432
 DMONTH                       1433-1434
 DNR                          1435-1436
 DQTR                         1437-1438
 DRG                          1439-1441
 DRG_NoPOA                    1442-1444
 DRGVER                       1445-1446
 DSHOSPID                     1447-1463 (A)
 DXPOA1                       1464     (A)
 DXPOA2                       1465     (A)
 DXPOA3                       1466     (A)
 DXPOA4                       1467     (A)
 DXPOA5                       1468     (A)
 DXPOA6                       1469     (A)
 DXPOA7                       1470     (A)
 DXPOA8                       1471     (A)
 DXPOA9                       1472     (A)
 DXPOA10                      1473     (A)
 DXPOA11                      1474     (A)
 DXPOA12                      1475     (A)
 DXPOA13                      1476     (A)
 DXPOA14                      1477     (A)
 DXPOA15                      1478     (A)
 DXPOA16                      1479     (A)
 DXPOA17                      1480     (A)
 DXPOA18                      1481     (A)
 DXPOA19                      1482     (A)
 DXPOA20                      1483     (A)
 DXPOA21                      1484     (A)
 DXPOA22                      1485     (A)
 DXPOA23                      1486     (A)
 DXPOA24                      1487     (A)
 DXPOA25                      1488     (A)
 DXPOA26                      1489     (A)
 DXPOA27                      1490     (A)
 DXPOA28                      1491     (A)
 DXPOA29                      1492     (A)
 DXPOA30                      1493     (A)
 FEMALE                       1494-1495
 HCUP_ED                      1496-1497
 HCUP_OS                      1498-1499
 HISPANIC                     1500-1501
 HISPANIC_X                   1502     (A)
 HOSPST                       1503-1504 (A)
 I10_DX_Admitting             1505-1511 (A)
 I10_DX1                      1512-1518 (A)
 I10_DX2                      1519-1525 (A)
 I10_DX3                      1526-1532 (A)
 I10_DX4                      1533-1539 (A)
 I10_DX5                      1540-1546 (A)
 I10_DX6                      1547-1553 (A)
 I10_DX7                      1554-1560 (A)
 I10_DX8                      1561-1567 (A)
 I10_DX9                      1568-1574 (A)
 I10_DX10                     1575-1581 (A)
 I10_DX11                     1582-1588 (A)
 I10_DX12                     1589-1595 (A)
 I10_DX13                     1596-1602 (A)
 I10_DX14                     1603-1609 (A)
 I10_DX15                     1610-1616 (A)
 I10_DX16                     1617-1623 (A)
 I10_DX17                     1624-1630 (A)
 I10_DX18                     1631-1637 (A)
 I10_DX19                     1638-1644 (A)
 I10_DX20                     1645-1651 (A)
 I10_DX21                     1652-1658 (A)
 I10_DX22                     1659-1665 (A)
 I10_DX23                     1666-1672 (A)
 I10_DX24                     1673-1679 (A)
 I10_DX25                     1680-1686 (A)
 I10_DX26                     1687-1693 (A)
 I10_DX27                     1694-1700 (A)
 I10_DX28                     1701-1707 (A)
 I10_DX29                     1708-1714 (A)
 I10_DX30                     1715-1721 (A)
 I10_DX31                     1722-1728 (A)
 I10_DX32                     1729-1735 (A)
 I10_DX33                     1736-1742 (A)
 I10_DX34                     1743-1749 (A)
 I10_DX35                     1750-1756 (A)
 I10_DX36                     1757-1763 (A)
 I10_NDX                      1764-1766
 I10_NPR                      1767-1769
 I10_PR1                      1770-1776 (A)
 I10_PR2                      1777-1783 (A)
 I10_PR3                      1784-1790 (A)
 I10_PR4                      1791-1797 (A)
 I10_PR5                      1798-1804 (A)
 I10_PR6                      1805-1811 (A)
 I10_PR7                      1812-1818 (A)
 I10_PR8                      1819-1825 (A)
 I10_PR9                      1826-1832 (A)
 I10_PR10                     1833-1839 (A)
 I10_PR11                     1840-1846 (A)
 I10_PR12                     1847-1853 (A)
 I10_PR13                     1854-1860 (A)
 I10_PR14                     1861-1867 (A)
 I10_PR15                     1868-1874 (A)
 I10_PR16                     1875-1881 (A)
 I10_PR17                     1882-1888 (A)
 I10_PR18                     1889-1895 (A)
 I10_PR19                     1896-1902 (A)
 I10_PR20                     1903-1909 (A)
 I10_PR21                     1910-1916 (A)
 I10_PROCTYPE                 1917-1919
 KEY                          1920-1934
 LOS                          1935-1939
 LOS_X                        1940-1945
 MARITALSTATUS_X              1946     (A)
 MARITALSTATUSUB04            1947     (A)
 MDC                          1948-1949
 MDC_NoPOA                    1950-1951
 MDNUM1_R                     1952-1960
 MDNUM2_R                     1961-1969
 MDNUM3_R                     1970-1978
 MDNUM4_R                     1979-1987
 MEDINCSTQ                    1988-1989
 MRN_R                        1990-1998
 NCPT                         1999-2002
 OS_TIME                      2003-2013
 P7EDSRC_X                    2014-2015 (A)
 PAY1                         2016-2017
 PAY1_X                       2018     (A)
 PAY2                         2019-2020
 PAY2_X                       2021     (A)
 PAY3                         2022-2023
 PAY3_X                       2024     (A)
 PL_CBSA                      2025-2027
 PL_NCHS                      2028-2029
 PL_RUCC                      2030-2031
 PL_UIC                       2032-2033
 PL_UR_CAT4                   2034-2035
 POA_Disch_Edit1              2036-2037
 POA_Disch_Edit2              2038-2039
 POA_Hosp_Edit1               2040-2041
 POA_Hosp_Edit2               2042-2043
 POA_Hosp_Edit3               2044-2045
 POA_Hosp_Edit3_Value         2046-2053
 PointOfOrigin_X              2054     (A)
 PointOfOriginUB04            2055     (A)
 PRDAY1                       2056-2060
 PRDAY2                       2061-2065
 PRDAY3                       2066-2070
 PRDAY4                       2071-2075
 PRDAY5                       2076-2080
 PRDAY6                       2081-2085
 PRDAY7                       2086-2090
 PRDAY8                       2091-2095
 PRDAY9                       2096-2100
 PRDAY10                      2101-2105
 PRDAY11                      2106-2110
 PRDAY12                      2111-2115
 PRDAY13                      2116-2120
 PRDAY14                      2121-2125
 PRDAY15                      2126-2130
 PRDAY16                      2131-2135
 PRDAY17                      2136-2140
 PRDAY18                      2141-2145
 PRDAY19                      2146-2150
 PRDAY20                      2151-2155
 PRDAY21                      2156-2160
 PSTATE                       2161-2162 (A)
 PSTCO                        2163-2167
 PSTCO2                       2168-2172
 RACE                         2173-2174
 RACE_EDIT                    2175-2176
 RACE_X                       2177     (A)
 TOTCHG                       2178-2187
 TOTCHG_X                     2188-2202
 TRAN_IN                      2203-2204
 TRAN_OUT                     2205-2206
 VisitLink                    2207-2215
 YEAR                         2216-2219
 ZIP3                         2220-2222 (A)
 ZIPINC_QRTL                  2223-2225
 AYEAR                        2226-2229
 BMONTH                       2230-2231
 BYEAR                        2232-2235
 PRMONTH1                     2236-2237
 PRMONTH2                     2238-2239
 PRMONTH3                     2240-2241
 PRMONTH4                     2242-2243
 PRMONTH5                     2244-2245
 PRMONTH6                     2246-2247
 PRMONTH7                     2248-2249
 PRMONTH8                     2250-2251
 PRMONTH9                     2252-2253
 PRMONTH10                    2254-2255
 PRMONTH11                    2256-2257
 PRMONTH12                    2258-2259
 PRMONTH13                    2260-2261
 PRMONTH14                    2262-2263
 PRMONTH15                    2264-2265
 PRMONTH16                    2266-2267
 PRMONTH17                    2268-2269
 PRMONTH18                    2270-2271
 PRMONTH19                    2272-2273
 PRMONTH20                    2274-2275
 PRMONTH21                    2276-2277
 PRYEAR1                      2278-2281
 PRYEAR2                      2282-2285
 PRYEAR3                      2286-2289
 PRYEAR4                      2290-2293
 PRYEAR5                      2294-2297
 PRYEAR6                      2298-2301
 PRYEAR7                      2302-2305
 PRYEAR8                      2306-2309
 PRYEAR9                      2310-2313
 PRYEAR10                     2314-2317
 PRYEAR11                     2318-2321
 PRYEAR12                     2322-2325
 PRYEAR13                     2326-2329
 PRYEAR14                     2330-2333
 PRYEAR15                     2334-2337
 PRYEAR16                     2338-2341
 PRYEAR17                     2342-2345
 PRYEAR18                     2346-2349
 PRYEAR19                     2350-2353
 PRYEAR20                     2354-2357
 PRYEAR21                     2358-2361.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 APGAR1                       (F3.0) /
 APGAR5                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 BWT                          (F4.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 CPTCCS51                     (F4.0) /
 CPTCCS52                     (F4.0) /
 CPTCCS53                     (F4.0) /
 CPTCCS54                     (F4.0) /
 CPTCCS55                     (F4.0) /
 CPTCCS56                     (F4.0) /
 CPTCCS57                     (F4.0) /
 CPTCCS58                     (F4.0) /
 CPTCCS59                     (F4.0) /
 CPTCCS60                     (F4.0) /
 CPTCCS61                     (F4.0) /
 CPTCCS62                     (F4.0) /
 CPTCCS63                     (F4.0) /
 CPTCCS64                     (F4.0) /
 CPTCCS65                     (F4.0) /
 CPTCCS66                     (F4.0) /
 CPTCCS67                     (F4.0) /
 CPTCCS68                     (F4.0) /
 CPTCCS69                     (F4.0) /
 CPTCCS70                     (F4.0) /
 CPTCCS71                     (F4.0) /
 CPTCCS72                     (F4.0) /
 CPTCCS73                     (F4.0) /
 CPTCCS74                     (F4.0) /
 CPTCCS75                     (F4.0) /
 CPTCCS76                     (F4.0) /
 CPTCCS77                     (F4.0) /
 CPTCCS78                     (F4.0) /
 CPTCCS79                     (F4.0) /
 CPTCCS80                     (F4.0) /
 CPTCCS81                     (F4.0) /
 CPTCCS82                     (F4.0) /
 CPTCCS83                     (F4.0) /
 CPTCCS84                     (F4.0) /
 CPTCCS85                     (F4.0) /
 CPTCCS86                     (F4.0) /
 CPTCCS87                     (F4.0) /
 CPTCCS88                     (F4.0) /
 CPTCCS89                     (F4.0) /
 CPTCCS90                     (F4.0) /
 CPTCCS91                     (F4.0) /
 CPTCCS92                     (F4.0) /
 CPTCCS93                     (F4.0) /
 CPTCCS94                     (F4.0) /
 CPTCCS95                     (F4.0) /
 CPTCCS96                     (F4.0) /
 CPTCCS97                     (F4.0) /
 CPTCCS98                     (F4.0) /
 CPTCCS99                     (F4.0) /
 CPTCCS100                    (F4.0) /
 CPTCCS101                    (F4.0) /
 CPTCCS102                    (F4.0) /
 CPTCCS103                    (F4.0) /
 CPTCCS104                    (F4.0) /
 CPTCCS105                    (F4.0) /
 CPTCCS106                    (F4.0) /
 CPTCCS107                    (F4.0) /
 CPTCCS108                    (F4.0) /
 CPTCCS109                    (F4.0) /
 CPTCCS110                    (F4.0) /
 CPTCCS111                    (F4.0) /
 CPTCCS112                    (F4.0) /
 CPTCCS113                    (F4.0) /
 CPTCCS114                    (F4.0) /
 CPTCCS115                    (F4.0) /
 CPTCCS116                    (F4.0) /
 CPTCCS117                    (F4.0) /
 CPTCCS118                    (F4.0) /
 CPTCCS119                    (F4.0) /
 CPTCCS120                    (F4.0) /
 CPTCCS121                    (F4.0) /
 CPTCCS122                    (F4.0) /
 CPTCCS123                    (F4.0) /
 CPTCCS124                    (F4.0) /
 CPTCCS125                    (F4.0) /
 CPTCCS126                    (F4.0) /
 CPTCCS127                    (F4.0) /
 CPTCCS128                    (F4.0) /
 CPTCCS129                    (F4.0) /
 CPTCCS130                    (F4.0) /
 CPTCCS131                    (F4.0) /
 CPTCCS132                    (F4.0) /
 CPTCCS133                    (F4.0) /
 CPTCCS134                    (F4.0) /
 CPTCCS135                    (F4.0) /
 CPTCCS136                    (F4.0) /
 CPTCCS137                    (F4.0) /
 CPTCCS138                    (F4.0) /
 CPTCCS139                    (F4.0) /
 CPTCCS140                    (F4.0) /
 CPTCCS141                    (F4.0) /
 CPTCCS142                    (F4.0) /
 CPTCCS143                    (F4.0) /
 CPTCCS144                    (F4.0) /
 CPTCCS145                    (F4.0) /
 CPTCCS146                    (F4.0) /
 CPTCCS147                    (F4.0) /
 CPTCCS148                    (F4.0) /
 CPTCCS149                    (F4.0) /
 CPTCCS150                    (F4.0) /
 CPTCCS151                    (F4.0) /
 CPTCCS152                    (F4.0) /
 CPTCCS153                    (F4.0) /
 CPTCCS154                    (F4.0) /
 CPTCCS155                    (F4.0) /
 CPTCCS156                    (F4.0) /
 CPTCCS157                    (F4.0) /
 CPTCCS158                    (F4.0) /
 CPTCCS159                    (F4.0) /
 CPTCCS160                    (F4.0) /
 CPTCCS161                    (F4.0) /
 CPTCCS162                    (F4.0) /
 CPTCCS163                    (F4.0) /
 CPTCCS164                    (F4.0) /
 CPTCCS165                    (F4.0) /
 CPTDAY1                      (F4.0) /
 CPTDAY2                      (F4.0) /
 CPTDAY3                      (F4.0) /
 CPTDAY4                      (F4.0) /
 CPTDAY5                      (F4.0) /
 CPTDAY6                      (F4.0) /
 CPTDAY7                      (F4.0) /
 CPTDAY8                      (F4.0) /
 CPTDAY9                      (F4.0) /
 CPTDAY10                     (F4.0) /
 CPTDAY11                     (F4.0) /
 CPTDAY12                     (F4.0) /
 CPTDAY13                     (F4.0) /
 CPTDAY14                     (F4.0) /
 CPTDAY15                     (F4.0) /
 CPTDAY16                     (F4.0) /
 CPTDAY17                     (F4.0) /
 CPTDAY18                     (F4.0) /
 CPTDAY19                     (F4.0) /
 CPTDAY20                     (F4.0) /
 CPTDAY21                     (F4.0) /
 DaysToEvent                  (F8.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DNR                          (F3.0) /
 DQTR                         (F3.0) /
 DRG                          (F3.0) /
 DRG_NoPOA                    (F3.0) /
 DRGVER                       (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HISPANIC                     (F3.0) /
 I10_NDX                      (F3.0) /
 I10_NPR                      (F3.0) /
 I10_PROCTYPE                 (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDC                          (F3.0) /
 MDC_NoPOA                    (F3.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MDNUM3_R                     (F5.0) /
 MDNUM4_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MRN_R                        (F5.0) /
 NCPT                         (F3.0) /
 OS_TIME                      (F4.2) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PRDAY21                      (F4.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 RACE_EDIT                    (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 TRAN_IN                      (F3.0) /
 TRAN_OUT                     (F3.0) /
 VisitLink                    (F8.0) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRMONTH21                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) /
 PRYEAR21                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 APGAR1                       "One-minute APGAR score"
 APGAR5                       "Five-minute APGAR score"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 BWT                          "Birth weight in grams"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPT51                        "CPT/HCPCS procedure code 51"
 CPT52                        "CPT/HCPCS procedure code 52"
 CPT53                        "CPT/HCPCS procedure code 53"
 CPT54                        "CPT/HCPCS procedure code 54"
 CPT55                        "CPT/HCPCS procedure code 55"
 CPT56                        "CPT/HCPCS procedure code 56"
 CPT57                        "CPT/HCPCS procedure code 57"
 CPT58                        "CPT/HCPCS procedure code 58"
 CPT59                        "CPT/HCPCS procedure code 59"
 CPT60                        "CPT/HCPCS procedure code 60"
 CPT61                        "CPT/HCPCS procedure code 61"
 CPT62                        "CPT/HCPCS procedure code 62"
 CPT63                        "CPT/HCPCS procedure code 63"
 CPT64                        "CPT/HCPCS procedure code 64"
 CPT65                        "CPT/HCPCS procedure code 65"
 CPT66                        "CPT/HCPCS procedure code 66"
 CPT67                        "CPT/HCPCS procedure code 67"
 CPT68                        "CPT/HCPCS procedure code 68"
 CPT69                        "CPT/HCPCS procedure code 69"
 CPT70                        "CPT/HCPCS procedure code 70"
 CPT71                        "CPT/HCPCS procedure code 71"
 CPT72                        "CPT/HCPCS procedure code 72"
 CPT73                        "CPT/HCPCS procedure code 73"
 CPT74                        "CPT/HCPCS procedure code 74"
 CPT75                        "CPT/HCPCS procedure code 75"
 CPT76                        "CPT/HCPCS procedure code 76"
 CPT77                        "CPT/HCPCS procedure code 77"
 CPT78                        "CPT/HCPCS procedure code 78"
 CPT79                        "CPT/HCPCS procedure code 79"
 CPT80                        "CPT/HCPCS procedure code 80"
 CPT81                        "CPT/HCPCS procedure code 81"
 CPT82                        "CPT/HCPCS procedure code 82"
 CPT83                        "CPT/HCPCS procedure code 83"
 CPT84                        "CPT/HCPCS procedure code 84"
 CPT85                        "CPT/HCPCS procedure code 85"
 CPT86                        "CPT/HCPCS procedure code 86"
 CPT87                        "CPT/HCPCS procedure code 87"
 CPT88                        "CPT/HCPCS procedure code 88"
 CPT89                        "CPT/HCPCS procedure code 89"
 CPT90                        "CPT/HCPCS procedure code 90"
 CPT91                        "CPT/HCPCS procedure code 91"
 CPT92                        "CPT/HCPCS procedure code 92"
 CPT93                        "CPT/HCPCS procedure code 93"
 CPT94                        "CPT/HCPCS procedure code 94"
 CPT95                        "CPT/HCPCS procedure code 95"
 CPT96                        "CPT/HCPCS procedure code 96"
 CPT97                        "CPT/HCPCS procedure code 97"
 CPT98                        "CPT/HCPCS procedure code 98"
 CPT99                        "CPT/HCPCS procedure code 99"
 CPT100                       "CPT/HCPCS procedure code 100"
 CPT101                       "CPT/HCPCS procedure code 101"
 CPT102                       "CPT/HCPCS procedure code 102"
 CPT103                       "CPT/HCPCS procedure code 103"
 CPT104                       "CPT/HCPCS procedure code 104"
 CPT105                       "CPT/HCPCS procedure code 105"
 CPT106                       "CPT/HCPCS procedure code 106"
 CPT107                       "CPT/HCPCS procedure code 107"
 CPT108                       "CPT/HCPCS procedure code 108"
 CPT109                       "CPT/HCPCS procedure code 109"
 CPT110                       "CPT/HCPCS procedure code 110"
 CPT111                       "CPT/HCPCS procedure code 111"
 CPT112                       "CPT/HCPCS procedure code 112"
 CPT113                       "CPT/HCPCS procedure code 113"
 CPT114                       "CPT/HCPCS procedure code 114"
 CPT115                       "CPT/HCPCS procedure code 115"
 CPT116                       "CPT/HCPCS procedure code 116"
 CPT117                       "CPT/HCPCS procedure code 117"
 CPT118                       "CPT/HCPCS procedure code 118"
 CPT119                       "CPT/HCPCS procedure code 119"
 CPT120                       "CPT/HCPCS procedure code 120"
 CPT121                       "CPT/HCPCS procedure code 121"
 CPT122                       "CPT/HCPCS procedure code 122"
 CPT123                       "CPT/HCPCS procedure code 123"
 CPT124                       "CPT/HCPCS procedure code 124"
 CPT125                       "CPT/HCPCS procedure code 125"
 CPT126                       "CPT/HCPCS procedure code 126"
 CPT127                       "CPT/HCPCS procedure code 127"
 CPT128                       "CPT/HCPCS procedure code 128"
 CPT129                       "CPT/HCPCS procedure code 129"
 CPT130                       "CPT/HCPCS procedure code 130"
 CPT131                       "CPT/HCPCS procedure code 131"
 CPT132                       "CPT/HCPCS procedure code 132"
 CPT133                       "CPT/HCPCS procedure code 133"
 CPT134                       "CPT/HCPCS procedure code 134"
 CPT135                       "CPT/HCPCS procedure code 135"
 CPT136                       "CPT/HCPCS procedure code 136"
 CPT137                       "CPT/HCPCS procedure code 137"
 CPT138                       "CPT/HCPCS procedure code 138"
 CPT139                       "CPT/HCPCS procedure code 139"
 CPT140                       "CPT/HCPCS procedure code 140"
 CPT141                       "CPT/HCPCS procedure code 141"
 CPT142                       "CPT/HCPCS procedure code 142"
 CPT143                       "CPT/HCPCS procedure code 143"
 CPT144                       "CPT/HCPCS procedure code 144"
 CPT145                       "CPT/HCPCS procedure code 145"
 CPT146                       "CPT/HCPCS procedure code 146"
 CPT147                       "CPT/HCPCS procedure code 147"
 CPT148                       "CPT/HCPCS procedure code 148"
 CPT149                       "CPT/HCPCS procedure code 149"
 CPT150                       "CPT/HCPCS procedure code 150"
 CPT151                       "CPT/HCPCS procedure code 151"
 CPT152                       "CPT/HCPCS procedure code 152"
 CPT153                       "CPT/HCPCS procedure code 153"
 CPT154                       "CPT/HCPCS procedure code 154"
 CPT155                       "CPT/HCPCS procedure code 155"
 CPT156                       "CPT/HCPCS procedure code 156"
 CPT157                       "CPT/HCPCS procedure code 157"
 CPT158                       "CPT/HCPCS procedure code 158"
 CPT159                       "CPT/HCPCS procedure code 159"
 CPT160                       "CPT/HCPCS procedure code 160"
 CPT161                       "CPT/HCPCS procedure code 161"
 CPT162                       "CPT/HCPCS procedure code 162"
 CPT163                       "CPT/HCPCS procedure code 163"
 CPT164                       "CPT/HCPCS procedure code 164"
 CPT165                       "CPT/HCPCS procedure code 165"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTCCS51                     "CCS: CPT 51"
 CPTCCS52                     "CCS: CPT 52"
 CPTCCS53                     "CCS: CPT 53"
 CPTCCS54                     "CCS: CPT 54"
 CPTCCS55                     "CCS: CPT 55"
 CPTCCS56                     "CCS: CPT 56"
 CPTCCS57                     "CCS: CPT 57"
 CPTCCS58                     "CCS: CPT 58"
 CPTCCS59                     "CCS: CPT 59"
 CPTCCS60                     "CCS: CPT 60"
 CPTCCS61                     "CCS: CPT 61"
 CPTCCS62                     "CCS: CPT 62"
 CPTCCS63                     "CCS: CPT 63"
 CPTCCS64                     "CCS: CPT 64"
 CPTCCS65                     "CCS: CPT 65"
 CPTCCS66                     "CCS: CPT 66"
 CPTCCS67                     "CCS: CPT 67"
 CPTCCS68                     "CCS: CPT 68"
 CPTCCS69                     "CCS: CPT 69"
 CPTCCS70                     "CCS: CPT 70"
 CPTCCS71                     "CCS: CPT 71"
 CPTCCS72                     "CCS: CPT 72"
 CPTCCS73                     "CCS: CPT 73"
 CPTCCS74                     "CCS: CPT 74"
 CPTCCS75                     "CCS: CPT 75"
 CPTCCS76                     "CCS: CPT 76"
 CPTCCS77                     "CCS: CPT 77"
 CPTCCS78                     "CCS: CPT 78"
 CPTCCS79                     "CCS: CPT 79"
 CPTCCS80                     "CCS: CPT 80"
 CPTCCS81                     "CCS: CPT 81"
 CPTCCS82                     "CCS: CPT 82"
 CPTCCS83                     "CCS: CPT 83"
 CPTCCS84                     "CCS: CPT 84"
 CPTCCS85                     "CCS: CPT 85"
 CPTCCS86                     "CCS: CPT 86"
 CPTCCS87                     "CCS: CPT 87"
 CPTCCS88                     "CCS: CPT 88"
 CPTCCS89                     "CCS: CPT 89"
 CPTCCS90                     "CCS: CPT 90"
 CPTCCS91                     "CCS: CPT 91"
 CPTCCS92                     "CCS: CPT 92"
 CPTCCS93                     "CCS: CPT 93"
 CPTCCS94                     "CCS: CPT 94"
 CPTCCS95                     "CCS: CPT 95"
 CPTCCS96                     "CCS: CPT 96"
 CPTCCS97                     "CCS: CPT 97"
 CPTCCS98                     "CCS: CPT 98"
 CPTCCS99                     "CCS: CPT 99"
 CPTCCS100                    "CCS: CPT 100"
 CPTCCS101                    "CCS: CPT 101"
 CPTCCS102                    "CCS: CPT 102"
 CPTCCS103                    "CCS: CPT 103"
 CPTCCS104                    "CCS: CPT 104"
 CPTCCS105                    "CCS: CPT 105"
 CPTCCS106                    "CCS: CPT 106"
 CPTCCS107                    "CCS: CPT 107"
 CPTCCS108                    "CCS: CPT 108"
 CPTCCS109                    "CCS: CPT 109"
 CPTCCS110                    "CCS: CPT 110"
 CPTCCS111                    "CCS: CPT 111"
 CPTCCS112                    "CCS: CPT 112"
 CPTCCS113                    "CCS: CPT 113"
 CPTCCS114                    "CCS: CPT 114"
 CPTCCS115                    "CCS: CPT 115"
 CPTCCS116                    "CCS: CPT 116"
 CPTCCS117                    "CCS: CPT 117"
 CPTCCS118                    "CCS: CPT 118"
 CPTCCS119                    "CCS: CPT 119"
 CPTCCS120                    "CCS: CPT 120"
 CPTCCS121                    "CCS: CPT 121"
 CPTCCS122                    "CCS: CPT 122"
 CPTCCS123                    "CCS: CPT 123"
 CPTCCS124                    "CCS: CPT 124"
 CPTCCS125                    "CCS: CPT 125"
 CPTCCS126                    "CCS: CPT 126"
 CPTCCS127                    "CCS: CPT 127"
 CPTCCS128                    "CCS: CPT 128"
 CPTCCS129                    "CCS: CPT 129"
 CPTCCS130                    "CCS: CPT 130"
 CPTCCS131                    "CCS: CPT 131"
 CPTCCS132                    "CCS: CPT 132"
 CPTCCS133                    "CCS: CPT 133"
 CPTCCS134                    "CCS: CPT 134"
 CPTCCS135                    "CCS: CPT 135"
 CPTCCS136                    "CCS: CPT 136"
 CPTCCS137                    "CCS: CPT 137"
 CPTCCS138                    "CCS: CPT 138"
 CPTCCS139                    "CCS: CPT 139"
 CPTCCS140                    "CCS: CPT 140"
 CPTCCS141                    "CCS: CPT 141"
 CPTCCS142                    "CCS: CPT 142"
 CPTCCS143                    "CCS: CPT 143"
 CPTCCS144                    "CCS: CPT 144"
 CPTCCS145                    "CCS: CPT 145"
 CPTCCS146                    "CCS: CPT 146"
 CPTCCS147                    "CCS: CPT 147"
 CPTCCS148                    "CCS: CPT 148"
 CPTCCS149                    "CCS: CPT 149"
 CPTCCS150                    "CCS: CPT 150"
 CPTCCS151                    "CCS: CPT 151"
 CPTCCS152                    "CCS: CPT 152"
 CPTCCS153                    "CCS: CPT 153"
 CPTCCS154                    "CCS: CPT 154"
 CPTCCS155                    "CCS: CPT 155"
 CPTCCS156                    "CCS: CPT 156"
 CPTCCS157                    "CCS: CPT 157"
 CPTCCS158                    "CCS: CPT 158"
 CPTCCS159                    "CCS: CPT 159"
 CPTCCS160                    "CCS: CPT 160"
 CPTCCS161                    "CCS: CPT 161"
 CPTCCS162                    "CCS: CPT 162"
 CPTCCS163                    "CCS: CPT 163"
 CPTCCS164                    "CCS: CPT 164"
 CPTCCS165                    "CCS: CPT 165"
 CPTDAY1                      "Number of days from admission to CPT1"
 CPTDAY2                      "Number of days from admission to CPT2"
 CPTDAY3                      "Number of days from admission to CPT3"
 CPTDAY4                      "Number of days from admission to CPT4"
 CPTDAY5                      "Number of days from admission to CPT5"
 CPTDAY6                      "Number of days from admission to CPT6"
 CPTDAY7                      "Number of days from admission to CPT7"
 CPTDAY8                      "Number of days from admission to CPT8"
 CPTDAY9                      "Number of days from admission to CPT9"
 CPTDAY10                     "Number of days from admission to CPT10"
 CPTDAY11                     "Number of days from admission to CPT11"
 CPTDAY12                     "Number of days from admission to CPT12"
 CPTDAY13                     "Number of days from admission to CPT13"
 CPTDAY14                     "Number of days from admission to CPT14"
 CPTDAY15                     "Number of days from admission to CPT15"
 CPTDAY16                     "Number of days from admission to CPT16"
 CPTDAY17                     "Number of days from admission to CPT17"
 CPTDAY18                     "Number of days from admission to CPT18"
 CPTDAY19                     "Number of days from admission to CPT19"
 CPTDAY20                     "Number of days from admission to CPT20"
 CPTDAY21                     "Number of days from admission to CPT21"
 DaysToEvent                  "Days from 'start date' to admission"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISP_X                       "Disposition of patient (as received from source)"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DMONTH                       "Discharge month"
 DNR                          "Do not resuscitate indicator"
 DQTR                         "Discharge quarter"
 DRG                          "DRG in effect on discharge date"
 DRG_NoPOA                    "DRG in use on discharge date, calculated without POA"
 DRGVER                       "DRG grouper version used on discharge date"
 DSHOSPID                     "Data source hospital identifier"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXPOA25                      "Diagnosis 25, present on admission indicator"
 DXPOA26                      "Diagnosis 26, present on admission indicator"
 DXPOA27                      "Diagnosis 27, present on admission indicator"
 DXPOA28                      "Diagnosis 28, present on admission indicator"
 DXPOA29                      "Diagnosis 29, present on admission indicator"
 DXPOA30                      "Diagnosis 30, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC                     "Hispanic ethnicity (uniform)"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPST                       "Hospital state postal code"
 I10_DX_Admitting             "ICD-10-CM Admitting Diagnosis Code"
 I10_DX1                      "ICD-10-CM Diagnosis 1"
 I10_DX2                      "ICD-10-CM Diagnosis 2"
 I10_DX3                      "ICD-10-CM Diagnosis 3"
 I10_DX4                      "ICD-10-CM Diagnosis 4"
 I10_DX5                      "ICD-10-CM Diagnosis 5"
 I10_DX6                      "ICD-10-CM Diagnosis 6"
 I10_DX7                      "ICD-10-CM Diagnosis 7"
 I10_DX8                      "ICD-10-CM Diagnosis 8"
 I10_DX9                      "ICD-10-CM Diagnosis 9"
 I10_DX10                     "ICD-10-CM Diagnosis 10"
 I10_DX11                     "ICD-10-CM Diagnosis 11"
 I10_DX12                     "ICD-10-CM Diagnosis 12"
 I10_DX13                     "ICD-10-CM Diagnosis 13"
 I10_DX14                     "ICD-10-CM Diagnosis 14"
 I10_DX15                     "ICD-10-CM Diagnosis 15"
 I10_DX16                     "ICD-10-CM Diagnosis 16"
 I10_DX17                     "ICD-10-CM Diagnosis 17"
 I10_DX18                     "ICD-10-CM Diagnosis 18"
 I10_DX19                     "ICD-10-CM Diagnosis 19"
 I10_DX20                     "ICD-10-CM Diagnosis 20"
 I10_DX21                     "ICD-10-CM Diagnosis 21"
 I10_DX22                     "ICD-10-CM Diagnosis 22"
 I10_DX23                     "ICD-10-CM Diagnosis 23"
 I10_DX24                     "ICD-10-CM Diagnosis 24"
 I10_DX25                     "ICD-10-CM Diagnosis 25"
 I10_DX26                     "ICD-10-CM Diagnosis 26"
 I10_DX27                     "ICD-10-CM Diagnosis 27"
 I10_DX28                     "ICD-10-CM Diagnosis 28"
 I10_DX29                     "ICD-10-CM Diagnosis 29"
 I10_DX30                     "ICD-10-CM Diagnosis 30"
 I10_DX31                     "ICD-10-CM Diagnosis 31"
 I10_DX32                     "ICD-10-CM Diagnosis 32"
 I10_DX33                     "ICD-10-CM Diagnosis 33"
 I10_DX34                     "ICD-10-CM Diagnosis 34"
 I10_DX35                     "ICD-10-CM Diagnosis 35"
 I10_DX36                     "ICD-10-CM Diagnosis 36"
 I10_NDX                      "ICD-10-CM Number of diagnoses on this record"
 I10_NPR                      "ICD-10-PCS Number of procedures on this record"
 I10_PR1                      "ICD-10-PCS Procedure 1"
 I10_PR2                      "ICD-10-PCS Procedure 2"
 I10_PR3                      "ICD-10-PCS Procedure 3"
 I10_PR4                      "ICD-10-PCS Procedure 4"
 I10_PR5                      "ICD-10-PCS Procedure 5"
 I10_PR6                      "ICD-10-PCS Procedure 6"
 I10_PR7                      "ICD-10-PCS Procedure 7"
 I10_PR8                      "ICD-10-PCS Procedure 8"
 I10_PR9                      "ICD-10-PCS Procedure 9"
 I10_PR10                     "ICD-10-PCS Procedure 10"
 I10_PR11                     "ICD-10-PCS Procedure 11"
 I10_PR12                     "ICD-10-PCS Procedure 12"
 I10_PR13                     "ICD-10-PCS Procedure 13"
 I10_PR14                     "ICD-10-PCS Procedure 14"
 I10_PR15                     "ICD-10-PCS Procedure 15"
 I10_PR16                     "ICD-10-PCS Procedure 16"
 I10_PR17                     "ICD-10-PCS Procedure 17"
 I10_PR18                     "ICD-10-PCS Procedure 18"
 I10_PR19                     "ICD-10-PCS Procedure 19"
 I10_PR20                     "ICD-10-PCS Procedure 20"
 I10_PR21                     "ICD-10-PCS Procedure 21"
 I10_PROCTYPE                 "ICD-10-PCS Procedure type indicator"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUS_X              "Patient's marital status (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDC                          "MDC in effect on discharge date"
 MDC_NoPOA                    "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MDNUM3_R                     "Physician 3 number (re-identified)"
 MDNUM4_R                     "Physician 4 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MRN_R                        "Medical record number (re-identified)"
 NCPT                         "Number of CPT/HCPCS procedures for this visit"
 OS_TIME                      "Observation stay time summed from UNITS"
 P7EDSRC_X                    "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes (RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2              "Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1               "Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2               "Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value         "Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PointOfOrigin_X              "Point of origin for admission or visit, as received from source"
 PointOfOriginUB04            "Point of origin for admission or visit, UB-04 standard coding"
 PRDAY1                       "Number of days from admission to I10_PR1"
 PRDAY2                       "Number of days from admission to I10_PR2"
 PRDAY3                       "Number of days from admission to I10_PR3"
 PRDAY4                       "Number of days from admission to I10_PR4"
 PRDAY5                       "Number of days from admission to I10_PR5"
 PRDAY6                       "Number of days from admission to I10_PR6"
 PRDAY7                       "Number of days from admission to I10_PR7"
 PRDAY8                       "Number of days from admission to I10_PR8"
 PRDAY9                       "Number of days from admission to I10_PR9"
 PRDAY10                      "Number of days from admission to I10_PR10"
 PRDAY11                      "Number of days from admission to I10_PR11"
 PRDAY12                      "Number of days from admission to I10_PR12"
 PRDAY13                      "Number of days from admission to I10_PR13"
 PRDAY14                      "Number of days from admission to I10_PR14"
 PRDAY15                      "Number of days from admission to I10_PR15"
 PRDAY16                      "Number of days from admission to I10_PR16"
 PRDAY17                      "Number of days from admission to I10_PR17"
 PRDAY18                      "Number of days from admission to I10_PR18"
 PRDAY19                      "Number of days from admission to I10_PR19"
 PRDAY20                      "Number of days from admission to I10_PR20"
 PRDAY21                      "Number of days from admission to I10_PR21"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2                       "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                         "Race (uniform)"
 RACE_EDIT                    "Race Edit Checks"
 RACE_X                       "Race (as received from source)"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 TRAN_IN                      "Transfer in indicator"
 TRAN_OUT                     "Transfer out indicator"
 VisitLink                    "Visit linkage variable"
 YEAR                         "Calendar year"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL                  "Median household income national quartile for patient ZIP Code"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRMONTH21                    "Month of procedure 21"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20"
 PRYEAR21                     "Year of procedure 21" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE APGAR1
 (-9,-8,-6,-5=SYSMIS).
RECODE APGAR5
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS51
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS52
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS53
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS54
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS55
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS56
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS57
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS58
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS59
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS60
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS61
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS62
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS63
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS64
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS65
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS66
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS67
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS68
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS69
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS70
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS71
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS72
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS73
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS74
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS75
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS76
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS77
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS78
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS79
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS80
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS81
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS82
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS83
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS84
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS85
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS86
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS87
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS88
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS89
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS90
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS91
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS92
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS93
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS94
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS95
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS96
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS97
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS98
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS99
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS100
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS101
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS102
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS103
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS104
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS105
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS106
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS107
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS108
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS109
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS110
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS111
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS112
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS113
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS114
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS115
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS116
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS117
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS118
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS119
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS120
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS121
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS122
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS123
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS124
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS125
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS126
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS127
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS128
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS129
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS130
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS131
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS132
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS133
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS134
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS135
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS136
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS137
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS138
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS139
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS140
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS141
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS142
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS143
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS144
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS145
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS146
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS147
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS148
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS149
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS150
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS151
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS152
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS153
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS154
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS155
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS156
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS157
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS158
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS159
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS160
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS161
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS162
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS163
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS164
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS165
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HISPANIC
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE I10_PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM4_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE OS_TIME
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE RACE_EDIT
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AR_SID_2018_CORE.SAV' /COMPRESSED.
