/*******************************************************************
*   RI_SID_2010_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY AHAL FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'RI_SID_2010_AHAL.ASC' FIXED / 
 AHAID                      1-   7 (A)
 DSHOSPID                   8-  24 (A)
 HOSPID                    25-  29
 HOSPST                    30-  31 (A)
 HOSPSTCO                  32-  36
 YEAR                      37-  40.


***  Specify write formats  ***.
FORMATS
 HOSPID                  (F4.0) /
 HOSPSTCO                (F4.0) /
 YEAR                    (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID                   "AHA hospital identifier with the leading 6"
 DSHOSPID                "Data source hospital identifier"
 HOSPID                  "HCUP hospital identification number"
 HOSPST                  "Hospital state postal code"
 HOSPSTCO                "Hospital modified FIPS state/county code"
 YEAR                    "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE HOSPSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).



SAVE OUTFILE = 'RI_SID_2010_AHAL.SAV' /COMPRESSED.
