/*******************************************************************
*   NY_SID_2001_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CHGS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NY_SID_2001_CHGS.ASC' FIXED / 
 KEY                   1-  14
 CHG1                 15-  26
 CHG2                 27-  38
 CHG3                 39-  50
 CHG4                 51-  62
 CHG5                 63-  74
 CHG6                 75-  86
 CHG7                 87-  98
 CHG8                 99- 110
 CHG9                111- 122
 CHG10               123- 134
 CHG11               135- 146
 CHG12               147- 158
 CHG13               159- 170
 CHG14               171- 182
 CHG15               183- 194
 CHG16               195- 206
 CHG17               207- 218
 CHG18               219- 230
 CHG19               231- 242
 CHG20               243- 254
 CHG21               255- 266
 CHG22               267- 278
 CHG23               279- 290
 CHG24               291- 302
 CHG25               303- 314
 RATE1               315- 320
 RATE2               321- 326
 RATE3               327- 332
 RATE4               333- 338
 RATE5               339- 344
 REVCD1              345- 348 (A)
 REVCD2              349- 352 (A)
 REVCD3              353- 356 (A)
 REVCD4              357- 360 (A)
 REVCD5              361- 364 (A)
 REVCD6              365- 368 (A)
 REVCD7              369- 372 (A)
 REVCD8              373- 376 (A)
 REVCD9              377- 380 (A)
 REVCD10             381- 384 (A)
 REVCD11             385- 388 (A)
 REVCD12             389- 392 (A)
 REVCD13             393- 396 (A)
 REVCD14             397- 400 (A)
 REVCD15             401- 404 (A)
 REVCD16             405- 408 (A)
 REVCD17             409- 412 (A)
 REVCD18             413- 416 (A)
 REVCD19             417- 420 (A)
 REVCD20             421- 424 (A)
 REVCD21             425- 428 (A)
 REVCD22             429- 432 (A)
 REVCD23             433- 436 (A)
 REVCD24             437- 440 (A)
 REVCD25             441- 444 (A)
 UNIT1               445- 448
 UNIT2               449- 452
 UNIT3               453- 456
 UNIT4               457- 460
 UNIT5               461- 464.


***  Specify write formats  ***.
FORMATS
 KEY                 (F8.0) /
 CHG1                (F6.2) /
 CHG2                (F6.2) /
 CHG3                (F6.2) /
 CHG4                (F6.2) /
 CHG5                (F6.2) /
 CHG6                (F6.2) /
 CHG7                (F6.2) /
 CHG8                (F6.2) /
 CHG9                (F6.2) /
 CHG10               (F6.2) /
 CHG11               (F6.2) /
 CHG12               (F6.2) /
 CHG13               (F6.2) /
 CHG14               (F6.2) /
 CHG15               (F6.2) /
 CHG16               (F6.2) /
 CHG17               (F6.2) /
 CHG18               (F6.2) /
 CHG19               (F6.2) /
 CHG20               (F6.2) /
 CHG21               (F6.2) /
 CHG22               (F6.2) /
 CHG23               (F6.2) /
 CHG24               (F6.2) /
 CHG25               (F6.2) /
 RATE1               (F5.2) /
 RATE2               (F5.2) /
 RATE3               (F5.2) /
 RATE4               (F5.2) /
 RATE5               (F5.2) /
 UNIT1               (F4.0) /
 UNIT2               (F4.0) /
 UNIT3               (F4.0) /
 UNIT4               (F4.0) /
 UNIT5               (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CHG1      "Detailed charges 1 (as received from source)"
 CHG2      "Detailed charges 2 (as received from source)"
 CHG3      "Detailed charges 3 (as received from source)"
 CHG4      "Detailed charges 4 (as received from source)"
 CHG5      "Detailed charges 5 (as received from source)"
 CHG6      "Detailed charges 6 (as received from source)"
 CHG7      "Detailed charges 7 (as received from source)"
 CHG8      "Detailed charges 8 (as received from source)"
 CHG9      "Detailed charges 9 (as received from source)"
 CHG10     "Detailed charges 10 (as received from source)"
 CHG11     "Detailed charges 11 (as received from source)"
 CHG12     "Detailed charges 12 (as received from source)"
 CHG13     "Detailed charges 13 (as received from source)"
 CHG14     "Detailed charges 14 (as received from source)"
 CHG15     "Detailed charges 15 (as received from source)"
 CHG16     "Detailed charges 16 (as received from source)"
 CHG17     "Detailed charges 17 (as received from source)"
 CHG18     "Detailed charges 18 (as received from source)"
 CHG19     "Detailed charges 19 (as received from source)"
 CHG20     "Detailed charges 20 (as received from source)"
 CHG21     "Detailed charges 21 (as received from source)"
 CHG22     "Detailed charges 22 (as received from source)"
 CHG23     "Detailed charges 23 (as received from source)"
 CHG24     "Detailed charges 24 (as received from source)"
 CHG25     "Detailed charges 25 (as received from source)"
 RATE1     "Daily rate 1 (as received from source)"
 RATE2     "Daily rate 2 (as received from source)"
 RATE3     "Daily rate 3 (as received from source)"
 RATE4     "Daily rate 4 (as received from source)"
 RATE5     "Daily rate 5 (as received from source)"
 REVCD1    "Revenue code 1 (as received from source)"
 REVCD2    "Revenue code 2 (as received from source)"
 REVCD3    "Revenue code 3 (as received from source)"
 REVCD4    "Revenue code 4 (as received from source)"
 REVCD5    "Revenue code 5 (as received from source)"
 REVCD6    "Revenue code 6 (as received from source)"
 REVCD7    "Revenue code 7 (as received from source)"
 REVCD8    "Revenue code 8 (as received from source)"
 REVCD9    "Revenue code 9 (as received from source)"
 REVCD10   "Revenue code 10 (as received from source)"
 REVCD11   "Revenue code 11 (as received from source)"
 REVCD12   "Revenue code 12 (as received from source)"
 REVCD13   "Revenue code 13 (as received from source)"
 REVCD14   "Revenue code 14 (as received from source)"
 REVCD15   "Revenue code 15 (as received from source)"
 REVCD16   "Revenue code 16 (as received from source)"
 REVCD17   "Revenue code 17 (as received from source)"
 REVCD18   "Revenue code 18 (as received from source)"
 REVCD19   "Revenue code 19 (as received from source)"
 REVCD20   "Revenue code 20 (as received from source)"
 REVCD21   "Revenue code 21 (as received from source)"
 REVCD22   "Revenue code 22 (as received from source)"
 REVCD23   "Revenue code 23 (as received from source)"
 REVCD24   "Revenue code 24 (as received from source)"
 REVCD25   "Revenue code 25 (as received from source)"
 UNIT1     "Units of service 1 (as received from source)"
 UNIT2     "Units of service 2 (as received from source)"
 UNIT3     "Units of service 3 (as received from source)"
 UNIT4     "Units of service 4 (as received from source)"
 UNIT5     "Units of service 5 (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHG1
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG2
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG3
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG4
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG5
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG6
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG7
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG8
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG9
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG10
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG11
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG12
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG13
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG14
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG15
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG16
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG17
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG18
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG19
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG20
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG21
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG22
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG23
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG24
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE CHG25
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE RATE1
 (-99.99,-88.88,-66.66,-55.55=SYSMIS).
RECODE RATE2
 (-99.99,-88.88,-66.66,-55.55=SYSMIS).
RECODE RATE3
 (-99.99,-88.88,-66.66,-55.55=SYSMIS).
RECODE RATE4
 (-99.99,-88.88,-66.66,-55.55=SYSMIS).
RECODE RATE5
 (-99.99,-88.88,-66.66,-55.55=SYSMIS).
RECODE UNIT1
 (-999,-888,-666,-555=SYSMIS).
RECODE UNIT2
 (-999,-888,-666,-555=SYSMIS).
RECODE UNIT3
 (-999,-888,-666,-555=SYSMIS).
RECODE UNIT4
 (-999,-888,-666,-555=SYSMIS).
RECODE UNIT5
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NY_SID_2001_CHGS.SAV' /COMPRESSED.
