/*******************************************************************
*   NJ_SID_2006_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'NJ_SID_2006_DX_PR_GRPS.ASC' FIXED / 
 KEY                        1-  14
 CCSMGN1                   15-  17
 CCSMGN2                   18-  20
 CCSMGN3                   21-  23
 CCSMGN4                   24-  26
 CCSMGN5                   27-  29
 CCSMGN6                   30-  32
 CCSMGN7                   33-  35
 CCSMGN8                   36-  38
 CCSMGN9                   39-  41
 CCSMSP1                   42-  45
 CCSMSP2                   46-  49
 CCSMSP3                   50-  53
 CCSMSP4                   54-  57
 CCSMSP5                   58-  61
 CCSMSP6                   62-  65
 CCSMSP7                   66-  69
 CCSMSP8                   70-  73
 CCSMSP9                   74-  77
 CHRON1                    78-  79
 CHRON2                    80-  81
 CHRON3                    82-  83
 CHRON4                    84-  85
 CHRON5                    86-  87
 CHRON6                    88-  89
 CHRON7                    90-  91
 CHRON8                    92-  93
 CHRON9                    94-  95
 CHRONB1                   96-  97
 CHRONB2                   98-  99
 CHRONB3                  100- 101
 CHRONB4                  102- 103
 CHRONB5                  104- 105
 CHRONB6                  106- 107
 CHRONB7                  108- 109
 CHRONB8                  110- 111
 CHRONB9                  112- 113
 ECCSMGN1                 114- 116
 ECCSMGN2                 117- 119
 ECCSMGN3                 120- 122
 ECCSMGN4                 123- 125
 ECCSMGN5                 126- 128
 PCLASS1                  129- 130
 PCLASS2                  131- 132
 PCLASS3                  133- 134
 PCLASS4                  135- 136
 PCLASS5                  137- 138
 PCLASS6                  139- 140
 PCLASS7                  141- 142
 PCLASS8                  143- 144.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 CCSMGN1                 (F3.0) /
 CCSMGN2                 (F3.0) /
 CCSMGN3                 (F3.0) /
 CCSMGN4                 (F3.0) /
 CCSMGN5                 (F3.0) /
 CCSMGN6                 (F3.0) /
 CCSMGN7                 (F3.0) /
 CCSMGN8                 (F3.0) /
 CCSMGN9                 (F3.0) /
 CCSMSP1                 (F3.0) /
 CCSMSP2                 (F3.0) /
 CCSMSP3                 (F3.0) /
 CCSMSP4                 (F3.0) /
 CCSMSP5                 (F3.0) /
 CCSMSP6                 (F3.0) /
 CCSMSP7                 (F3.0) /
 CCSMSP8                 (F3.0) /
 CCSMSP9                 (F3.0) /
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 ECCSMGN1                (F3.0) /
 ECCSMGN2                (F3.0) /
 ECCSMGN3                (F3.0) /
 ECCSMGN4                (F3.0) /
 ECCSMGN5                (F3.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CCSMGN1   "CCS-MHSA general category: principal diagnosis"
 CCSMGN2   "CCS-MHSA general category: diagnosis 2"
 CCSMGN3   "CCS-MHSA general category: diagnosis 3"
 CCSMGN4   "CCS-MHSA general category: diagnosis 4"
 CCSMGN5   "CCS-MHSA general category: diagnosis 5"
 CCSMGN6   "CCS-MHSA general category: diagnosis 6"
 CCSMGN7   "CCS-MHSA general category: diagnosis 7"
 CCSMGN8   "CCS-MHSA general category: diagnosis 8"
 CCSMGN9   "CCS-MHSA general category: diagnosis 9"
 CCSMSP1   "CCS-MHSA specific category: principal diagnosis"
 CCSMSP2   "CCS-MHSA specific category: diagnosis 2"
 CCSMSP3   "CCS-MHSA specific category: diagnosis 3"
 CCSMSP4   "CCS-MHSA specific category: diagnosis 4"
 CCSMSP5   "CCS-MHSA specific category: diagnosis 5"
 CCSMSP6   "CCS-MHSA specific category: diagnosis 6"
 CCSMSP7   "CCS-MHSA specific category: diagnosis 7"
 CCSMSP8   "CCS-MHSA specific category: diagnosis 8"
 CCSMSP9   "CCS-MHSA specific category: diagnosis 9"
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 ECCSMGN1  "CCS-MHSA general category: E Code 1"
 ECCSMGN2  "CCS-MHSA general category: E Code 2"
 ECCSMGN3  "CCS-MHSA general category: E Code 3"
 ECCSMGN4  "CCS-MHSA general category: E Code 4"
 ECCSMGN5  "CCS-MHSA general category: E Code 5"
 PCLASS1   "Principal procedure class"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 PCLASS7   "Procedure class 7"
 PCLASS8   "Procedure class 8" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CCSMGN1
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN2
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN3
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN4
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN5
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN6
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN7
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN8
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMGN9
 (-99,-88,-66,-55=SYSMIS).
RECODE CCSMSP1
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP2
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP3
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP4
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP5
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP6
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP7
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP8
 (-999,-888,-666,-555=SYSMIS).
RECODE CCSMSP9
 (-999,-888,-666,-555=SYSMIS).
RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE ECCSMGN1
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN2
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN3
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN4
 (-99,-88,-66,-55=SYSMIS).
RECODE ECCSMGN5
 (-99,-88,-66,-55=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NJ_SID_2006_DX_PR_GRPS.SAV' /COMPRESSED.
