/*******************************************************************
*   IA_SID_2012_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'IA_SID_2012_CORE.ASC' FIXED SKIP=2 / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AMONTH                    10-  11
 ATYPE                     12-  13
 AWEEKEND                  14-  15
 DIED                      16-  17
 DISPUB04                  18-  19
 DISPUNIFORM               20-  21
 DISP_X                    22-  25 (A)
 DQTR                      26-  27
 DRG                       28-  30
 DRG24                     31-  33
 DRGVER                    34-  35
 DRG_NoPOA                 36-  38
 DX1                       39-  43 (A)
 DX2                       44-  48 (A)
 DX3                       49-  53 (A)
 DX4                       54-  58 (A)
 DX5                       59-  63 (A)
 DX6                       64-  68 (A)
 DX7                       69-  73 (A)
 DX8                       74-  78 (A)
 DX9                       79-  83 (A)
 DX10                      84-  88 (A)
 DX11                      89-  93 (A)
 DX12                      94-  98 (A)
 DX13                      99- 103 (A)
 DX14                     104- 108 (A)
 DX15                     109- 113 (A)
 DX16                     114- 118 (A)
 DX17                     119- 123 (A)
 DX18                     124- 128 (A)
 DX19                     129- 133 (A)
 DX20                     134- 138 (A)
 DX21                     139- 143 (A)
 DX22                     144- 148 (A)
 DX23                     149- 153 (A)
 DX24                     154- 158 (A)
 DX25                     159- 163 (A)
 DX26                     164- 168 (A)
 DX27                     169- 173 (A)
 DX28                     174- 178 (A)
 DX29                     179- 183 (A)
 DX30                     184- 188 (A)
 DX31                     189- 193 (A)
 DX32                     194- 198 (A)
 DX33                     199- 203 (A)
 DX34                     204- 208 (A)
 DX35                     209- 213 (A)
 DX36                     214- 218 (A)
 DX37                     219- 223 (A)
 DX38                     224- 228 (A)
 DX39                     229- 233 (A)
 DX40                     234- 238 (A)
 DX41                     239- 243 (A)
 DX42                     244- 248 (A)
 DX43                     249- 253 (A)
 DX44                     254- 258 (A)
 DX45                     259- 263 (A)
 DX46                     264- 268 (A)
 DX47                     269- 273 (A)
 DX48                     274- 278 (A)
 DX49                     279- 283 (A)
 DX50                     284- 288 (A)
 DX51                     289- 293 (A)
 DX52                     294- 298 (A)
 DX53                     299- 303 (A)
 DX54                     304- 308 (A)
 DX55                     309- 313 (A)
 DX56                     314- 318 (A)
 DX57                     319- 323 (A)
 DXCCS1                   324- 327
 DXCCS2                   328- 331
 DXCCS3                   332- 335
 DXCCS4                   336- 339
 DXCCS5                   340- 343
 DXCCS6                   344- 347
 DXCCS7                   348- 351
 DXCCS8                   352- 355
 DXCCS9                   356- 359
 DXCCS10                  360- 363
 DXCCS11                  364- 367
 DXCCS12                  368- 371
 DXCCS13                  372- 375
 DXCCS14                  376- 379
 DXCCS15                  380- 383
 DXCCS16                  384- 387
 DXCCS17                  388- 391
 DXCCS18                  392- 395
 DXCCS19                  396- 399
 DXCCS20                  400- 403
 DXCCS21                  404- 407
 DXCCS22                  408- 411
 DXCCS23                  412- 415
 DXCCS24                  416- 419
 DXCCS25                  420- 423
 DXCCS26                  424- 427
 DXCCS27                  428- 431
 DXCCS28                  432- 435
 DXCCS29                  436- 439
 DXCCS30                  440- 443
 DXCCS31                  444- 447
 DXCCS32                  448- 451
 DXCCS33                  452- 455
 DXCCS34                  456- 459
 DXCCS35                  460- 463
 DXCCS36                  464- 467
 DXCCS37                  468- 471
 DXCCS38                  472- 475
 DXCCS39                  476- 479
 DXCCS40                  480- 483
 DXCCS41                  484- 487
 DXCCS42                  488- 491
 DXCCS43                  492- 495
 DXCCS44                  496- 499
 DXCCS45                  500- 503
 DXCCS46                  504- 507
 DXCCS47                  508- 511
 DXCCS48                  512- 515
 DXCCS49                  516- 519
 DXCCS50                  520- 523
 DXCCS51                  524- 527
 DXCCS52                  528- 531
 DXCCS53                  532- 535
 DXCCS54                  536- 539
 DXCCS55                  540- 543
 DXCCS56                  544- 547
 DXCCS57                  548- 551
 DXPOA1                   552     (A)
 DXPOA2                   553     (A)
 DXPOA3                   554     (A)
 DXPOA4                   555     (A)
 DXPOA5                   556     (A)
 DXPOA6                   557     (A)
 DXPOA7                   558     (A)
 DXPOA8                   559     (A)
 DXPOA9                   560     (A)
 DXPOA10                  561     (A)
 DXPOA11                  562     (A)
 DXPOA12                  563     (A)
 DXPOA13                  564     (A)
 DXPOA14                  565     (A)
 DXPOA15                  566     (A)
 DXPOA16                  567     (A)
 DXPOA17                  568     (A)
 DXPOA18                  569     (A)
 DXPOA19                  570     (A)
 DXPOA20                  571     (A)
 DXPOA21                  572     (A)
 DXPOA22                  573     (A)
 DXPOA23                  574     (A)
 DXPOA24                  575     (A)
 DXPOA25                  576     (A)
 DXPOA26                  577     (A)
 DXPOA27                  578     (A)
 DXPOA28                  579     (A)
 DXPOA29                  580     (A)
 DXPOA30                  581     (A)
 DXPOA31                  582     (A)
 DXPOA32                  583     (A)
 DXPOA33                  584     (A)
 DXPOA34                  585     (A)
 DXPOA35                  586     (A)
 DXPOA36                  587     (A)
 DXPOA37                  588     (A)
 DXPOA38                  589     (A)
 DXPOA39                  590     (A)
 DXPOA40                  591     (A)
 DXPOA41                  592     (A)
 DXPOA42                  593     (A)
 DXPOA43                  594     (A)
 DXPOA44                  595     (A)
 DXPOA45                  596     (A)
 DXPOA46                  597     (A)
 DXPOA47                  598     (A)
 DXPOA48                  599     (A)
 DXPOA49                  600     (A)
 DXPOA50                  601     (A)
 DXPOA51                  602     (A)
 DXPOA52                  603     (A)
 DXPOA53                  604     (A)
 DXPOA54                  605     (A)
 DXPOA55                  606     (A)
 DXPOA56                  607     (A)
 DXPOA57                  608     (A)
 DX_Admitting             609- 613 (A)
 DaysToEvent              614- 619
 ECODE1                   620- 624 (A)
 ECODE2                   625- 629 (A)
 ECODE3                   630- 634 (A)
 ECODE4                   635- 639 (A)
 ECODE5                   640- 644 (A)
 ECODE6                   645- 649 (A)
 ECODE7                   650- 654 (A)
 ECODE8                   655- 659 (A)
 ECODE9                   660- 664 (A)
 E_CCS1                   665- 668
 E_CCS2                   669- 672
 E_CCS3                   673- 676
 E_CCS4                   677- 680
 E_CCS5                   681- 684
 E_CCS6                   685- 688
 E_CCS7                   689- 692
 E_CCS8                   693- 696
 E_CCS9                   697- 700
 E_POA1                   701     (A)
 E_POA2                   702     (A)
 E_POA3                   703     (A)
 E_POA4                   704     (A)
 E_POA5                   705     (A)
 E_POA6                   706     (A)
 E_POA7                   707     (A)
 E_POA8                   708     (A)
 E_POA9                   709     (A)
 FEMALE                   710- 711
 HCUP_ED                  712- 713
 HCUP_OS                  714- 715
 HISPANIC_X               716     (A)
 HOSPBRTH                 717- 719
 HOSPST                   720- 721 (A)
 HospitalUnit             722- 723
 KEY                      724- 738
 LOS                      739- 743
 LOS_X                    744- 749
 MDC                      750- 751
 MDC24                    752- 753
 MDC_NoPOA                754- 755
 MDNUM1_R                 756- 764
 MDNUM2_R                 765- 773
 MDNUM3_R                 774- 782
 MEDINCSTQ                783- 784
 MRN_R                    785- 793
 NCHRONIC                 794- 796
 NDX                      797- 798
 NECODE                   799- 800
 NEOMAT                   801- 802
 NPR                      803- 804
 ORPROC                   805- 806
 P7EDSRC_X                807- 808 (A)
 PAY1                     809- 810
 PAY1_X                   811- 814 (A)
 PAY2                     815- 816
 PAY2_X                   817- 820 (A)
 PAY3                     821- 822
 PAY3_X                   823- 826 (A)
 PL_CBSA                  827- 829
 PL_MSA1993               830- 832
 PL_NCHS2006              833- 834
 PL_RUCA10_2005           835- 836
 PL_RUCA2005              837- 840
 PL_RUCA4_2005            841- 842
 PL_RUCC2003              843- 844
 PL_UIC2003               845- 846
 PL_UR_CAT4               847- 848
 PNUM_R                   849- 857
 PR1                      858- 861 (A)
 PR2                      862- 865 (A)
 PR3                      866- 869 (A)
 PR4                      870- 873 (A)
 PR5                      874- 877 (A)
 PR6                      878- 881 (A)
 PR7                      882- 885 (A)
 PR8                      886- 889 (A)
 PR9                      890- 893 (A)
 PR10                     894- 897 (A)
 PR11                     898- 901 (A)
 PR12                     902- 905 (A)
 PR13                     906- 909 (A)
 PR14                     910- 913 (A)
 PR15                     914- 917 (A)
 PR16                     918- 921 (A)
 PR17                     922- 925 (A)
 PR18                     926- 929 (A)
 PR19                     930- 933 (A)
 PR20                     934- 937 (A)
 PR21                     938- 941 (A)
 PR22                     942- 945 (A)
 PR23                     946- 949 (A)
 PR24                     950- 953 (A)
 PR25                     954- 957 (A)
 PR26                     958- 961 (A)
 PR27                     962- 965 (A)
 PR28                     966- 969 (A)
 PR29                     970- 973 (A)
 PR30                     974- 977 (A)
 PR31                     978- 981 (A)
 PR32                     982- 985 (A)
 PR33                     986- 989 (A)
 PR34                     990- 993 (A)
 PR35                     994- 997 (A)
 PR36                     998-1001 (A)
 PR37                    1002-1005 (A)
 PR38                    1006-1009 (A)
 PR39                    1010-1013 (A)
 PR40                    1014-1017 (A)
 PR41                    1018-1021 (A)
 PR42                    1022-1025 (A)
 PR43                    1026-1029 (A)
 PR44                    1030-1033 (A)
 PR45                    1034-1037 (A)
 PR46                    1038-1041 (A)
 PR47                    1042-1045 (A)
 PR48                    1046-1049 (A)
 PR49                    1050-1053 (A)
 PR50                    1054-1057 (A)
 PRCCS1                  1058-1060
 PRCCS2                  1061-1063
 PRCCS3                  1064-1066
 PRCCS4                  1067-1069
 PRCCS5                  1070-1072
 PRCCS6                  1073-1075
 PRCCS7                  1076-1078
 PRCCS8                  1079-1081
 PRCCS9                  1082-1084
 PRCCS10                 1085-1087
 PRCCS11                 1088-1090
 PRCCS12                 1091-1093
 PRCCS13                 1094-1096
 PRCCS14                 1097-1099
 PRCCS15                 1100-1102
 PRCCS16                 1103-1105
 PRCCS17                 1106-1108
 PRCCS18                 1109-1111
 PRCCS19                 1112-1114
 PRCCS20                 1115-1117
 PRCCS21                 1118-1120
 PRCCS22                 1121-1123
 PRCCS23                 1124-1126
 PRCCS24                 1127-1129
 PRCCS25                 1130-1132
 PRCCS26                 1133-1135
 PRCCS27                 1136-1138
 PRCCS28                 1139-1141
 PRCCS29                 1142-1144
 PRCCS30                 1145-1147
 PRCCS31                 1148-1150
 PRCCS32                 1151-1153
 PRCCS33                 1154-1156
 PRCCS34                 1157-1159
 PRCCS35                 1160-1162
 PRCCS36                 1163-1165
 PRCCS37                 1166-1168
 PRCCS38                 1169-1171
 PRCCS39                 1172-1174
 PRCCS40                 1175-1177
 PRCCS41                 1178-1180
 PRCCS42                 1181-1183
 PRCCS43                 1184-1186
 PRCCS44                 1187-1189
 PRCCS45                 1190-1192
 PRCCS46                 1193-1195
 PRCCS47                 1196-1198
 PRCCS48                 1199-1201
 PRCCS49                 1202-1204
 PRCCS50                 1205-1207
 PRDAY1                  1208-1212
 PRDAY2                  1213-1217
 PRDAY3                  1218-1222
 PRDAY4                  1223-1227
 PRDAY5                  1228-1232
 PRDAY6                  1233-1237
 PRDAY7                  1238-1242
 PRDAY8                  1243-1247
 PRDAY9                  1248-1252
 PRDAY10                 1253-1257
 PRDAY11                 1258-1262
 PRDAY12                 1263-1267
 PRDAY13                 1268-1272
 PRDAY14                 1273-1277
 PRDAY15                 1278-1282
 PRDAY16                 1283-1287
 PRDAY17                 1288-1292
 PRDAY18                 1293-1297
 PRDAY19                 1298-1302
 PRDAY20                 1303-1307
 PRDAY21                 1308-1312
 PRDAY22                 1313-1317
 PRDAY23                 1318-1322
 PRDAY24                 1323-1327
 PRDAY25                 1328-1332
 PRDAY26                 1333-1337
 PRDAY27                 1338-1342
 PRDAY28                 1343-1347
 PRDAY29                 1348-1352
 PRDAY30                 1353-1357
 PRDAY31                 1358-1362
 PRDAY32                 1363-1367
 PRDAY33                 1368-1372
 PRDAY34                 1373-1377
 PRDAY35                 1378-1382
 PRDAY36                 1383-1387
 PRDAY37                 1388-1392
 PRDAY38                 1393-1397
 PRDAY39                 1398-1402
 PRDAY40                 1403-1407
 PRDAY41                 1408-1412
 PRDAY42                 1413-1417
 PRDAY43                 1418-1422
 PRDAY44                 1423-1427
 PRDAY45                 1428-1432
 PRDAY46                 1433-1437
 PRDAY47                 1438-1442
 PRDAY48                 1443-1447
 PRDAY49                 1448-1452
 PRDAY50                 1453-1457
 PROCTYPE                1458-1460
 PSTATE                  1461-1462 (A)
 PSTCO                   1463-1467
 PSTCO2                  1468-1472
 PointOfOriginUB04       1473     (A)
 PointOfOrigin_X         1474     (A)
 RACE                    1475-1476
 RACE_X                  1477-1480 (A)
 TOTCHG                  1481-1490
 TOTCHG_X                1491-1505
 TRAN_IN                 1506-1507
 TRAN_OUT                1508-1509
 VisitLink               1510-1518
 YEAR                    1519-1522
 ZIP3                    1523-1525 (A)
 ZIPINC_QRTL             1526-1528
 ZIP                     1529-1533 (A)
 AYEAR                   1534-1537
 DMONTH                  1538-1539
 BMONTH                  1540-1541
 BYEAR                   1542-1545
 PRMONTH1                1546-1547
 PRMONTH2                1548-1549
 PRMONTH3                1550-1551
 PRMONTH4                1552-1553
 PRMONTH5                1554-1555
 PRMONTH6                1556-1557
 PRMONTH7                1558-1559
 PRMONTH8                1560-1561
 PRMONTH9                1562-1563
 PRMONTH10               1564-1565
 PRMONTH11               1566-1567
 PRMONTH12               1568-1569
 PRMONTH13               1570-1571
 PRMONTH14               1572-1573
 PRMONTH15               1574-1575
 PRMONTH16               1576-1577
 PRMONTH17               1578-1579
 PRMONTH18               1580-1581
 PRMONTH19               1582-1583
 PRMONTH20               1584-1585
 PRMONTH21               1586-1587
 PRMONTH22               1588-1589
 PRMONTH23               1590-1591
 PRMONTH24               1592-1593
 PRMONTH25               1594-1595
 PRMONTH26               1596-1597
 PRMONTH27               1598-1599
 PRMONTH28               1600-1601
 PRMONTH29               1602-1603
 PRMONTH30               1604-1605
 PRMONTH31               1606-1607
 PRMONTH32               1608-1609
 PRMONTH33               1610-1611
 PRMONTH34               1612-1613
 PRMONTH35               1614-1615
 PRMONTH36               1616-1617
 PRMONTH37               1618-1619
 PRMONTH38               1620-1621
 PRMONTH39               1622-1623
 PRMONTH40               1624-1625
 PRMONTH41               1626-1627
 PRMONTH42               1628-1629
 PRMONTH43               1630-1631
 PRMONTH44               1632-1633
 PRMONTH45               1634-1635
 PRMONTH46               1636-1637
 PRMONTH47               1638-1639
 PRMONTH48               1640-1641
 PRMONTH49               1642-1643
 PRMONTH50               1644-1645
 PRYEAR1                 1646-1649
 PRYEAR2                 1650-1653
 PRYEAR3                 1654-1657
 PRYEAR4                 1658-1661
 PRYEAR5                 1662-1665
 PRYEAR6                 1666-1669
 PRYEAR7                 1670-1673
 PRYEAR8                 1674-1677
 PRYEAR9                 1678-1681
 PRYEAR10                1682-1685
 PRYEAR11                1686-1689
 PRYEAR12                1690-1693
 PRYEAR13                1694-1697
 PRYEAR14                1698-1701
 PRYEAR15                1702-1705
 PRYEAR16                1706-1709
 PRYEAR17                1710-1713
 PRYEAR18                1714-1717
 PRYEAR19                1718-1721
 PRYEAR20                1722-1725
 PRYEAR21                1726-1729
 PRYEAR22                1730-1733
 PRYEAR23                1734-1737
 PRYEAR24                1738-1741
 PRYEAR25                1742-1745
 PRYEAR26                1746-1749
 PRYEAR27                1750-1753
 PRYEAR28                1754-1757
 PRYEAR29                1758-1761
 PRYEAR30                1762-1765
 PRYEAR31                1766-1769
 PRYEAR32                1770-1773
 PRYEAR33                1774-1777
 PRYEAR34                1778-1781
 PRYEAR35                1782-1785
 PRYEAR36                1786-1789
 PRYEAR37                1790-1793
 PRYEAR38                1794-1797
 PRYEAR39                1798-1801
 PRYEAR40                1802-1805
 PRYEAR41                1806-1809
 PRYEAR42                1810-1813
 PRYEAR43                1814-1817
 PRYEAR44                1818-1821
 PRYEAR45                1822-1825
 PRYEAR46                1826-1829
 PRYEAR47                1830-1833
 PRYEAR48                1834-1837
 PRYEAR49                1838-1841
 PRYEAR50                1842-1845.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG24                   (F3.0) /
 DRGVER                  (F3.0) /
 DRG_NoPOA               (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 DXCCS21                 (F4.0) /
 DXCCS22                 (F4.0) /
 DXCCS23                 (F4.0) /
 DXCCS24                 (F4.0) /
 DXCCS25                 (F4.0) /
 DXCCS26                 (F4.0) /
 DXCCS27                 (F4.0) /
 DXCCS28                 (F4.0) /
 DXCCS29                 (F4.0) /
 DXCCS30                 (F4.0) /
 DXCCS31                 (F4.0) /
 DXCCS32                 (F4.0) /
 DXCCS33                 (F4.0) /
 DXCCS34                 (F4.0) /
 DXCCS35                 (F4.0) /
 DXCCS36                 (F4.0) /
 DXCCS37                 (F4.0) /
 DXCCS38                 (F4.0) /
 DXCCS39                 (F4.0) /
 DXCCS40                 (F4.0) /
 DXCCS41                 (F4.0) /
 DXCCS42                 (F4.0) /
 DXCCS43                 (F4.0) /
 DXCCS44                 (F4.0) /
 DXCCS45                 (F4.0) /
 DXCCS46                 (F4.0) /
 DXCCS47                 (F4.0) /
 DXCCS48                 (F4.0) /
 DXCCS49                 (F4.0) /
 DXCCS50                 (F4.0) /
 DXCCS51                 (F4.0) /
 DXCCS52                 (F4.0) /
 DXCCS53                 (F4.0) /
 DXCCS54                 (F4.0) /
 DXCCS55                 (F4.0) /
 DXCCS56                 (F4.0) /
 DXCCS57                 (F4.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 E_CCS9                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 HospitalUnit            (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC24                   (F3.0) /
 MDC_NoPOA               (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MDNUM3_R                (F5.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PAY3                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRCCS21                 (F3.0) /
 PRCCS22                 (F3.0) /
 PRCCS23                 (F3.0) /
 PRCCS24                 (F3.0) /
 PRCCS25                 (F3.0) /
 PRCCS26                 (F3.0) /
 PRCCS27                 (F3.0) /
 PRCCS28                 (F3.0) /
 PRCCS29                 (F3.0) /
 PRCCS30                 (F3.0) /
 PRCCS31                 (F3.0) /
 PRCCS32                 (F3.0) /
 PRCCS33                 (F3.0) /
 PRCCS34                 (F3.0) /
 PRCCS35                 (F3.0) /
 PRCCS36                 (F3.0) /
 PRCCS37                 (F3.0) /
 PRCCS38                 (F3.0) /
 PRCCS39                 (F3.0) /
 PRCCS40                 (F3.0) /
 PRCCS41                 (F3.0) /
 PRCCS42                 (F3.0) /
 PRCCS43                 (F3.0) /
 PRCCS44                 (F3.0) /
 PRCCS45                 (F3.0) /
 PRCCS46                 (F3.0) /
 PRCCS47                 (F3.0) /
 PRCCS48                 (F3.0) /
 PRCCS49                 (F3.0) /
 PRCCS50                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PRDAY21                 (F4.0) /
 PRDAY22                 (F4.0) /
 PRDAY23                 (F4.0) /
 PRDAY24                 (F4.0) /
 PRDAY25                 (F4.0) /
 PRDAY26                 (F4.0) /
 PRDAY27                 (F4.0) /
 PRDAY28                 (F4.0) /
 PRDAY29                 (F4.0) /
 PRDAY30                 (F4.0) /
 PRDAY31                 (F4.0) /
 PRDAY32                 (F4.0) /
 PRDAY33                 (F4.0) /
 PRDAY34                 (F4.0) /
 PRDAY35                 (F4.0) /
 PRDAY36                 (F4.0) /
 PRDAY37                 (F4.0) /
 PRDAY38                 (F4.0) /
 PRDAY39                 (F4.0) /
 PRDAY40                 (F4.0) /
 PRDAY41                 (F4.0) /
 PRDAY42                 (F4.0) /
 PRDAY43                 (F4.0) /
 PRDAY44                 (F4.0) /
 PRDAY45                 (F4.0) /
 PRDAY46                 (F4.0) /
 PRDAY47                 (F4.0) /
 PRDAY48                 (F4.0) /
 PRDAY49                 (F4.0) /
 PRDAY50                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TRAN_IN                 (F3.0) /
 TRAN_OUT                (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRMONTH21               (F3.0) /
 PRMONTH22               (F3.0) /
 PRMONTH23               (F3.0) /
 PRMONTH24               (F3.0) /
 PRMONTH25               (F3.0) /
 PRMONTH26               (F3.0) /
 PRMONTH27               (F3.0) /
 PRMONTH28               (F3.0) /
 PRMONTH29               (F3.0) /
 PRMONTH30               (F3.0) /
 PRMONTH31               (F3.0) /
 PRMONTH32               (F3.0) /
 PRMONTH33               (F3.0) /
 PRMONTH34               (F3.0) /
 PRMONTH35               (F3.0) /
 PRMONTH36               (F3.0) /
 PRMONTH37               (F3.0) /
 PRMONTH38               (F3.0) /
 PRMONTH39               (F3.0) /
 PRMONTH40               (F3.0) /
 PRMONTH41               (F3.0) /
 PRMONTH42               (F3.0) /
 PRMONTH43               (F3.0) /
 PRMONTH44               (F3.0) /
 PRMONTH45               (F3.0) /
 PRMONTH46               (F3.0) /
 PRMONTH47               (F3.0) /
 PRMONTH48               (F3.0) /
 PRMONTH49               (F3.0) /
 PRMONTH50               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) /
 PRYEAR21                (F3.0) /
 PRYEAR22                (F3.0) /
 PRYEAR23                (F3.0) /
 PRYEAR24                (F3.0) /
 PRYEAR25                (F3.0) /
 PRYEAR26                (F3.0) /
 PRYEAR27                (F3.0) /
 PRYEAR28                (F3.0) /
 PRYEAR29                (F3.0) /
 PRYEAR30                (F3.0) /
 PRYEAR31                (F3.0) /
 PRYEAR32                (F3.0) /
 PRYEAR33                (F3.0) /
 PRYEAR34                (F3.0) /
 PRYEAR35                (F3.0) /
 PRYEAR36                (F3.0) /
 PRYEAR37                (F3.0) /
 PRYEAR38                (F3.0) /
 PRYEAR39                (F3.0) /
 PRYEAR40                (F3.0) /
 PRYEAR41                (F3.0) /
 PRYEAR42                (F3.0) /
 PRYEAR43                (F3.0) /
 PRYEAR44                (F3.0) /
 PRYEAR45                (F3.0) /
 PRYEAR46                (F3.0) /
 PRYEAR47                (F3.0) /
 PRYEAR48                (F3.0) /
 PRYEAR49                (F3.0) /
 PRYEAR50                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG24                   "DRG, version 24"
 DRGVER                  "DRG grouper version used on discharge date"
 DRG_NoPOA               "DRG in use on discharge date, calculated without POA"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DX21                    "Diagnosis 21"
 DX22                    "Diagnosis 22"
 DX23                    "Diagnosis 23"
 DX24                    "Diagnosis 24"
 DX25                    "Diagnosis 25"
 DX26                    "Diagnosis 26"
 DX27                    "Diagnosis 27"
 DX28                    "Diagnosis 28"
 DX29                    "Diagnosis 29"
 DX30                    "Diagnosis 30"
 DX31                    "Diagnosis 31"
 DX32                    "Diagnosis 32"
 DX33                    "Diagnosis 33"
 DX34                    "Diagnosis 34"
 DX35                    "Diagnosis 35"
 DX36                    "Diagnosis 36"
 DX37                    "Diagnosis 37"
 DX38                    "Diagnosis 38"
 DX39                    "Diagnosis 39"
 DX40                    "Diagnosis 40"
 DX41                    "Diagnosis 41"
 DX42                    "Diagnosis 42"
 DX43                    "Diagnosis 43"
 DX44                    "Diagnosis 44"
 DX45                    "Diagnosis 45"
 DX46                    "Diagnosis 46"
 DX47                    "Diagnosis 47"
 DX48                    "Diagnosis 48"
 DX49                    "Diagnosis 49"
 DX50                    "Diagnosis 50"
 DX51                    "Diagnosis 51"
 DX52                    "Diagnosis 52"
 DX53                    "Diagnosis 53"
 DX54                    "Diagnosis 54"
 DX55                    "Diagnosis 55"
 DX56                    "Diagnosis 56"
 DX57                    "Diagnosis 57"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DXCCS21                 "CCS: diagnosis 21"
 DXCCS22                 "CCS: diagnosis 22"
 DXCCS23                 "CCS: diagnosis 23"
 DXCCS24                 "CCS: diagnosis 24"
 DXCCS25                 "CCS: diagnosis 25"
 DXCCS26                 "CCS: diagnosis 26"
 DXCCS27                 "CCS: diagnosis 27"
 DXCCS28                 "CCS: diagnosis 28"
 DXCCS29                 "CCS: diagnosis 29"
 DXCCS30                 "CCS: diagnosis 30"
 DXCCS31                 "CCS: diagnosis 31"
 DXCCS32                 "CCS: diagnosis 32"
 DXCCS33                 "CCS: diagnosis 33"
 DXCCS34                 "CCS: diagnosis 34"
 DXCCS35                 "CCS: diagnosis 35"
 DXCCS36                 "CCS: diagnosis 36"
 DXCCS37                 "CCS: diagnosis 37"
 DXCCS38                 "CCS: diagnosis 38"
 DXCCS39                 "CCS: diagnosis 39"
 DXCCS40                 "CCS: diagnosis 40"
 DXCCS41                 "CCS: diagnosis 41"
 DXCCS42                 "CCS: diagnosis 42"
 DXCCS43                 "CCS: diagnosis 43"
 DXCCS44                 "CCS: diagnosis 44"
 DXCCS45                 "CCS: diagnosis 45"
 DXCCS46                 "CCS: diagnosis 46"
 DXCCS47                 "CCS: diagnosis 47"
 DXCCS48                 "CCS: diagnosis 48"
 DXCCS49                 "CCS: diagnosis 49"
 DXCCS50                 "CCS: diagnosis 50"
 DXCCS51                 "CCS: diagnosis 51"
 DXCCS52                 "CCS: diagnosis 52"
 DXCCS53                 "CCS: diagnosis 53"
 DXCCS54                 "CCS: diagnosis 54"
 DXCCS55                 "CCS: diagnosis 55"
 DXCCS56                 "CCS: diagnosis 56"
 DXCCS57                 "CCS: diagnosis 57"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DXPOA7                  "Diagnosis 7, present on admission indicator"
 DXPOA8                  "Diagnosis 8, present on admission indicator"
 DXPOA9                  "Diagnosis 9, present on admission indicator"
 DXPOA10                 "Diagnosis 10, present on admission indicator"
 DXPOA11                 "Diagnosis 11, present on admission indicator"
 DXPOA12                 "Diagnosis 12, present on admission indicator"
 DXPOA13                 "Diagnosis 13, present on admission indicator"
 DXPOA14                 "Diagnosis 14, present on admission indicator"
 DXPOA15                 "Diagnosis 15, present on admission indicator"
 DXPOA16                 "Diagnosis 16, present on admission indicator"
 DXPOA17                 "Diagnosis 17, present on admission indicator"
 DXPOA18                 "Diagnosis 18, present on admission indicator"
 DXPOA19                 "Diagnosis 19, present on admission indicator"
 DXPOA20                 "Diagnosis 20, present on admission indicator"
 DXPOA21                 "Diagnosis 21, present on admission indicator"
 DXPOA22                 "Diagnosis 22, present on admission indicator"
 DXPOA23                 "Diagnosis 23, present on admission indicator"
 DXPOA24                 "Diagnosis 24, present on admission indicator"
 DXPOA25                 "Diagnosis 25, present on admission indicator"
 DXPOA26                 "Diagnosis 26, present on admission indicator"
 DXPOA27                 "Diagnosis 27, present on admission indicator"
 DXPOA28                 "Diagnosis 28, present on admission indicator"
 DXPOA29                 "Diagnosis 29, present on admission indicator"
 DXPOA30                 "Diagnosis 30, present on admission indicator"
 DXPOA31                 "Diagnosis 31, present on admission indicator"
 DXPOA32                 "Diagnosis 32, present on admission indicator"
 DXPOA33                 "Diagnosis 33, present on admission indicator"
 DXPOA34                 "Diagnosis 34, present on admission indicator"
 DXPOA35                 "Diagnosis 35, present on admission indicator"
 DXPOA36                 "Diagnosis 36, present on admission indicator"
 DXPOA37                 "Diagnosis 37, present on admission indicator"
 DXPOA38                 "Diagnosis 38, present on admission indicator"
 DXPOA39                 "Diagnosis 39, present on admission indicator"
 DXPOA40                 "Diagnosis 40, present on admission indicator"
 DXPOA41                 "Diagnosis 41, present on admission indicator"
 DXPOA42                 "Diagnosis 42, present on admission indicator"
 DXPOA43                 "Diagnosis 43, present on admission indicator"
 DXPOA44                 "Diagnosis 44, present on admission indicator"
 DXPOA45                 "Diagnosis 45, present on admission indicator"
 DXPOA46                 "Diagnosis 46, present on admission indicator"
 DXPOA47                 "Diagnosis 47, present on admission indicator"
 DXPOA48                 "Diagnosis 48, present on admission indicator"
 DXPOA49                 "Diagnosis 49, present on admission indicator"
 DXPOA50                 "Diagnosis 50, present on admission indicator"
 DXPOA51                 "Diagnosis 51, present on admission indicator"
 DXPOA52                 "Diagnosis 52, present on admission indicator"
 DXPOA53                 "Diagnosis 53, present on admission indicator"
 DXPOA54                 "Diagnosis 54, present on admission indicator"
 DXPOA55                 "Diagnosis 55, present on admission indicator"
 DXPOA56                 "Diagnosis 56, present on admission indicator"
 DXPOA57                 "Diagnosis 57, present on admission indicator"
 DX_Admitting            "Admitting Diagnosis Code"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 ECODE9                  "E code 9"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 E_CCS9                  "CCS: E Code 9"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 E_POA7                  "E Code 7, present on admission indicator"
 E_POA8                  "E Code 8, present on admission indicator"
 E_POA9                  "E Code 9, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 HospitalUnit

"Indicator that patient was discharged from a special unit within an acute care hospital (re
ported by source)"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MDC                     "MDC in effect on discharge date"
 MDC24                   "MDC, version 24"
 MDC_NoPOA               "MDC in use on discharge date, calculated without POA"
 MDNUM1_R                "Physician 1 number (re-identified)"
 MDNUM2_R                "Physician 2 number (re-identified)"
 MDNUM3_R                "Physician 3 number (re-identified)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 P7EDSRC_X               "Condition Code P7, Direct Inpatient Admission from Emergency Room"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3                    "Tertiary expected payer (uniform)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PNUM_R                  "Person number (re-identified)"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PR21                    "Procedure 21"
 PR22                    "Procedure 22"
 PR23                    "Procedure 23"
 PR24                    "Procedure 24"
 PR25                    "Procedure 25"
 PR26                    "Procedure 26"
 PR27                    "Procedure 27"
 PR28                    "Procedure 28"
 PR29                    "Procedure 29"
 PR30                    "Procedure 30"
 PR31                    "Procedure 31"
 PR32                    "Procedure 32"
 PR33                    "Procedure 33"
 PR34                    "Procedure 34"
 PR35                    "Procedure 35"
 PR36                    "Procedure 36"
 PR37                    "Procedure 37"
 PR38                    "Procedure 38"
 PR39                    "Procedure 39"
 PR40                    "Procedure 40"
 PR41                    "Procedure 41"
 PR42                    "Procedure 42"
 PR43                    "Procedure 43"
 PR44                    "Procedure 44"
 PR45                    "Procedure 45"
 PR46                    "Procedure 46"
 PR47                    "Procedure 47"
 PR48                    "Procedure 48"
 PR49                    "Procedure 49"
 PR50                    "Procedure 50"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRCCS21                 "CCS: procedure 21"
 PRCCS22                 "CCS: procedure 22"
 PRCCS23                 "CCS: procedure 23"
 PRCCS24                 "CCS: procedure 24"
 PRCCS25                 "CCS: procedure 25"
 PRCCS26                 "CCS: procedure 26"
 PRCCS27                 "CCS: procedure 27"
 PRCCS28                 "CCS: procedure 28"
 PRCCS29                 "CCS: procedure 29"
 PRCCS30                 "CCS: procedure 30"
 PRCCS31                 "CCS: procedure 31"
 PRCCS32                 "CCS: procedure 32"
 PRCCS33                 "CCS: procedure 33"
 PRCCS34                 "CCS: procedure 34"
 PRCCS35                 "CCS: procedure 35"
 PRCCS36                 "CCS: procedure 36"
 PRCCS37                 "CCS: procedure 37"
 PRCCS38                 "CCS: procedure 38"
 PRCCS39                 "CCS: procedure 39"
 PRCCS40                 "CCS: procedure 40"
 PRCCS41                 "CCS: procedure 41"
 PRCCS42                 "CCS: procedure 42"
 PRCCS43                 "CCS: procedure 43"
 PRCCS44                 "CCS: procedure 44"
 PRCCS45                 "CCS: procedure 45"
 PRCCS46                 "CCS: procedure 46"
 PRCCS47                 "CCS: procedure 47"
 PRCCS48                 "CCS: procedure 48"
 PRCCS49                 "CCS: procedure 49"
 PRCCS50                 "CCS: procedure 50"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PRDAY21                 "Number of days from admission to PR21"
 PRDAY22                 "Number of days from admission to PR22"
 PRDAY23                 "Number of days from admission to PR23"
 PRDAY24                 "Number of days from admission to PR24"
 PRDAY25                 "Number of days from admission to PR25"
 PRDAY26                 "Number of days from admission to PR26"
 PRDAY27                 "Number of days from admission to PR27"
 PRDAY28                 "Number of days from admission to PR28"
 PRDAY29                 "Number of days from admission to PR29"
 PRDAY30                 "Number of days from admission to PR30"
 PRDAY31                 "Number of days from admission to PR31"
 PRDAY32                 "Number of days from admission to PR32"
 PRDAY33                 "Number of days from admission to PR33"
 PRDAY34                 "Number of days from admission to PR34"
 PRDAY35                 "Number of days from admission to PR35"
 PRDAY36                 "Number of days from admission to PR36"
 PRDAY37                 "Number of days from admission to PR37"
 PRDAY38                 "Number of days from admission to PR38"
 PRDAY39                 "Number of days from admission to PR39"
 PRDAY40                 "Number of days from admission to PR40"
 PRDAY41                 "Number of days from admission to PR41"
 PRDAY42                 "Number of days from admission to PR42"
 PRDAY43                 "Number of days from admission to PR43"
 PRDAY44                 "Number of days from admission to PR44"
 PRDAY45                 "Number of days from admission to PR45"
 PRDAY46                 "Number of days from admission to PR46"
 PRDAY47                 "Number of days from admission to PR47"
 PRDAY48                 "Number of days from admission to PR48"
 PRDAY49                 "Number of days from admission to PR49"
 PRDAY50                 "Number of days from admission to PR50"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TRAN_IN                 "Transfer in indicator"
 TRAN_OUT                "Transfer out indicator"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRMONTH21               "Month of procedure 21"
 PRMONTH22               "Month of procedure 22"
 PRMONTH23               "Month of procedure 23"
 PRMONTH24               "Month of procedure 24"
 PRMONTH25               "Month of procedure 25"
 PRMONTH26               "Month of procedure 26"
 PRMONTH27               "Month of procedure 27"
 PRMONTH28               "Month of procedure 28"
 PRMONTH29               "Month of procedure 29"
 PRMONTH30               "Month of procedure 30"
 PRMONTH31               "Month of procedure 31"
 PRMONTH32               "Month of procedure 32"
 PRMONTH33               "Month of procedure 33"
 PRMONTH34               "Month of procedure 34"
 PRMONTH35               "Month of procedure 35"
 PRMONTH36               "Month of procedure 36"
 PRMONTH37               "Month of procedure 37"
 PRMONTH38               "Month of procedure 38"
 PRMONTH39               "Month of procedure 39"
 PRMONTH40               "Month of procedure 40"
 PRMONTH41               "Month of procedure 41"
 PRMONTH42               "Month of procedure 42"
 PRMONTH43               "Month of procedure 43"
 PRMONTH44               "Month of procedure 44"
 PRMONTH45               "Month of procedure 45"
 PRMONTH46               "Month of procedure 46"
 PRMONTH47               "Month of procedure 47"
 PRMONTH48               "Month of procedure 48"
 PRMONTH49               "Month of procedure 49"
 PRMONTH50               "Month of procedure 50"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20"
 PRYEAR21                "Year of procedure 21"
 PRYEAR22                "Year of procedure 22"
 PRYEAR23                "Year of procedure 23"
 PRYEAR24                "Year of procedure 24"
 PRYEAR25                "Year of procedure 25"
 PRYEAR26                "Year of procedure 26"
 PRYEAR27                "Year of procedure 27"
 PRYEAR28                "Year of procedure 28"
 PRYEAR29                "Year of procedure 29"
 PRYEAR30                "Year of procedure 30"
 PRYEAR31                "Year of procedure 31"
 PRYEAR32                "Year of procedure 32"
 PRYEAR33                "Year of procedure 33"
 PRYEAR34                "Year of procedure 34"
 PRYEAR35                "Year of procedure 35"
 PRYEAR36                "Year of procedure 36"
 PRYEAR37                "Year of procedure 37"
 PRYEAR38                "Year of procedure 38"
 PRYEAR39                "Year of procedure 39"
 PRYEAR40                "Year of procedure 40"
 PRYEAR41                "Year of procedure 41"
 PRYEAR42                "Year of procedure 42"
 PRYEAR43                "Year of procedure 43"
 PRYEAR44                "Year of procedure 44"
 PRYEAR45                "Year of procedure 45"
 PRYEAR46                "Year of procedure 46"
 PRYEAR47                "Year of procedure 47"
 PRYEAR48                "Year of procedure 48"
 PRYEAR49                "Year of procedure 49"
 PRYEAR50                "Year of procedure 50" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG24
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG_NoPOA
 (-99,-88,-66,-55=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS25
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS26
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS27
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS28
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS29
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS30
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS31
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS32
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS33
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS34
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS35
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS36
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS37
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS38
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS39
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS40
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS41
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS42
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS43
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS44
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS45
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS46
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS47
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS48
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS49
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS50
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS51
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS52
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS53
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS54
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS55
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS56
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS57
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE HospitalUnit
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC24
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC_NoPOA
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM3_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY21
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY22
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY23
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY24
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY25
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY26
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY27
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY28
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY29
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY30
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY31
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY32
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY33
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY34
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY35
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY36
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY37
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY38
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY39
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY40
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY41
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY42
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY43
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY44
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY45
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY46
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY47
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY48
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY49
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY50
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TRAN_IN
 (-9,-8,-6,-5=SYSMIS).
RECODE TRAN_OUT
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH21
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH22
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH23
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH24
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH25
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH26
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH27
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH28
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH29
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH30
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH31
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH32
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH33
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH34
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH35
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH36
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH37
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH38
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH39
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH40
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH41
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH42
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH43
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH44
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH45
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH46
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH47
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH48
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH49
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH50
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR21
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR22
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR23
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR24
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR25
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR26
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR27
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR28
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR29
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR30
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR31
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR32
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR33
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR34
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR35
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR36
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR37
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR38
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR39
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR40
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR41
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR42
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR43
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR44
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR45
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR46
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR47
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR48
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR49
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR50
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_2012_CORE.SAV' /COMPRESSED.
