/*******************************************************************
*   IA_SID_1994_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'IA_SID_1994_CORE.ASC' FIXED / 
 SEQ_SID               1-  13
 AGE                  14-  16
 AGEDAY               17-  19
 SEX                  20-  22
 RACE                 23-  24
 DQTR                 25-  26
 LOS                  27-  31
 DISP                 32-  33
 DIED                 34-  35
 ATYPE                36-  37
 ASOURCE              38-  39
 NDX                  40-  41
 DX1                  42-  46 (A)
 DXV1                 47-  50
 DCCHPR1              51-  54
 NPR                  55-  56
 PR1                  57-  60 (A)
 PRV1                 61-  63
 PCCHPR1              64-  67
 DRG                  68-  70
 MDC                  71-  72
 DRGVER               73-  74
 DRG10                75-  77
 MDC10                78-  79
 PAY1                 80-  81
 TOTCHG               82-  91
 PROCESS              92- 102
 YEAR                103- 106
 DSHOSPID            107- 119 (A)
 DSNUM               120- 122
 DSTYPE              123- 125
 HOSPST              126- 127 (A)
 MDID_S              128- 143 (A)
 SURGID_S            144- 159 (A)
 ADAYWK              160- 162
 AMONTH              163- 164
 LOS_X               165- 169
 NEOMAT              170- 171
 DXSYS               172- 174
 DSNDX               175- 177
 PRSYS               178- 180
 DSNPR               181- 183
 PRDAY1              184- 188
 PAY1_N              189- 191
 TOTCHG_X            192- 203
 DX2                 204- 208 (A)
 DX3                 209- 213 (A)
 DX4                 214- 218 (A)
 DX5                 219- 223 (A)
 DX6                 224- 228 (A)
 DX7                 229- 233 (A)
 DX8                 234- 238 (A)
 DX9                 239- 243 (A)
 DX10                244- 248 (A)
 DXV2                249- 252
 DXV3                253- 256
 DXV4                257- 260
 DXV5                261- 264
 DXV6                265- 268
 DXV7                269- 272
 DXV8                273- 276
 DXV9                277- 280
 DXV10               281- 284
 DCCHPR2             285- 288
 DCCHPR3             289- 292
 DCCHPR4             293- 296
 DCCHPR5             297- 300
 DCCHPR6             301- 304
 DCCHPR7             305- 308
 DCCHPR8             309- 312
 DCCHPR9             313- 316
 DCCHPR10            317- 320
 PR2                 321- 324 (A)
 PR3                 325- 328 (A)
 PR4                 329- 332 (A)
 PR5                 333- 336 (A)
 PR6                 337- 340 (A)
 PRV2                341- 343
 PRV3                344- 346
 PRV4                347- 349
 PRV5                350- 352
 PRV6                353- 355
 PCCHPR2             356- 359
 PCCHPR3             360- 363
 PCCHPR4             364- 367
 PCCHPR5             368- 371
 PCCHPR6             372- 375
 PRDAY2              376- 380
 PRDAY3              381- 385
 PRDAY4              386- 390
 PRDAY5              391- 395
 PRDAY6              396- 400
 ZIP                 401- 405 (A)
 MRN_S               406- 422 (A)
 PSTCO               423- 427
 PAY1_X              428- 429 (A)
 AYEAR               430- 433
 DMONTH              434- 435
 BMONTH              436- 437
 BYEAR               438- 441
 PRMNTH1             442- 443
 PRMNTH2             444- 445
 PRMNTH3             446- 447
 PRMNTH4             448- 449
 PRMNTH5             450- 451
 PRMNTH6             452- 453
 PRYEAR1             454- 457
 PRYEAR2             458- 461
 PRYEAR3             462- 465
 PRYEAR4             466- 469
 PRYEAR5             470- 473
 PRYEAR6             474- 477.


***  Specify write formats  ***.
FORMATS
 SEQ_SID             (F7.0) /
 AGE                 (F3.0) /
 AGEDAY              (F3.0) /
 SEX                 (F3.0) /
 RACE                (F3.0) /
 DQTR                (F3.0) /
 LOS                 (F4.0) /
 DISP                (F3.0) /
 DIED                (F3.0) /
 ATYPE               (F3.0) /
 ASOURCE             (F3.0) /
 NDX                 (F3.0) /
 DXV1                (F3.0) /
 DCCHPR1             (F3.0) /
 NPR                 (F3.0) /
 PRV1                (F3.0) /
 PCCHPR1             (F3.0) /
 DRG                 (F3.0) /
 MDC                 (F3.0) /
 DRGVER              (F3.0) /
 DRG10               (F3.0) /
 MDC10               (F3.0) /
 PAY1                (F3.0) /
 TOTCHG              (F6.0) /
 PROCESS             (F6.0) /
 YEAR                (F3.0) /
 DSNUM               (F3.0) /
 DSTYPE              (F3.0) /
 ADAYWK              (F3.0) /
 AMONTH              (F3.0) /
 LOS_X               (F4.0) /
 NEOMAT              (F3.0) /
 DXSYS               (F3.0) /
 DSNDX               (F3.0) /
 PRSYS               (F3.0) /
 DSNPR               (F3.0) /
 PRDAY1              (F4.0) /
 PAY1_N              (F3.0) /
 TOTCHG_X            (F6.2) /
 DXV2                (F3.0) /
 DXV3                (F3.0) /
 DXV4                (F3.0) /
 DXV5                (F3.0) /
 DXV6                (F3.0) /
 DXV7                (F3.0) /
 DXV8                (F3.0) /
 DXV9                (F3.0) /
 DXV10               (F3.0) /
 DCCHPR2             (F3.0) /
 DCCHPR3             (F3.0) /
 DCCHPR4             (F3.0) /
 DCCHPR5             (F3.0) /
 DCCHPR6             (F3.0) /
 DCCHPR7             (F3.0) /
 DCCHPR8             (F3.0) /
 DCCHPR9             (F3.0) /
 DCCHPR10            (F3.0) /
 PRV2                (F3.0) /
 PRV3                (F3.0) /
 PRV4                (F3.0) /
 PRV5                (F3.0) /
 PRV6                (F3.0) /
 PCCHPR2             (F3.0) /
 PCCHPR3             (F3.0) /
 PCCHPR4             (F3.0) /
 PCCHPR5             (F3.0) /
 PCCHPR6             (F3.0) /
 PRDAY2              (F4.0) /
 PRDAY3              (F4.0) /
 PRDAY4              (F4.0) /
 PRDAY5              (F4.0) /
 PRDAY6              (F4.0) /
 PSTCO               (F5.0) /
 AYEAR               (F3.0) /
 DMONTH              (F3.0) /
 BMONTH              (F3.0) /
 BYEAR               (F3.0) /
 PRMNTH1             (F3.0) /
 PRMNTH2             (F3.0) /
 PRMNTH3             (F3.0) /
 PRMNTH4             (F3.0) /
 PRMNTH5             (F3.0) /
 PRMNTH6             (F3.0) /
 PRYEAR1             (F3.0) /
 PRYEAR2             (F3.0) /
 PRYEAR3             (F3.0) /
 PRYEAR4             (F3.0) /
 PRYEAR5             (F3.0) /
 PRYEAR6             (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 SEQ_SID   "I:HCUP-3 SID record sequence number"
 AGE       "I:Age in years at admission"
 AGEDAY    "I:Age in days (when < 1 year)"
 SEX       "I:Sex"
 RACE      "I:Race"
 DQTR      "I:Discharge quarter"
 LOS       "I:Length of stay (cleaned)"
 DISP      "I:Disposition of patient"
 DIED      "I:Died during hospitalization"
 ATYPE     "I:Admission type"
 ASOURCE   "I:Admission source"
 NDX       "I:Number of diagnoses on this discharge"
 DX1       "I:Principal diagnosis"
 DXV1      "I:Validity flag: principal diagnosis"
 DCCHPR1   "I:CCHPR: principal diagnosis"
 NPR       "I:Number of procedures on this discharge"
 PR1       "I:Principal procedure"
 PRV1      "I:Validity flag: principal procedure"
 PCCHPR1   "I:CCHPR: principal procedure"
 DRG       "I:DRG in effect on discharge date"
 MDC       "I:MDC in effect on discharge date"
 DRGVER    "I:DRG grouper version used on disch date"
 DRG10     "I:DRG, Version 10"
 MDC10     "I:MDC, Version 10"
 PAY1      "I:Primary expected payer, uniform"
 TOTCHG    "I:Total charges (cleaned)"
 PROCESS   "I:HCUP-3 discharge processing ID number"
 YEAR      "Calendar year"
 DSHOSPID  "I:Data source hospital ID number"
 DSNUM     "I:Data source ID number"
 DSTYPE    "I:Data source type"
 HOSPST    "Hospital state postal code"
 MDID_S    "I:Attending physician number (synthetic)"
 SURGID_S  "I:Primary surgeon number (synthetic)"
 ADAYWK    "I:Admission day of week"
 AMONTH    "I:Admission month"
 LOS_X     "I:Length of stay (uncleaned)"
 NEOMAT    "I:Neonatal and/or maternal DX and/or PR"
 DXSYS     "I:Diagnosis coding system"
 DSNDX     "I:Max number of diagnoses from source"
 PRSYS     "I:Procedure coding system"
 DSNPR     "I:Max number of procedures from source"
 PRDAY1    "I:No. of days from admission to PR1"
 PAY1_N    "I:Primary expected payer, nonuniform"
 TOTCHG_X  "I:Total charges (from data source)"
 DX2       "I:Diagnosis 2"
 DX3       "I:Diagnosis 3"
 DX4       "I:Diagnosis 4"
 DX5       "I:Diagnosis 5"
 DX6       "I:Diagnosis 6"
 DX7       "I:Diagnosis 7"
 DX8       "I:Diagnosis 8"
 DX9       "I:Diagnosis 9"
 DX10      "I:Diagnosis 10"
 DXV2      "I:Validity flag: diagnosis 2"
 DXV3      "I:Validity flag: diagnosis 3"
 DXV4      "I:Validity flag: diagnosis 4"
 DXV5      "I:Validity flag: diagnosis 5"
 DXV6      "I:Validity flag: diagnosis 6"
 DXV7      "I:Validity flag: diagnosis 7"
 DXV8      "I:Validity flag: diagnosis 8"
 DXV9      "I:Validity flag: diagnosis 9"
 DXV10     "I:Validity flag: diagnosis 10"
 DCCHPR2   "I:CCHPR: diagnosis 2"
 DCCHPR3   "I:CCHPR: diagnosis 3"
 DCCHPR4   "I:CCHPR: diagnosis 4"
 DCCHPR5   "I:CCHPR: diagnosis 5"
 DCCHPR6   "I:CCHPR: diagnosis 6"
 DCCHPR7   "I:CCHPR: diagnosis 7"
 DCCHPR8   "I:CCHPR: diagnosis 8"
 DCCHPR9   "I:CCHPR: diagnosis 9"
 DCCHPR10  "I:CCHPR: diagnosis 10"
 PR2       "I:Procedure 2"
 PR3       "I:Procedure 3"
 PR4       "I:Procedure 4"
 PR5       "I:Procedure 5"
 PR6       "I:Procedure 6"
 PRV2      "I:Validity flag: procedure 2"
 PRV3      "I:Validity flag: procedure 3"
 PRV4      "I:Validity flag: procedure 4"
 PRV5      "I:Validity flag: procedure 5"
 PRV6      "I:Validity flag: procedure 6"
 PCCHPR2   "I:CCHPR: procedure 2"
 PCCHPR3   "I:CCHPR: procedure 3"
 PCCHPR4   "I:CCHPR: procedure 4"
 PCCHPR5   "I:CCHPR: procedure 5"
 PCCHPR6   "I:CCHPR: procedure 6"
 PRDAY2    "I:No. of days from admission to PR2"
 PRDAY3    "I:No. of days from admission to PR3"
 PRDAY4    "I:No. of days from admission to PR4"
 PRDAY5    "I:No. of days from admission to PR5"
 PRDAY6    "I:No. of days from admission to PR6"
 ZIP       "I:Patient zip code"
 MRN_S     "I:Medical record number (synthetic)"
 PSTCO     "I:Patient state/county FIPS code"
 PAY1_X    "I:Primary exp. payer (from data source)"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE SEX
 (-99,-88,-66,-55=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE DISP
 (-9,-8,-6,-5=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE DXV1
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PRV1
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR1
 (-999,-888,-666,-555=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE DSNUM
 (-99,-88,-66,-55=SYSMIS).
RECODE DSTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE ADAYWK
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS_X
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE DXSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNDX
 (-99,-88,-66,-55=SYSMIS).
RECODE PRSYS
 (-99,-88,-66,-55=SYSMIS).
RECODE DSNPR
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PAY1_N
 (-99,-88,-66,-55=SYSMIS).
RECODE TOTCHG_X
 (-99999999.99,-88888888.88,-66666666.66,-55555555.55=SYSMIS).
RECODE DXV2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXV10
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR7
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR8
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR9
 (-999,-888,-666,-555=SYSMIS).
RECODE DCCHPR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRV2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRV6
 (-99,-88,-66,-55=SYSMIS).
RECODE PCCHPR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PCCHPR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'IA_SID_1994_CORE.SAV' /COMPRESSED.
