/*******************************************************************
*   HI_SID_2003_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'HI_SID_2003_CORE.ASC' FIXED / 
 HOSPID                     1-   5
 HOSPST                     6-   7 (A)
 KEY                        8-  21
 AGEDAY                    22-  24
 AGEMONTH                  25-  27
 AMONTH                    28-  29
 ASOURCE                   30-  31
 ASOURCE_                  32     (A)
 ASOURCEU                  33     (A)
 ATYPE                     34-  35
 AWEEKEND                  36-  37
 BWT                       38-  41
 DIED                      42-  43
 DISP_X                    44-  45 (A)
 DISPUB92                  46-  47
 DISPUNIF                  48-  49
 DQTR                      50-  51
 DRG                       52-  54
 DRG18                     55-  57
 DRGVER                    58-  59
 DX1                       60-  64 (A)
 DX2                       65-  69 (A)
 DX3                       70-  74 (A)
 DX4                       75-  79 (A)
 DX5                       80-  84 (A)
 DX6                       85-  89 (A)
 DX7                       90-  94 (A)
 DX8                       95-  99 (A)
 DX9                      100- 104 (A)
 DX10                     105- 109 (A)
 DX11                     110- 114 (A)
 DX12                     115- 119 (A)
 DX13                     120- 124 (A)
 DX14                     125- 129 (A)
 DX15                     130- 134 (A)
 DX16                     135- 139 (A)
 DX17                     140- 144 (A)
 DX18                     145- 149 (A)
 DX19                     150- 154 (A)
 DX20                     155- 159 (A)
 DXCCS1                   160- 163
 DXCCS2                   164- 167
 DXCCS3                   168- 171
 DXCCS4                   172- 175
 DXCCS5                   176- 179
 DXCCS6                   180- 183
 DXCCS7                   184- 187
 DXCCS8                   188- 191
 DXCCS9                   192- 195
 DXCCS10                  196- 199
 DXCCS11                  200- 203
 DXCCS12                  204- 207
 DXCCS13                  208- 211
 DXCCS14                  212- 215
 DXCCS15                  216- 219
 DXCCS16                  220- 223
 DXCCS17                  224- 227
 DXCCS18                  228- 231
 DXCCS19                  232- 235
 DXCCS20                  236- 239
 ECODE1                   240- 244 (A)
 ECODE2                   245- 249 (A)
 ECODE3                   250- 254 (A)
 ECODE4                   255- 259 (A)
 ECODE5                   260- 264 (A)
 ECODE6                   265- 269 (A)
 ECODE7                   270- 274 (A)
 ECODE8                   275- 279 (A)
 E_CCS1                   280- 283
 E_CCS2                   284- 287
 E_CCS3                   288- 291
 E_CCS4                   292- 295
 E_CCS5                   296- 299
 E_CCS6                   300- 303
 E_CCS7                   304- 307
 E_CCS8                   308- 311
 FEMALE                   312- 313
 LOS                      314- 318
 LOS_X                    319- 324
 MDC                      325- 326
 MDC18                    327- 328
 MRN_R                    329- 337
 NDX                      338- 339
 NECODE                   340- 341
 NEOMAT                   342- 343
 NPR                      344- 345
 PAY1                     346- 347
 PAY1_X                   348- 349 (A)
 PL_CBSA                  350- 352
 PL_MSA19                 353- 355
 PL_RUCA                  356- 359
 PL_RUCA1                 360- 361
 PL_RUCA4                 362- 363
 PL_RUCC2                 364- 365
 PL_UIC20                 366- 367
 PL_UR_CA                 368- 369
 PL_UR_CA                 370- 371
 PR1                      372- 375 (A)
 PR2                      376- 379 (A)
 PR3                      380- 383 (A)
 PR4                      384- 387 (A)
 PR5                      388- 391 (A)
 PR6                      392- 395 (A)
 PR7                      396- 399 (A)
 PR8                      400- 403 (A)
 PR9                      404- 407 (A)
 PR10                     408- 411 (A)
 PR11                     412- 415 (A)
 PR12                     416- 419 (A)
 PR13                     420- 423 (A)
 PR14                     424- 427 (A)
 PR15                     428- 431 (A)
 PR16                     432- 435 (A)
 PR17                     436- 439 (A)
 PR18                     440- 443 (A)
 PR19                     444- 447 (A)
 PR20                     448- 451 (A)
 PRCCS1                   452- 454
 PRCCS2                   455- 457
 PRCCS3                   458- 460
 PRCCS4                   461- 463
 PRCCS5                   464- 466
 PRCCS6                   467- 469
 PRCCS7                   470- 472
 PRCCS8                   473- 475
 PRCCS9                   476- 478
 PRCCS10                  479- 481
 PRCCS11                  482- 484
 PRCCS12                  485- 487
 PRCCS13                  488- 490
 PRCCS14                  491- 493
 PRCCS15                  494- 496
 PRCCS16                  497- 499
 PRCCS17                  500- 502
 PRCCS18                  503- 505
 PRCCS19                  506- 508
 PRCCS20                  509- 511
 PRDAY1                   512- 516
 PRDAY2                   517- 521
 PRDAY3                   522- 526
 PRDAY4                   527- 531
 PRDAY5                   532- 536
 PRDAY6                   537- 541
 PRDAY7                   542- 546
 PRDAY8                   547- 551
 PRDAY9                   552- 556
 PRDAY10                  557- 561
 PRDAY11                  562- 566
 PRDAY12                  567- 571
 PRDAY13                  572- 576
 PRDAY14                  577- 581
 PRDAY15                  582- 586
 PRDAY16                  587- 591
 PRDAY17                  592- 596
 PRDAY18                  597- 601
 PRDAY19                  602- 606
 PRDAY20                  607- 611
 PSTATE                   612- 613 (A)
 PSTCO2                   614- 618
 RACE                     619- 620
 RACE_X                   621- 622 (A)
 TOTCHG                   623- 632
 TOTCHG_X                 633- 647
 YEAR                     648- 651
 ZIP                      652- 656 (A)
 AGEGROUP                 657- 659
 AYEAR                    660- 663
 DMONTH                   664- 665
 BMONTH                   666- 667
 BYEAR                    668- 671
 PRMNTH1                  672- 673
 PRMNTH2                  674- 675
 PRMNTH3                  676- 677
 PRMNTH4                  678- 679
 PRMNTH5                  680- 681
 PRMNTH6                  682- 683
 PRMNTH7                  684- 685
 PRMNTH8                  686- 687
 PRMNTH9                  688- 689
 PRMNTH10                 690- 691
 PRMNTH11                 692- 693
 PRMNTH12                 694- 695
 PRMNTH13                 696- 697
 PRMNTH14                 698- 699
 PRMNTH15                 700- 701
 PRMNTH16                 702- 703
 PRMNTH17                 704- 705
 PRMNTH18                 706- 707
 PRMNTH19                 708- 709
 PRMNTH20                 710- 711
 PRYEAR1                  712- 715
 PRYEAR2                  716- 719
 PRYEAR3                  720- 723
 PRYEAR4                  724- 727
 PRYEAR5                  728- 731
 PRYEAR6                  732- 735
 PRYEAR7                  736- 739
 PRYEAR8                  740- 743
 PRYEAR9                  744- 747
 PRYEAR10                 748- 751
 PRYEAR11                 752- 755
 PRYEAR12                 756- 759
 PRYEAR13                 760- 763
 PRYEAR14                 764- 767
 PRYEAR15                 768- 771
 PRYEAR16                 772- 775
 PRYEAR17                 776- 779
 PRYEAR18                 780- 783
 PRYEAR19                 784- 787
 PRYEAR20                 788- 791.


***  Specify write formats  ***.
FORMATS
 HOSPID                  (F4.0) /
 KEY                     (F8.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA                 (F4.1) /
 PL_RUCA1                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 AGEGROUP                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRMNTH2                 (F3.0) /
 PRMNTH3                 (F3.0) /
 PRMNTH4                 (F3.0) /
 PRMNTH5                 (F3.0) /
 PRMNTH6                 (F3.0) /
 PRMNTH7                 (F3.0) /
 PRMNTH8                 (F3.0) /
 PRMNTH9                 (F3.0) /
 PRMNTH10                (F3.0) /
 PRMNTH11                (F3.0) /
 PRMNTH12                (F3.0) /
 PRMNTH13                (F3.0) /
 PRMNTH14                (F3.0) /
 PRMNTH15                (F3.0) /
 PRMNTH16                (F3.0) /
 PRMNTH17                (F3.0) /
 PRMNTH18                (F3.0) /
 PRMNTH19                (F3.0) /
 PRMNTH20                (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 HOSPID    "HCUP hospital identification number"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BWT       "Birth weight in grams"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DX10      "Diagnosis 10"
 DX11      "Diagnosis 11"
 DX12      "Diagnosis 12"
 DX13      "Diagnosis 13"
 DX14      "Diagnosis 14"
 DX15      "Diagnosis 15"
 DX16      "Diagnosis 16"
 DX17      "Diagnosis 17"
 DX18      "Diagnosis 18"
 DX19      "Diagnosis 19"
 DX20      "Diagnosis 20"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 DXCCS10   "CCS: diagnosis 10"
 DXCCS11   "CCS: diagnosis 11"
 DXCCS12   "CCS: diagnosis 12"
 DXCCS13   "CCS: diagnosis 13"
 DXCCS14   "CCS: diagnosis 14"
 DXCCS15   "CCS: diagnosis 15"
 DXCCS16   "CCS: diagnosis 16"
 DXCCS17   "CCS: diagnosis 17"
 DXCCS18   "CCS: diagnosis 18"
 DXCCS19   "CCS: diagnosis 19"
 DXCCS20   "CCS: diagnosis 20"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 ECODE6    "E code 6"
 ECODE7    "E code 7"
 ECODE8    "E code 8"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_CCS6    "CCS: E Code 6"
 E_CCS7    "CCS: E Code 7"
 E_CCS8    "CCS: E Code 8"
 FEMALE    "Indicator of sex"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA   "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PR7       "Procedure 7"
 PR8       "Procedure 8"
 PR9       "Procedure 9"
 PR10      "Procedure 10"
 PR11      "Procedure 11"
 PR12      "Procedure 12"
 PR13      "Procedure 13"
 PR14      "Procedure 14"
 PR15      "Procedure 15"
 PR16      "Procedure 16"
 PR17      "Procedure 17"
 PR18      "Procedure 18"
 PR19      "Procedure 19"
 PR20      "Procedure 20"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRCCS7    "CCS: procedure 7"
 PRCCS8    "CCS: procedure 8"
 PRCCS9    "CCS: procedure 9"
 PRCCS10   "CCS: procedure 10"
 PRCCS11   "CCS: procedure 11"
 PRCCS12   "CCS: procedure 12"
 PRCCS13   "CCS: procedure 13"
 PRCCS14   "CCS: procedure 14"
 PRCCS15   "CCS: procedure 15"
 PRCCS16   "CCS: procedure 16"
 PRCCS17   "CCS: procedure 17"
 PRCCS18   "CCS: procedure 18"
 PRCCS19   "CCS: procedure 19"
 PRCCS20   "CCS: procedure 20"
 PRDAY1    "Number of days from admission to PR1"
 PRDAY2    "Number of days from admission to PR2"
 PRDAY3    "Number of days from admission to PR3"
 PRDAY4    "Number of days from admission to PR4"
 PRDAY5    "Number of days from admission to PR5"
 PRDAY6    "Number of days from admission to PR6"
 PRDAY7    "Number of days from admission to PR7"
 PRDAY8    "Number of days from admission to PR8"
 PRDAY9    "Number of days from admission to PR9"
 PRDAY10   "Number of days from admission to PR10"
 PRDAY11   "Number of days from admission to PR11"
 PRDAY12   "Number of days from admission to PR12"
 PRDAY13   "Number of days from admission to PR13"
 PRDAY14   "Number of days from admission to PR14"
 PRDAY15   "Number of days from admission to PR15"
 PRDAY16   "Number of days from admission to PR16"
 PRDAY17   "Number of days from admission to PR17"
 PRDAY18   "Number of days from admission to PR18"
 PRDAY19   "Number of days from admission to PR19"
 PRDAY20   "Number of days from admission to PR20"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code"
 AGEGROUP  "Age Group"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRMNTH2   "Month of procedure 2"
 PRMNTH3   "Month of procedure 3"
 PRMNTH4   "Month of procedure 4"
 PRMNTH5   "Month of procedure 5"
 PRMNTH6   "Month of procedure 6"
 PRMNTH7   "Month of procedure 7"
 PRMNTH8   "Month of procedure 8"
 PRMNTH9   "Month of procedure 9"
 PRMNTH10  "Month of procedure 10"
 PRMNTH11  "Month of procedure 11"
 PRMNTH12  "Month of procedure 12"
 PRMNTH13  "Month of procedure 13"
 PRMNTH14  "Month of procedure 14"
 PRMNTH15  "Month of procedure 15"
 PRMNTH16  "Month of procedure 16"
 PRMNTH17  "Month of procedure 17"
 PRMNTH18  "Month of procedure 18"
 PRMNTH19  "Month of procedure 19"
 PRMNTH20  "Month of procedure 20"
 PRYEAR1   "Year of procedure 1"
 PRYEAR2   "Year of procedure 2"
 PRYEAR3   "Year of procedure 3"
 PRYEAR4   "Year of procedure 4"
 PRYEAR5   "Year of procedure 5"
 PRYEAR6   "Year of procedure 6"
 PRYEAR7   "Year of procedure 7"
 PRYEAR8   "Year of procedure 8"
 PRYEAR9   "Year of procedure 9"
 PRYEAR10  "Year of procedure 10"
 PRYEAR11  "Year of procedure 11"
 PRYEAR12  "Year of procedure 12"
 PRYEAR13  "Year of procedure 13"
 PRYEAR14  "Year of procedure 14"
 PRYEAR15  "Year of procedure 15"
 PRYEAR16  "Year of procedure 16"
 PRYEAR17  "Year of procedure 17"
 PRYEAR18  "Year of procedure 18"
 PRYEAR19  "Year of procedure 19"
 PRYEAR20  "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMNTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'HI_SID_2003_CORE.SAV' /COMPRESSED.
