/*******************************************************************
* Creation Date: 11/24/2014   
*   HI_SID_1999_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'HI_SID_1999_CORE.ASC' FIXED SKIP=2 / 
 KEY                        1-  15
 AGEDAY                    16-  18
 AGEMONTH                  19-  21
 AMONTH                    22-  23
 ASOURCE                   24-  25
 ASOURCE_X                 26     (A)
 ATYPE                     27-  28
 AWEEKEND                  29-  30
 BWT                       31-  34
 DIED                      35-  36
 DISPUB92                  37-  38
 DISPUNIFORM               39-  40
 DISP_X                    41-  42 (A)
 DQTR                      43-  44
 DRG                       45-  47
 DRG10                     48-  50
 DRG18                     51-  53
 DRGVER                    54-  55
 DX1                       56-  60 (A)
 DX2                       61-  65 (A)
 DX3                       66-  70 (A)
 DX4                       71-  75 (A)
 DX5                       76-  80 (A)
 DX6                       81-  85 (A)
 DX7                       86-  90 (A)
 DX8                       91-  95 (A)
 DX9                       96- 100 (A)
 DX10                     101- 105 (A)
 DX11                     106- 110 (A)
 DXCCS1                   111- 114
 DXCCS2                   115- 118
 DXCCS3                   119- 122
 DXCCS4                   123- 126
 DXCCS5                   127- 130
 DXCCS6                   131- 134
 DXCCS7                   135- 138
 DXCCS8                   139- 142
 DXCCS9                   143- 146
 DXCCS10                  147- 150
 DXCCS11                  151- 154
 FEMALE                   155- 156
 HOSPST                   157- 158 (A)
 LOS                      159- 163
 LOS_X                    164- 169
 MDC                      170- 171
 MDC10                    172- 173
 MDC18                    174- 175
 MRN_S                    176- 193 (A)
 NDX                      194- 195
 NEOMAT                   196- 197
 NPR                      198- 199
 PAY1                     200- 201
 PAY1_X                   202- 203 (A)
 PR1                      204- 207 (A)
 PR2                      208- 211 (A)
 PR3                      212- 215 (A)
 PR4                      216- 219 (A)
 PR5                      220- 223 (A)
 PR6                      224- 227 (A)
 PR7                      228- 231 (A)
 PR8                      232- 235 (A)
 PR9                      236- 239 (A)
 PR10                     240- 243 (A)
 PRCCS1                   244- 246
 PRCCS2                   247- 249
 PRCCS3                   250- 252
 PRCCS4                   253- 255
 PRCCS5                   256- 258
 PRCCS6                   259- 261
 PRCCS7                   262- 264
 PRCCS8                   265- 267
 PRCCS9                   268- 270
 PRCCS10                  271- 273
 PRDAY1                   274- 278
 PRDAY2                   279- 283
 PRDAY3                   284- 288
 PRDAY4                   289- 293
 PRDAY5                   294- 298
 PRDAY6                   299- 303
 PRDAY7                   304- 308
 PRDAY8                   309- 313
 PRDAY9                   314- 318
 PRDAY10                  319- 323
 RACE                     324- 325
 RACE_X                   326- 327 (A)
 TOTCHG                   328- 337
 TOTCHG_X                 338- 352
 YEAR                     353- 356
 ZIP_S                    357- 361 (A)
 HOSPID                   362- 366
 AGEGROUP                 367- 369
 AYEAR                    370- 373
 DMONTH                   374- 375
 BMONTH                   376- 377
 BYEAR                    378- 381
 PRMONTH1                 382- 383
 PRMONTH2                 384- 385
 PRMONTH3                 386- 387
 PRMONTH4                 388- 389
 PRMONTH5                 390- 391
 PRMONTH6                 392- 393
 PRMONTH7                 394- 395
 PRMONTH8                 396- 397
 PRMONTH9                 398- 399
 PRMONTH10                400- 401
 PRYEAR1                  402- 405
 PRYEAR2                  406- 409
 PRYEAR3                  410- 413
 PRYEAR4                  414- 417
 PRYEAR5                  418- 421
 PRYEAR6                  422- 425
 PRYEAR7                  426- 429
 PRYEAR8                  430- 433
 PRYEAR9                  434- 437
 PRYEAR10                 438- 441.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG10                   (F3.0) /
 DRG18                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 FEMALE                  (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC10                   (F3.0) /
 MDC18                   (F3.0) /
 NDX                     (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 HOSPID                  (F4.0) /
 AGEGROUP                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY                     "HCUP record identifier"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BWT                     "Birth weight in grams"
 DIED                    "Died during hospitalization"
 DISPUB92                "Disposition of patient (UB-92 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DRG                     "DRG in effect on discharge date"
 DRG10                   "DRG, version 10"
 DRG18                   "DRG, version 18"
 DRGVER                  "DRG grouper version used on discharge date"
 DX1                     "Principal diagnosis"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DXCCS1                  "CCS: principal diagnosis"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 FEMALE                  "Indicator of sex"
 HOSPST                  "Hospital state postal code"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (uncleaned)"
 MDC                     "MDC in effect on discharge date"
 MDC10                   "MDC, version 10"
 MDC18                   "MDC, version 18"
 MRN_S                   "Medical record number (synthetic)"
 NDX                     "Number of diagnoses on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PR1                     "Principal procedure"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PRCCS1                  "CCS: principal procedure"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIP_S                   "Patient zip code (synthetic)"
 HOSPID                  "HCUP hospital identifier (SSHHH)"
 AGEGROUP                "Age Group"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG10
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC10
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'HI_SID_1999_CORE.SAV' /COMPRESSED.
