/*******************************************************************
*   AZ_SID_2004_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'AZ_SID_2004_CORE.ASC' FIXED / 
 KEY                        1-  14
 AGE                       15-  17
 AGEDAY                    18-  20
 AGEMONTH                  21-  23
 AHOUR                     24-  27
 AMONTH                    28-  29
 ASOURCE                   30-  31
 ASOURCE_                  32     (A)
 ASOURCEU                  33     (A)
 ATYPE                     34-  35
 AWEEKEND                  36-  37
 BWT                       38-  41
 DHOUR                     42-  45
 DIED                      46-  47
 DISP_X                    48-  49 (A)
 DISPUB92                  50-  51
 DISPUNIF                  52-  53
 DNR                       54-  55
 DQTR                      56-  57
 DRG                       58-  60
 DRG18                     61-  63
 DRGVER                    64-  65
 DSHOSPID                  66-  78 (A)
 DX1                       79-  83 (A)
 DX2                       84-  88 (A)
 DX3                       89-  93 (A)
 DX4                       94-  98 (A)
 DX5                       99- 103 (A)
 DX6                      104- 108 (A)
 DX7                      109- 113 (A)
 DX8                      114- 118 (A)
 DX9                      119- 123 (A)
 DXCCS1                   124- 127
 DXCCS2                   128- 131
 DXCCS3                   132- 135
 DXCCS4                   136- 139
 DXCCS5                   140- 143
 DXCCS6                   144- 147
 DXCCS7                   148- 151
 DXCCS8                   152- 155
 DXCCS9                   156- 159
 ECODE1                   160- 164 (A)
 ECODE2                   165- 169 (A)
 ECODE3                   170- 174 (A)
 ECODE4                   175- 179 (A)
 ECODE5                   180- 184 (A)
 E_CCS1                   185- 188
 E_CCS2                   189- 192
 E_CCS3                   193- 196
 E_CCS4                   197- 200
 E_CCS5                   201- 204
 FEMALE                   205- 206
 HOSPST                   207- 208 (A)
 LOS                      209- 213
 LOS_X                    214- 219
 MARITALS                 220     (A)
 MDBOARD1                 221     (A)
 MDBOARD2                 222     (A)
 MDC                      223- 224
 MDC18                    225- 226
 MDNUM1_R                 227- 235
 MDNUM2_R                 236- 244
 MRN_R                    245- 253
 NDX                      254- 255
 NECODE                   256- 257
 NEOMAT                   258- 259
 NPR                      260- 261
 PAY1                     262- 263
 PAY1_X                   264- 265 (A)
 PL_CBSA                  266- 268
 PL_MSA19                 269- 271
 PL_RUCA                  272- 275
 PL_RUCA1                 276- 277
 PL_RUCA4                 278- 279
 PL_RUCC2                 280- 281
 PL_UIC20                 282- 283
 PL_UR_CA                 284- 285
 PL_UR_CA                 286- 287
 PNUM_R                   288- 296
 PR1                      297- 300 (A)
 PR2                      301- 304 (A)
 PR3                      305- 308 (A)
 PR4                      309- 312 (A)
 PR5                      313- 316 (A)
 PR6                      317- 320 (A)
 PRCCS1                   321- 323
 PRCCS2                   324- 326
 PRCCS3                   327- 329
 PRCCS4                   330- 332
 PRCCS5                   333- 335
 PRCCS6                   336- 338
 PRDAY1                   339- 343
 PSTATE                   344- 345 (A)
 PSTCO2                   346- 350
 RACE                     351- 352
 RACE_X                   353     (A)
 TOTCHG                   354- 363
 TOTCHG_X                 364- 378
 YEAR                     379- 382
 ZIP                      383- 387 (A)
 AYEAR                    388- 391
 DMONTH                   392- 393
 BMONTH                   394- 395
 BYEAR                    396- 399
 PRMNTH1                  400- 401
 PRYEAR1                  402- 405.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 BWT                     (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUB92                (F3.0) /
 DISPUNIF                (F3.0) /
 DNR                     (F3.0) /
 DQTR                    (F3.0) /
 DRG                     (F3.0) /
 DRG18                   (F3.0) /
 DRGVER                  (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MDC                     (F3.0) /
 MDC18                   (F3.0) /
 MDNUM1_R                (F5.0) /
 MDNUM2_R                (F5.0) /
 MRN_R                   (F5.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA                 (F4.1) /
 PL_RUCA1                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_RUCC2                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PL_UR_CA                (F3.0) /
 PNUM_R                  (F5.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRDAY1                  (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMNTH1                 (F3.0) /
 PRYEAR1                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 AGE       "Age in years at admission"
 AGEDAY    "Age in days (when age < 1 year)"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ASOURCEU  "Admission source (UB-92 standard coding)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 BWT       "Birth weight in grams"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISP_X    "Disposition of patient (as received from source)"
 DISPUB92  "Disposition of patient (UB-92 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DNR       "Do not resuscitate indicator"
 DQTR      "Discharge quarter"
 DRG       "DRG in effect on discharge date"
 DRG18     "DRG, version 18"
 DRGVER    "DRG grouper version used on discharge date"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Principal diagnosis"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: principal diagnosis"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HOSPST    "Hospital state postal code"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MARITALS  "Patient's marital status"
 MDBOARD1  "Physician 1 licensing board (as received from source)"
 MDBOARD2  "Physician 2 licensing board (as received from source)"
 MDC       "MDC in effect on discharge date"
 MDC18     "MDC, version 18"
 MDNUM1_R  "Physician 1 number (re-identified)"
 MDNUM2_R  "Physician 2 number (re-identified)"
 MRN_R     "Medical record number (re-identified)"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA   "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA1  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2  "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PL_UR_CA  "Patient Location: Urban-Rural 5 Categories"
 PNUM_R    "Person number (re-identified)"
 PR1       "Principal procedure"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PR5       "Procedure 5"
 PR6       "Procedure 6"
 PRCCS1    "CCS: principal procedure"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PRCCS5    "CCS: procedure 5"
 PRCCS6    "CCS: procedure 6"
 PRDAY1    "Number of days from admission to PR1"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 YEAR      "Calendar year"
 ZIP       "Patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month"
 BMONTH    "Birth month"
 BYEAR     "Birth year"
 PRMNTH1   "Month of procedure 1"
 PRYEAR1   "Year of procedure 1" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE BWT
 (-999,-888,-666,-555=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB92
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DNR
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DRG
 (-99,-88,-66,-55=SYSMIS).
RECODE DRG18
 (-99,-88,-66,-55=SYSMIS).
RECODE DRGVER
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDC
 (-9,-8,-6,-5=SYSMIS).
RECODE MDC18
 (-9,-8,-6,-5=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMNTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'AZ_SID_2004_CORE.SAV' /COMPRESSED.
