/*****************************************************************************
* Creation Date: 04/08/2019   
* MD_SEDD_2014_ZIP.Do
* This program will load the 2014 MD ASCII ZIP File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      str    HOSPST                       1-   2   ///
      double KEY                          3-  17   ///
      int    YEAR                        18-  21   ///
      str    ZIP                         22-  26   ///
      using  "MD_SEDD_2014_ZIP.ASC"

***  Assign labels to the data elements ***
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"

*** Convert special values to missing values ***
recode YEAR                      (-999 -888 -666=.)

save "MD_SEDD_2014_ZIP.dta", replace
