/*******************************************************************
*   VT_SEDD_2009_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'VT_SEDD_2009_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEDAY                     4-   6
 AGEMONTH                   7-   9
 AHOUR                     10-  13
 AMONTH                    14-  15
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 BILLTYPE                  20-  23 (A)
 CPT1                      24-  28 (A)
 CPT2                      29-  33 (A)
 CPT3                      34-  38 (A)
 CPT4                      39-  43 (A)
 CPT5                      44-  48 (A)
 CPT6                      49-  53 (A)
 CPT7                      54-  58 (A)
 CPT8                      59-  63 (A)
 CPT9                      64-  68 (A)
 CPT10                     69-  73 (A)
 CPT11                     74-  78 (A)
 CPT12                     79-  83 (A)
 CPT13                     84-  88 (A)
 CPT14                     89-  93 (A)
 CPT15                     94-  98 (A)
 CPT16                     99- 103 (A)
 CPT17                    104- 108 (A)
 CPT18                    109- 113 (A)
 CPT19                    114- 118 (A)
 CPT20                    119- 123 (A)
 CPT21                    124- 128 (A)
 CPT22                    129- 133 (A)
 CPT23                    134- 138 (A)
 CPT24                    139- 143 (A)
 CPT25                    144- 148 (A)
 CPTCCS1                  149- 151
 CPTCCS2                  152- 154
 CPTCCS3                  155- 157
 CPTCCS4                  158- 160
 CPTCCS5                  161- 163
 CPTCCS6                  164- 166
 CPTCCS7                  167- 169
 CPTCCS8                  170- 172
 CPTCCS9                  173- 175
 CPTCCS10                 176- 178
 CPTCCS11                 179- 181
 CPTCCS12                 182- 184
 CPTCCS13                 185- 187
 CPTCCS14                 188- 190
 CPTCCS15                 191- 193
 CPTCCS16                 194- 196
 CPTCCS17                 197- 199
 CPTCCS18                 200- 202
 CPTCCS19                 203- 205
 CPTCCS20                 206- 208
 CPTCCS21                 209- 211
 CPTCCS22                 212- 214
 CPTCCS23                 215- 217
 CPTCCS24                 218- 220
 CPTCCS25                 221- 223
 CPTDAY1                  224- 226
 CPTDAY2                  227- 229
 CPTDAY3                  230- 232
 CPTDAY4                  233- 235
 CPTDAY5                  236- 238
 CPTDAY6                  239- 241
 CPTDAY7                  242- 244
 CPTDAY8                  245- 247
 CPTDAY9                  248- 250
 CPTDAY10                 251- 253
 CPTDAY11                 254- 256
 CPTDAY12                 257- 259
 CPTDAY13                 260- 262
 CPTDAY14                 263- 265
 CPTDAY15                 266- 268
 CPTDAY16                 269- 271
 CPTDAY17                 272- 274
 CPTDAY18                 275- 277
 CPTDAY19                 278- 280
 CPTDAY20                 281- 283
 CPTDAY21                 284- 286
 CPTDAY22                 287- 289
 CPTDAY23                 290- 292
 CPTDAY24                 293- 295
 CPTDAY25                 296- 298
 CPTM1_1                  299- 300 (A)
 CPTM1_2                  301- 302 (A)
 CPTM1_3                  303- 304 (A)
 CPTM1_4                  305- 306 (A)
 CPTM1_5                  307- 308 (A)
 CPTM1_6                  309- 310 (A)
 CPTM1_7                  311- 312 (A)
 CPTM1_8                  313- 314 (A)
 CPTM1_9                  315- 316 (A)
 CPTM1_10                 317- 318 (A)
 CPTM1_11                 319- 320 (A)
 CPTM1_12                 321- 322 (A)
 CPTM1_13                 323- 324 (A)
 CPTM1_14                 325- 326 (A)
 CPTM1_15                 327- 328 (A)
 CPTM1_16                 329- 330 (A)
 CPTM1_17                 331- 332 (A)
 CPTM1_18                 333- 334 (A)
 CPTM1_19                 335- 336 (A)
 CPTM1_20                 337- 338 (A)
 CPTM1_21                 339- 340 (A)
 CPTM1_22                 341- 342 (A)
 CPTM1_23                 343- 344 (A)
 CPTM1_24                 345- 346 (A)
 CPTM1_25                 347- 348 (A)
 CPTM2_1                  349- 350 (A)
 CPTM2_2                  351- 352 (A)
 CPTM2_3                  353- 354 (A)
 CPTM2_4                  355- 356 (A)
 CPTM2_5                  357- 358 (A)
 CPTM2_6                  359- 360 (A)
 CPTM2_7                  361- 362 (A)
 CPTM2_8                  363- 364 (A)
 CPTM2_9                  365- 366 (A)
 CPTM2_10                 367- 368 (A)
 CPTM2_11                 369- 370 (A)
 CPTM2_12                 371- 372 (A)
 CPTM2_13                 373- 374 (A)
 CPTM2_14                 375- 376 (A)
 CPTM2_15                 377- 378 (A)
 CPTM2_16                 379- 380 (A)
 CPTM2_17                 381- 382 (A)
 CPTM2_18                 383- 384 (A)
 CPTM2_19                 385- 386 (A)
 CPTM2_20                 387- 388 (A)
 CPTM2_21                 389- 390 (A)
 CPTM2_22                 391- 392 (A)
 CPTM2_23                 393- 394 (A)
 CPTM2_24                 395- 396 (A)
 CPTM2_25                 397- 398 (A)
 DIED                     399- 400
 DISPUB04                 401- 402
 DISPUNIFORM              403- 404
 DISP_X                   405- 406 (A)
 DQTR                     407- 408
 DSHOSPID                 409- 425 (A)
 DX1                      426- 430 (A)
 DX2                      431- 435 (A)
 DX3                      436- 440 (A)
 DX4                      441- 445 (A)
 DX5                      446- 450 (A)
 DX6                      451- 455 (A)
 DX7                      456- 460 (A)
 DX8                      461- 465 (A)
 DX9                      466- 470 (A)
 DX10                     471- 475 (A)
 DX11                     476- 480 (A)
 DX12                     481- 485 (A)
 DX13                     486- 490 (A)
 DX14                     491- 495 (A)
 DX15                     496- 500 (A)
 DX16                     501- 505 (A)
 DX17                     506- 510 (A)
 DX18                     511- 515 (A)
 DX19                     516- 520 (A)
 DX20                     521- 525 (A)
 DXCCS1                   526- 529
 DXCCS2                   530- 533
 DXCCS3                   534- 537
 DXCCS4                   538- 541
 DXCCS5                   542- 545
 DXCCS6                   546- 549
 DXCCS7                   550- 553
 DXCCS8                   554- 557
 DXCCS9                   558- 561
 DXCCS10                  562- 565
 DXCCS11                  566- 569
 DXCCS12                  570- 573
 DXCCS13                  574- 577
 DXCCS14                  578- 581
 DXCCS15                  582- 585
 DXCCS16                  586- 589
 DXCCS17                  590- 593
 DXCCS18                  594- 597
 DXCCS19                  598- 601
 DXCCS20                  602- 605
 DX_Visit_Reason1         606- 610 (A)
 ECODE1                   611- 615 (A)
 ECODE2                   616- 620 (A)
 ECODE3                   621- 625 (A)
 ECODE4                   626- 630 (A)
 ECODE5                   631- 635 (A)
 ECODE6                   636- 640 (A)
 ECODE7                   641- 645 (A)
 ECODE8                   646- 650 (A)
 E_CCS1                   651- 654
 E_CCS2                   655- 658
 E_CCS3                   659- 662
 E_CCS4                   663- 666
 E_CCS5                   667- 670
 E_CCS6                   671- 674
 E_CCS7                   675- 678
 E_CCS8                   679- 682
 FEMALE                   683- 684
 HCUP_AS                  685- 686
 HCUP_ED                  687- 688
 HCUP_OS                  689- 690
 HOSPBRTH                 691- 693
 HOSPST                   694- 695 (A)
 KEY                      696- 709
 LOS                      710- 714
 LOS_X                    715- 720
 MEDINCSTQ                721- 722
 MRN_R                    723- 731
 NCHRONIC                 732- 734
 NCPT                     735- 737
 NDX                      738- 739
 NECODE                   740- 741
 NEOMAT                   742- 743
 NPR                      744- 745
 ORPROC                   746- 747
 PAY1                     748- 749
 PAY1_X                   750- 757 (A)
 PAY2                     758- 759
 PAY2_X                   760- 767 (A)
 PAY3_X                   768- 775 (A)
 PAYER1_X                 776- 791 (A)
 PAYER2_X                 792- 807 (A)
 PL_CBSA                  808- 810
 PL_MSA1993               811- 813
 PL_NCHS2006              814- 815
 PL_RUCA10_2005           816- 817
 PL_RUCA2005              818- 821
 PL_RUCA4_2005            822- 823
 PL_RUCC2003              824- 825
 PL_UIC2003               826- 827
 PL_UR_CAT4               828- 829
 PR1                      830- 833 (A)
 PR2                      834- 837 (A)
 PR3                      838- 841 (A)
 PR4                      842- 845 (A)
 PR5                      846- 849 (A)
 PR6                      850- 853 (A)
 PR7                      854- 857 (A)
 PR8                      858- 861 (A)
 PR9                      862- 865 (A)
 PR10                     866- 869 (A)
 PR11                     870- 873 (A)
 PR12                     874- 877 (A)
 PR13                     878- 881 (A)
 PR14                     882- 885 (A)
 PR15                     886- 889 (A)
 PR16                     890- 893 (A)
 PR17                     894- 897 (A)
 PR18                     898- 901 (A)
 PR19                     902- 905 (A)
 PR20                     906- 909 (A)
 PRCCS1                   910- 912
 PRCCS2                   913- 915
 PRCCS3                   916- 918
 PRCCS4                   919- 921
 PRCCS5                   922- 924
 PRCCS6                   925- 927
 PRCCS7                   928- 930
 PRCCS8                   931- 933
 PRCCS9                   934- 936
 PRCCS10                  937- 939
 PRCCS11                  940- 942
 PRCCS12                  943- 945
 PRCCS13                  946- 948
 PRCCS14                  949- 951
 PRCCS15                  952- 954
 PRCCS16                  955- 957
 PRCCS17                  958- 960
 PRCCS18                  961- 963
 PRCCS19                  964- 966
 PRCCS20                  967- 969
 PRDAY1                   970- 974
 PRDAY2                   975- 979
 PRDAY3                   980- 984
 PRDAY4                   985- 989
 PRDAY5                   990- 994
 PRDAY6                   995- 999
 PRDAY7                  1000-1004
 PRDAY8                  1005-1009
 PRDAY9                  1010-1014
 PRDAY10                 1015-1019
 PRDAY11                 1020-1024
 PRDAY12                 1025-1029
 PRDAY13                 1030-1034
 PRDAY14                 1035-1039
 PRDAY15                 1040-1044
 PRDAY16                 1045-1049
 PRDAY17                 1050-1054
 PRDAY18                 1055-1059
 PRDAY19                 1060-1064
 PRDAY20                 1065-1069
 PROCTYPE                1070-1072
 PSTATE                  1073-1074 (A)
 PSTCO                   1075-1079
 PSTCO2                  1080-1084
 PointOfOriginUB04       1085     (A)
 PointOfOrigin_X         1086-1093 (A)
 RACE                    1094-1095
 RACE_X                  1096-1103 (A)
 READMIT                 1104-1105
 STATE_AS                1106-1107
 STATE_ED                1108-1109
 STATE_OS                1110-1111
 TOTCHG                  1112-1121
 TOTCHG_X                1122-1136
 YEAR                    1137-1140
 ZIP3                    1141-1143 (A)
 ZIPINC_QRTL             1144-1146
 TOWN                    1147-1154 (A)
 ZIP                     1155-1159 (A)
 AYEAR                   1160-1163
 DMONTH                  1164-1165
 BMONTH                  1166-1167
 BYEAR                   1168-1171
 PRMONTH1                1172-1173
 PRMONTH2                1174-1175
 PRMONTH3                1176-1177
 PRMONTH4                1178-1179
 PRMONTH5                1180-1181
 PRMONTH6                1182-1183
 PRMONTH7                1184-1185
 PRMONTH8                1186-1187
 PRMONTH9                1188-1189
 PRMONTH10               1190-1191
 PRMONTH11               1192-1193
 PRMONTH12               1194-1195
 PRMONTH13               1196-1197
 PRMONTH14               1198-1199
 PRMONTH15               1200-1201
 PRMONTH16               1202-1203
 PRMONTH17               1204-1205
 PRMONTH18               1206-1207
 PRMONTH19               1208-1209
 PRMONTH20               1210-1211
 PRYEAR1                 1212-1215
 PRYEAR2                 1216-1219
 PRYEAR3                 1220-1223
 PRYEAR4                 1224-1227
 PRYEAR5                 1228-1231
 PRYEAR6                 1232-1235
 PRYEAR7                 1236-1239
 PRYEAR8                 1240-1243
 PRYEAR9                 1244-1247
 PRYEAR10                1248-1251
 PRYEAR11                1252-1255
 PRYEAR12                1256-1259
 PRYEAR13                1260-1263
 PRYEAR14                1264-1267
 PRYEAR15                1268-1271
 PRYEAR16                1272-1275
 PRYEAR17                1276-1279
 PRYEAR18                1280-1283
 PRYEAR19                1284-1287
 PRYEAR20                1288-1291.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEDAY                  (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 DXCCS10                 (F4.0) /
 DXCCS11                 (F4.0) /
 DXCCS12                 (F4.0) /
 DXCCS13                 (F4.0) /
 DXCCS14                 (F4.0) /
 DXCCS15                 (F4.0) /
 DXCCS16                 (F4.0) /
 DXCCS17                 (F4.0) /
 DXCCS18                 (F4.0) /
 DXCCS19                 (F4.0) /
 DXCCS20                 (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 E_CCS7                  (F3.0) /
 E_CCS8                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 MRN_R                   (F5.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_NCHS2006             (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_RUCC2003             (F3.0) /
 PL_UIC2003              (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PRCCS5                  (F3.0) /
 PRCCS6                  (F3.0) /
 PRCCS7                  (F3.0) /
 PRCCS8                  (F3.0) /
 PRCCS9                  (F3.0) /
 PRCCS10                 (F3.0) /
 PRCCS11                 (F3.0) /
 PRCCS12                 (F3.0) /
 PRCCS13                 (F3.0) /
 PRCCS14                 (F3.0) /
 PRCCS15                 (F3.0) /
 PRCCS16                 (F3.0) /
 PRCCS17                 (F3.0) /
 PRCCS18                 (F3.0) /
 PRCCS19                 (F3.0) /
 PRCCS20                 (F3.0) /
 PRDAY1                  (F4.0) /
 PRDAY2                  (F4.0) /
 PRDAY3                  (F4.0) /
 PRDAY4                  (F4.0) /
 PRDAY5                  (F4.0) /
 PRDAY6                  (F4.0) /
 PRDAY7                  (F4.0) /
 PRDAY8                  (F4.0) /
 PRDAY9                  (F4.0) /
 PRDAY10                 (F4.0) /
 PRDAY11                 (F4.0) /
 PRDAY12                 (F4.0) /
 PRDAY13                 (F4.0) /
 PRDAY14                 (F4.0) /
 PRDAY15                 (F4.0) /
 PRDAY16                 (F4.0) /
 PRDAY17                 (F4.0) /
 PRDAY18                 (F4.0) /
 PRDAY19                 (F4.0) /
 PRDAY20                 (F4.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 READMIT                 (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) /
 BMONTH                  (F3.0) /
 BYEAR                   (F3.0) /
 PRMONTH1                (F3.0) /
 PRMONTH2                (F3.0) /
 PRMONTH3                (F3.0) /
 PRMONTH4                (F3.0) /
 PRMONTH5                (F3.0) /
 PRMONTH6                (F3.0) /
 PRMONTH7                (F3.0) /
 PRMONTH8                (F3.0) /
 PRMONTH9                (F3.0) /
 PRMONTH10               (F3.0) /
 PRMONTH11               (F3.0) /
 PRMONTH12               (F3.0) /
 PRMONTH13               (F3.0) /
 PRMONTH14               (F3.0) /
 PRMONTH15               (F3.0) /
 PRMONTH16               (F3.0) /
 PRMONTH17               (F3.0) /
 PRMONTH18               (F3.0) /
 PRMONTH19               (F3.0) /
 PRMONTH20               (F3.0) /
 PRYEAR1                 (F3.0) /
 PRYEAR2                 (F3.0) /
 PRYEAR3                 (F3.0) /
 PRYEAR4                 (F3.0) /
 PRYEAR5                 (F3.0) /
 PRYEAR6                 (F3.0) /
 PRYEAR7                 (F3.0) /
 PRYEAR8                 (F3.0) /
 PRYEAR9                 (F3.0) /
 PRYEAR10                (F3.0) /
 PRYEAR11                (F3.0) /
 PRYEAR12                (F3.0) /
 PRYEAR13                (F3.0) /
 PRYEAR14                (F3.0) /
 PRYEAR15                (F3.0) /
 PRYEAR16                (F3.0) /
 PRYEAR17                (F3.0) /
 PRYEAR18                (F3.0) /
 PRYEAR19                (F3.0) /
 PRYEAR20                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEDAY                  "Age in days (when age < 1 year)"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 BILLTYPE                "UB-92 bill type"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTDAY1                 "Number of days from admission to CPT1"
 CPTDAY2                 "Number of days from admission to CPT2"
 CPTDAY3                 "Number of days from admission to CPT3"
 CPTDAY4                 "Number of days from admission to CPT4"
 CPTDAY5                 "Number of days from admission to CPT5"
 CPTDAY6                 "Number of days from admission to CPT6"
 CPTDAY7                 "Number of days from admission to CPT7"
 CPTDAY8                 "Number of days from admission to CPT8"
 CPTDAY9                 "Number of days from admission to CPT9"
 CPTDAY10                "Number of days from admission to CPT10"
 CPTDAY11                "Number of days from admission to CPT11"
 CPTDAY12                "Number of days from admission to CPT12"
 CPTDAY13                "Number of days from admission to CPT13"
 CPTDAY14                "Number of days from admission to CPT14"
 CPTDAY15                "Number of days from admission to CPT15"
 CPTDAY16                "Number of days from admission to CPT16"
 CPTDAY17                "Number of days from admission to CPT17"
 CPTDAY18                "Number of days from admission to CPT18"
 CPTDAY19                "Number of days from admission to CPT19"
 CPTDAY20                "Number of days from admission to CPT20"
 CPTDAY21                "Number of days from admission to CPT21"
 CPTDAY22                "Number of days from admission to CPT22"
 CPTDAY23                "Number of days from admission to CPT23"
 CPTDAY24                "Number of days from admission to CPT24"
 CPTDAY25                "Number of days from admission to CPT25"
 CPTM1_1                 "First CPT-4/HCPCS modifier 1"
 CPTM1_2                 "First CPT-4/HCPCS modifier 2"
 CPTM1_3                 "First CPT-4/HCPCS modifier 3"
 CPTM1_4                 "First CPT-4/HCPCS modifier 4"
 CPTM1_5                 "First CPT-4/HCPCS modifier 5"
 CPTM1_6                 "First CPT-4/HCPCS modifier 6"
 CPTM1_7                 "First CPT-4/HCPCS modifier 7"
 CPTM1_8                 "First CPT-4/HCPCS modifier 8"
 CPTM1_9                 "First CPT-4/HCPCS modifier 9"
 CPTM1_10                "First CPT-4/HCPCS modifier 10"
 CPTM1_11                "First CPT-4/HCPCS modifier 11"
 CPTM1_12                "First CPT-4/HCPCS modifier 12"
 CPTM1_13                "First CPT-4/HCPCS modifier 13"
 CPTM1_14                "First CPT-4/HCPCS modifier 14"
 CPTM1_15                "First CPT-4/HCPCS modifier 15"
 CPTM1_16                "First CPT-4/HCPCS modifier 16"
 CPTM1_17                "First CPT-4/HCPCS modifier 17"
 CPTM1_18                "First CPT-4/HCPCS modifier 18"
 CPTM1_19                "First CPT-4/HCPCS modifier 19"
 CPTM1_20                "First CPT-4/HCPCS modifier 20"
 CPTM1_21                "First CPT-4/HCPCS modifier 21"
 CPTM1_22                "First CPT-4/HCPCS modifier 22"
 CPTM1_23                "First CPT-4/HCPCS modifier 23"
 CPTM1_24                "First CPT-4/HCPCS modifier 24"
 CPTM1_25                "First CPT-4/HCPCS modifier 25"
 CPTM2_1                 "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                 "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                 "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                 "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                 "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                 "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                 "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                 "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                 "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                "Second CPT-4/HCPCS modifier 25"
 DIED                    "Died during hospitalization"
 DISPUB04                "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DX7                     "Diagnosis 7"
 DX8                     "Diagnosis 8"
 DX9                     "Diagnosis 9"
 DX10                    "Diagnosis 10"
 DX11                    "Diagnosis 11"
 DX12                    "Diagnosis 12"
 DX13                    "Diagnosis 13"
 DX14                    "Diagnosis 14"
 DX15                    "Diagnosis 15"
 DX16                    "Diagnosis 16"
 DX17                    "Diagnosis 17"
 DX18                    "Diagnosis 18"
 DX19                    "Diagnosis 19"
 DX20                    "Diagnosis 20"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXCCS7                  "CCS: diagnosis 7"
 DXCCS8                  "CCS: diagnosis 8"
 DXCCS9                  "CCS: diagnosis 9"
 DXCCS10                 "CCS: diagnosis 10"
 DXCCS11                 "CCS: diagnosis 11"
 DXCCS12                 "CCS: diagnosis 12"
 DXCCS13                 "CCS: diagnosis 13"
 DXCCS14                 "CCS: diagnosis 14"
 DXCCS15                 "CCS: diagnosis 15"
 DXCCS16                 "CCS: diagnosis 16"
 DXCCS17                 "CCS: diagnosis 17"
 DXCCS18                 "CCS: diagnosis 18"
 DXCCS19                 "CCS: diagnosis 19"
 DXCCS20                 "CCS: diagnosis 20"
 DX_Visit_Reason1        "Reason for visit diagnosis 1"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 ECODE7                  "E code 7"
 ECODE8                  "E code 8"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_CCS7                  "CCS: E Code 7"
 E_CCS8                  "CCS: E Code 8"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 MRN_R                   "Medical record number (re-identified)"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PAY3_X                  "Tertiary expected payer (as received from source)"
 PAYER1_X                "Primary expected payer plan identifier (as received from source)"
 PAYER2_X
"Secondary expected payer plan identifier (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2006             "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_RUCC2003             "Patient location: Rural-Urban Continuum Codes(RUCC), 2003"
 PL_UIC2003              "Patient location: Urban Influence Codes, 2003"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PR5                     "Procedure 5"
 PR6                     "Procedure 6"
 PR7                     "Procedure 7"
 PR8                     "Procedure 8"
 PR9                     "Procedure 9"
 PR10                    "Procedure 10"
 PR11                    "Procedure 11"
 PR12                    "Procedure 12"
 PR13                    "Procedure 13"
 PR14                    "Procedure 14"
 PR15                    "Procedure 15"
 PR16                    "Procedure 16"
 PR17                    "Procedure 17"
 PR18                    "Procedure 18"
 PR19                    "Procedure 19"
 PR20                    "Procedure 20"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PRCCS5                  "CCS: procedure 5"
 PRCCS6                  "CCS: procedure 6"
 PRCCS7                  "CCS: procedure 7"
 PRCCS8                  "CCS: procedure 8"
 PRCCS9                  "CCS: procedure 9"
 PRCCS10                 "CCS: procedure 10"
 PRCCS11                 "CCS: procedure 11"
 PRCCS12                 "CCS: procedure 12"
 PRCCS13                 "CCS: procedure 13"
 PRCCS14                 "CCS: procedure 14"
 PRCCS15                 "CCS: procedure 15"
 PRCCS16                 "CCS: procedure 16"
 PRCCS17                 "CCS: procedure 17"
 PRCCS18                 "CCS: procedure 18"
 PRCCS19                 "CCS: procedure 19"
 PRCCS20                 "CCS: procedure 20"
 PRDAY1                  "Number of days from admission to PR1"
 PRDAY2                  "Number of days from admission to PR2"
 PRDAY3                  "Number of days from admission to PR3"
 PRDAY4                  "Number of days from admission to PR4"
 PRDAY5                  "Number of days from admission to PR5"
 PRDAY6                  "Number of days from admission to PR6"
 PRDAY7                  "Number of days from admission to PR7"
 PRDAY8                  "Number of days from admission to PR8"
 PRDAY9                  "Number of days from admission to PR9"
 PRDAY10                 "Number of days from admission to PR10"
 PRDAY11                 "Number of days from admission to PR11"
 PRDAY12                 "Number of days from admission to PR12"
 PRDAY13                 "Number of days from admission to PR13"
 PRDAY14                 "Number of days from admission to PR14"
 PRDAY15                 "Number of days from admission to PR15"
 PRDAY16                 "Number of days from admission to PR16"
 PRDAY17                 "Number of days from admission to PR17"
 PRDAY18                 "Number of days from admission to PR18"
 PRDAY19                 "Number of days from admission to PR19"
 PRDAY20                 "Number of days from admission to PR20"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO                   "Patient state/county FIPS code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04       "Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X         "Point of origin for admission or visit, as received from source"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 READMIT                 "Readmission"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 TOWN                    "Patient town of residence (as received from source)"
 ZIP                     "Patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month"
 BMONTH                  "Birth month"
 BYEAR                   "Birth year"
 PRMONTH1                "Month of procedure 1"
 PRMONTH2                "Month of procedure 2"
 PRMONTH3                "Month of procedure 3"
 PRMONTH4                "Month of procedure 4"
 PRMONTH5                "Month of procedure 5"
 PRMONTH6                "Month of procedure 6"
 PRMONTH7                "Month of procedure 7"
 PRMONTH8                "Month of procedure 8"
 PRMONTH9                "Month of procedure 9"
 PRMONTH10               "Month of procedure 10"
 PRMONTH11               "Month of procedure 11"
 PRMONTH12               "Month of procedure 12"
 PRMONTH13               "Month of procedure 13"
 PRMONTH14               "Month of procedure 14"
 PRMONTH15               "Month of procedure 15"
 PRMONTH16               "Month of procedure 16"
 PRMONTH17               "Month of procedure 17"
 PRMONTH18               "Month of procedure 18"
 PRMONTH19               "Month of procedure 19"
 PRMONTH20               "Month of procedure 20"
 PRYEAR1                 "Year of procedure 1"
 PRYEAR2                 "Year of procedure 2"
 PRYEAR3                 "Year of procedure 3"
 PRYEAR4                 "Year of procedure 4"
 PRYEAR5                 "Year of procedure 5"
 PRYEAR6                 "Year of procedure 6"
 PRYEAR7                 "Year of procedure 7"
 PRYEAR8                 "Year of procedure 8"
 PRYEAR9                 "Year of procedure 9"
 PRYEAR10                "Year of procedure 10"
 PRYEAR11                "Year of procedure 11"
 PRYEAR12                "Year of procedure 12"
 PRYEAR13                "Year of procedure 13"
 PRYEAR14                "Year of procedure 14"
 PRYEAR15                "Year of procedure 15"
 PRYEAR16                "Year of procedure 16"
 PRYEAR17                "Year of procedure 17"
 PRYEAR18                "Year of procedure 18"
 PRYEAR19                "Year of procedure 19"
 PRYEAR20                "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2006
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC2003
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'VT_SEDD_2009_CORE.SAV' /COMPRESSED.
