/*******************************************************************
*   NJ_SEDD_2007_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY DX_PR_GRPS FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'NJ_SEDD_2007_DX_PR_GRPS.ASC' FIXED / 
 CHRON1                     1-   2
 CHRON2                     3-   4
 CHRON3                     5-   6
 CHRON4                     7-   8
 CHRON5                     9-  10
 CHRON6                    11-  12
 CHRON7                    13-  14
 CHRON8                    15-  16
 CHRON9                    17-  18
 CHRONB1                   19-  20
 CHRONB2                   21-  22
 CHRONB3                   23-  24
 CHRONB4                   25-  26
 CHRONB5                   27-  28
 CHRONB6                   29-  30
 CHRONB7                   31-  32
 CHRONB8                   33-  34
 CHRONB9                   35-  36
 DXMCCS1                   37-  47 (A)
 DXMCCS2                   48-  58 (A)
 DXMCCS3                   59-  69 (A)
 DXMCCS4                   70-  80 (A)
 DXMCCS5                   81-  91 (A)
 DXMCCS6                   92- 102 (A)
 DXMCCS7                  103- 113 (A)
 DXMCCS8                  114- 124 (A)
 DXMCCS9                  125- 135 (A)
 E_MCCS1                  136- 146 (A)
 E_MCCS2                  147- 157 (A)
 E_MCCS3                  158- 168 (A)
 E_MCCS4                  169- 179 (A)
 E_MCCS5                  180- 190 (A)
 E_MCCS6                  191- 201 (A)
 E_MCCS7                  202- 212 (A)
 KEY                      213- 226
 PCLASS1                  227- 228
 PCLASS2                  229- 230
 PCLASS3                  231- 232
 PCLASS4                  233- 234
 PCLASS5                  235- 236
 PCLASS6                  237- 238
 PCLASS7                  239- 240
 PCLASS8                  241- 242
 PRMCCS1                  243- 250 (A)
 PRMCCS2                  251- 258 (A)
 PRMCCS3                  259- 266 (A)
 PRMCCS4                  267- 274 (A)
 PRMCCS5                  275- 282 (A)
 PRMCCS6                  283- 290 (A)
 PRMCCS7                  291- 298 (A)
 PRMCCS8                  299- 306 (A)
 U_BLOOD                  307- 308
 U_CATH                   309- 310
 U_CCU                    311- 312
 U_CHESTX                 313- 314
 U_CTSCAN                 315- 316
 U_DIALYS                 317- 318
 U_ECHO                   319- 320
 U_ED                     321- 322
 U_EEG                    323- 324
 U_EKG                    325- 326
 U_EPO                    327- 328
 U_ICU                    329- 330
 U_LITHOT                 331- 332
 U_MHSA                   333- 334
 U_MRT                    335- 336
 U_NEWBN2                 337- 338
 U_NEWBN3                 339- 340
 U_NEWBN4                 341- 342
 U_NUCMED                 343- 344
 U_OBSERV                 345- 346
 U_OCCTHE                 347- 348
 U_ORGANA                 349- 350
 U_OTHIMP                 351- 352
 U_PACEMA                 353- 354
 U_PHYTHE                 355- 356
 U_RADTHE                 357- 358
 U_RESPTH                 359- 360
 U_SPEECH                 361- 362
 U_STRESS                 363- 364
 U_ULTRAS                 365- 366.


***  Specify write formats  ***.
FORMATS
 CHRON1                  (F3.0) /
 CHRON2                  (F3.0) /
 CHRON3                  (F3.0) /
 CHRON4                  (F3.0) /
 CHRON5                  (F3.0) /
 CHRON6                  (F3.0) /
 CHRON7                  (F3.0) /
 CHRON8                  (F3.0) /
 CHRON9                  (F3.0) /
 CHRONB1                 (F3.0) /
 CHRONB2                 (F3.0) /
 CHRONB3                 (F3.0) /
 CHRONB4                 (F3.0) /
 CHRONB5                 (F3.0) /
 CHRONB6                 (F3.0) /
 CHRONB7                 (F3.0) /
 CHRONB8                 (F3.0) /
 CHRONB9                 (F3.0) /
 KEY                     (F8.0) /
 PCLASS1                 (F3.0) /
 PCLASS2                 (F3.0) /
 PCLASS3                 (F3.0) /
 PCLASS4                 (F3.0) /
 PCLASS5                 (F3.0) /
 PCLASS6                 (F3.0) /
 PCLASS7                 (F3.0) /
 PCLASS8                 (F3.0) /
 U_BLOOD                 (F3.0) /
 U_CATH                  (F3.0) /
 U_CCU                   (F3.0) /
 U_CHESTX                (F3.0) /
 U_CTSCAN                (F3.0) /
 U_DIALYS                (F3.0) /
 U_ECHO                  (F3.0) /
 U_ED                    (F3.0) /
 U_EEG                   (F3.0) /
 U_EKG                   (F3.0) /
 U_EPO                   (F3.0) /
 U_ICU                   (F3.0) /
 U_LITHOT                (F3.0) /
 U_MHSA                  (F3.0) /
 U_MRT                   (F3.0) /
 U_NEWBN2                (F3.0) /
 U_NEWBN3                (F3.0) /
 U_NEWBN4                (F3.0) /
 U_NUCMED                (F3.0) /
 U_OBSERV                (F3.0) /
 U_OCCTHE                (F3.0) /
 U_ORGANA                (F3.0) /
 U_OTHIMP                (F3.0) /
 U_PACEMA                (F3.0) /
 U_PHYTHE                (F3.0) /
 U_RADTHE                (F3.0) /
 U_RESPTH                (F3.0) /
 U_SPEECH                (F3.0) /
 U_STRESS                (F3.0) /
 U_ULTRAS                (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CHRON1    "Chronic condition indicator 1"
 CHRON2    "Chronic condition indicator 2"
 CHRON3    "Chronic condition indicator 3"
 CHRON4    "Chronic condition indicator 4"
 CHRON5    "Chronic condition indicator 5"
 CHRON6    "Chronic condition indicator 6"
 CHRON7    "Chronic condition indicator 7"
 CHRON8    "Chronic condition indicator 8"
 CHRON9    "Chronic condition indicator 9"
 CHRONB1   "Chronic condition body system 1"
 CHRONB2   "Chronic condition body system 2"
 CHRONB3   "Chronic condition body system 3"
 CHRONB4   "Chronic condition body system 4"
 CHRONB5   "Chronic condition body system 5"
 CHRONB6   "Chronic condition body system 6"
 CHRONB7   "Chronic condition body system 7"
 CHRONB8   "Chronic condition body system 8"
 CHRONB9   "Chronic condition body system 9"
 DXMCCS1   "Multi-Level CCS:  Diagnosis 1"
 DXMCCS2   "Multi-Level CCS:  Diagnosis 2"
 DXMCCS3   "Multi-Level CCS:  Diagnosis 3"
 DXMCCS4   "Multi-Level CCS:  Diagnosis 4"
 DXMCCS5   "Multi-Level CCS:  Diagnosis 5"
 DXMCCS6   "Multi-Level CCS:  Diagnosis 6"
 DXMCCS7   "Multi-Level CCS:  Diagnosis 7"
 DXMCCS8   "Multi-Level CCS:  Diagnosis 8"
 DXMCCS9   "Multi-Level CCS:  Diagnosis 9"
 E_MCCS1   "Multi-Level CCS:  E Code 1"
 E_MCCS2   "Multi-Level CCS:  E Code 2"
 E_MCCS3   "Multi-Level CCS:  E Code 3"
 E_MCCS4   "Multi-Level CCS:  E Code 4"
 E_MCCS5   "Multi-Level CCS:  E Code 5"
 E_MCCS6   "Multi-Level CCS:  E Code 6"
 E_MCCS7   "Multi-Level CCS:  E Code 7"
 KEY       "HCUP record identifier"
 PCLASS1   "Procedure class 1"
 PCLASS2   "Procedure class 2"
 PCLASS3   "Procedure class 3"
 PCLASS4   "Procedure class 4"
 PCLASS5   "Procedure class 5"
 PCLASS6   "Procedure class 6"
 PCLASS7   "Procedure class 7"
 PCLASS8   "Procedure class 8"
 PRMCCS1   "Multi-Level CCS:  Procedure 1"
 PRMCCS2   "Multi-Level CCS:  Procedure 2"
 PRMCCS3   "Multi-Level CCS:  Procedure 3"
 PRMCCS4   "Multi-Level CCS:  Procedure 4"
 PRMCCS5   "Multi-Level CCS:  Procedure 5"
 PRMCCS6   "Multi-Level CCS:  Procedure 6"
 PRMCCS7   "Multi-Level CCS:  Procedure 7"
 PRMCCS8   "Multi-Level CCS:  Procedure 8"
 U_BLOOD   "Utilization Flag: Blood"
 U_CATH    "Utilization Flag: Cardiac Catheterization Lab"
 U_CCU     "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTX  "Utilization Flag: Chest X-Ray"
 U_CTSCAN  "Utilization Flag: Computed Tomography Scan"
 U_DIALYS  "Utilization Flag: Renal Dialysis"
 U_ECHO    "Utilization Flag: Echocardiology"
 U_ED      "Utilization Flag: Emergency Room"
 U_EEG     "Utilization Flag: Electroencephalogram"
 U_EKG     "Utilization Flag: Electrocardiogram"
 U_EPO     "Utilization Flag: EPO"
 U_ICU     "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOT  "Utilization Flag: Lithotripsy"
 U_MHSA    "Utilization Flag: Mental Health and Substance Abuse"
 U_MRT     "Utilization Flag: Medical Resonance Technology"
 U_NEWBN2  "Utilization Flag: Nursery Level II"
 U_NEWBN3  "Utilization Flag: Nursery Level III"
 U_NEWBN4  "Utilization Flag: Nursery Level IV"
 U_NUCMED  "Utilization Flag: Nuclear Medicine"
 U_OBSERV  "Utilization Flag: Observation Room"
 U_OCCTHE  "Utilization Flag: Occupational Therapy"
 U_ORGANA  "Utilization Flag: Organ Acquisition"
 U_OTHIMP  "Utilization Flag: Other Implants"
 U_PACEMA  "Utilization Flag: Pacemaker"
 U_PHYTHE  "Utilization Flag: Physical Therapy"
 U_RADTHE  "Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 U_RESPTH  "Utilization Flag: Respiratory Services"
 U_SPEECH  "Utilization Flag: Speech - Language Pathology"
 U_STRESS  "Utilization Flag: Cardiac Stress Test"
 U_ULTRAS  "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB1
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB2
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB3
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB4
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB5
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB6
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB7
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB8
 (-9,-8,-6,-5=SYSMIS).
RECODE CHRONB9
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTX
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERV
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMP
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PACEMA
 (-9,-8,-6,-5=SYSMIS).
RECODE U_PHYTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RADTHE
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECH
 (-9,-8,-6,-5=SYSMIS).
RECODE U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRAS
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'NJ_SEDD_2007_DX_PR_GRPS.SAV' /COMPRESSED.
