/*******************************************************************
*   MA_SEDD_2010_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MA_SEDD_2010_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEMONTH                   4-   6
 AHOUR                      7-  10
 AMONTH                    11-  12
 ASOURCE                   13-  14
 ASOURCE_X                 15     (A)
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 CPT1                      20-  24 (A)
 CPT2                      25-  29 (A)
 CPT3                      30-  34 (A)
 CPT4                      35-  39 (A)
 CPT5                      40-  44 (A)
 CPT6                      45-  49 (A)
 CPT7                      50-  54 (A)
 CPT8                      55-  59 (A)
 CPT9                      60-  64 (A)
 CPT10                     65-  69 (A)
 CPT11                     70-  74 (A)
 CPT12                     75-  79 (A)
 CPT13                     80-  84 (A)
 CPT14                     85-  89 (A)
 CPT15                     90-  94 (A)
 CPT16                     95-  99 (A)
 CPT17                    100- 104 (A)
 CPT18                    105- 109 (A)
 CPT19                    110- 114 (A)
 CPT20                    115- 119 (A)
 CPT21                    120- 124 (A)
 CPT22                    125- 129 (A)
 CPT23                    130- 134 (A)
 CPT24                    135- 139 (A)
 CPT25                    140- 144 (A)
 CPT26                    145- 149 (A)
 CPT27                    150- 154 (A)
 CPT28                    155- 159 (A)
 CPT29                    160- 164 (A)
 CPT30                    165- 169 (A)
 CPT31                    170- 174 (A)
 CPT32                    175- 179 (A)
 CPT33                    180- 184 (A)
 CPT34                    185- 189 (A)
 CPTCCS1                  190- 192
 CPTCCS2                  193- 195
 CPTCCS3                  196- 198
 CPTCCS4                  199- 201
 CPTCCS5                  202- 204
 CPTCCS6                  205- 207
 CPTCCS7                  208- 210
 CPTCCS8                  211- 213
 CPTCCS9                  214- 216
 CPTCCS10                 217- 219
 CPTCCS11                 220- 222
 CPTCCS12                 223- 225
 CPTCCS13                 226- 228
 CPTCCS14                 229- 231
 CPTCCS15                 232- 234
 CPTCCS16                 235- 237
 CPTCCS17                 238- 240
 CPTCCS18                 241- 243
 CPTCCS19                 244- 246
 CPTCCS20                 247- 249
 CPTCCS21                 250- 252
 CPTCCS22                 253- 255
 CPTCCS23                 256- 258
 CPTCCS24                 259- 261
 CPTCCS25                 262- 264
 CPTCCS26                 265- 267
 CPTCCS27                 268- 270
 CPTCCS28                 271- 273
 CPTCCS29                 274- 276
 CPTCCS30                 277- 279
 CPTCCS31                 280- 282
 CPTCCS32                 283- 285
 CPTCCS33                 286- 288
 CPTCCS34                 289- 291
 DHOUR                    292- 295
 DIED                     296- 297
 DISPUNIFORM              298- 299
 DISP_X                   300     (A)
 DQTR                     301- 302
 DSHOSPID                 303- 319 (A)
 DX1                      320- 324 (A)
 DX2                      325- 329 (A)
 DX3                      330- 334 (A)
 DX4                      335- 339 (A)
 DX5                      340- 344 (A)
 DX6                      345- 349 (A)
 DXCCS1                   350- 353
 DXCCS2                   354- 357
 DXCCS3                   358- 361
 DXCCS4                   362- 365
 DXCCS5                   366- 369
 DXCCS6                   370- 373
 DXPOA1                   374     (A)
 DXPOA2                   375     (A)
 DXPOA3                   376     (A)
 DXPOA4                   377     (A)
 DXPOA5                   378     (A)
 DXPOA6                   379     (A)
 DaysBetweenVisits        380- 383
 DaysToEvent              384- 389
 ECODE1                   390- 394 (A)
 ECODE2                   395- 399 (A)
 ECODE3                   400- 404 (A)
 ECODE4                   405- 409 (A)
 ECODE5                   410- 414 (A)
 ECODE6                   415- 419 (A)
 E_CCS1                   420- 423
 E_CCS2                   424- 427
 E_CCS3                   428- 431
 E_CCS4                   432- 435
 E_CCS5                   436- 439
 E_CCS6                   440- 443
 E_POA1                   444     (A)
 E_POA2                   445     (A)
 E_POA3                   446     (A)
 E_POA4                   447     (A)
 E_POA5                   448     (A)
 E_POA6                   449     (A)
 FEMALE                   450- 451
 HCUP_AS                  452- 453
 HCUP_ED                  454- 455
 HCUP_OS                  456- 457
 HISPANIC_X               458- 472 (A)
 HOSPBRTH                 473- 475
 HOSPST                   476- 477 (A)
 Homeless                 478- 479
 KEY                      480- 497
 LOS                      498- 502
 LOS_X                    503- 508
 MEDINCSTQ                509- 510
 NCHRONIC                 511- 513
 NCPT                     514- 516
 NDX                      517- 518
 NECODE                   519- 520
 NEOMAT                   521- 522
 NPR                      523- 524
 ORPROC                   525- 526
 PAY1                     527- 528
 PAY1_X                   529- 533 (A)
 PAY2                     534- 535
 PAY2_X                   536- 540 (A)
 PL_CBSA                  541- 543
 PL_MSA1993               544- 546
 PL_RUCA10_2005           547- 548
 PL_RUCA2005              549- 552
 PL_RUCA4_2005            553- 554
 PL_UR_CAT4               555- 556
 PR1                      557- 560 (A)
 PR2                      561- 564 (A)
 PR3                      565- 568 (A)
 PR4                      569- 572 (A)
 PRCCS1                   573- 575
 PRCCS2                   576- 578
 PRCCS3                   579- 581
 PRCCS4                   582- 584
 PROCTYPE                 585- 587
 PSTATE                   588- 589 (A)
 PSTCO2                   590- 594
 RACE                     595- 596
 RACE_X                   597- 601 (A)
 STATE_AS                 602- 603
 STATE_ED                 604- 605
 STATE_OS                 606- 607
 TOTCHG                   608- 617
 TOTCHG_X                 618- 632
 TransportToHosp          633- 634
 VisitLink                635- 643
 YEAR                     644- 647
 ZIP3                     648- 650 (A)
 ZIPINC_QRTL              651- 653
 AYEAR                    654- 657
 DMONTH                   658- 659.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 CPTCCS1                 (F4.0) /
 CPTCCS2                 (F4.0) /
 CPTCCS3                 (F4.0) /
 CPTCCS4                 (F4.0) /
 CPTCCS5                 (F4.0) /
 CPTCCS6                 (F4.0) /
 CPTCCS7                 (F4.0) /
 CPTCCS8                 (F4.0) /
 CPTCCS9                 (F4.0) /
 CPTCCS10                (F4.0) /
 CPTCCS11                (F4.0) /
 CPTCCS12                (F4.0) /
 CPTCCS13                (F4.0) /
 CPTCCS14                (F4.0) /
 CPTCCS15                (F4.0) /
 CPTCCS16                (F4.0) /
 CPTCCS17                (F4.0) /
 CPTCCS18                (F4.0) /
 CPTCCS19                (F4.0) /
 CPTCCS20                (F4.0) /
 CPTCCS21                (F4.0) /
 CPTCCS22                (F4.0) /
 CPTCCS23                (F4.0) /
 CPTCCS24                (F4.0) /
 CPTCCS25                (F4.0) /
 CPTCCS26                (F4.0) /
 CPTCCS27                (F4.0) /
 CPTCCS28                (F4.0) /
 CPTCCS29                (F4.0) /
 CPTCCS30                (F4.0) /
 CPTCCS31                (F4.0) /
 CPTCCS32                (F4.0) /
 CPTCCS33                (F4.0) /
 CPTCCS34                (F4.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUNIFORM             (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DaysBetweenVisits       (F3.0) /
 DaysToEvent             (F8.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 E_CCS6                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCSTQ               (F3.0) /
 NCHRONIC                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 ORPROC                  (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA1993              (F3.0) /
 PL_RUCA10_2005          (F3.0) /
 PL_RUCA2005             (F4.1) /
 PL_RUCA4_2005           (F3.0) /
 PL_UR_CAT4              (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 TransportToHosp         (F3.0) /
 VisitLink               (F8.0) /
 YEAR                    (F3.0) /
 ZIPINC_QRTL             (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                     "Age in years at admission"
 AGEMONTH                "Age in months (when age < 11 years)"
 AHOUR                   "Admission Hour"
 AMONTH                  "Admission month"
 ASOURCE                 "Admission source (uniform)"
 ASOURCE_X               "Admission source (as received from source)"
 ATYPE                   "Admission type"
 AWEEKEND                "Admission day is a weekend"
 CPT1                    "CPT/HCPCS procedure code 1"
 CPT2                    "CPT/HCPCS procedure code 2"
 CPT3                    "CPT/HCPCS procedure code 3"
 CPT4                    "CPT/HCPCS procedure code 4"
 CPT5                    "CPT/HCPCS procedure code 5"
 CPT6                    "CPT/HCPCS procedure code 6"
 CPT7                    "CPT/HCPCS procedure code 7"
 CPT8                    "CPT/HCPCS procedure code 8"
 CPT9                    "CPT/HCPCS procedure code 9"
 CPT10                   "CPT/HCPCS procedure code 10"
 CPT11                   "CPT/HCPCS procedure code 11"
 CPT12                   "CPT/HCPCS procedure code 12"
 CPT13                   "CPT/HCPCS procedure code 13"
 CPT14                   "CPT/HCPCS procedure code 14"
 CPT15                   "CPT/HCPCS procedure code 15"
 CPT16                   "CPT/HCPCS procedure code 16"
 CPT17                   "CPT/HCPCS procedure code 17"
 CPT18                   "CPT/HCPCS procedure code 18"
 CPT19                   "CPT/HCPCS procedure code 19"
 CPT20                   "CPT/HCPCS procedure code 20"
 CPT21                   "CPT/HCPCS procedure code 21"
 CPT22                   "CPT/HCPCS procedure code 22"
 CPT23                   "CPT/HCPCS procedure code 23"
 CPT24                   "CPT/HCPCS procedure code 24"
 CPT25                   "CPT/HCPCS procedure code 25"
 CPT26                   "CPT/HCPCS procedure code 26"
 CPT27                   "CPT/HCPCS procedure code 27"
 CPT28                   "CPT/HCPCS procedure code 28"
 CPT29                   "CPT/HCPCS procedure code 29"
 CPT30                   "CPT/HCPCS procedure code 30"
 CPT31                   "CPT/HCPCS procedure code 31"
 CPT32                   "CPT/HCPCS procedure code 32"
 CPT33                   "CPT/HCPCS procedure code 33"
 CPT34                   "CPT/HCPCS procedure code 34"
 CPTCCS1                 "CCS: CPT 1"
 CPTCCS2                 "CCS: CPT 2"
 CPTCCS3                 "CCS: CPT 3"
 CPTCCS4                 "CCS: CPT 4"
 CPTCCS5                 "CCS: CPT 5"
 CPTCCS6                 "CCS: CPT 6"
 CPTCCS7                 "CCS: CPT 7"
 CPTCCS8                 "CCS: CPT 8"
 CPTCCS9                 "CCS: CPT 9"
 CPTCCS10                "CCS: CPT 10"
 CPTCCS11                "CCS: CPT 11"
 CPTCCS12                "CCS: CPT 12"
 CPTCCS13                "CCS: CPT 13"
 CPTCCS14                "CCS: CPT 14"
 CPTCCS15                "CCS: CPT 15"
 CPTCCS16                "CCS: CPT 16"
 CPTCCS17                "CCS: CPT 17"
 CPTCCS18                "CCS: CPT 18"
 CPTCCS19                "CCS: CPT 19"
 CPTCCS20                "CCS: CPT 20"
 CPTCCS21                "CCS: CPT 21"
 CPTCCS22                "CCS: CPT 22"
 CPTCCS23                "CCS: CPT 23"
 CPTCCS24                "CCS: CPT 24"
 CPTCCS25                "CCS: CPT 25"
 CPTCCS26                "CCS: CPT 26"
 CPTCCS27                "CCS: CPT 27"
 CPTCCS28                "CCS: CPT 28"
 CPTCCS29                "CCS: CPT 29"
 CPTCCS30                "CCS: CPT 30"
 CPTCCS31                "CCS: CPT 31"
 CPTCCS32                "CCS: CPT 32"
 CPTCCS33                "CCS: CPT 33"
 CPTCCS34                "CCS: CPT 34"
 DHOUR                   "Discharge Hour"
 DIED                    "Died during hospitalization"
 DISPUNIFORM             "Disposition of patient (uniform)"
 DISP_X                  "Disposition of patient (as received from source)"
 DQTR                    "Discharge quarter"
 DSHOSPID                "Data source hospital identifier"
 DX1                     "Diagnosis 1"
 DX2                     "Diagnosis 2"
 DX3                     "Diagnosis 3"
 DX4                     "Diagnosis 4"
 DX5                     "Diagnosis 5"
 DX6                     "Diagnosis 6"
 DXCCS1                  "CCS: diagnosis 1"
 DXCCS2                  "CCS: diagnosis 2"
 DXCCS3                  "CCS: diagnosis 3"
 DXCCS4                  "CCS: diagnosis 4"
 DXCCS5                  "CCS: diagnosis 5"
 DXCCS6                  "CCS: diagnosis 6"
 DXPOA1                  "Diagnosis 1, present on admission indicator"
 DXPOA2                  "Diagnosis 2, present on admission indicator"
 DXPOA3                  "Diagnosis 3, present on admission indicator"
 DXPOA4                  "Diagnosis 4, present on admission indicator"
 DXPOA5                  "Diagnosis 5, present on admission indicator"
 DXPOA6                  "Diagnosis 6, present on admission indicator"
 DaysBetweenVisits       "Number of days between visits"
 DaysToEvent             "Days from 'start date' to admission"
 ECODE1                  "E code 1"
 ECODE2                  "E code 2"
 ECODE3                  "E code 3"
 ECODE4                  "E code 4"
 ECODE5                  "E code 5"
 ECODE6                  "E code 6"
 E_CCS1                  "CCS: E Code 1"
 E_CCS2                  "CCS: E Code 2"
 E_CCS3                  "CCS: E Code 3"
 E_CCS4                  "CCS: E Code 4"
 E_CCS5                  "CCS: E Code 5"
 E_CCS6                  "CCS: E Code 6"
 E_POA1                  "E Code 1, present on admission indicator"
 E_POA2                  "E Code 2, present on admission indicator"
 E_POA3                  "E Code 3, present on admission indicator"
 E_POA4                  "E Code 4, present on admission indicator"
 E_POA5                  "E Code 5, present on admission indicator"
 E_POA6                  "E Code 6, present on admission indicator"
 FEMALE                  "Indicator of sex"
 HCUP_AS                 "HCUP Ambulatory Surgery service indicator"
 HCUP_ED                 "HCUP Emergency Department service indicator"
 HCUP_OS                 "HCUP Observation Stay service indicator"
 HISPANIC_X              "Hispanic ethnicity (as received from source)"
 HOSPBRTH                "Indicator of birth in this hospital"
 HOSPST                  "Hospital state postal code"
 Homeless                "Indicator that patient is homeless"
 KEY                     "HCUP record identifier"
 LOS                     "Length of stay (cleaned)"
 LOS_X                   "Length of stay (as received from source)"
 MEDINCSTQ               "Median household income state quartile for patient ZIP Code"
 NCHRONIC                "Number of chronic conditions"
 NCPT                    "Number of CPT/HCPCS procedures on this record"
 NDX                     "Number of diagnoses on this record"
 NECODE                  "Number of E codes on this record"
 NEOMAT                  "Neonatal and/or maternal DX and/or PR"
 NPR                     "Number of procedures on this record"
 ORPROC                  "Major operating room procedure indicator"
 PAY1                    "Primary expected payer (uniform)"
 PAY1_X                  "Primary expected payer (as received from source)"
 PAY2                    "Secondary expected payer (uniform)"
 PAY2_X                  "Secondary expected payer (as received from source)"
 PL_CBSA                 "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA1993              "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA10_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, ten levels"
 PL_RUCA2005             "Patient location: Rural-Urban Commuting Area (RUCA) Codes"
 PL_RUCA4_2005
"Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CAT4              "Patient Location: Urban-Rural 4 Categories"
 PR1                     "Procedure 1"
 PR2                     "Procedure 2"
 PR3                     "Procedure 3"
 PR4                     "Procedure 4"
 PRCCS1                  "CCS: procedure 1"
 PRCCS2                  "CCS: procedure 2"
 PRCCS3                  "CCS: procedure 3"
 PRCCS4                  "CCS: procedure 4"
 PROCTYPE                "Procedure type indicator"
 PSTATE                  "Patient State postal code"
 PSTCO2                  "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE                    "Race (uniform)"
 RACE_X                  "Race (as received from source)"
 STATE_AS                "State Ambulatory Surgery service indicator"
 STATE_ED                "State Emergency Department service indicator"
 STATE_OS                "State Observation Stay service indicator"
 TOTCHG                  "Total charges (cleaned)"
 TOTCHG_X                "Total charges (as received from source)"
 TransportToHosp         "Method of transportation to hospita"
 VisitLink               "Visit linkage variable"
 YEAR                    "Calendar year"
 ZIP3                    "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL             "Median household income national quartile for patient ZIP Code"
 AYEAR                   "Admission year"
 DMONTH                  "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBetweenVisits
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysToEvent
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA1993
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA10_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA2005
 (-9.9,-8.8,-6.6,-5.5=SYSMIS).
RECODE PL_RUCA4_2005
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE TransportToHosp
 (-9,-8,-6,-5=SYSMIS).
RECODE VisitLink
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2010_CORE.SAV' /COMPRESSED.
