/*******************************************************************
*   MA_SEDD_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      INPATIENT STAY CORE FILE INTO SPSS                         
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'MA_SEDD_2007_CORE.ASC' FIXED / 
 AGE                        1-   3
 AGEMONTH                   4-   6
 AHOUR                      7-  10
 AMONTH                    11-  12
 ASOURCE                   13-  14
 ASOURCE_                  15     (A)
 ATYPE                     16-  17
 AWEEKEND                  18-  19
 CPT1                      20-  24 (A)
 CPT2                      25-  29 (A)
 CPT3                      30-  34 (A)
 CPT4                      35-  39 (A)
 CPT5                      40-  44 (A)
 CPT6                      45-  49 (A)
 CPT7                      50-  54 (A)
 CPT8                      55-  59 (A)
 CPT9                      60-  64 (A)
 CPT10                     65-  69 (A)
 CPT11                     70-  74 (A)
 CPT12                     75-  79 (A)
 CPT13                     80-  84 (A)
 CPT14                     85-  89 (A)
 CPT15                     90-  94 (A)
 CPT16                     95-  99 (A)
 CPT17                    100- 104 (A)
 CPT18                    105- 109 (A)
 CPT19                    110- 114 (A)
 CPT20                    115- 119 (A)
 CPT21                    120- 124 (A)
 CPT22                    125- 129 (A)
 CPT23                    130- 134 (A)
 CPT24                    135- 139 (A)
 CPT25                    140- 144 (A)
 CPT26                    145- 149 (A)
 CPT27                    150- 154 (A)
 CPT28                    155- 159 (A)
 CPT29                    160- 164 (A)
 CPT30                    165- 169 (A)
 DHOUR                    170- 173
 DIED                     174- 175
 DISPUNIF                 176- 177
 DISP_X                   178     (A)
 DQTR                     179- 180
 DSHOSPID                 181- 193 (A)
 DX1                      194- 198 (A)
 DX2                      199- 203 (A)
 DX3                      204- 208 (A)
 DX4                      209- 213 (A)
 DX5                      214- 218 (A)
 DX6                      219- 223 (A)
 DXCCS1                   224- 227
 DXCCS2                   228- 231
 DXCCS3                   232- 235
 DXCCS4                   236- 239
 DXCCS5                   240- 243
 DXCCS6                   244- 247
 DXPOA1                   248     (A)
 DXPOA2                   249     (A)
 DXPOA3                   250     (A)
 DXPOA4                   251     (A)
 DXPOA5                   252     (A)
 DaysBetw                 253- 256
 ECODE1                   257- 261 (A)
 ECODE2                   262- 266 (A)
 ECODE3                   267- 271 (A)
 ECODE4                   272- 276 (A)
 ECODE5                   277- 281 (A)
 E_CCS1                   282- 285
 E_CCS2                   286- 289
 E_CCS3                   290- 293
 E_CCS4                   294- 297
 E_CCS5                   298- 301
 E_POA1                   302     (A)
 E_POA2                   303     (A)
 E_POA3                   304     (A)
 E_POA4                   305     (A)
 E_POA5                   306     (A)
 FEMALE                   307- 308
 HCUP_AS                  309- 310
 HCUP_ED                  311- 312
 HCUP_OS                  313- 314
 HISPANIC                 315- 329 (A)
 HOSPBRTH                 330- 332
 HOSPST                   333- 334 (A)
 Homeless                 335- 336
 KEY                      337- 350
 LOS                      351- 355
 LOS_X                    356- 361
 MEDINCST                 362- 363
 NCPT                     364- 366
 NDX                      367- 368
 NECODE                   369- 370
 NEOMAT                   371- 372
 NPR                      373- 374
 PAY1                     375- 376
 PAY1_X                   377- 381 (A)
 PAY2                     382- 383
 PAY2_X                   384- 388 (A)
 PL_CBSA                  389- 391
 PL_MSA19                 392- 394
 PL_RUCA4                 395- 396
 PL_UR_CA                 397- 398
 PR1                      399- 402 (A)
 PR2                      403- 406 (A)
 PR3                      407- 410 (A)
 PR4                      411- 414 (A)
 PRCCS1                   415- 417
 PRCCS2                   418- 420
 PRCCS3                   421- 423
 PRCCS4                   424- 426
 PROCTYPE                 427- 429
 PSTATE                   430- 431 (A)
 PSTCO2                   432- 436
 RACE                     437- 438
 RACE_X                   439- 443 (A)
 STATE_AS                 444- 445
 STATE_ED                 446- 447
 STATE_OS                 448- 449
 TOTCHG                   450- 459
 TOTCHG_X                 460- 474
 Transpor                 475- 476
 YEAR                     477- 480
 ZIP3                     481- 483 (A)
 ZIPINC_Q                 484- 486
 AYEAR                    487- 490
 DMONTH                   491- 492.


***  Specify write formats  ***.
FORMATS
 AGE                     (F3.0) /
 AGEMONTH                (F3.0) /
 AHOUR                   (F3.0) /
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 ATYPE                   (F3.0) /
 AWEEKEND                (F3.0) /
 DHOUR                   (F3.0) /
 DIED                    (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DaysBetw                (F3.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 Homeless                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 LOS_X                   (F4.0) /
 MEDINCST                (F3.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 NPR                     (F3.0) /
 PAY1                    (F3.0) /
 PAY2                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UR_CA                (F3.0) /
 PRCCS1                  (F3.0) /
 PRCCS2                  (F3.0) /
 PRCCS3                  (F3.0) /
 PRCCS4                  (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO2                  (F4.0) /
 RACE                    (F3.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 TOTCHG                  (F6.0) /
 TOTCHG_X                (F7.2) /
 Transpor                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE       "Age in years at admission"
 AGEMONTH  "Age in months (when age < 11 years)"
 AHOUR     "Admission Hour"
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 ASOURCE_  "Admission source (as received from source)"
 ATYPE     "Admission type"
 AWEEKEND  "Admission day is a weekend"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 DHOUR     "Discharge Hour"
 DIED      "Died during hospitalization"
 DISPUNIF  "Disposition of patient (uniform)"
 DISP_X    "Disposition of patient (as received from source)"
 DQTR      "Discharge quarter"
 DSHOSPID  "Data source hospital identifier"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXPOA1    "Diagnosis 1, present on admission indicator"
 DXPOA2    "Diagnosis 2, present on admission indicator"
 DXPOA3    "Diagnosis 3, present on admission indicator"
 DXPOA4    "Diagnosis 4, present on admission indicator"
 DXPOA5    "Diagnosis 5, present on admission indicator"
 DaysBetw  "Number of days between visits"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 E_POA1    "E Code 1, present on admission indicator"
 E_POA2    "E Code 2, present on admission indicator"
 E_POA3    "E Code 3, present on admission indicator"
 E_POA4    "E Code 4, present on admission indicator"
 E_POA5    "E Code 5, present on admission indicator"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HISPANIC  "Hispanic ethnicity (as received from source)"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 Homeless  "Indicator that patient is homeless"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 LOS_X     "Length of stay (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 NPR       "Number of procedures on this record"
 PAY1      "Primary expected payer (uniform)"
 PAY1_X    "Primary expected payer (as received from source)"
 PAY2      "Secondary expected payer (uniform)"
 PAY2_X    "Secondary expected payer (as received from source)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PR1       "Procedure 1"
 PR2       "Procedure 2"
 PR3       "Procedure 3"
 PR4       "Procedure 4"
 PRCCS1    "CCS: procedure 1"
 PRCCS2    "CCS: procedure 2"
 PRCCS3    "CCS: procedure 3"
 PRCCS4    "CCS: procedure 4"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 RACE      "Race (uniform)"
 RACE_X    "Race (as received from source)"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 TOTCHG    "Total charges (cleaned)"
 TOTCHG_X  "Total charges (as received from source)"
 Transpor  "Method of transportation to hospita"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DaysBetw
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE Homeless
 (-9,-8,-6,-5=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE Transpor
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'MA_SEDD_2007_CORE.SAV' /COMPRESSED.
