/*****************************************************************************
* Creation Date: 05/01/2018   
* UT_SASD_2015q1q3_CORE.Do
* This program will load the 2015 UT ASCII CORE File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      int    AGE                          1-   3   ///
      int    AGEDAY                       4-   6   ///
      int    AGEMONTH                     7-   9   ///
      byte   AMONTH                      10-  11   ///
      byte   AWEEKEND                    12-  13   ///
      str    BILLTYPE                    14-  17   ///
      str    CPT1                        18-  22   ///
      str    CPT2                        23-  27   ///
      str    CPT3                        28-  32   ///
      str    CPT4                        33-  37   ///
      str    CPT5                        38-  42   ///
      str    CPT6                        43-  47   ///
      int    CPTCCS1                     48-  50   ///
      int    CPTCCS2                     51-  53   ///
      int    CPTCCS3                     54-  56   ///
      int    CPTCCS4                     57-  59   ///
      int    CPTCCS5                     60-  62   ///
      int    CPTCCS6                     63-  65   ///
      int    CPTDAY1                     66-  68   ///
      str    CPTM1_1                     69-  70   ///
      str    CPTM1_2                     71-  72   ///
      str    CPTM1_3                     73-  74   ///
      str    CPTM1_4                     75-  76   ///
      str    CPTM1_5                     77-  78   ///
      str    CPTM1_6                     79-  80   ///
      str    CPTM2_1                     81-  82   ///
      str    CPTM2_2                     83-  84   ///
      str    CPTM2_3                     85-  86   ///
      str    CPTM2_4                     87-  88   ///
      str    CPTM2_5                     89-  90   ///
      str    CPTM2_6                     91-  92   ///
      long   DaysToEvent                 93-  98   ///
      byte   DIED                        99- 100   ///
      str    DISP_X                     101- 102   ///
      byte   DISPUB04                   103- 104   ///
      byte   DISPUNIFORM                105- 106   ///
      byte   DMONTH                     107- 108   ///
      byte   DQTR                       109- 110   ///
      str    DSHOSPID                   111- 127   ///
      str    DX_Visit_Reason1           128- 134   ///
      str    DX_Visit_Reason2           135- 141   ///
      str    DX_Visit_Reason3           142- 148   ///
      str    DX1                        149- 155   ///
      str    DX2                        156- 162   ///
      str    DX3                        163- 169   ///
      str    DX4                        170- 176   ///
      str    DX5                        177- 183   ///
      str    DX6                        184- 190   ///
      str    DX7                        191- 197   ///
      str    DX8                        198- 204   ///
      str    DX9                        205- 211   ///
      int    DXCCS1                     212- 215   ///
      int    DXCCS2                     216- 219   ///
      int    DXCCS3                     220- 223   ///
      int    DXCCS4                     224- 227   ///
      int    DXCCS5                     228- 231   ///
      int    DXCCS6                     232- 235   ///
      int    DXCCS7                     236- 239   ///
      int    DXCCS8                     240- 243   ///
      int    DXCCS9                     244- 247   ///
      int    DXVER                      248- 250   ///
      int    E_CCS1                     251- 254   ///
      int    E_CCS2                     255- 258   ///
      int    E_CCS3                     259- 262   ///
      int    E_CCS4                     263- 266   ///
      int    E_CCS5                     267- 270   ///
      int    E_CCS6                     271- 274   ///
      str    ECODE1                     275- 281   ///
      str    ECODE2                     282- 288   ///
      str    ECODE3                     289- 295   ///
      str    ECODE4                     296- 302   ///
      str    ECODE5                     303- 309   ///
      str    ECODE6                     310- 316   ///
      byte   FEMALE                     317- 318   ///
      byte   HCUP_ED                    319- 320   ///
      byte   HCUP_OS                    321- 322   ///
      long   HCUP_SURGERY_BROAD_CPT     323- 327   ///
      long   HCUP_SURGERY_BROAD_I9      328- 332   ///
      long   HCUP_SURGERY_NARROW_CPT    333- 337   ///
      long   HCUP_SURGERY_NARROW_I9     338- 342   ///
      int    HOSPBRTH                   343- 345   ///
      str    HOSPST                     346- 347   ///
      double KEY                        348- 362   ///
      long   LOS                        363- 367   ///
      long   LOS_X                      368- 373   ///
      long   MDNUM1_R                   374- 382   ///
      byte   MEDINCSTQ                  383- 384   ///
      int    NCHRONIC                   385- 387   ///
      int    NCPT                       388- 391   ///
      int    NDX                        392- 394   ///
      byte   NECODE                     395- 396   ///
      byte   NEOMAT                     397- 398   ///
      int    NPR                        399- 401   ///
      byte   ORPROC                     402- 403   ///
      byte   PAY1                       404- 405   ///
      str    PAY1_X                     406- 435   ///
      int    PL_CBSA                    436- 438   ///
      byte   PL_NCHS                    439- 440   ///
      byte   PL_RUCC                    441- 442   ///
      byte   PL_UIC                     443- 444   ///
      byte   PL_UR_CAT4                 445- 446   ///
      str    PointOfOrigin_X            447        ///
      str    PointOfOriginUB04          448        ///
      str    PR1                        449- 455   ///
      str    PR2                        456- 462   ///
      str    PR3                        463- 469   ///
      str    PR4                        470- 476   ///
      str    PR5                        477- 483   ///
      str    PR6                        484- 490   ///
      int    PRCCS1                     491- 493   ///
      int    PRCCS2                     494- 496   ///
      int    PRCCS3                     497- 499   ///
      int    PRCCS4                     500- 502   ///
      int    PRCCS5                     503- 505   ///
      int    PRCCS6                     506- 508   ///
      long   PRDAY1                     509- 513   ///
      int    PROCTYPE                   514- 516   ///
      int    PRVER                      517- 519   ///
      str    PSTATE                     520- 521   ///
      long   PSTCO2                     522- 526   ///
      byte   STATE_AS                   527- 528   ///
      byte   STATE_ED                   529- 530   ///
      byte   STATE_OS                   531- 532   ///
      double TOTCHG                     533- 542   ///
      double TOTCHG_X                   543- 557   ///
      long   VisitLink                  558- 566   ///
      int    YEAR                       567- 570   ///
      str    ZIP                        571- 575   ///
      str    ZIP3                       576- 578   ///
      int    ZIPINC_QRTL                579- 581   ///
      int    AYEAR                      582- 585   ///
      byte   BMONTH                     586- 587   ///
      int    BYEAR                      588- 591   ///
      byte   PRMONTH1                   592- 593   ///
      int    PRYEAR1                    594- 597   ///
      using  "UT_SASD_2015q1q3_CORE.ASC"

***  Assign labels to the data elements ***
label var AGE                      "Age in years at admission"
label var AGEDAY                   "Age in days (when age < 1 year)"
label var AGEMONTH                 "Age in months (when age < 11 years)"
label var AMONTH                   "Admission month"
label var AWEEKEND                 "Admission day is a weekend"
label var BILLTYPE                 "Type of bill, UB-04 coding"
label var CPT1                     "CPT/HCPCS procedure code 1"
label var CPT2                     "CPT/HCPCS procedure code 2"
label var CPT3                     "CPT/HCPCS procedure code 3"
label var CPT4                     "CPT/HCPCS procedure code 4"
label var CPT5                     "CPT/HCPCS procedure code 5"
label var CPT6                     "CPT/HCPCS procedure code 6"
label var CPTCCS1                  "CCS: CPT 1"
label var CPTCCS2                  "CCS: CPT 2"
label var CPTCCS3                  "CCS: CPT 3"
label var CPTCCS4                  "CCS: CPT 4"
label var CPTCCS5                  "CCS: CPT 5"
label var CPTCCS6                  "CCS: CPT 6"
label var CPTDAY1                  "Number of days from admission to CPT1"
label var CPTM1_1                  "First CPT-4/HCPCS modifier 1"
label var CPTM1_2                  "First CPT-4/HCPCS modifier 2"
label var CPTM1_3                  "First CPT-4/HCPCS modifier 3"
label var CPTM1_4                  "First CPT-4/HCPCS modifier 4"
label var CPTM1_5                  "First CPT-4/HCPCS modifier 5"
label var CPTM1_6                  "First CPT-4/HCPCS modifier 6"
label var CPTM2_1                  "Second CPT-4/HCPCS modifier 1"
label var CPTM2_2                  "Second CPT-4/HCPCS modifier 2"
label var CPTM2_3                  "Second CPT-4/HCPCS modifier 3"
label var CPTM2_4                  "Second CPT-4/HCPCS modifier 4"
label var CPTM2_5                  "Second CPT-4/HCPCS modifier 5"
label var CPTM2_6                  "Second CPT-4/HCPCS modifier 6"
label var DaysToEvent              "Days from 'start date' to admission"
label var DIED                     "Died during hospitalization"
label var DISP_X                   "Disposition of patient (as received from source)"
label var DISPUB04                 "Disposition of patient (UB-04 standard coding)"
label var DISPUNIFORM              "Disposition of patient (uniform)"
label var DMONTH                   "Discharge month"
label var DQTR                     "Discharge quarter"
label var DSHOSPID                 "Data source hospital identifier"
label var DX_Visit_Reason1         "Reason for visit diagnosis 1"
label var DX_Visit_Reason2         "Reason for visit diagnosis 2"
label var DX_Visit_Reason3         "Reason for visit diagnosis 3"
label var DX1                      "Diagnosis 1"
label var DX2                      "Diagnosis 2"
label var DX3                      "Diagnosis 3"
label var DX4                      "Diagnosis 4"
label var DX5                      "Diagnosis 5"
label var DX6                      "Diagnosis 6"
label var DX7                      "Diagnosis 7"
label var DX8                      "Diagnosis 8"
label var DX9                      "Diagnosis 9"
label var DXCCS1                   "CCS: diagnosis 1"
label var DXCCS2                   "CCS: diagnosis 2"
label var DXCCS3                   "CCS: diagnosis 3"
label var DXCCS4                   "CCS: diagnosis 4"
label var DXCCS5                   "CCS: diagnosis 5"
label var DXCCS6                   "CCS: diagnosis 6"
label var DXCCS7                   "CCS: diagnosis 7"
label var DXCCS8                   "CCS: diagnosis 8"
label var DXCCS9                   "CCS: diagnosis 9"
label var DXVER                    "Diagnosis Version"
label var E_CCS1                   "CCS: E Code 1"
label var E_CCS2                   "CCS: E Code 2"
label var E_CCS3                   "CCS: E Code 3"
label var E_CCS4                   "CCS: E Code 4"
label var E_CCS5                   "CCS: E Code 5"
label var E_CCS6                   "CCS: E Code 6"
label var ECODE1                   "E code 1"
label var ECODE2                   "E code 2"
label var ECODE3                   "E code 3"
label var ECODE4                   "E code 4"
label var ECODE5                   "E code 5"
label var ECODE6                   "E code 6"
label var FEMALE                   "Indicator of sex"
label var HCUP_ED                  "HCUP Emergency Department service indicator"
label var HCUP_OS                  "HCUP Observation Stay service indicator"
label var HCUP_SURGERY_BROAD_CPT   "Number of reported CPT procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_BROAD_I9    "Number of reported ICD-9-CM procedures that qualify as a surgery using a broad definition"
label var HCUP_SURGERY_NARROW_CPT  "Number of reported CPT procedures that qualify as a surgery using a narrow definition"
label var HCUP_SURGERY_NARROW_I9   "Number of reported ICD-9-CM procedures that qualify as a surgery using a narrow definition"
label var HOSPBRTH                 "Indicator of birth in this hospital"
label var HOSPST                   "Hospital state postal code"
label var KEY                      "HCUP record identifier"
label var LOS                      "Length of stay (cleaned)"
label var LOS_X                    "Length of stay (as received from source)"
label var MDNUM1_R                 "Physician 1 number (re-identified)"
label var MEDINCSTQ                "Median household income state quartile for patient ZIP Code"
label var NCHRONIC                 "Number of chronic conditions"
label var NCPT                     "Number of CPT/HCPCS procedures for this visit"
label var NDX                      "Number of diagnoses on this record"
label var NECODE                   "Number of E codes on this record"
label var NEOMAT                   "Neonatal and/or maternal DX and/or PR"
label var NPR                      "Number of procedures on this record"
label var ORPROC                   "Major operating room procedure indicator"
label var PAY1                     "Primary expected payer (uniform)"
label var PAY1_X                   "Primary expected payer (as received from source)"
label var PL_CBSA                  "Patient location: Core Based Statistical Area (CBSA)"
label var PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
label var PL_RUCC                  "Patient location: Rural-Urban Continuum Codes(RUCC)"
label var PL_UIC                   "Patient location: Urban Influence Codes"
label var PL_UR_CAT4               "Patient Location: Urban-Rural 4 Categories"
label var PointOfOrigin_X          "Point of origin for admission or visit, as received from source"
label var PointOfOriginUB04        "Point of origin for admission or visit, UB-04 standard coding"
label var PR1                      "Procedure 1"
label var PR2                      "Procedure 2"
label var PR3                      "Procedure 3"
label var PR4                      "Procedure 4"
label var PR5                      "Procedure 5"
label var PR6                      "Procedure 6"
label var PRCCS1                   "CCS: procedure 1"
label var PRCCS2                   "CCS: procedure 2"
label var PRCCS3                   "CCS: procedure 3"
label var PRCCS4                   "CCS: procedure 4"
label var PRCCS5                   "CCS: procedure 5"
label var PRCCS6                   "CCS: procedure 6"
label var PRDAY1                   "Number of days from admission to PR1"
label var PROCTYPE                 "Procedure type indicator"
label var PRVER                    "Procedure Version"
label var PSTATE                   "Patient State postal code"
label var PSTCO2                   "Patient state/county FIPS code, possibly derived from ZIP Code"
label var STATE_AS                 "State Ambulatory Surgery service indicator"
label var STATE_ED                 "State Emergency Department service indicator"
label var STATE_OS                 "State Observation Stay service indicator"
label var TOTCHG                   "Total charges (cleaned)"
label var TOTCHG_X                 "Total charges (as received from source)"
label var VisitLink                "Visit linkage variable"
label var YEAR                     "Calendar year"
label var ZIP                      "Patient ZIP Code"
label var ZIP3                     "Patient ZIP Code, first 3 digits"
label var ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code"
label var AYEAR                    "Admission year"
label var BMONTH                   "Birth month"
label var BYEAR                    "Birth year"
label var PRMONTH1                 "Month of procedure 1"
label var PRYEAR1                  "Year of procedure 1"

*** Convert special values to missing values ***
recode AGE                       (-99 -88 -66=.)
recode AGEDAY                    (-99 -88 -66=.)
recode AGEMONTH                  (-99 -88 -66=.)
recode AMONTH                    (-9 -8 -6 -5=.)
recode AWEEKEND                  (-9 -8 -6 -5=.)
recode CPTCCS1                   (-99 -88 -66=.)
recode CPTCCS2                   (-99 -88 -66=.)
recode CPTCCS3                   (-99 -88 -66=.)
recode CPTCCS4                   (-99 -88 -66=.)
recode CPTCCS5                   (-99 -88 -66=.)
recode CPTCCS6                   (-99 -88 -66=.)
recode CPTDAY1                   (-99 -88 -66=.)
recode DaysToEvent               (-99999 -88888 -66666=.)
recode DIED                      (-9 -8 -6 -5=.)
recode DISPUB04                  (-9 -8 -6 -5=.)
recode DISPUNIFORM               (-9 -8 -6 -5=.)
recode DMONTH                    (-9 -8 -6 -5=.)
recode DQTR                      (-9 -8 -6 -5=.)
recode DXCCS1                    (-999 -888 -666=.)
recode DXCCS2                    (-999 -888 -666=.)
recode DXCCS3                    (-999 -888 -666=.)
recode DXCCS4                    (-999 -888 -666=.)
recode DXCCS5                    (-999 -888 -666=.)
recode DXCCS6                    (-999 -888 -666=.)
recode DXCCS7                    (-999 -888 -666=.)
recode DXCCS8                    (-999 -888 -666=.)
recode DXCCS9                    (-999 -888 -666=.)
recode DXVER                     (-99 -88 -66=.)
recode E_CCS1                    (-999 -888 -666=.)
recode E_CCS2                    (-999 -888 -666=.)
recode E_CCS3                    (-999 -888 -666=.)
recode E_CCS4                    (-999 -888 -666=.)
recode E_CCS5                    (-999 -888 -666=.)
recode E_CCS6                    (-999 -888 -666=.)
recode FEMALE                    (-9 -8 -6 -5=.)
recode HCUP_ED                   (-9 -8 -6 -5=.)
recode HCUP_OS                   (-9 -8 -6 -5=.)
recode HCUP_SURGERY_BROAD_CPT    (-9999 -8888 -6666=.)
recode HCUP_SURGERY_BROAD_I9     (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_CPT   (-9999 -8888 -6666=.)
recode HCUP_SURGERY_NARROW_I9    (-9999 -8888 -6666=.)
recode HOSPBRTH                  (-99 -88 -66=.)
recode LOS                       (-9999 -8888 -6666=.)
recode LOS_X                     (-99999 -88888 -66666=.)
recode MDNUM1_R                  (-99999999 -88888888 -66666666=.)
recode MEDINCSTQ                 (-9 -8 -6 -5=.)
recode NCHRONIC                  (-99 -88 -66=.)
recode NCPT                      (-999 -888 -666=.)
recode NDX                       (-99 -88 -66=.)
recode NECODE                    (-9 -8 -6 -5=.)
recode NEOMAT                    (-9 -8 -6 -5=.)
recode NPR                       (-99 -88 -66=.)
recode ORPROC                    (-9 -8 -6 -5=.)
recode PAY1                      (-9 -8 -6 -5=.)
recode PL_CBSA                   (-99 -88 -66=.)
recode PL_NCHS                   (-9 -8 -6 -5=.)
recode PL_RUCC                   (-9 -8 -6 -5=.)
recode PL_UIC                    (-9 -8 -6 -5=.)
recode PL_UR_CAT4                (-9 -8 -6 -5=.)
recode PRCCS1                    (-99 -88 -66=.)
recode PRCCS2                    (-99 -88 -66=.)
recode PRCCS3                    (-99 -88 -66=.)
recode PRCCS4                    (-99 -88 -66=.)
recode PRCCS5                    (-99 -88 -66=.)
recode PRCCS6                    (-99 -88 -66=.)
recode PRDAY1                    (-9999 -8888 -6666=.)
recode PROCTYPE                  (-99 -88 -66=.)
recode PRVER                     (-99 -88 -66=.)
recode PSTCO2                    (-9999 -8888 -6666=.)
recode STATE_AS                  (-9 -8 -6 -5=.)
recode STATE_ED                  (-9 -8 -6 -5=.)
recode STATE_OS                  (-9 -8 -6 -5=.)
recode TOTCHG                    (-999999999 -888888888 -666666666=.)
recode TOTCHG_X                  (-99999999999.99 -88888888888.88 -66666666666.66=.)
recode VisitLink                 (-99999999 -88888888 -66666666=.)
recode YEAR                      (-999 -888 -666=.)
recode ZIPINC_QRTL               (-99 -88 -66=.)
recode AYEAR                     (-999 -888 -666=.)
recode BMONTH                    (-9 -8 -6 -5=.)
recode BYEAR                     (-999 -888 -666=.)
recode PRMONTH1                  (-9 -8 -6 -5=.)
recode PRYEAR1                   (-999 -888 -666=.)

save "UT_SASD_2015q1q3_CORE.dta", replace
