/*****************************************************************************
* Creation Date: 06/25/2018   
* NJ_SASD_2015q1q3_AHAL.Do
* This program will load the 2015 NJ ASCII AHAL File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
*** Skip the first two lines from the ASCII file i.e. infix 3 firstlineoffile ***
infix 3 firstlineoffile                            ///
      str    AHAID                        1-   7   ///
      str    DSHOSPID                     8-  24   ///
      long   HOSPID                      25-  29   ///
      byte   FREESTANDING                30-  31   ///
      long   HFIPSSTCO                   32-  36   ///
      str    HOSPST                      37-  38   ///
      int    YEAR                        39-  42   ///
      using  "NJ_SASD_2015q1q3_AHAL.ASC"

***  Assign labels to the data elements ***
label var AHAID                    "AHA hospital identifier with the leading 6"
label var DSHOSPID                 "Data source hospital identifier"
label var HOSPID                   "HCUP hospital identification number"
label var FREESTANDING             "Indicator of freestanding ambulatory surgery center"
label var HFIPSSTCO                "Hospital FIPS state/county code"
label var HOSPST                   "Hospital state postal code"
label var YEAR                     "Calendar year"

*** Convert special values to missing values ***
recode FREESTANDING              (-9 -8 -6 -5=.)
recode HFIPSSTCO                 (-9999 -8888 -6666=.)
recode YEAR                      (-999 -888 -666=.)

save "NJ_SASD_2015q1q3_AHAL.dta", replace
