/*******************************************************************
* Creation Date: 05/03/2018   
*   UT_SASD_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'UT_SASD_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_CHRON1                     19-  20
 I10_CHRON2                     21-  22
 I10_CHRON3                     23-  24
 I10_CHRON4                     25-  26
 I10_CHRON5                     27-  28
 I10_CHRON6                     29-  30
 I10_CHRON7                     31-  32
 I10_CHRON8                     33-  34
 I10_CHRON9                     35-  36
 I10_DXMCCS1                    37-  47 (A)
 I10_DXMCCS2                    48-  58 (A)
 I10_DXMCCS3                    59-  69 (A)
 I10_DXMCCS4                    70-  80 (A)
 I10_DXMCCS5                    81-  91 (A)
 I10_DXMCCS6                    92- 102 (A)
 I10_DXMCCS7                   103- 113 (A)
 I10_DXMCCS8                   114- 124 (A)
 I10_DXMCCS9                   125- 135 (A)
 I10_ECauseMCCS1               136- 146 (A)
 I10_ECauseMCCS2               147- 157 (A)
 I10_ECauseMCCS3               158- 168 (A)
 I10_ECauseMCCS4               169- 179 (A)
 I10_ECauseMCCS5               180- 190 (A)
 I10_ECauseMCCS6               191- 201 (A)
 I10_INJURY                    202- 203
 I10_MULTINJURY                204- 205
 I10_PCLASS1                   206- 207
 I10_PCLASS2                   208- 209
 I10_PCLASS3                   210- 211
 I10_PCLASS4                   212- 213
 I10_PCLASS5                   214- 215
 I10_PCLASS6                   216- 217
 I10_PRMCCS1                   218- 225 (A)
 I10_PRMCCS2                   226- 233 (A)
 I10_PRMCCS3                   234- 241 (A)
 I10_PRMCCS4                   242- 249 (A)
 I10_PRMCCS5                   250- 257 (A)
 I10_PRMCCS6                   258- 265 (A)
 KEY                           266- 280.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_PCLASS1                  (F3.0) /
 I10_PCLASS2                  (F3.0) /
 I10_PCLASS3                  (F3.0) /
 I10_PCLASS4                  (F3.0) /
 I10_PCLASS5                  (F3.0) /
 I10_PCLASS6                  (F3.0) /
 KEY                          (F8.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_INJURY
 "ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an injury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_PCLASS1                  "ICD-10-PCS Procedure class 1"
 I10_PCLASS2                  "ICD-10-PCS Procedure class 2"
 I10_PCLASS3                  "ICD-10-PCS Procedure class 3"
 I10_PCLASS4                  "ICD-10-PCS Procedure class 4"
 I10_PCLASS5                  "ICD-10-PCS Procedure class 5"
 I10_PCLASS6                  "ICD-10-PCS Procedure class 6"
 I10_PRMCCS1                  "ICD-10-PCS Multi-Level CCS:  Procedure 1"
 I10_PRMCCS2                  "ICD-10-PCS Multi-Level CCS:  Procedure 2"
 I10_PRMCCS3                  "ICD-10-PCS Multi-Level CCS:  Procedure 3"
 I10_PRMCCS4                  "ICD-10-PCS Multi-Level CCS:  Procedure 4"
 I10_PRMCCS5                  "ICD-10-PCS Multi-Level CCS:  Procedure 5"
 I10_PRMCCS6                  "ICD-10-PCS Multi-Level CCS:  Procedure 6"
 KEY                          "HCUP record identifier" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS6
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'UT_SASD_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
