/*******************************************************************
*   ME_SASD_2003_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


*******************************.
*  Define the data file       *.
*******************************.

DATA LIST FILE = 'ME_SASD_2003_CHGS.ASC' FIXED / 
 KEY                        1-  14
 CPTHCPCS                  15-  19 (A)
 REVCODE                   20-  23 (A)
 SERVDAY                   24-  28
 UNITS                     29-  36.


***  Specify write formats  ***.
FORMATS
 KEY                     (F8.0) /
 SERVDAY                 (F3.0) /
 UNITS                   (F4.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 KEY       "HCUP record identifier"
 CPTHCPCS  "Line item CPT-4/HCPCS procedure code (as received from source)"
 REVCODE   "Line item revenue code (as received from source)"
 SERVDAY   "Line item days from admission date"
 UNITS     "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2003_CHGS.SAV' /COMPRESSED.
