/*******************************************************************
* Creation Date: 05/24/2022   
*   FL_SASD_2020_AHAL.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT AHAL FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'FL_SASD_2020_AHAL.ASC' FIXED SKIP=2 / 
 AHAID                           1-   7 (A)
 DSHOSPID                        8-  24 (A)
 HOSPID                         25-  29
 COMMUNITY_NONREHAB_NONLTAC     30-  33
 HFIPSSTCO                      34-  38
 HOSPST                         39-  40 (A)
 HOSPITAL_OWNED                 41-  42
 YEAR                           43-  46.


***  Specify write formats  ***.
FORMATS
 HOSPID                       (F4.0) /
 COMMUNITY_NONREHAB_NONLTAC   (F3.0) /
 HFIPSSTCO                    (F4.0) /
 HOSPITAL_OWNED               (F3.0) /
 YEAR                         (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AHAID                        "AHA hospital identifier with the leading 6"
 DSHOSPID                     "Data source hospital identifier"
 HOSPID                       "HCUP hospital identification number"
 COMMUNITY_NONREHAB_NONLTAC
"Indicator of U.S. community hospital that is not a rehabilitation or long-term acute care hospital (Z997)"
 HFIPSSTCO                    "Hospital FIPS state/county code"
 HOSPST                       "Hospital state postal code"
 HOSPITAL_OWNED               "Hospital Owned Ambulatory Surgery Center Indicator"
 YEAR                         "Calendar year" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE COMMUNITY_NONREHAB_NONLTAC
 (-999,-888,-666,-555=SYSMIS).
RECODE HFIPSSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE HOSPITAL_OWNED
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'FL_SASD_2020_AHAL.SAV' /COMPRESSED.
