/*******************************************************************
* Creation Date: 08/31/2017   
*   VT_SASD_2015q4_DX_PR_GRPS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT DX_PR_GRPS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'VT_SASD_2015q4_DX_PR_GRPS.ASC' FIXED SKIP=2 / 
 I10_BODYSYSTEM1                 1-   2
 I10_BODYSYSTEM2                 3-   4
 I10_BODYSYSTEM3                 5-   6
 I10_BODYSYSTEM4                 7-   8
 I10_BODYSYSTEM5                 9-  10
 I10_BODYSYSTEM6                11-  12
 I10_BODYSYSTEM7                13-  14
 I10_BODYSYSTEM8                15-  16
 I10_BODYSYSTEM9                17-  18
 I10_BODYSYSTEM10               19-  20
 I10_BODYSYSTEM11               21-  22
 I10_BODYSYSTEM12               23-  24
 I10_BODYSYSTEM13               25-  26
 I10_BODYSYSTEM14               27-  28
 I10_BODYSYSTEM15               29-  30
 I10_BODYSYSTEM16               31-  32
 I10_BODYSYSTEM17               33-  34
 I10_BODYSYSTEM18               35-  36
 I10_BODYSYSTEM19               37-  38
 I10_BODYSYSTEM20               39-  40
 I10_CHRON1                     41-  42
 I10_CHRON2                     43-  44
 I10_CHRON3                     45-  46
 I10_CHRON4                     47-  48
 I10_CHRON5                     49-  50
 I10_CHRON6                     51-  52
 I10_CHRON7                     53-  54
 I10_CHRON8                     55-  56
 I10_CHRON9                     57-  58
 I10_CHRON10                    59-  60
 I10_CHRON11                    61-  62
 I10_CHRON12                    63-  64
 I10_CHRON13                    65-  66
 I10_CHRON14                    67-  68
 I10_CHRON15                    69-  70
 I10_CHRON16                    71-  72
 I10_CHRON17                    73-  74
 I10_CHRON18                    75-  76
 I10_CHRON19                    77-  78
 I10_CHRON20                    79-  80
 I10_DXMCCS1                    81-  91 (A)
 I10_DXMCCS2                    92- 102 (A)
 I10_DXMCCS3                   103- 113 (A)
 I10_DXMCCS4                   114- 124 (A)
 I10_DXMCCS5                   125- 135 (A)
 I10_DXMCCS6                   136- 146 (A)
 I10_DXMCCS7                   147- 157 (A)
 I10_DXMCCS8                   158- 168 (A)
 I10_DXMCCS9                   169- 179 (A)
 I10_DXMCCS10                  180- 190 (A)
 I10_DXMCCS11                  191- 201 (A)
 I10_DXMCCS12                  202- 212 (A)
 I10_DXMCCS13                  213- 223 (A)
 I10_DXMCCS14                  224- 234 (A)
 I10_DXMCCS15                  235- 245 (A)
 I10_DXMCCS16                  246- 256 (A)
 I10_DXMCCS17                  257- 267 (A)
 I10_DXMCCS18                  268- 278 (A)
 I10_DXMCCS19                  279- 289 (A)
 I10_DXMCCS20                  290- 300 (A)
 I10_ECauseMCCS1               301- 311 (A)
 I10_ECauseMCCS2               312- 322 (A)
 I10_ECauseMCCS3               323- 333 (A)
 I10_ECauseMCCS4               334- 344 (A)
 I10_ECauseMCCS5               345- 355 (A)
 I10_ECauseMCCS6               356- 366 (A)
 I10_ECauseMCCS7               367- 377 (A)
 I10_ECauseMCCS8               378- 388 (A)
 I10_ECauseMCCS9               389- 399 (A)
 I10_ECauseMCCS10              400- 410 (A)
 I10_ECauseMCCS11              411- 421 (A)
 I10_INJURY                    422- 423
 I10_MULTINJURY                424- 425
 I10_PCLASS1                   426- 427
 I10_PCLASS2                   428- 429
 I10_PCLASS3                   430- 431
 I10_PCLASS4                   432- 433
 I10_PCLASS5                   434- 435
 I10_PCLASS6                   436- 437
 I10_PCLASS7                   438- 439
 I10_PCLASS8                   440- 441
 I10_PCLASS9                   442- 443
 I10_PCLASS10                  444- 445
 I10_PCLASS11                  446- 447
 I10_PCLASS12                  448- 449
 I10_PCLASS13                  450- 451
 I10_PCLASS14                  452- 453
 I10_PCLASS15                  454- 455
 I10_PCLASS16                  456- 457
 I10_PCLASS17                  458- 459
 I10_PCLASS18                  460- 461
 I10_PCLASS19                  462- 463
 I10_PCLASS20                  464- 465
 I10_PRMCCS1                   466- 473 (A)
 I10_PRMCCS2                   474- 481 (A)
 I10_PRMCCS3                   482- 489 (A)
 I10_PRMCCS4                   490- 497 (A)
 I10_PRMCCS5                   498- 505 (A)
 I10_PRMCCS6                   506- 513 (A)
 I10_PRMCCS7                   514- 521 (A)
 I10_PRMCCS8                   522- 529 (A)
 I10_PRMCCS9                   530- 537 (A)
 I10_PRMCCS10                  538- 545 (A)
 I10_PRMCCS11                  546- 553 (A)
 I10_PRMCCS12                  554- 561 (A)
 I10_PRMCCS13                  562- 569 (A)
 I10_PRMCCS14                  570- 577 (A)
 I10_PRMCCS15                  578- 585 (A)
 I10_PRMCCS16                  586- 593 (A)
 I10_PRMCCS17                  594- 601 (A)
 I10_PRMCCS18                  602- 609 (A)
 I10_PRMCCS19                  610- 617 (A)
 I10_PRMCCS20                  618- 625 (A)
 I10_U_BLOOD                   626- 627
 I10_U_CATH                    628- 629
 I10_U_CTSCAN                  630- 631
 I10_U_EKG                     632- 633
 I10_U_MHSA                    634- 635
 I10_U_MRT                     636- 637
 I10_U_PACEMAKER               638- 639
 I10_U_PHYTHERAPY              640- 641
 I10_U_RADTHERAPY              642- 643
 I10_U_STRESS                  644- 645
 KEY                           646- 660
 U_CCU                         661- 662
 U_CHESTXRAY                   663- 664
 U_DIALYSIS                    665- 666
 U_ECHO                        667- 668
 U_ED                          669- 670
 U_EEG                         671- 672
 U_EPO                         673- 674
 U_ICU                         675- 676
 U_LITHOTRIPSY                 677- 678
 U_NEWBN2L                     679- 680
 U_NEWBN3L                     681- 682
 U_NEWBN4L                     683- 684
 U_NUCMED                      685- 686
 U_OBSERVATION                 687- 688
 U_OCCTHERAPY                  689- 690
 U_ORGANACQ                    691- 692
 U_OTHIMPLANTS                 693- 694
 U_RESPTHERAPY                 695- 696
 U_SPEECHTHERAPY               697- 698
 U_ULTRASOUND                  699- 700.


***  Specify write formats  ***.
FORMATS
 I10_BODYSYSTEM1              (F3.0) /
 I10_BODYSYSTEM2              (F3.0) /
 I10_BODYSYSTEM3              (F3.0) /
 I10_BODYSYSTEM4              (F3.0) /
 I10_BODYSYSTEM5              (F3.0) /
 I10_BODYSYSTEM6              (F3.0) /
 I10_BODYSYSTEM7              (F3.0) /
 I10_BODYSYSTEM8              (F3.0) /
 I10_BODYSYSTEM9              (F3.0) /
 I10_BODYSYSTEM10             (F3.0) /
 I10_BODYSYSTEM11             (F3.0) /
 I10_BODYSYSTEM12             (F3.0) /
 I10_BODYSYSTEM13             (F3.0) /
 I10_BODYSYSTEM14             (F3.0) /
 I10_BODYSYSTEM15             (F3.0) /
 I10_BODYSYSTEM16             (F3.0) /
 I10_BODYSYSTEM17             (F3.0) /
 I10_BODYSYSTEM18             (F3.0) /
 I10_BODYSYSTEM19             (F3.0) /
 I10_BODYSYSTEM20             (F3.0) /
 I10_CHRON1                   (F3.0) /
 I10_CHRON2                   (F3.0) /
 I10_CHRON3                   (F3.0) /
 I10_CHRON4                   (F3.0) /
 I10_CHRON5                   (F3.0) /
 I10_CHRON6                   (F3.0) /
 I10_CHRON7                   (F3.0) /
 I10_CHRON8                   (F3.0) /
 I10_CHRON9                   (F3.0) /
 I10_CHRON10                  (F3.0) /
 I10_CHRON11                  (F3.0) /
 I10_CHRON12                  (F3.0) /
 I10_CHRON13                  (F3.0) /
 I10_CHRON14                  (F3.0) /
 I10_CHRON15                  (F3.0) /
 I10_CHRON16                  (F3.0) /
 I10_CHRON17                  (F3.0) /
 I10_CHRON18                  (F3.0) /
 I10_CHRON19                  (F3.0) /
 I10_CHRON20                  (F3.0) /
 I10_INJURY                   (F3.0) /
 I10_MULTINJURY               (F3.0) /
 I10_PCLASS1                  (F3.0) /
 I10_PCLASS2                  (F3.0) /
 I10_PCLASS3                  (F3.0) /
 I10_PCLASS4                  (F3.0) /
 I10_PCLASS5                  (F3.0) /
 I10_PCLASS6                  (F3.0) /
 I10_PCLASS7                  (F3.0) /
 I10_PCLASS8                  (F3.0) /
 I10_PCLASS9                  (F3.0) /
 I10_PCLASS10                 (F3.0) /
 I10_PCLASS11                 (F3.0) /
 I10_PCLASS12                 (F3.0) /
 I10_PCLASS13                 (F3.0) /
 I10_PCLASS14                 (F3.0) /
 I10_PCLASS15                 (F3.0) /
 I10_PCLASS16                 (F3.0) /
 I10_PCLASS17                 (F3.0) /
 I10_PCLASS18                 (F3.0) /
 I10_PCLASS19                 (F3.0) /
 I10_PCLASS20                 (F3.0) /
 I10_U_BLOOD                  (F3.0) /
 I10_U_CATH                   (F3.0) /
 I10_U_CTSCAN                 (F3.0) /
 I10_U_EKG                    (F3.0) /
 I10_U_MHSA                   (F3.0) /
 I10_U_MRT                    (F3.0) /
 I10_U_PACEMAKER              (F3.0) /
 I10_U_PHYTHERAPY             (F3.0) /
 I10_U_RADTHERAPY             (F3.0) /
 I10_U_STRESS                 (F3.0) /
 KEY                          (F8.0) /
 U_CCU                        (F3.0) /
 U_CHESTXRAY                  (F3.0) /
 U_DIALYSIS                   (F3.0) /
 U_ECHO                       (F3.0) /
 U_ED                         (F3.0) /
 U_EEG                        (F3.0) /
 U_EPO                        (F3.0) /
 U_ICU                        (F3.0) /
 U_LITHOTRIPSY                (F3.0) /
 U_NEWBN2L                    (F3.0) /
 U_NEWBN3L                    (F3.0) /
 U_NEWBN4L                    (F3.0) /
 U_NUCMED                     (F3.0) /
 U_OBSERVATION                (F3.0) /
 U_OCCTHERAPY                 (F3.0) /
 U_ORGANACQ                   (F3.0) /
 U_OTHIMPLANTS                (F3.0) /
 U_RESPTHERAPY                (F3.0) /
 U_SPEECHTHERAPY              (F3.0) /
 U_ULTRASOUND                 (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 I10_BODYSYSTEM1              "ICD-10-CM Body system 1"
 I10_BODYSYSTEM2              "ICD-10-CM Body system 2"
 I10_BODYSYSTEM3              "ICD-10-CM Body system 3"
 I10_BODYSYSTEM4              "ICD-10-CM Body system 4"
 I10_BODYSYSTEM5              "ICD-10-CM Body system 5"
 I10_BODYSYSTEM6              "ICD-10-CM Body system 6"
 I10_BODYSYSTEM7              "ICD-10-CM Body system 7"
 I10_BODYSYSTEM8              "ICD-10-CM Body system 8"
 I10_BODYSYSTEM9              "ICD-10-CM Body system 9"
 I10_BODYSYSTEM10             "ICD-10-CM Body system 10"
 I10_BODYSYSTEM11             "ICD-10-CM Body system 11"
 I10_BODYSYSTEM12             "ICD-10-CM Body system 12"
 I10_BODYSYSTEM13             "ICD-10-CM Body system 13"
 I10_BODYSYSTEM14             "ICD-10-CM Body system 14"
 I10_BODYSYSTEM15             "ICD-10-CM Body system 15"
 I10_BODYSYSTEM16             "ICD-10-CM Body system 16"
 I10_BODYSYSTEM17             "ICD-10-CM Body system 17"
 I10_BODYSYSTEM18             "ICD-10-CM Body system 18"
 I10_BODYSYSTEM19             "ICD-10-CM Body system 19"
 I10_BODYSYSTEM20             "ICD-10-CM Body system 20"
 I10_CHRON1                   "ICD-10-CM Chronic condition indicator 1"
 I10_CHRON2                   "ICD-10-CM Chronic condition indicator 2"
 I10_CHRON3                   "ICD-10-CM Chronic condition indicator 3"
 I10_CHRON4                   "ICD-10-CM Chronic condition indicator 4"
 I10_CHRON5                   "ICD-10-CM Chronic condition indicator 5"
 I10_CHRON6                   "ICD-10-CM Chronic condition indicator 6"
 I10_CHRON7                   "ICD-10-CM Chronic condition indicator 7"
 I10_CHRON8                   "ICD-10-CM Chronic condition indicator 8"
 I10_CHRON9                   "ICD-10-CM Chronic condition indicator 9"
 I10_CHRON10                  "ICD-10-CM Chronic condition indicator 10"
 I10_CHRON11                  "ICD-10-CM Chronic condition indicator 11"
 I10_CHRON12                  "ICD-10-CM Chronic condition indicator 12"
 I10_CHRON13                  "ICD-10-CM Chronic condition indicator 13"
 I10_CHRON14                  "ICD-10-CM Chronic condition indicator 14"
 I10_CHRON15                  "ICD-10-CM Chronic condition indicator 15"
 I10_CHRON16                  "ICD-10-CM Chronic condition indicator 16"
 I10_CHRON17                  "ICD-10-CM Chronic condition indicator 17"
 I10_CHRON18                  "ICD-10-CM Chronic condition indicator 18"
 I10_CHRON19                  "ICD-10-CM Chronic condition indicator 19"
 I10_CHRON20                  "ICD-10-CM Chronic condition indicator 20"
 I10_DXMCCS1                  "ICD-10-CM Multi-Level CCS:  Diagnosis 1"
 I10_DXMCCS2                  "ICD-10-CM Multi-Level CCS:  Diagnosis 2"
 I10_DXMCCS3                  "ICD-10-CM Multi-Level CCS:  Diagnosis 3"
 I10_DXMCCS4                  "ICD-10-CM Multi-Level CCS:  Diagnosis 4"
 I10_DXMCCS5                  "ICD-10-CM Multi-Level CCS:  Diagnosis 5"
 I10_DXMCCS6                  "ICD-10-CM Multi-Level CCS:  Diagnosis 6"
 I10_DXMCCS7                  "ICD-10-CM Multi-Level CCS:  Diagnosis 7"
 I10_DXMCCS8                  "ICD-10-CM Multi-Level CCS:  Diagnosis 8"
 I10_DXMCCS9                  "ICD-10-CM Multi-Level CCS:  Diagnosis 9"
 I10_DXMCCS10                 "ICD-10-CM Multi-Level CCS:  Diagnosis 10"
 I10_DXMCCS11                 "ICD-10-CM Multi-Level CCS:  Diagnosis 11"
 I10_DXMCCS12                 "ICD-10-CM Multi-Level CCS:  Diagnosis 12"
 I10_DXMCCS13                 "ICD-10-CM Multi-Level CCS:  Diagnosis 13"
 I10_DXMCCS14                 "ICD-10-CM Multi-Level CCS:  Diagnosis 14"
 I10_DXMCCS15                 "ICD-10-CM Multi-Level CCS:  Diagnosis 15"
 I10_DXMCCS16                 "ICD-10-CM Multi-Level CCS:  Diagnosis 16"
 I10_DXMCCS17                 "ICD-10-CM Multi-Level CCS:  Diagnosis 17"
 I10_DXMCCS18                 "ICD-10-CM Multi-Level CCS:  Diagnosis 18"
 I10_DXMCCS19                 "ICD-10-CM Multi-Level CCS:  Diagnosis 19"
 I10_DXMCCS20                 "ICD-10-CM Multi-Level CCS:  Diagnosis 20"
 I10_ECauseMCCS1              "ICD-10-CM Multi-Level CCS:  E Cause 1"
 I10_ECauseMCCS2              "ICD-10-CM Multi-Level CCS:  E Cause 2"
 I10_ECauseMCCS3              "ICD-10-CM Multi-Level CCS:  E Cause 3"
 I10_ECauseMCCS4              "ICD-10-CM Multi-Level CCS:  E Cause 4"
 I10_ECauseMCCS5              "ICD-10-CM Multi-Level CCS:  E Cause 5"
 I10_ECauseMCCS6              "ICD-10-CM Multi-Level CCS:  E Cause 6"
 I10_ECauseMCCS7              "ICD-10-CM Multi-Level CCS:  E Cause 7"
 I10_ECauseMCCS8              "ICD-10-CM Multi-Level CCS:  E Cause 8"
 I10_ECauseMCCS9              "ICD-10-CM Multi-Level CCS:  E Cause 9"
 I10_ECauseMCCS10             "ICD-10-CM Multi-Level CCS:  E Cause 10"
 I10_ECauseMCCS11             "ICD-10-CM Multi-Level CCS:  E Cause 11"
 I10_INJURY

"ICD-10-CM Injury diagnosis reported on record (1:I10_DX1 is an injury; 2:I10_DX2+ is an inj
ury; 0:No injury)"
 I10_MULTINJURY               "ICD-10-CM More than one injury diagnosis reported on record"
 I10_PCLASS1                  "ICD-10-PCS Procedure class 1"
 I10_PCLASS2                  "ICD-10-PCS Procedure class 2"
 I10_PCLASS3                  "ICD-10-PCS Procedure class 3"
 I10_PCLASS4                  "ICD-10-PCS Procedure class 4"
 I10_PCLASS5                  "ICD-10-PCS Procedure class 5"
 I10_PCLASS6                  "ICD-10-PCS Procedure class 6"
 I10_PCLASS7                  "ICD-10-PCS Procedure class 7"
 I10_PCLASS8                  "ICD-10-PCS Procedure class 8"
 I10_PCLASS9                  "ICD-10-PCS Procedure class 9"
 I10_PCLASS10                 "ICD-10-PCS Procedure class 10"
 I10_PCLASS11                 "ICD-10-PCS Procedure class 11"
 I10_PCLASS12                 "ICD-10-PCS Procedure class 12"
 I10_PCLASS13                 "ICD-10-PCS Procedure class 13"
 I10_PCLASS14                 "ICD-10-PCS Procedure class 14"
 I10_PCLASS15                 "ICD-10-PCS Procedure class 15"
 I10_PCLASS16                 "ICD-10-PCS Procedure class 16"
 I10_PCLASS17                 "ICD-10-PCS Procedure class 17"
 I10_PCLASS18                 "ICD-10-PCS Procedure class 18"
 I10_PCLASS19                 "ICD-10-PCS Procedure class 19"
 I10_PCLASS20                 "ICD-10-PCS Procedure class 20"
 I10_PRMCCS1                  "ICD-10-PCS Multi-Level CCS:  Procedure 1"
 I10_PRMCCS2                  "ICD-10-PCS Multi-Level CCS:  Procedure 2"
 I10_PRMCCS3                  "ICD-10-PCS Multi-Level CCS:  Procedure 3"
 I10_PRMCCS4                  "ICD-10-PCS Multi-Level CCS:  Procedure 4"
 I10_PRMCCS5                  "ICD-10-PCS Multi-Level CCS:  Procedure 5"
 I10_PRMCCS6                  "ICD-10-PCS Multi-Level CCS:  Procedure 6"
 I10_PRMCCS7                  "ICD-10-PCS Multi-Level CCS:  Procedure 7"
 I10_PRMCCS8                  "ICD-10-PCS Multi-Level CCS:  Procedure 8"
 I10_PRMCCS9                  "ICD-10-PCS Multi-Level CCS:  Procedure 9"
 I10_PRMCCS10                 "ICD-10-PCS Multi-Level CCS:  Procedure 10"
 I10_PRMCCS11                 "ICD-10-PCS Multi-Level CCS:  Procedure 11"
 I10_PRMCCS12                 "ICD-10-PCS Multi-Level CCS:  Procedure 12"
 I10_PRMCCS13                 "ICD-10-PCS Multi-Level CCS:  Procedure 13"
 I10_PRMCCS14                 "ICD-10-PCS Multi-Level CCS:  Procedure 14"
 I10_PRMCCS15                 "ICD-10-PCS Multi-Level CCS:  Procedure 15"
 I10_PRMCCS16                 "ICD-10-PCS Multi-Level CCS:  Procedure 16"
 I10_PRMCCS17                 "ICD-10-PCS Multi-Level CCS:  Procedure 17"
 I10_PRMCCS18                 "ICD-10-PCS Multi-Level CCS:  Procedure 18"
 I10_PRMCCS19                 "ICD-10-PCS Multi-Level CCS:  Procedure 19"
 I10_PRMCCS20                 "ICD-10-PCS Multi-Level CCS:  Procedure 20"
 I10_U_BLOOD                  "ICD-10-PCS Utilization Flag: Blood"
 I10_U_CATH                   "ICD-10-PCS Utilization Flag: Cardiac Catheterization Lab"
 I10_U_CTSCAN                 "ICD-10-PCS Utilization Flag: Computed Tomography Scan"
 I10_U_EKG                    "ICD-10-PCS Utilization Flag: Electrocardiogram"
 I10_U_MHSA
"ICD-10-PCS Utilization Flag: Mental Health and Substance Abuse"
 I10_U_MRT                    "ICD-10-PCS Utilization Flag: Magnetic Resonance Technology"
 I10_U_PACEMAKER              "ICD-10-PCS Utilization Flag: Pacemaker"
 I10_U_PHYTHERAPY             "ICD-10-PCS Utilization Flag: Physical Therapy"
 I10_U_RADTHERAPY
"ICD-10-PCS Utilization Flag: Radiology - Therapeutic and/or Chemotherapy Administration"
 I10_U_STRESS                 "ICD-10-PCS Utilization Flag: Cardiac Stress Test"
 KEY                          "HCUP record identifier"
 U_CCU                        "Utilization Flag: Coronary Care Unit (CCU)"
 U_CHESTXRAY                  "Utilization Flag: Chest X-Ray"
 U_DIALYSIS                   "Utilization Flag: Renal Dialysis"
 U_ECHO                       "Utilization Flag: Echocardiology"
 U_ED                         "Utilization Flag: Emergency Room"
 U_EEG                        "Utilization Flag: Electroencephalogram"
 U_EPO                        "Utilization Flag: EPO"
 U_ICU                        "Utilization Flag: Intensive Care Unit (ICU)"
 U_LITHOTRIPSY                "Utilization Flag: Lithotripsy"
 U_NEWBN2L                    "Utilization Flag: Nursery Level II"
 U_NEWBN3L                    "Utilization Flag: Nursery Level III"
 U_NEWBN4L                    "Utilization Flag: Nursery Level IV"
 U_NUCMED                     "Utilization Flag: Nuclear Medicine"
 U_OBSERVATION                "Utilization Flag: Observation Room"
 U_OCCTHERAPY                 "Utilization Flag: Occupational Therapy"
 U_ORGANACQ                   "Utilization Flag: Organ Acquisition"
 U_OTHIMPLANTS                "Utilization Flag: Other Implants"
 U_RESPTHERAPY                "Utilization Flag: Respiratory Services"
 U_SPEECHTHERAPY              "Utilization Flag: Speech - Language Pathology"
 U_ULTRASOUND                 "Utilization Flag: Ultrasound" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE I10_BODYSYSTEM1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_BODYSYSTEM20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_CHRON20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_INJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_MULTINJURY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS1
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS2
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS3
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS4
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS5
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS6
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS7
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS8
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS9
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS10
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS11
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS12
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS13
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS14
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS15
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS16
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS17
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS18
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS19
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_PCLASS20
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_BLOOD
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CATH
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_CTSCAN
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_EKG
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MHSA
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_MRT
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PACEMAKER
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_PHYTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_RADTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE I10_U_STRESS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CCU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_CHESTXRAY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_DIALYSIS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ECHO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EEG
 (-9,-8,-6,-5=SYSMIS).
RECODE U_EPO
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ICU
 (-9,-8,-6,-5=SYSMIS).
RECODE U_LITHOTRIPSY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN2L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN3L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NEWBN4L
 (-9,-8,-6,-5=SYSMIS).
RECODE U_NUCMED
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OBSERVATION
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OCCTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ORGANACQ
 (-9,-8,-6,-5=SYSMIS).
RECODE U_OTHIMPLANTS
 (-9,-8,-6,-5=SYSMIS).
RECODE U_RESPTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_SPEECHTHERAPY
 (-9,-8,-6,-5=SYSMIS).
RECODE U_ULTRASOUND
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'VT_SASD_2015q4_DX_PR_GRPS.SAV' /COMPRESSED.
