/*******************************************************************
* Creation Date: 10/28/2015   
*   NJ_SASD_2014_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'NJ_SASD_2014_CORE.ASC' FIXED SKIP=2 / 
 AGE                             1-   3
 AGEDAY                          4-   6
 AGEMONTH                        7-   9
 AHOUR                          10-  13
 AMONTH                         14-  15
 ATYPE                          16-  17
 AWEEKEND                       18-  19
 BILLTYPE                       20-  23 (A)
 CPT1                           24-  28 (A)
 CPT2                           29-  33 (A)
 CPT3                           34-  38 (A)
 CPT4                           39-  43 (A)
 CPT5                           44-  48 (A)
 CPT6                           49-  53 (A)
 CPT7                           54-  58 (A)
 CPT8                           59-  63 (A)
 CPT9                           64-  68 (A)
 CPT10                          69-  73 (A)
 CPT11                          74-  78 (A)
 CPT12                          79-  83 (A)
 CPT13                          84-  88 (A)
 CPT14                          89-  93 (A)
 CPT15                          94-  98 (A)
 CPT16                          99- 103 (A)
 CPT17                         104- 108 (A)
 CPT18                         109- 113 (A)
 CPT19                         114- 118 (A)
 CPT20                         119- 123 (A)
 CPT21                         124- 128 (A)
 CPT22                         129- 133 (A)
 CPT23                         134- 138 (A)
 CPT24                         139- 143 (A)
 CPT25                         144- 148 (A)
 CPT26                         149- 153 (A)
 CPT27                         154- 158 (A)
 CPT28                         159- 163 (A)
 CPT29                         164- 168 (A)
 CPT30                         169- 173 (A)
 CPT31                         174- 178 (A)
 CPT32                         179- 183 (A)
 CPT33                         184- 188 (A)
 CPT34                         189- 193 (A)
 CPT35                         194- 198 (A)
 CPT36                         199- 203 (A)
 CPT37                         204- 208 (A)
 CPT38                         209- 213 (A)
 CPT39                         214- 218 (A)
 CPT40                         219- 223 (A)
 CPT41                         224- 228 (A)
 CPT42                         229- 233 (A)
 CPT43                         234- 238 (A)
 CPT44                         239- 243 (A)
 CPT45                         244- 248 (A)
 CPT46                         249- 253 (A)
 CPT47                         254- 258 (A)
 CPT48                         259- 263 (A)
 CPT49                         264- 268 (A)
 CPT50                         269- 273 (A)
 CPTCCS1                       274- 276
 CPTCCS2                       277- 279
 CPTCCS3                       280- 282
 CPTCCS4                       283- 285
 CPTCCS5                       286- 288
 CPTCCS6                       289- 291
 CPTCCS7                       292- 294
 CPTCCS8                       295- 297
 CPTCCS9                       298- 300
 CPTCCS10                      301- 303
 CPTCCS11                      304- 306
 CPTCCS12                      307- 309
 CPTCCS13                      310- 312
 CPTCCS14                      313- 315
 CPTCCS15                      316- 318
 CPTCCS16                      319- 321
 CPTCCS17                      322- 324
 CPTCCS18                      325- 327
 CPTCCS19                      328- 330
 CPTCCS20                      331- 333
 CPTCCS21                      334- 336
 CPTCCS22                      337- 339
 CPTCCS23                      340- 342
 CPTCCS24                      343- 345
 CPTCCS25                      346- 348
 CPTCCS26                      349- 351
 CPTCCS27                      352- 354
 CPTCCS28                      355- 357
 CPTCCS29                      358- 360
 CPTCCS30                      361- 363
 CPTCCS31                      364- 366
 CPTCCS32                      367- 369
 CPTCCS33                      370- 372
 CPTCCS34                      373- 375
 CPTCCS35                      376- 378
 CPTCCS36                      379- 381
 CPTCCS37                      382- 384
 CPTCCS38                      385- 387
 CPTCCS39                      388- 390
 CPTCCS40                      391- 393
 CPTCCS41                      394- 396
 CPTCCS42                      397- 399
 CPTCCS43                      400- 402
 CPTCCS44                      403- 405
 CPTCCS45                      406- 408
 CPTCCS46                      409- 411
 CPTCCS47                      412- 414
 CPTCCS48                      415- 417
 CPTCCS49                      418- 420
 CPTCCS50                      421- 423
 CPTM1_1                       424- 425 (A)
 CPTM1_2                       426- 427 (A)
 CPTM1_3                       428- 429 (A)
 CPTM1_4                       430- 431 (A)
 CPTM1_5                       432- 433 (A)
 CPTM1_6                       434- 435 (A)
 CPTM1_7                       436- 437 (A)
 CPTM1_8                       438- 439 (A)
 CPTM1_9                       440- 441 (A)
 CPTM1_10                      442- 443 (A)
 CPTM1_11                      444- 445 (A)
 CPTM1_12                      446- 447 (A)
 CPTM1_13                      448- 449 (A)
 CPTM1_14                      450- 451 (A)
 CPTM1_15                      452- 453 (A)
 CPTM1_16                      454- 455 (A)
 CPTM1_17                      456- 457 (A)
 CPTM1_18                      458- 459 (A)
 CPTM1_19                      460- 461 (A)
 CPTM1_20                      462- 463 (A)
 CPTM1_21                      464- 465 (A)
 CPTM1_22                      466- 467 (A)
 CPTM1_23                      468- 469 (A)
 CPTM1_24                      470- 471 (A)
 CPTM1_25                      472- 473 (A)
 CPTM1_26                      474- 475 (A)
 CPTM1_27                      476- 477 (A)
 CPTM1_28                      478- 479 (A)
 CPTM1_29                      480- 481 (A)
 CPTM1_30                      482- 483 (A)
 CPTM1_31                      484- 485 (A)
 CPTM1_32                      486- 487 (A)
 CPTM1_33                      488- 489 (A)
 CPTM1_34                      490- 491 (A)
 CPTM1_35                      492- 493 (A)
 CPTM1_36                      494- 495 (A)
 CPTM1_37                      496- 497 (A)
 CPTM1_38                      498- 499 (A)
 CPTM1_39                      500- 501 (A)
 CPTM1_40                      502- 503 (A)
 CPTM1_41                      504- 505 (A)
 CPTM1_42                      506- 507 (A)
 CPTM1_43                      508- 509 (A)
 CPTM1_44                      510- 511 (A)
 CPTM1_45                      512- 513 (A)
 CPTM1_46                      514- 515 (A)
 CPTM1_47                      516- 517 (A)
 CPTM1_48                      518- 519 (A)
 CPTM1_49                      520- 521 (A)
 CPTM1_50                      522- 523 (A)
 CPTM2_1                       524- 525 (A)
 CPTM2_2                       526- 527 (A)
 CPTM2_3                       528- 529 (A)
 CPTM2_4                       530- 531 (A)
 CPTM2_5                       532- 533 (A)
 CPTM2_6                       534- 535 (A)
 CPTM2_7                       536- 537 (A)
 CPTM2_8                       538- 539 (A)
 CPTM2_9                       540- 541 (A)
 CPTM2_10                      542- 543 (A)
 CPTM2_11                      544- 545 (A)
 CPTM2_12                      546- 547 (A)
 CPTM2_13                      548- 549 (A)
 CPTM2_14                      550- 551 (A)
 CPTM2_15                      552- 553 (A)
 CPTM2_16                      554- 555 (A)
 CPTM2_17                      556- 557 (A)
 CPTM2_18                      558- 559 (A)
 CPTM2_19                      560- 561 (A)
 CPTM2_20                      562- 563 (A)
 CPTM2_21                      564- 565 (A)
 CPTM2_22                      566- 567 (A)
 CPTM2_23                      568- 569 (A)
 CPTM2_24                      570- 571 (A)
 CPTM2_25                      572- 573 (A)
 CPTM2_26                      574- 575 (A)
 CPTM2_27                      576- 577 (A)
 CPTM2_28                      578- 579 (A)
 CPTM2_29                      580- 581 (A)
 CPTM2_30                      582- 583 (A)
 CPTM2_31                      584- 585 (A)
 CPTM2_32                      586- 587 (A)
 CPTM2_33                      588- 589 (A)
 CPTM2_34                      590- 591 (A)
 CPTM2_35                      592- 593 (A)
 CPTM2_36                      594- 595 (A)
 CPTM2_37                      596- 597 (A)
 CPTM2_38                      598- 599 (A)
 CPTM2_39                      600- 601 (A)
 CPTM2_40                      602- 603 (A)
 CPTM2_41                      604- 605 (A)
 CPTM2_42                      606- 607 (A)
 CPTM2_43                      608- 609 (A)
 CPTM2_44                      610- 611 (A)
 CPTM2_45                      612- 613 (A)
 CPTM2_46                      614- 615 (A)
 CPTM2_47                      616- 617 (A)
 CPTM2_48                      618- 619 (A)
 CPTM2_49                      620- 621 (A)
 CPTM2_50                      622- 623 (A)
 DHOUR                         624- 627
 DIED                          628- 629
 DISPUB04                      630- 631
 DISPUNIFORM                   632- 633
 DISP_X                        634- 635 (A)
 DMONTH                        636- 637
 DQTR                          638- 639
 DSHOSPID                      640- 656 (A)
 DURATION                      657- 662
 DX1                           663- 669 (A)
 DX2                           670- 676 (A)
 DX3                           677- 683 (A)
 DX4                           684- 690 (A)
 DX5                           691- 697 (A)
 DX6                           698- 704 (A)
 DX7                           705- 711 (A)
 DX8                           712- 718 (A)
 DX9                           719- 725 (A)
 DX10                          726- 732 (A)
 DX11                          733- 739 (A)
 DX12                          740- 746 (A)
 DX13                          747- 753 (A)
 DX14                          754- 760 (A)
 DX15                          761- 767 (A)
 DX16                          768- 774 (A)
 DX17                          775- 781 (A)
 DX18                          782- 788 (A)
 DX19                          789- 795 (A)
 DX20                          796- 802 (A)
 DX21                          803- 809 (A)
 DX22                          810- 816 (A)
 DX23                          817- 823 (A)
 DX24                          824- 830 (A)
 DXCCS1                        831- 834
 DXCCS2                        835- 838
 DXCCS3                        839- 842
 DXCCS4                        843- 846
 DXCCS5                        847- 850
 DXCCS6                        851- 854
 DXCCS7                        855- 858
 DXCCS8                        859- 862
 DXCCS9                        863- 866
 DXCCS10                       867- 870
 DXCCS11                       871- 874
 DXCCS12                       875- 878
 DXCCS13                       879- 882
 DXCCS14                       883- 886
 DXCCS15                       887- 890
 DXCCS16                       891- 894
 DXCCS17                       895- 898
 DXCCS18                       899- 902
 DXCCS19                       903- 906
 DXCCS20                       907- 910
 DXCCS21                       911- 914
 DXCCS22                       915- 918
 DXCCS23                       919- 922
 DXCCS24                       923- 926
 DXPOA1                        927     (A)
 DXPOA2                        928     (A)
 DXPOA3                        929     (A)
 DXPOA4                        930     (A)
 DXPOA5                        931     (A)
 DXPOA6                        932     (A)
 DXPOA7                        933     (A)
 DXPOA8                        934     (A)
 DXPOA9                        935     (A)
 DXPOA10                       936     (A)
 DXPOA11                       937     (A)
 DXPOA12                       938     (A)
 DXPOA13                       939     (A)
 DXPOA14                       940     (A)
 DXPOA15                       941     (A)
 DXPOA16                       942     (A)
 DXPOA17                       943     (A)
 DXPOA18                       944     (A)
 DXPOA19                       945     (A)
 DXPOA20                       946     (A)
 DXPOA21                       947     (A)
 DXPOA22                       948     (A)
 DXPOA23                       949     (A)
 DXPOA24                       950     (A)
 DXVER                         951- 953
 DX_Visit_Reason1              954- 960 (A)
 DX_Visit_Reason2              961- 967 (A)
 DX_Visit_Reason3              968- 974 (A)
 ECODE1                        975- 981 (A)
 ECODE2                        982- 988 (A)
 ECODE3                        989- 995 (A)
 ECODE4                        996-1002 (A)
 ECODE5                       1003-1009 (A)
 ECODE6                       1010-1016 (A)
 ECODE7                       1017-1023 (A)
 ECODE8                       1024-1030 (A)
 ECODE9                       1031-1037 (A)
 ECODE10                      1038-1044 (A)
 ECODE11                      1045-1051 (A)
 ECODE12                      1052-1058 (A)
 E_CCS1                       1059-1062
 E_CCS2                       1063-1066
 E_CCS3                       1067-1070
 E_CCS4                       1071-1074
 E_CCS5                       1075-1078
 E_CCS6                       1079-1082
 E_CCS7                       1083-1086
 E_CCS8                       1087-1090
 E_CCS9                       1091-1094
 E_CCS10                      1095-1098
 E_CCS11                      1099-1102
 E_CCS12                      1103-1106
 E_POA1                       1107     (A)
 E_POA2                       1108     (A)
 E_POA3                       1109     (A)
 E_POA4                       1110     (A)
 E_POA5                       1111     (A)
 E_POA6                       1112     (A)
 E_POA7                       1113     (A)
 E_POA8                       1114     (A)
 E_POA9                       1115     (A)
 E_POA10                      1116     (A)
 E_POA11                      1117     (A)
 E_POA12                      1118     (A)
 FEMALE                       1119-1120
 HCUP_ED                      1121-1122
 HCUP_OS                      1123-1124
 HISPANIC_X                   1125-1129 (A)
 HOSPBRTH                     1130-1132
 HOSPST                       1133-1134 (A)
 KEY                          1135-1149
 LOS                          1150-1154
 LOS_X                        1155-1160
 MARITALSTATUSUB04            1161     (A)
 MDNUM1_R                     1162-1170
 MDNUM2_R                     1171-1179
 MEDINCSTQ                    1180-1181
 MOMNUM_R                     1182-1190
 MRN_R                        1191-1199
 NCHRONIC                     1200-1202
 NCPT                         1203-1206
 NDX                          1207-1209
 NECODE                       1210-1211
 NEOMAT                       1212-1213
 NPR                          1214-1216
 OPservice                    1217     (A)
 ORPROC                       1218-1219
 OS_TIME                      1220-1227
 PAY1                         1228-1229
 PAY1_X                       1230-1232 (A)
 PAY2                         1233-1234
 PAY2_X                       1235-1237 (A)
 PAY3                         1238-1239
 PAY3_X                       1240-1242 (A)
 PL_CBSA                      1243-1245
 PL_NCHS                      1246-1247
 PL_RUCC                      1248-1249
 PL_UIC                       1250-1251
 PL_UR_CAT4                   1252-1253
 POA_Disch_Edit1              1254-1255
 POA_Disch_Edit2              1256-1257
 POA_Hosp_Edit1               1258-1259
 POA_Hosp_Edit2               1260-1261
 POA_Hosp_Edit3               1262-1263
 POA_Hosp_Edit3_Value         1264-1271
 PR1                          1272-1278 (A)
 PR2                          1279-1285 (A)
 PR3                          1286-1292 (A)
 PR4                          1293-1299 (A)
 PR5                          1300-1306 (A)
 PR6                          1307-1313 (A)
 PR7                          1314-1320 (A)
 PR8                          1321-1327 (A)
 PR9                          1328-1334 (A)
 PR10                         1335-1341 (A)
 PR11                         1342-1348 (A)
 PR12                         1349-1355 (A)
 PR13                         1356-1362 (A)
 PR14                         1363-1369 (A)
 PR15                         1370-1376 (A)
 PR16                         1377-1383 (A)
 PR17                         1384-1390 (A)
 PR18                         1391-1397 (A)
 PR19                         1398-1404 (A)
 PR20                         1405-1411 (A)
 PRCCS1                       1412-1414
 PRCCS2                       1415-1417
 PRCCS3                       1418-1420
 PRCCS4                       1421-1423
 PRCCS5                       1424-1426
 PRCCS6                       1427-1429
 PRCCS7                       1430-1432
 PRCCS8                       1433-1435
 PRCCS9                       1436-1438
 PRCCS10                      1439-1441
 PRCCS11                      1442-1444
 PRCCS12                      1445-1447
 PRCCS13                      1448-1450
 PRCCS14                      1451-1453
 PRCCS15                      1454-1456
 PRCCS16                      1457-1459
 PRCCS17                      1460-1462
 PRCCS18                      1463-1465
 PRCCS19                      1466-1468
 PRCCS20                      1469-1471
 PRDAY1                       1472-1476
 PRDAY2                       1477-1481
 PRDAY3                       1482-1486
 PRDAY4                       1487-1491
 PRDAY5                       1492-1496
 PRDAY6                       1497-1501
 PRDAY7                       1502-1506
 PRDAY8                       1507-1511
 PRDAY9                       1512-1516
 PRDAY10                      1517-1521
 PRDAY11                      1522-1526
 PRDAY12                      1527-1531
 PRDAY13                      1532-1536
 PRDAY14                      1537-1541
 PRDAY15                      1542-1546
 PRDAY16                      1547-1551
 PRDAY17                      1552-1556
 PRDAY18                      1557-1561
 PRDAY19                      1562-1566
 PRDAY20                      1567-1571
 PROCTYPE                     1572-1574
 PRVER                        1575-1577
 PSTATE                       1578-1579 (A)
 PSTCO                        1580-1584
 PSTCO2                       1585-1589
 PointOfOriginUB04            1590     (A)
 PointOfOrigin_X              1591     (A)
 PrimLang                     1592-1594 (A)
 RACE                         1595-1596
 RACE_X                       1597-1601 (A)
 READMIT                      1602-1603
 STATE_AS                     1604-1605
 STATE_ED                     1606-1607
 STATE_OS                     1608-1609
 TOTCHG                       1610-1619
 TOTCHG_X                     1620-1634
 YEAR                         1635-1638
 ZIP                          1639-1643 (A)
 ZIP3                         1644-1646 (A)
 ZIPINC_QRTL                  1647-1649
 TOWN                         1650-1653 (A)
 AYEAR                        1654-1657
 BMONTH                       1658-1659
 BYEAR                        1660-1663
 PRMONTH1                     1664-1665
 PRMONTH2                     1666-1667
 PRMONTH3                     1668-1669
 PRMONTH4                     1670-1671
 PRMONTH5                     1672-1673
 PRMONTH6                     1674-1675
 PRMONTH7                     1676-1677
 PRMONTH8                     1678-1679
 PRMONTH9                     1680-1681
 PRMONTH10                    1682-1683
 PRMONTH11                    1684-1685
 PRMONTH12                    1686-1687
 PRMONTH13                    1688-1689
 PRMONTH14                    1690-1691
 PRMONTH15                    1692-1693
 PRMONTH16                    1694-1695
 PRMONTH17                    1696-1697
 PRMONTH18                    1698-1699
 PRMONTH19                    1700-1701
 PRMONTH20                    1702-1703
 PRYEAR1                      1704-1707
 PRYEAR2                      1708-1711
 PRYEAR3                      1712-1715
 PRYEAR4                      1716-1719
 PRYEAR5                      1720-1723
 PRYEAR6                      1724-1727
 PRYEAR7                      1728-1731
 PRYEAR8                      1732-1735
 PRYEAR9                      1736-1739
 PRYEAR10                     1740-1743
 PRYEAR11                     1744-1747
 PRYEAR12                     1748-1751
 PRYEAR13                     1752-1755
 PRYEAR14                     1756-1759
 PRYEAR15                     1760-1763
 PRYEAR16                     1764-1767
 PRYEAR17                     1768-1771
 PRYEAR18                     1772-1775
 PRYEAR19                     1776-1779
 PRYEAR20                     1780-1783.


***  Specify write formats  ***.
FORMATS
 AGE                          (F3.0) /
 AGEDAY                       (F3.0) /
 AGEMONTH                     (F3.0) /
 AHOUR                        (F3.0) /
 AMONTH                       (F3.0) /
 ATYPE                        (F3.0) /
 AWEEKEND                     (F3.0) /
 CPTCCS1                      (F4.0) /
 CPTCCS2                      (F4.0) /
 CPTCCS3                      (F4.0) /
 CPTCCS4                      (F4.0) /
 CPTCCS5                      (F4.0) /
 CPTCCS6                      (F4.0) /
 CPTCCS7                      (F4.0) /
 CPTCCS8                      (F4.0) /
 CPTCCS9                      (F4.0) /
 CPTCCS10                     (F4.0) /
 CPTCCS11                     (F4.0) /
 CPTCCS12                     (F4.0) /
 CPTCCS13                     (F4.0) /
 CPTCCS14                     (F4.0) /
 CPTCCS15                     (F4.0) /
 CPTCCS16                     (F4.0) /
 CPTCCS17                     (F4.0) /
 CPTCCS18                     (F4.0) /
 CPTCCS19                     (F4.0) /
 CPTCCS20                     (F4.0) /
 CPTCCS21                     (F4.0) /
 CPTCCS22                     (F4.0) /
 CPTCCS23                     (F4.0) /
 CPTCCS24                     (F4.0) /
 CPTCCS25                     (F4.0) /
 CPTCCS26                     (F4.0) /
 CPTCCS27                     (F4.0) /
 CPTCCS28                     (F4.0) /
 CPTCCS29                     (F4.0) /
 CPTCCS30                     (F4.0) /
 CPTCCS31                     (F4.0) /
 CPTCCS32                     (F4.0) /
 CPTCCS33                     (F4.0) /
 CPTCCS34                     (F4.0) /
 CPTCCS35                     (F4.0) /
 CPTCCS36                     (F4.0) /
 CPTCCS37                     (F4.0) /
 CPTCCS38                     (F4.0) /
 CPTCCS39                     (F4.0) /
 CPTCCS40                     (F4.0) /
 CPTCCS41                     (F4.0) /
 CPTCCS42                     (F4.0) /
 CPTCCS43                     (F4.0) /
 CPTCCS44                     (F4.0) /
 CPTCCS45                     (F4.0) /
 CPTCCS46                     (F4.0) /
 CPTCCS47                     (F4.0) /
 CPTCCS48                     (F4.0) /
 CPTCCS49                     (F4.0) /
 CPTCCS50                     (F4.0) /
 DHOUR                        (F3.0) /
 DIED                         (F3.0) /
 DISPUB04                     (F3.0) /
 DISPUNIFORM                  (F3.0) /
 DMONTH                       (F3.0) /
 DQTR                         (F3.0) /
 DURATION                     (F4.0) /
 DXCCS1                       (F4.0) /
 DXCCS2                       (F4.0) /
 DXCCS3                       (F4.0) /
 DXCCS4                       (F4.0) /
 DXCCS5                       (F4.0) /
 DXCCS6                       (F4.0) /
 DXCCS7                       (F4.0) /
 DXCCS8                       (F4.0) /
 DXCCS9                       (F4.0) /
 DXCCS10                      (F4.0) /
 DXCCS11                      (F4.0) /
 DXCCS12                      (F4.0) /
 DXCCS13                      (F4.0) /
 DXCCS14                      (F4.0) /
 DXCCS15                      (F4.0) /
 DXCCS16                      (F4.0) /
 DXCCS17                      (F4.0) /
 DXCCS18                      (F4.0) /
 DXCCS19                      (F4.0) /
 DXCCS20                      (F4.0) /
 DXCCS21                      (F4.0) /
 DXCCS22                      (F4.0) /
 DXCCS23                      (F4.0) /
 DXCCS24                      (F4.0) /
 DXVER                        (F3.0) /
 E_CCS1                       (F3.0) /
 E_CCS2                       (F3.0) /
 E_CCS3                       (F3.0) /
 E_CCS4                       (F3.0) /
 E_CCS5                       (F3.0) /
 E_CCS6                       (F3.0) /
 E_CCS7                       (F3.0) /
 E_CCS8                       (F3.0) /
 E_CCS9                       (F3.0) /
 E_CCS10                      (F3.0) /
 E_CCS11                      (F3.0) /
 E_CCS12                      (F3.0) /
 FEMALE                       (F3.0) /
 HCUP_ED                      (F3.0) /
 HCUP_OS                      (F3.0) /
 HOSPBRTH                     (F3.0) /
 KEY                          (F8.0) /
 LOS                          (F4.0) /
 LOS_X                        (F4.0) /
 MDNUM1_R                     (F5.0) /
 MDNUM2_R                     (F5.0) /
 MEDINCSTQ                    (F3.0) /
 MOMNUM_R                     (F5.0) /
 MRN_R                        (F5.0) /
 NCHRONIC                     (F3.0) /
 NCPT                         (F3.0) /
 NDX                          (F3.0) /
 NECODE                       (F3.0) /
 NEOMAT                       (F3.0) /
 NPR                          (F3.0) /
 ORPROC                       (F3.0) /
 OS_TIME                      (F4.0) /
 PAY1                         (F3.0) /
 PAY2                         (F3.0) /
 PAY3                         (F3.0) /
 PL_CBSA                      (F3.0) /
 PL_NCHS                      (F3.0) /
 PL_RUCC                      (F3.0) /
 PL_UIC                       (F3.0) /
 PL_UR_CAT4                   (F3.0) /
 POA_Disch_Edit1              (F3.0) /
 POA_Disch_Edit2              (F3.0) /
 POA_Hosp_Edit1               (F3.0) /
 POA_Hosp_Edit2               (F3.0) /
 POA_Hosp_Edit3               (F3.0) /
 POA_Hosp_Edit3_Value         (F8.2) /
 PRCCS1                       (F3.0) /
 PRCCS2                       (F3.0) /
 PRCCS3                       (F3.0) /
 PRCCS4                       (F3.0) /
 PRCCS5                       (F3.0) /
 PRCCS6                       (F3.0) /
 PRCCS7                       (F3.0) /
 PRCCS8                       (F3.0) /
 PRCCS9                       (F3.0) /
 PRCCS10                      (F3.0) /
 PRCCS11                      (F3.0) /
 PRCCS12                      (F3.0) /
 PRCCS13                      (F3.0) /
 PRCCS14                      (F3.0) /
 PRCCS15                      (F3.0) /
 PRCCS16                      (F3.0) /
 PRCCS17                      (F3.0) /
 PRCCS18                      (F3.0) /
 PRCCS19                      (F3.0) /
 PRCCS20                      (F3.0) /
 PRDAY1                       (F4.0) /
 PRDAY2                       (F4.0) /
 PRDAY3                       (F4.0) /
 PRDAY4                       (F4.0) /
 PRDAY5                       (F4.0) /
 PRDAY6                       (F4.0) /
 PRDAY7                       (F4.0) /
 PRDAY8                       (F4.0) /
 PRDAY9                       (F4.0) /
 PRDAY10                      (F4.0) /
 PRDAY11                      (F4.0) /
 PRDAY12                      (F4.0) /
 PRDAY13                      (F4.0) /
 PRDAY14                      (F4.0) /
 PRDAY15                      (F4.0) /
 PRDAY16                      (F4.0) /
 PRDAY17                      (F4.0) /
 PRDAY18                      (F4.0) /
 PRDAY19                      (F4.0) /
 PRDAY20                      (F4.0) /
 PROCTYPE                     (F3.0) /
 PRVER                        (F3.0) /
 PSTCO                        (F4.0) /
 PSTCO2                       (F4.0) /
 RACE                         (F3.0) /
 READMIT                      (F3.0) /
 STATE_AS                     (F3.0) /
 STATE_ED                     (F3.0) /
 STATE_OS                     (F3.0) /
 TOTCHG                       (F6.0) /
 TOTCHG_X                     (F7.2) /
 YEAR                         (F3.0) /
 ZIPINC_QRTL                  (F3.0) /
 AYEAR                        (F3.0) /
 BMONTH                       (F3.0) /
 BYEAR                        (F3.0) /
 PRMONTH1                     (F3.0) /
 PRMONTH2                     (F3.0) /
 PRMONTH3                     (F3.0) /
 PRMONTH4                     (F3.0) /
 PRMONTH5                     (F3.0) /
 PRMONTH6                     (F3.0) /
 PRMONTH7                     (F3.0) /
 PRMONTH8                     (F3.0) /
 PRMONTH9                     (F3.0) /
 PRMONTH10                    (F3.0) /
 PRMONTH11                    (F3.0) /
 PRMONTH12                    (F3.0) /
 PRMONTH13                    (F3.0) /
 PRMONTH14                    (F3.0) /
 PRMONTH15                    (F3.0) /
 PRMONTH16                    (F3.0) /
 PRMONTH17                    (F3.0) /
 PRMONTH18                    (F3.0) /
 PRMONTH19                    (F3.0) /
 PRMONTH20                    (F3.0) /
 PRYEAR1                      (F3.0) /
 PRYEAR2                      (F3.0) /
 PRYEAR3                      (F3.0) /
 PRYEAR4                      (F3.0) /
 PRYEAR5                      (F3.0) /
 PRYEAR6                      (F3.0) /
 PRYEAR7                      (F3.0) /
 PRYEAR8                      (F3.0) /
 PRYEAR9                      (F3.0) /
 PRYEAR10                     (F3.0) /
 PRYEAR11                     (F3.0) /
 PRYEAR12                     (F3.0) /
 PRYEAR13                     (F3.0) /
 PRYEAR14                     (F3.0) /
 PRYEAR15                     (F3.0) /
 PRYEAR16                     (F3.0) /
 PRYEAR17                     (F3.0) /
 PRYEAR18                     (F3.0) /
 PRYEAR19                     (F3.0) /
 PRYEAR20                     (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AGE                          "Age in years at admission"
 AGEDAY                       "Age in days (when age < 1 year)"
 AGEMONTH                     "Age in months (when age < 11 years)"
 AHOUR                        "Admission Hour"
 AMONTH                       "Admission month"
 ATYPE                        "Admission type"
 AWEEKEND                     "Admission day is a weekend"
 BILLTYPE                     "Type of bill, UB-04 coding"
 CPT1                         "CPT/HCPCS procedure code 1"
 CPT2                         "CPT/HCPCS procedure code 2"
 CPT3                         "CPT/HCPCS procedure code 3"
 CPT4                         "CPT/HCPCS procedure code 4"
 CPT5                         "CPT/HCPCS procedure code 5"
 CPT6                         "CPT/HCPCS procedure code 6"
 CPT7                         "CPT/HCPCS procedure code 7"
 CPT8                         "CPT/HCPCS procedure code 8"
 CPT9                         "CPT/HCPCS procedure code 9"
 CPT10                        "CPT/HCPCS procedure code 10"
 CPT11                        "CPT/HCPCS procedure code 11"
 CPT12                        "CPT/HCPCS procedure code 12"
 CPT13                        "CPT/HCPCS procedure code 13"
 CPT14                        "CPT/HCPCS procedure code 14"
 CPT15                        "CPT/HCPCS procedure code 15"
 CPT16                        "CPT/HCPCS procedure code 16"
 CPT17                        "CPT/HCPCS procedure code 17"
 CPT18                        "CPT/HCPCS procedure code 18"
 CPT19                        "CPT/HCPCS procedure code 19"
 CPT20                        "CPT/HCPCS procedure code 20"
 CPT21                        "CPT/HCPCS procedure code 21"
 CPT22                        "CPT/HCPCS procedure code 22"
 CPT23                        "CPT/HCPCS procedure code 23"
 CPT24                        "CPT/HCPCS procedure code 24"
 CPT25                        "CPT/HCPCS procedure code 25"
 CPT26                        "CPT/HCPCS procedure code 26"
 CPT27                        "CPT/HCPCS procedure code 27"
 CPT28                        "CPT/HCPCS procedure code 28"
 CPT29                        "CPT/HCPCS procedure code 29"
 CPT30                        "CPT/HCPCS procedure code 30"
 CPT31                        "CPT/HCPCS procedure code 31"
 CPT32                        "CPT/HCPCS procedure code 32"
 CPT33                        "CPT/HCPCS procedure code 33"
 CPT34                        "CPT/HCPCS procedure code 34"
 CPT35                        "CPT/HCPCS procedure code 35"
 CPT36                        "CPT/HCPCS procedure code 36"
 CPT37                        "CPT/HCPCS procedure code 37"
 CPT38                        "CPT/HCPCS procedure code 38"
 CPT39                        "CPT/HCPCS procedure code 39"
 CPT40                        "CPT/HCPCS procedure code 40"
 CPT41                        "CPT/HCPCS procedure code 41"
 CPT42                        "CPT/HCPCS procedure code 42"
 CPT43                        "CPT/HCPCS procedure code 43"
 CPT44                        "CPT/HCPCS procedure code 44"
 CPT45                        "CPT/HCPCS procedure code 45"
 CPT46                        "CPT/HCPCS procedure code 46"
 CPT47                        "CPT/HCPCS procedure code 47"
 CPT48                        "CPT/HCPCS procedure code 48"
 CPT49                        "CPT/HCPCS procedure code 49"
 CPT50                        "CPT/HCPCS procedure code 50"
 CPTCCS1                      "CCS: CPT 1"
 CPTCCS2                      "CCS: CPT 2"
 CPTCCS3                      "CCS: CPT 3"
 CPTCCS4                      "CCS: CPT 4"
 CPTCCS5                      "CCS: CPT 5"
 CPTCCS6                      "CCS: CPT 6"
 CPTCCS7                      "CCS: CPT 7"
 CPTCCS8                      "CCS: CPT 8"
 CPTCCS9                      "CCS: CPT 9"
 CPTCCS10                     "CCS: CPT 10"
 CPTCCS11                     "CCS: CPT 11"
 CPTCCS12                     "CCS: CPT 12"
 CPTCCS13                     "CCS: CPT 13"
 CPTCCS14                     "CCS: CPT 14"
 CPTCCS15                     "CCS: CPT 15"
 CPTCCS16                     "CCS: CPT 16"
 CPTCCS17                     "CCS: CPT 17"
 CPTCCS18                     "CCS: CPT 18"
 CPTCCS19                     "CCS: CPT 19"
 CPTCCS20                     "CCS: CPT 20"
 CPTCCS21                     "CCS: CPT 21"
 CPTCCS22                     "CCS: CPT 22"
 CPTCCS23                     "CCS: CPT 23"
 CPTCCS24                     "CCS: CPT 24"
 CPTCCS25                     "CCS: CPT 25"
 CPTCCS26                     "CCS: CPT 26"
 CPTCCS27                     "CCS: CPT 27"
 CPTCCS28                     "CCS: CPT 28"
 CPTCCS29                     "CCS: CPT 29"
 CPTCCS30                     "CCS: CPT 30"
 CPTCCS31                     "CCS: CPT 31"
 CPTCCS32                     "CCS: CPT 32"
 CPTCCS33                     "CCS: CPT 33"
 CPTCCS34                     "CCS: CPT 34"
 CPTCCS35                     "CCS: CPT 35"
 CPTCCS36                     "CCS: CPT 36"
 CPTCCS37                     "CCS: CPT 37"
 CPTCCS38                     "CCS: CPT 38"
 CPTCCS39                     "CCS: CPT 39"
 CPTCCS40                     "CCS: CPT 40"
 CPTCCS41                     "CCS: CPT 41"
 CPTCCS42                     "CCS: CPT 42"
 CPTCCS43                     "CCS: CPT 43"
 CPTCCS44                     "CCS: CPT 44"
 CPTCCS45                     "CCS: CPT 45"
 CPTCCS46                     "CCS: CPT 46"
 CPTCCS47                     "CCS: CPT 47"
 CPTCCS48                     "CCS: CPT 48"
 CPTCCS49                     "CCS: CPT 49"
 CPTCCS50                     "CCS: CPT 50"
 CPTM1_1                      "First CPT-4/HCPCS modifier 1"
 CPTM1_2                      "First CPT-4/HCPCS modifier 2"
 CPTM1_3                      "First CPT-4/HCPCS modifier 3"
 CPTM1_4                      "First CPT-4/HCPCS modifier 4"
 CPTM1_5                      "First CPT-4/HCPCS modifier 5"
 CPTM1_6                      "First CPT-4/HCPCS modifier 6"
 CPTM1_7                      "First CPT-4/HCPCS modifier 7"
 CPTM1_8                      "First CPT-4/HCPCS modifier 8"
 CPTM1_9                      "First CPT-4/HCPCS modifier 9"
 CPTM1_10                     "First CPT-4/HCPCS modifier 10"
 CPTM1_11                     "First CPT-4/HCPCS modifier 11"
 CPTM1_12                     "First CPT-4/HCPCS modifier 12"
 CPTM1_13                     "First CPT-4/HCPCS modifier 13"
 CPTM1_14                     "First CPT-4/HCPCS modifier 14"
 CPTM1_15                     "First CPT-4/HCPCS modifier 15"
 CPTM1_16                     "First CPT-4/HCPCS modifier 16"
 CPTM1_17                     "First CPT-4/HCPCS modifier 17"
 CPTM1_18                     "First CPT-4/HCPCS modifier 18"
 CPTM1_19                     "First CPT-4/HCPCS modifier 19"
 CPTM1_20                     "First CPT-4/HCPCS modifier 20"
 CPTM1_21                     "First CPT-4/HCPCS modifier 21"
 CPTM1_22                     "First CPT-4/HCPCS modifier 22"
 CPTM1_23                     "First CPT-4/HCPCS modifier 23"
 CPTM1_24                     "First CPT-4/HCPCS modifier 24"
 CPTM1_25                     "First CPT-4/HCPCS modifier 25"
 CPTM1_26                     "First CPT-4/HCPCS modifier 26"
 CPTM1_27                     "First CPT-4/HCPCS modifier 27"
 CPTM1_28                     "First CPT-4/HCPCS modifier 28"
 CPTM1_29                     "First CPT-4/HCPCS modifier 29"
 CPTM1_30                     "First CPT-4/HCPCS modifier 30"
 CPTM1_31                     "First CPT-4/HCPCS modifier 31"
 CPTM1_32                     "First CPT-4/HCPCS modifier 32"
 CPTM1_33                     "First CPT-4/HCPCS modifier 33"
 CPTM1_34                     "First CPT-4/HCPCS modifier 34"
 CPTM1_35                     "First CPT-4/HCPCS modifier 35"
 CPTM1_36                     "First CPT-4/HCPCS modifier 36"
 CPTM1_37                     "First CPT-4/HCPCS modifier 37"
 CPTM1_38                     "First CPT-4/HCPCS modifier 38"
 CPTM1_39                     "First CPT-4/HCPCS modifier 39"
 CPTM1_40                     "First CPT-4/HCPCS modifier 40"
 CPTM1_41                     "First CPT-4/HCPCS modifier 41"
 CPTM1_42                     "First CPT-4/HCPCS modifier 42"
 CPTM1_43                     "First CPT-4/HCPCS modifier 43"
 CPTM1_44                     "First CPT-4/HCPCS modifier 44"
 CPTM1_45                     "First CPT-4/HCPCS modifier 45"
 CPTM1_46                     "First CPT-4/HCPCS modifier 46"
 CPTM1_47                     "First CPT-4/HCPCS modifier 47"
 CPTM1_48                     "First CPT-4/HCPCS modifier 48"
 CPTM1_49                     "First CPT-4/HCPCS modifier 49"
 CPTM1_50                     "First CPT-4/HCPCS modifier 50"
 CPTM2_1                      "Second CPT-4/HCPCS modifier 1"
 CPTM2_2                      "Second CPT-4/HCPCS modifier 2"
 CPTM2_3                      "Second CPT-4/HCPCS modifier 3"
 CPTM2_4                      "Second CPT-4/HCPCS modifier 4"
 CPTM2_5                      "Second CPT-4/HCPCS modifier 5"
 CPTM2_6                      "Second CPT-4/HCPCS modifier 6"
 CPTM2_7                      "Second CPT-4/HCPCS modifier 7"
 CPTM2_8                      "Second CPT-4/HCPCS modifier 8"
 CPTM2_9                      "Second CPT-4/HCPCS modifier 9"
 CPTM2_10                     "Second CPT-4/HCPCS modifier 10"
 CPTM2_11                     "Second CPT-4/HCPCS modifier 11"
 CPTM2_12                     "Second CPT-4/HCPCS modifier 12"
 CPTM2_13                     "Second CPT-4/HCPCS modifier 13"
 CPTM2_14                     "Second CPT-4/HCPCS modifier 14"
 CPTM2_15                     "Second CPT-4/HCPCS modifier 15"
 CPTM2_16                     "Second CPT-4/HCPCS modifier 16"
 CPTM2_17                     "Second CPT-4/HCPCS modifier 17"
 CPTM2_18                     "Second CPT-4/HCPCS modifier 18"
 CPTM2_19                     "Second CPT-4/HCPCS modifier 19"
 CPTM2_20                     "Second CPT-4/HCPCS modifier 20"
 CPTM2_21                     "Second CPT-4/HCPCS modifier 21"
 CPTM2_22                     "Second CPT-4/HCPCS modifier 22"
 CPTM2_23                     "Second CPT-4/HCPCS modifier 23"
 CPTM2_24                     "Second CPT-4/HCPCS modifier 24"
 CPTM2_25                     "Second CPT-4/HCPCS modifier 25"
 CPTM2_26                     "Second CPT-4/HCPCS modifier 26"
 CPTM2_27                     "Second CPT-4/HCPCS modifier 27"
 CPTM2_28                     "Second CPT-4/HCPCS modifier 28"
 CPTM2_29                     "Second CPT-4/HCPCS modifier 29"
 CPTM2_30                     "Second CPT-4/HCPCS modifier 30"
 CPTM2_31                     "Second CPT-4/HCPCS modifier 31"
 CPTM2_32                     "Second CPT-4/HCPCS modifier 32"
 CPTM2_33                     "Second CPT-4/HCPCS modifier 33"
 CPTM2_34                     "Second CPT-4/HCPCS modifier 34"
 CPTM2_35                     "Second CPT-4/HCPCS modifier 35"
 CPTM2_36                     "Second CPT-4/HCPCS modifier 36"
 CPTM2_37                     "Second CPT-4/HCPCS modifier 37"
 CPTM2_38                     "Second CPT-4/HCPCS modifier 38"
 CPTM2_39                     "Second CPT-4/HCPCS modifier 39"
 CPTM2_40                     "Second CPT-4/HCPCS modifier 40"
 CPTM2_41                     "Second CPT-4/HCPCS modifier 41"
 CPTM2_42                     "Second CPT-4/HCPCS modifier 42"
 CPTM2_43                     "Second CPT-4/HCPCS modifier 43"
 CPTM2_44                     "Second CPT-4/HCPCS modifier 44"
 CPTM2_45                     "Second CPT-4/HCPCS modifier 45"
 CPTM2_46                     "Second CPT-4/HCPCS modifier 46"
 CPTM2_47                     "Second CPT-4/HCPCS modifier 47"
 CPTM2_48                     "Second CPT-4/HCPCS modifier 48"
 CPTM2_49                     "Second CPT-4/HCPCS modifier 49"
 CPTM2_50                     "Second CPT-4/HCPCS modifier 50"
 DHOUR                        "Discharge Hour"
 DIED                         "Died during hospitalization"
 DISPUB04                     "Disposition of patient (UB-04 standard coding)"
 DISPUNIFORM                  "Disposition of patient (uniform)"
 DISP_X                       "Disposition of patient (as received from source)"
 DMONTH                       "Discharge month"
 DQTR                         "Discharge quarter"
 DSHOSPID                     "Data source hospital identifier"
 DURATION                     "Elapsed time for hospital care in hours and minutes"
 DX1                          "Diagnosis 1"
 DX2                          "Diagnosis 2"
 DX3                          "Diagnosis 3"
 DX4                          "Diagnosis 4"
 DX5                          "Diagnosis 5"
 DX6                          "Diagnosis 6"
 DX7                          "Diagnosis 7"
 DX8                          "Diagnosis 8"
 DX9                          "Diagnosis 9"
 DX10                         "Diagnosis 10"
 DX11                         "Diagnosis 11"
 DX12                         "Diagnosis 12"
 DX13                         "Diagnosis 13"
 DX14                         "Diagnosis 14"
 DX15                         "Diagnosis 15"
 DX16                         "Diagnosis 16"
 DX17                         "Diagnosis 17"
 DX18                         "Diagnosis 18"
 DX19                         "Diagnosis 19"
 DX20                         "Diagnosis 20"
 DX21                         "Diagnosis 21"
 DX22                         "Diagnosis 22"
 DX23                         "Diagnosis 23"
 DX24                         "Diagnosis 24"
 DXCCS1                       "CCS: diagnosis 1"
 DXCCS2                       "CCS: diagnosis 2"
 DXCCS3                       "CCS: diagnosis 3"
 DXCCS4                       "CCS: diagnosis 4"
 DXCCS5                       "CCS: diagnosis 5"
 DXCCS6                       "CCS: diagnosis 6"
 DXCCS7                       "CCS: diagnosis 7"
 DXCCS8                       "CCS: diagnosis 8"
 DXCCS9                       "CCS: diagnosis 9"
 DXCCS10                      "CCS: diagnosis 10"
 DXCCS11                      "CCS: diagnosis 11"
 DXCCS12                      "CCS: diagnosis 12"
 DXCCS13                      "CCS: diagnosis 13"
 DXCCS14                      "CCS: diagnosis 14"
 DXCCS15                      "CCS: diagnosis 15"
 DXCCS16                      "CCS: diagnosis 16"
 DXCCS17                      "CCS: diagnosis 17"
 DXCCS18                      "CCS: diagnosis 18"
 DXCCS19                      "CCS: diagnosis 19"
 DXCCS20                      "CCS: diagnosis 20"
 DXCCS21                      "CCS: diagnosis 21"
 DXCCS22                      "CCS: diagnosis 22"
 DXCCS23                      "CCS: diagnosis 23"
 DXCCS24                      "CCS: diagnosis 24"
 DXPOA1                       "Diagnosis 1, present on admission indicator"
 DXPOA2                       "Diagnosis 2, present on admission indicator"
 DXPOA3                       "Diagnosis 3, present on admission indicator"
 DXPOA4                       "Diagnosis 4, present on admission indicator"
 DXPOA5                       "Diagnosis 5, present on admission indicator"
 DXPOA6                       "Diagnosis 6, present on admission indicator"
 DXPOA7                       "Diagnosis 7, present on admission indicator"
 DXPOA8                       "Diagnosis 8, present on admission indicator"
 DXPOA9                       "Diagnosis 9, present on admission indicator"
 DXPOA10                      "Diagnosis 10, present on admission indicator"
 DXPOA11                      "Diagnosis 11, present on admission indicator"
 DXPOA12                      "Diagnosis 12, present on admission indicator"
 DXPOA13                      "Diagnosis 13, present on admission indicator"
 DXPOA14                      "Diagnosis 14, present on admission indicator"
 DXPOA15                      "Diagnosis 15, present on admission indicator"
 DXPOA16                      "Diagnosis 16, present on admission indicator"
 DXPOA17                      "Diagnosis 17, present on admission indicator"
 DXPOA18                      "Diagnosis 18, present on admission indicator"
 DXPOA19                      "Diagnosis 19, present on admission indicator"
 DXPOA20                      "Diagnosis 20, present on admission indicator"
 DXPOA21                      "Diagnosis 21, present on admission indicator"
 DXPOA22                      "Diagnosis 22, present on admission indicator"
 DXPOA23                      "Diagnosis 23, present on admission indicator"
 DXPOA24                      "Diagnosis 24, present on admission indicator"
 DXVER                        "Diagnosis Version"
 DX_Visit_Reason1             "Reason for visit diagnosis 1"
 DX_Visit_Reason2             "Reason for visit diagnosis 2"
 DX_Visit_Reason3             "Reason for visit diagnosis 3"
 ECODE1                       "E code 1"
 ECODE2                       "E code 2"
 ECODE3                       "E code 3"
 ECODE4                       "E code 4"
 ECODE5                       "E code 5"
 ECODE6                       "E code 6"
 ECODE7                       "E code 7"
 ECODE8                       "E code 8"
 ECODE9                       "E code 9"
 ECODE10                      "E code 10"
 ECODE11                      "E code 11"
 ECODE12                      "E code 12"
 E_CCS1                       "CCS: E Code 1"
 E_CCS2                       "CCS: E Code 2"
 E_CCS3                       "CCS: E Code 3"
 E_CCS4                       "CCS: E Code 4"
 E_CCS5                       "CCS: E Code 5"
 E_CCS6                       "CCS: E Code 6"
 E_CCS7                       "CCS: E Code 7"
 E_CCS8                       "CCS: E Code 8"
 E_CCS9                       "CCS: E Code 9"
 E_CCS10                      "CCS: E Code 10"
 E_CCS11                      "CCS: E Code 11"
 E_CCS12                      "CCS: E Code 12"
 E_POA1                       "E Code 1, present on admission indicator"
 E_POA2                       "E Code 2, present on admission indicator"
 E_POA3                       "E Code 3, present on admission indicator"
 E_POA4                       "E Code 4, present on admission indicator"
 E_POA5                       "E Code 5, present on admission indicator"
 E_POA6                       "E Code 6, present on admission indicator"
 E_POA7                       "E Code 7, present on admission indicator"
 E_POA8                       "E Code 8, present on admission indicator"
 E_POA9                       "E Code 9, present on admission indicator"
 E_POA10                      "E Code 10, present on admission indicator"
 E_POA11                      "E Code 11, present on admission indicator"
 E_POA12                      "E Code 12, present on admission indicator"
 FEMALE                       "Indicator of sex"
 HCUP_ED                      "HCUP Emergency Department service indicator"
 HCUP_OS                      "HCUP Observation Stay service indicator"
 HISPANIC_X                   "Hispanic ethnicity (as received from source)"
 HOSPBRTH                     "Indicator of birth in this hospital"
 HOSPST                       "Hospital state postal code"
 KEY                          "HCUP record identifier"
 LOS                          "Length of stay (cleaned)"
 LOS_X                        "Length of stay (as received from source)"
 MARITALSTATUSUB04            "Patient's marital status, UB-04 standard coding"
 MDNUM1_R                     "Physician 1 number (re-identified)"
 MDNUM2_R                     "Physician 2 number (re-identified)"
 MEDINCSTQ                    "Median household income state quartile for patient ZIP Code"
 MOMNUM_R                     "Mother's number (re-identified)"
 MRN_R                        "Medical record number (re-identified)"
 NCHRONIC                     "Number of chronic conditions"
 NCPT                         "Number of CPT/HCPCS procedures on this record"
 NDX                          "Number of diagnoses on this record"
 NECODE                       "Number of E codes on this record"
 NEOMAT                       "Neonatal and/or maternal DX and/or PR"
 NPR                          "Number of procedures on this record"
 OPservice                    "Indicator of outpatient service (as received from source)"
 ORPROC                       "Major operating room procedure indicator"
 OS_TIME                      "Observation stay time summed from UNITS"
 PAY1                         "Primary expected payer (uniform)"
 PAY1_X                       "Primary expected payer (as received from source)"
 PAY2                         "Secondary expected payer (uniform)"
 PAY2_X                       "Secondary expected payer (as received from source)"
 PAY3                         "Tertiary expected payer (uniform)"
 PAY3_X                       "Tertiary expected payer (as received from source)"
 PL_CBSA                      "Patient location: Core Based Statistical Area (CBSA)"
 PL_NCHS                      "Patient Location: NCHS Urban-Rural Code"
 PL_RUCC                      "Patient location: Rural-Urban Continuum Codes(RUCC)"
 PL_UIC                       "Patient location: Urban Influence Codes"
 PL_UR_CAT4                   "Patient Location: Urban-Rural 4 Categories"
 POA_Disch_Edit1              "Discharge has POA missing on all nonexempt diagnoses"
 POA_Disch_Edit2
"Discharge has POA missing on all nonexempt secondary diagnoses"
 POA_Hosp_Edit1
"Hospital reported POA as Y on all diagnoses on all discharges"
 POA_Hosp_Edit2
"Hospital reported POA as missing on all non-Medicare discharges"
 POA_Hosp_Edit3
"Hospital reported POA as missing on all nonexempt diagnoses for 15% or more of discharges"
 POA_Hosp_Edit3_Value
"Percentage of discharges with all nonexempt diagnoses missing POA indicators"
 PR1                          "Procedure 1"
 PR2                          "Procedure 2"
 PR3                          "Procedure 3"
 PR4                          "Procedure 4"
 PR5                          "Procedure 5"
 PR6                          "Procedure 6"
 PR7                          "Procedure 7"
 PR8                          "Procedure 8"
 PR9                          "Procedure 9"
 PR10                         "Procedure 10"
 PR11                         "Procedure 11"
 PR12                         "Procedure 12"
 PR13                         "Procedure 13"
 PR14                         "Procedure 14"
 PR15                         "Procedure 15"
 PR16                         "Procedure 16"
 PR17                         "Procedure 17"
 PR18                         "Procedure 18"
 PR19                         "Procedure 19"
 PR20                         "Procedure 20"
 PRCCS1                       "CCS: procedure 1"
 PRCCS2                       "CCS: procedure 2"
 PRCCS3                       "CCS: procedure 3"
 PRCCS4                       "CCS: procedure 4"
 PRCCS5                       "CCS: procedure 5"
 PRCCS6                       "CCS: procedure 6"
 PRCCS7                       "CCS: procedure 7"
 PRCCS8                       "CCS: procedure 8"
 PRCCS9                       "CCS: procedure 9"
 PRCCS10                      "CCS: procedure 10"
 PRCCS11                      "CCS: procedure 11"
 PRCCS12                      "CCS: procedure 12"
 PRCCS13                      "CCS: procedure 13"
 PRCCS14                      "CCS: procedure 14"
 PRCCS15                      "CCS: procedure 15"
 PRCCS16                      "CCS: procedure 16"
 PRCCS17                      "CCS: procedure 17"
 PRCCS18                      "CCS: procedure 18"
 PRCCS19                      "CCS: procedure 19"
 PRCCS20                      "CCS: procedure 20"
 PRDAY1                       "Number of days from admission to PR1"
 PRDAY2                       "Number of days from admission to PR2"
 PRDAY3                       "Number of days from admission to PR3"
 PRDAY4                       "Number of days from admission to PR4"
 PRDAY5                       "Number of days from admission to PR5"
 PRDAY6                       "Number of days from admission to PR6"
 PRDAY7                       "Number of days from admission to PR7"
 PRDAY8                       "Number of days from admission to PR8"
 PRDAY9                       "Number of days from admission to PR9"
 PRDAY10                      "Number of days from admission to PR10"
 PRDAY11                      "Number of days from admission to PR11"
 PRDAY12                      "Number of days from admission to PR12"
 PRDAY13                      "Number of days from admission to PR13"
 PRDAY14                      "Number of days from admission to PR14"
 PRDAY15                      "Number of days from admission to PR15"
 PRDAY16                      "Number of days from admission to PR16"
 PRDAY17                      "Number of days from admission to PR17"
 PRDAY18                      "Number of days from admission to PR18"
 PRDAY19                      "Number of days from admission to PR19"
 PRDAY20                      "Number of days from admission to PR20"
 PROCTYPE                     "Procedure type indicator"
 PRVER                        "Procedure Version"
 PSTATE                       "Patient State postal code"
 PSTCO                        "Patient state/county FIPS code"
 PSTCO2
"Patient state/county FIPS code, possibly derived from ZIP Code"
 PointOfOriginUB04
"Point of origin for admission or visit, UB-04 standard coding"
 PointOfOrigin_X
"Point of origin for admission or visit, as received from source"
 PrimLang                     "Primary language of patient"
 RACE                         "Race (uniform)"
 RACE_X                       "Race (as received from source)"
 READMIT                      "Readmission"
 STATE_AS                     "State Ambulatory Surgery service indicator"
 STATE_ED                     "State Emergency Department service indicator"
 STATE_OS                     "State Observation Stay service indicator"
 TOTCHG                       "Total charges (cleaned)"
 TOTCHG_X                     "Total charges (as received from source)"
 YEAR                         "Calendar year"
 ZIP                          "Patient ZIP Code"
 ZIP3                         "Patient ZIP Code, first 3 digits"
 ZIPINC_QRTL
"Median household income national quartile for patient ZIP Code"
 TOWN                         "Patient town of residence (as received from source)"
 AYEAR                        "Admission year"
 BMONTH                       "Birth month"
 BYEAR                        "Birth year"
 PRMONTH1                     "Month of procedure 1"
 PRMONTH2                     "Month of procedure 2"
 PRMONTH3                     "Month of procedure 3"
 PRMONTH4                     "Month of procedure 4"
 PRMONTH5                     "Month of procedure 5"
 PRMONTH6                     "Month of procedure 6"
 PRMONTH7                     "Month of procedure 7"
 PRMONTH8                     "Month of procedure 8"
 PRMONTH9                     "Month of procedure 9"
 PRMONTH10                    "Month of procedure 10"
 PRMONTH11                    "Month of procedure 11"
 PRMONTH12                    "Month of procedure 12"
 PRMONTH13                    "Month of procedure 13"
 PRMONTH14                    "Month of procedure 14"
 PRMONTH15                    "Month of procedure 15"
 PRMONTH16                    "Month of procedure 16"
 PRMONTH17                    "Month of procedure 17"
 PRMONTH18                    "Month of procedure 18"
 PRMONTH19                    "Month of procedure 19"
 PRMONTH20                    "Month of procedure 20"
 PRYEAR1                      "Year of procedure 1"
 PRYEAR2                      "Year of procedure 2"
 PRYEAR3                      "Year of procedure 3"
 PRYEAR4                      "Year of procedure 4"
 PRYEAR5                      "Year of procedure 5"
 PRYEAR6                      "Year of procedure 6"
 PRYEAR7                      "Year of procedure 7"
 PRYEAR8                      "Year of procedure 8"
 PRYEAR9                      "Year of procedure 9"
 PRYEAR10                     "Year of procedure 10"
 PRYEAR11                     "Year of procedure 11"
 PRYEAR12                     "Year of procedure 12"
 PRYEAR13                     "Year of procedure 13"
 PRYEAR14                     "Year of procedure 14"
 PRYEAR15                     "Year of procedure 15"
 PRYEAR16                     "Year of procedure 16"
 PRYEAR17                     "Year of procedure 17"
 PRYEAR18                     "Year of procedure 18"
 PRYEAR19                     "Year of procedure 19"
 PRYEAR20                     "Year of procedure 20" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AGE
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEDAY
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEMONTH
 (-99,-88,-66,-55=SYSMIS).
RECODE AHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ATYPE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS30
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS31
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS32
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS33
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS34
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS35
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS36
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS37
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS38
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS39
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS40
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS41
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS42
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS43
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS44
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS45
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS46
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS47
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS48
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS49
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTCCS50
 (-99,-88,-66,-55=SYSMIS).
RECODE DHOUR
 (-999,-888,-666,-555=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIFORM
 (-9,-8,-6,-5=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DURATION
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS13
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS14
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS15
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS16
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS17
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS18
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS19
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS20
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS21
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS22
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS23
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS24
 (-999,-888,-666,-555=SYSMIS).
RECODE DXVER
 (-99,-88,-66,-55=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS10
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS11
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS12
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE LOS_X
 (-99999,-88888,-66666,-55555=SYSMIS).
RECODE MDNUM1_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MDNUM2_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MEDINCSTQ
 (-9,-8,-6,-5=SYSMIS).
RECODE MOMNUM_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCHRONIC
 (-99,-88,-66,-55=SYSMIS).
RECODE NCPT
 (-999,-888,-666,-555=SYSMIS).
RECODE NDX
 (-99,-88,-66,-55=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE NPR
 (-99,-88,-66,-55=SYSMIS).
RECODE ORPROC
 (-9,-8,-6,-5=SYSMIS).
RECODE OS_TIME
 (-9999999,-8888888,-6666666,-5555555=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY2
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY3
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CAT4
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Disch_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit1
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit2
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3
 (-9,-8,-6,-5=SYSMIS).
RECODE POA_Hosp_Edit3_Value
 (-9999.99,-8888.88,-6666.66,-5555.55=SYSMIS).
RECODE PRCCS1
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS2
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS3
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS4
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS5
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS6
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS7
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS8
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS9
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS10
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS11
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS12
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS13
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS14
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS15
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS16
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS17
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS18
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS19
 (-99,-88,-66,-55=SYSMIS).
RECODE PRCCS20
 (-99,-88,-66,-55=SYSMIS).
RECODE PRDAY1
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY3
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY4
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY5
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY6
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY7
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY8
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY9
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY10
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY11
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY12
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY13
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY14
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY15
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY16
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY17
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY18
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY19
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PRDAY20
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PRVER
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE RACE
 (-9,-8,-6,-5=SYSMIS).
RECODE READMIT
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE TOTCHG
 (-999999999,-888888888,-666666666,-555555555=SYSMIS).
RECODE TOTCHG_X
 (-99999999999.99,-88888888888.88,-66666666666.66,-55555555555.55=SYSMIS).
RECODE ZIPINC_QRTL
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE BMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE BYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE PRMONTH1
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH2
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH3
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH4
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH5
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH6
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH7
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH8
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH9
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH10
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH11
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH12
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH13
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH14
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH15
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH16
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH17
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH18
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH19
 (-9,-8,-6,-5=SYSMIS).
RECODE PRMONTH20
 (-9,-8,-6,-5=SYSMIS).
RECODE PRYEAR1
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR2
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR3
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR4
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR5
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR6
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR7
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR8
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR9
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR10
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR11
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR12
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR13
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR14
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR15
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR16
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR17
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR18
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR19
 (-999,-888,-666,-555=SYSMIS).
RECODE PRYEAR20
 (-999,-888,-666,-555=SYSMIS).



SAVE OUTFILE = 'NJ_SASD_2014_CORE.SAV' /COMPRESSED.
