/*******************************************************************
* Creation Date: 07/22/2021   
*   MO_SASD_2018_CHGS.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CHGS FILE INTO SPSS                             
*******************************************************************/


***************************************************************;
* ----------------------------------------------------------- *;
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;
* |  terms and conditions of the HCUP Data Use Agreement.   | *;
* ----------------------------------------------------------- *;
***************************************************************;


********************************************************************.
*  Define the data file                                            *.
*  ATTENTION!            ATTENTION!              ATTENTION!        *.
*  Variable names longer than 8 characters are no longer truncated *.
*  beginning with 2009 data for SPSS since SPSS now accommodates   *.
*  long variable names                                             *.
********************************************************************.

DATA LIST FILE = 'MO_SASD_2018_CHGS.ASC' FIXED SKIP=2 / 
 CPTHCPCS                        1-   5 (A)
 KEY                             6-  20
 REVCODE                        21-  24 (A)
 SERVDAY                        25-  29
 UNITS                          30-  40.


***  Specify write formats  ***.
FORMATS
 KEY                          (F8.0) /
 SERVDAY                      (F3.0) /
 UNITS                        (F4.2) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 CPTHCPCS                     "Line item CPT-4/HCPCS procedure code (as received from source)"
 KEY                          "HCUP record identifier"
 REVCODE                      "Line item revenue code (as received from source)"
 SERVDAY                      "Line item days from admission date"
 UNITS                        "Line item units (as received from source)" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE SERVDAY
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE UNITS
 (-9999999.99,-8888888.88,-6666666.66,-5555555.55=SYSMIS).



SAVE OUTFILE = 'MO_SASD_2018_CHGS.SAV' /COMPRESSED.
