/*******************************************************************
*   ME_SASD_2007_CORE.SPS:                                        
*      THE SPSS CODE SHOWN BELOW WILL LOAD THE ASCII                
*      OUTPATIENT CORE FILE INTO SPSS                             
*******************************************************************/


*******************************************************************.
*  Define the data file                                           *.
*  ATTENTION!            ATTENTION!              ATTENTION!       *.
*  Variable names longer than 8 characters are truncated for SPSS *.
*  and may no longer be unique                                    *.
*  Refer to the LOC file and adjust accordingly                   *.
*******************************************************************.

DATA LIST FILE = 'ME_SASD_2007_CORE.ASC' FIXED / 
 AMONTH                     1-   2
 ASOURCE                    3-   4
 AWEEKEND                   5-   6
 BILLTYPE                   7-  10 (A)
 CPT1                      11-  15 (A)
 CPT2                      16-  20 (A)
 CPT3                      21-  25 (A)
 CPT4                      26-  30 (A)
 CPT5                      31-  35 (A)
 CPT6                      36-  40 (A)
 CPT7                      41-  45 (A)
 CPT8                      46-  50 (A)
 CPT9                      51-  55 (A)
 CPT10                     56-  60 (A)
 CPT11                     61-  65 (A)
 CPT12                     66-  70 (A)
 CPT13                     71-  75 (A)
 CPT14                     76-  80 (A)
 CPT15                     81-  85 (A)
 CPT16                     86-  90 (A)
 CPT17                     91-  95 (A)
 CPT18                     96- 100 (A)
 CPT19                    101- 105 (A)
 CPT20                    106- 110 (A)
 CPT21                    111- 115 (A)
 CPT22                    116- 120 (A)
 CPT23                    121- 125 (A)
 CPT24                    126- 130 (A)
 CPT25                    131- 135 (A)
 CPT26                    136- 140 (A)
 CPT27                    141- 145 (A)
 CPT28                    146- 150 (A)
 CPT29                    151- 155 (A)
 CPT30                    156- 160 (A)
 CPTDAY1                  161- 163
 CPTDAY2                  164- 166
 CPTDAY3                  167- 169
 CPTDAY4                  170- 172
 CPTDAY5                  173- 175
 CPTDAY6                  176- 178
 CPTDAY7                  179- 181
 CPTDAY8                  182- 184
 CPTDAY9                  185- 187
 CPTDAY10                 188- 190
 CPTDAY11                 191- 193
 CPTDAY12                 194- 196
 CPTDAY13                 197- 199
 CPTDAY14                 200- 202
 CPTDAY15                 203- 205
 CPTDAY16                 206- 208
 CPTDAY17                 209- 211
 CPTDAY18                 212- 214
 CPTDAY19                 215- 217
 CPTDAY20                 218- 220
 CPTDAY21                 221- 223
 CPTDAY22                 224- 226
 CPTDAY23                 227- 229
 CPTDAY24                 230- 232
 CPTDAY25                 233- 235
 CPTDAY26                 236- 238
 CPTDAY27                 239- 241
 CPTDAY28                 242- 244
 CPTDAY29                 245- 247
 CPTDAY30                 248- 250
 CPTM1_1                  251- 252 (A)
 CPTM1_2                  253- 254 (A)
 CPTM1_3                  255- 256 (A)
 CPTM1_4                  257- 258 (A)
 CPTM1_5                  259- 260 (A)
 CPTM1_6                  261- 262 (A)
 CPTM1_7                  263- 264 (A)
 CPTM1_8                  265- 266 (A)
 CPTM1_9                  267- 268 (A)
 CPTM1_10                 269- 270 (A)
 CPTM1_11                 271- 272 (A)
 CPTM1_12                 273- 274 (A)
 CPTM1_13                 275- 276 (A)
 CPTM1_14                 277- 278 (A)
 CPTM1_15                 279- 280 (A)
 CPTM1_16                 281- 282 (A)
 CPTM1_17                 283- 284 (A)
 CPTM1_18                 285- 286 (A)
 CPTM1_19                 287- 288 (A)
 CPTM1_20                 289- 290 (A)
 CPTM1_21                 291- 292 (A)
 CPTM1_22                 293- 294 (A)
 CPTM1_23                 295- 296 (A)
 CPTM1_24                 297- 298 (A)
 CPTM1_25                 299- 300 (A)
 CPTM1_26                 301- 302 (A)
 CPTM1_27                 303- 304 (A)
 CPTM1_28                 305- 306 (A)
 CPTM1_29                 307- 308 (A)
 CPTM1_30                 309- 310 (A)
 CPTM2_1                  311- 312 (A)
 CPTM2_2                  313- 314 (A)
 CPTM2_3                  315- 316 (A)
 CPTM2_4                  317- 318 (A)
 CPTM2_5                  319- 320 (A)
 CPTM2_6                  321- 322 (A)
 CPTM2_7                  323- 324 (A)
 CPTM2_8                  325- 326 (A)
 CPTM2_9                  327- 328 (A)
 CPTM2_10                 329- 330 (A)
 CPTM2_11                 331- 332 (A)
 CPTM2_12                 333- 334 (A)
 CPTM2_13                 335- 336 (A)
 CPTM2_14                 337- 338 (A)
 CPTM2_15                 339- 340 (A)
 CPTM2_16                 341- 342 (A)
 CPTM2_17                 343- 344 (A)
 CPTM2_18                 345- 346 (A)
 CPTM2_19                 347- 348 (A)
 CPTM2_20                 349- 350 (A)
 CPTM2_21                 351- 352 (A)
 CPTM2_22                 353- 354 (A)
 CPTM2_23                 355- 356 (A)
 CPTM2_24                 357- 358 (A)
 CPTM2_25                 359- 360 (A)
 CPTM2_26                 361- 362 (A)
 CPTM2_27                 363- 364 (A)
 CPTM2_28                 365- 366 (A)
 CPTM2_29                 367- 368 (A)
 CPTM2_30                 369- 370 (A)
 DIED                     371- 372
 DISPUB04                 373- 374
 DISPUNIF                 375- 376
 DQTR                     377- 378
 DX1                      379- 383 (A)
 DX2                      384- 388 (A)
 DX3                      389- 393 (A)
 DX4                      394- 398 (A)
 DX5                      399- 403 (A)
 DX6                      404- 408 (A)
 DX7                      409- 413 (A)
 DX8                      414- 418 (A)
 DX9                      419- 423 (A)
 DXCCS1                   424- 427
 DXCCS2                   428- 431
 DXCCS3                   432- 435
 DXCCS4                   436- 439
 DXCCS5                   440- 443
 DXCCS6                   444- 447
 DXCCS7                   448- 451
 DXCCS8                   452- 455
 DXCCS9                   456- 459
 ECODE1                   460- 464 (A)
 ECODE2                   465- 469 (A)
 ECODE3                   470- 474 (A)
 ECODE4                   475- 479 (A)
 ECODE5                   480- 484 (A)
 E_CCS1                   485- 488
 E_CCS2                   489- 492
 E_CCS3                   493- 496
 E_CCS4                   497- 500
 E_CCS5                   501- 504
 FEMALE                   505- 506
 HCUP_AS                  507- 508
 HCUP_ED                  509- 510
 HCUP_OS                  511- 512
 HOSPBRTH                 513- 515
 HOSPST                   516- 517 (A)
 KEY                      518- 531
 LOS                      532- 536
 MDSPEC1                  537- 538 (A)
 MDSPEC2                  539- 540 (A)
 MEDINCST                 541- 542
 MRN_R                    543- 551
 NCPT                     552- 554
 NDX                      555- 556
 NECODE                   557- 558
 NEOMAT                   559- 560
 PAY1                     561- 562
 PL_CBSA                  563- 565
 PL_MSA19                 566- 568
 PL_NCHS2                 569- 570
 PL_RUCA4                 571- 572
 PL_UIC20                 573- 574
 PL_UR_CA                 575- 576
 PROCTYPE                 577- 579
 PSTATE                   580- 581 (A)
 PSTCO                    582- 586
 PSTCO2                   587- 591
 POFOUB04                 592     (A)
 STATE_AS                 593- 594
 STATE_ED                 595- 596
 STATE_OS                 597- 598
 YEAR                     599- 602
 ZIP3                     603- 605 (A)
 ZIPINC_Q                 606- 608
 ZIP_S                    609- 613 (A)
 AGEGROUP                 614- 616
 HOSPID                   617- 621
 AYEAR                    622- 625
 DMONTH                   626- 627.


***  Specify write formats  ***.
FORMATS
 AMONTH                  (F3.0) /
 ASOURCE                 (F3.0) /
 AWEEKEND                (F3.0) /
 CPTDAY1                 (F4.0) /
 CPTDAY2                 (F4.0) /
 CPTDAY3                 (F4.0) /
 CPTDAY4                 (F4.0) /
 CPTDAY5                 (F4.0) /
 CPTDAY6                 (F4.0) /
 CPTDAY7                 (F4.0) /
 CPTDAY8                 (F4.0) /
 CPTDAY9                 (F4.0) /
 CPTDAY10                (F4.0) /
 CPTDAY11                (F4.0) /
 CPTDAY12                (F4.0) /
 CPTDAY13                (F4.0) /
 CPTDAY14                (F4.0) /
 CPTDAY15                (F4.0) /
 CPTDAY16                (F4.0) /
 CPTDAY17                (F4.0) /
 CPTDAY18                (F4.0) /
 CPTDAY19                (F4.0) /
 CPTDAY20                (F4.0) /
 CPTDAY21                (F4.0) /
 CPTDAY22                (F4.0) /
 CPTDAY23                (F4.0) /
 CPTDAY24                (F4.0) /
 CPTDAY25                (F4.0) /
 CPTDAY26                (F4.0) /
 CPTDAY27                (F4.0) /
 CPTDAY28                (F4.0) /
 CPTDAY29                (F4.0) /
 CPTDAY30                (F4.0) /
 DIED                    (F3.0) /
 DISPUB04                (F3.0) /
 DISPUNIF                (F3.0) /
 DQTR                    (F3.0) /
 DXCCS1                  (F4.0) /
 DXCCS2                  (F4.0) /
 DXCCS3                  (F4.0) /
 DXCCS4                  (F4.0) /
 DXCCS5                  (F4.0) /
 DXCCS6                  (F4.0) /
 DXCCS7                  (F4.0) /
 DXCCS8                  (F4.0) /
 DXCCS9                  (F4.0) /
 E_CCS1                  (F3.0) /
 E_CCS2                  (F3.0) /
 E_CCS3                  (F3.0) /
 E_CCS4                  (F3.0) /
 E_CCS5                  (F3.0) /
 FEMALE                  (F3.0) /
 HCUP_AS                 (F3.0) /
 HCUP_ED                 (F3.0) /
 HCUP_OS                 (F3.0) /
 HOSPBRTH                (F3.0) /
 KEY                     (F8.0) /
 LOS                     (F4.0) /
 MEDINCST                (F3.0) /
 MRN_R                   (F5.0) /
 NCPT                    (F3.0) /
 NDX                     (F3.0) /
 NECODE                  (F3.0) /
 NEOMAT                  (F3.0) /
 PAY1                    (F3.0) /
 PL_CBSA                 (F3.0) /
 PL_MSA19                (F3.0) /
 PL_NCHS2                (F3.0) /
 PL_RUCA4                (F3.0) /
 PL_UIC20                (F3.0) /
 PL_UR_CA                (F3.0) /
 PROCTYPE                (F3.0) /
 PSTCO                   (F4.0) /
 PSTCO2                  (F4.0) /
 STATE_AS                (F3.0) /
 STATE_ED                (F3.0) /
 STATE_OS                (F3.0) /
 YEAR                    (F3.0) /
 ZIPINC_Q                (F3.0) /
 AGEGROUP                (F8.0) /
 HOSPID                  (F4.0) /
 AYEAR                   (F3.0) /
 DMONTH                  (F3.0) .


***  Assign labels to the variables ***.
VARIABLE LABELS 
 AMONTH    "Admission month"
 ASOURCE   "Admission source (uniform)"
 AWEEKEND  "Admission day is a weekend"
 BILLTYPE  "UB-92 bill type"
 CPT1      "CPT/HCPCS procedure code 1"
 CPT2      "CPT/HCPCS procedure code 2"
 CPT3      "CPT/HCPCS procedure code 3"
 CPT4      "CPT/HCPCS procedure code 4"
 CPT5      "CPT/HCPCS procedure code 5"
 CPT6      "CPT/HCPCS procedure code 6"
 CPT7      "CPT/HCPCS procedure code 7"
 CPT8      "CPT/HCPCS procedure code 8"
 CPT9      "CPT/HCPCS procedure code 9"
 CPT10     "CPT/HCPCS procedure code 10"
 CPT11     "CPT/HCPCS procedure code 11"
 CPT12     "CPT/HCPCS procedure code 12"
 CPT13     "CPT/HCPCS procedure code 13"
 CPT14     "CPT/HCPCS procedure code 14"
 CPT15     "CPT/HCPCS procedure code 15"
 CPT16     "CPT/HCPCS procedure code 16"
 CPT17     "CPT/HCPCS procedure code 17"
 CPT18     "CPT/HCPCS procedure code 18"
 CPT19     "CPT/HCPCS procedure code 19"
 CPT20     "CPT/HCPCS procedure code 20"
 CPT21     "CPT/HCPCS procedure code 21"
 CPT22     "CPT/HCPCS procedure code 22"
 CPT23     "CPT/HCPCS procedure code 23"
 CPT24     "CPT/HCPCS procedure code 24"
 CPT25     "CPT/HCPCS procedure code 25"
 CPT26     "CPT/HCPCS procedure code 26"
 CPT27     "CPT/HCPCS procedure code 27"
 CPT28     "CPT/HCPCS procedure code 28"
 CPT29     "CPT/HCPCS procedure code 29"
 CPT30     "CPT/HCPCS procedure code 30"
 CPTDAY1   "Number of days from admission to CPT1"
 CPTDAY2   "Number of days from admission to CPT2"
 CPTDAY3   "Number of days from admission to CPT3"
 CPTDAY4   "Number of days from admission to CPT4"
 CPTDAY5   "Number of days from admission to CPT5"
 CPTDAY6   "Number of days from admission to CPT6"
 CPTDAY7   "Number of days from admission to CPT7"
 CPTDAY8   "Number of days from admission to CPT8"
 CPTDAY9   "Number of days from admission to CPT9"
 CPTDAY10  "Number of days from admission to CPT10"
 CPTDAY11  "Number of days from admission to CPT11"
 CPTDAY12  "Number of days from admission to CPT12"
 CPTDAY13  "Number of days from admission to CPT13"
 CPTDAY14  "Number of days from admission to CPT14"
 CPTDAY15  "Number of days from admission to CPT15"
 CPTDAY16  "Number of days from admission to CPT16"
 CPTDAY17  "Number of days from admission to CPT17"
 CPTDAY18  "Number of days from admission to CPT18"
 CPTDAY19  "Number of days from admission to CPT19"
 CPTDAY20  "Number of days from admission to CPT20"
 CPTDAY21  "Number of days from admission to CPT21"
 CPTDAY22  "Number of days from admission to CPT22"
 CPTDAY23  "Number of days from admission to CPT23"
 CPTDAY24  "Number of days from admission to CPT24"
 CPTDAY25  "Number of days from admission to CPT25"
 CPTDAY26  "Number of days from admission to CPT26"
 CPTDAY27  "Number of days from admission to CPT27"
 CPTDAY28  "Number of days from admission to CPT28"
 CPTDAY29  "Number of days from admission to CPT29"
 CPTDAY30  "Number of days from admission to CPT30"
 CPTM1_1   "First CPT-4/HCPCS modifier 1"
 CPTM1_2   "First CPT-4/HCPCS modifier 2"
 CPTM1_3   "First CPT-4/HCPCS modifier 3"
 CPTM1_4   "First CPT-4/HCPCS modifier 4"
 CPTM1_5   "First CPT-4/HCPCS modifier 5"
 CPTM1_6   "First CPT-4/HCPCS modifier 6"
 CPTM1_7   "First CPT-4/HCPCS modifier 7"
 CPTM1_8   "First CPT-4/HCPCS modifier 8"
 CPTM1_9   "First CPT-4/HCPCS modifier 9"
 CPTM1_10  "First CPT-4/HCPCS modifier 10"
 CPTM1_11  "First CPT-4/HCPCS modifier 11"
 CPTM1_12  "First CPT-4/HCPCS modifier 12"
 CPTM1_13  "First CPT-4/HCPCS modifier 13"
 CPTM1_14  "First CPT-4/HCPCS modifier 14"
 CPTM1_15  "First CPT-4/HCPCS modifier 15"
 CPTM1_16  "First CPT-4/HCPCS modifier 16"
 CPTM1_17  "First CPT-4/HCPCS modifier 17"
 CPTM1_18  "First CPT-4/HCPCS modifier 18"
 CPTM1_19  "First CPT-4/HCPCS modifier 19"
 CPTM1_20  "First CPT-4/HCPCS modifier 20"
 CPTM1_21  "First CPT-4/HCPCS modifier 21"
 CPTM1_22  "First CPT-4/HCPCS modifier 22"
 CPTM1_23  "First CPT-4/HCPCS modifier 23"
 CPTM1_24  "First CPT-4/HCPCS modifier 24"
 CPTM1_25  "First CPT-4/HCPCS modifier 25"
 CPTM1_26  "First CPT-4/HCPCS modifier 26"
 CPTM1_27  "First CPT-4/HCPCS modifier 27"
 CPTM1_28  "First CPT-4/HCPCS modifier 28"
 CPTM1_29  "First CPT-4/HCPCS modifier 29"
 CPTM1_30  "First CPT-4/HCPCS modifier 30"
 CPTM2_1   "Second CPT-4/HCPCS modifier 1"
 CPTM2_2   "Second CPT-4/HCPCS modifier 2"
 CPTM2_3   "Second CPT-4/HCPCS modifier 3"
 CPTM2_4   "Second CPT-4/HCPCS modifier 4"
 CPTM2_5   "Second CPT-4/HCPCS modifier 5"
 CPTM2_6   "Second CPT-4/HCPCS modifier 6"
 CPTM2_7   "Second CPT-4/HCPCS modifier 7"
 CPTM2_8   "Second CPT-4/HCPCS modifier 8"
 CPTM2_9   "Second CPT-4/HCPCS modifier 9"
 CPTM2_10  "Second CPT-4/HCPCS modifier 10"
 CPTM2_11  "Second CPT-4/HCPCS modifier 11"
 CPTM2_12  "Second CPT-4/HCPCS modifier 12"
 CPTM2_13  "Second CPT-4/HCPCS modifier 13"
 CPTM2_14  "Second CPT-4/HCPCS modifier 14"
 CPTM2_15  "Second CPT-4/HCPCS modifier 15"
 CPTM2_16  "Second CPT-4/HCPCS modifier 16"
 CPTM2_17  "Second CPT-4/HCPCS modifier 17"
 CPTM2_18  "Second CPT-4/HCPCS modifier 18"
 CPTM2_19  "Second CPT-4/HCPCS modifier 19"
 CPTM2_20  "Second CPT-4/HCPCS modifier 20"
 CPTM2_21  "Second CPT-4/HCPCS modifier 21"
 CPTM2_22  "Second CPT-4/HCPCS modifier 22"
 CPTM2_23  "Second CPT-4/HCPCS modifier 23"
 CPTM2_24  "Second CPT-4/HCPCS modifier 24"
 CPTM2_25  "Second CPT-4/HCPCS modifier 25"
 CPTM2_26  "Second CPT-4/HCPCS modifier 26"
 CPTM2_27  "Second CPT-4/HCPCS modifier 27"
 CPTM2_28  "Second CPT-4/HCPCS modifier 28"
 CPTM2_29  "Second CPT-4/HCPCS modifier 29"
 CPTM2_30  "Second CPT-4/HCPCS modifier 30"
 DIED      "Died during hospitalization"
 DISPUB04  "Disposition of patient (UB-04 standard coding)"
 DISPUNIF  "Disposition of patient (uniform)"
 DQTR      "Discharge quarter"
 DX1       "Diagnosis 1"
 DX2       "Diagnosis 2"
 DX3       "Diagnosis 3"
 DX4       "Diagnosis 4"
 DX5       "Diagnosis 5"
 DX6       "Diagnosis 6"
 DX7       "Diagnosis 7"
 DX8       "Diagnosis 8"
 DX9       "Diagnosis 9"
 DXCCS1    "CCS: diagnosis 1"
 DXCCS2    "CCS: diagnosis 2"
 DXCCS3    "CCS: diagnosis 3"
 DXCCS4    "CCS: diagnosis 4"
 DXCCS5    "CCS: diagnosis 5"
 DXCCS6    "CCS: diagnosis 6"
 DXCCS7    "CCS: diagnosis 7"
 DXCCS8    "CCS: diagnosis 8"
 DXCCS9    "CCS: diagnosis 9"
 ECODE1    "E code 1"
 ECODE2    "E code 2"
 ECODE3    "E code 3"
 ECODE4    "E code 4"
 ECODE5    "E code 5"
 E_CCS1    "CCS: E Code 1"
 E_CCS2    "CCS: E Code 2"
 E_CCS3    "CCS: E Code 3"
 E_CCS4    "CCS: E Code 4"
 E_CCS5    "CCS: E Code 5"
 FEMALE    "Indicator of sex"
 HCUP_AS   "HCUP Ambulatory Surgery service indicator"
 HCUP_ED   "HCUP Emergency Department service indicator"
 HCUP_OS   "HCUP Observation Stay service indicator"
 HOSPBRTH  "Indicator of birth in this hospital"
 HOSPST    "Hospital state postal code"
 KEY       "HCUP record identifier"
 LOS       "Length of stay (cleaned)"
 MDSPEC1   "Physician 1 specialty (as received from source)"
 MDSPEC2   "Physician 2 specialty (as received from source)"
 MEDINCST  "Median household income state quartile for patient ZIP Code"
 MRN_R     "Medical record number (re-identified)"
 NCPT      "Number of CPT/HCPCS procedures on this record"
 NDX       "Number of diagnoses on this record"
 NECODE    "Number of E codes on this record"
 NEOMAT    "Neonatal and/or maternal DX and/or PR"
 PAY1      "Primary expected payer (uniform)"
 PL_CBSA   "Patient location: Core Based Statistical Area (CBSA)"
 PL_MSA19  "Patient location: Metropolitan Statistical Area (MSA), 1993"
 PL_NCHS2  "Patient Location: NCHS Urban-Rural Code (V2006)"
 PL_RUCA4  "Patient location: Rural-Urban Commuting Area (RUCA) Codes, four levels"
 PL_UIC20  "Patient location: Urban Influence Codes, 2003"
 PL_UR_CA  "Patient Location: Urban-Rural 4 Categories"
 PROCTYPE  "Procedure type indicator"
 PSTATE    "Patient State postal code"
 PSTCO     "Patient state/county FIPS code"
 PSTCO2    "Patient state/county FIPS code, possibly derived from ZIP Code"
 POFOUB04  "Point of origin for admission or visit, UB-04 standard coding"
 STATE_AS  "State Ambulatory Surgery service indicator"
 STATE_ED  "State Emergency Department service indicator"
 STATE_OS  "State Observation Stay service indicator"
 YEAR      "Calendar year"
 ZIP3      "Patient ZIP Code, first 3 digits"
 ZIPINC_Q  "Median household income national quartile for patient ZIP Code"
 ZIP_S     "Patient ZIP Code (synthetic)"
 AGEGROUP  " "
 HOSPID    "HCUP hospital identification number"
 AYEAR     "Admission year"
 DMONTH    "Discharge month" .


**********************************************************.
*    Convert missing data to system missing values       *.
**********************************************************.

RECODE AMONTH
 (-9,-8,-6,-5=SYSMIS).
RECODE ASOURCE
 (-9,-8,-6,-5=SYSMIS).
RECODE AWEEKEND
 (-9,-8,-6,-5=SYSMIS).
RECODE CPTDAY1
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY2
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY3
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY4
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY5
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY6
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY7
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY8
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY9
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY10
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY11
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY12
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY13
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY14
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY15
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY16
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY17
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY18
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY19
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY20
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY21
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY22
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY23
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY24
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY25
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY26
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY27
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY28
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY29
 (-99,-88,-66,-55=SYSMIS).
RECODE CPTDAY30
 (-99,-88,-66,-55=SYSMIS).
RECODE DIED
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUB04
 (-9,-8,-6,-5=SYSMIS).
RECODE DISPUNIF
 (-9,-8,-6,-5=SYSMIS).
RECODE DQTR
 (-9,-8,-6,-5=SYSMIS).
RECODE DXCCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS6
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS7
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS8
 (-999,-888,-666,-555=SYSMIS).
RECODE DXCCS9
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS1
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS2
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS3
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS4
 (-999,-888,-666,-555=SYSMIS).
RECODE E_CCS5
 (-999,-888,-666,-555=SYSMIS).
RECODE FEMALE
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE HCUP_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE HOSPBRTH
 (-99,-88,-66,-55=SYSMIS).
RECODE LOS
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE MEDINCST
 (-9,-8,-6,-5=SYSMIS).
RECODE MRN_R
 (-99999999,-88888888,-66666666,-55555555=SYSMIS).
RECODE NCPT
 (-99,-88,-66,-55=SYSMIS).
RECODE NDX
 (-9,-8,-6,-5=SYSMIS).
RECODE NECODE
 (-9,-8,-6,-5=SYSMIS).
RECODE NEOMAT
 (-9,-8,-6,-5=SYSMIS).
RECODE PAY1
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_CBSA
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_MSA19
 (-99,-88,-66,-55=SYSMIS).
RECODE PL_NCHS2
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_RUCA4
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UIC20
 (-9,-8,-6,-5=SYSMIS).
RECODE PL_UR_CA
 (-9,-8,-6,-5=SYSMIS).
RECODE PROCTYPE
 (-99,-88,-66,-55=SYSMIS).
RECODE PSTCO
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE PSTCO2
 (-9999,-8888,-6666,-5555=SYSMIS).
RECODE STATE_AS
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_ED
 (-9,-8,-6,-5=SYSMIS).
RECODE STATE_OS
 (-9,-8,-6,-5=SYSMIS).
RECODE ZIPINC_Q
 (-99,-88,-66,-55=SYSMIS).
RECODE AGEGROUP
 (-99,-88,-66,-55=SYSMIS).
RECODE AYEAR
 (-999,-888,-666,-555=SYSMIS).
RECODE DMONTH
 (-9,-8,-6,-5=SYSMIS).



SAVE OUTFILE = 'ME_SASD_2007_CORE.SAV' /COMPRESSED.
