/*******************************************************************            
* Creation Date: 03/16/2017                                                     
*   CO_SASD_2015q1q3_CORE.SAS:                                                  
*      THE SAS CODE SHOWN BELOW WILL LOAD THE ASCII                             
*      OUTPATIENT SASD CORE FILE INTO SAS                                       
*      INPATIENT STAY CORE FILE INTO SAS                                        
*******************************************************************/            
                                                                                
                                                                                
***************************************************************;                
* ----------------------------------------------------------- *;                
* |  NOTICE: Use of HCUP data constitutes acceptance of the | *;                
* |  terms and conditions of the HCUP Data Use Agreement.   | *;                
* ----------------------------------------------------------- *;                
***************************************************************;                
                                                                                
                                                                                
***********************************************;                                
*  Create SAS informats for missing values     ;                                
***********************************************;                                
PROC FORMAT;                                                                    
  INVALUE N2PF                                                                  
    '-9' = .                                                                    
    '-8' = .A                                                                   
    '-6' = .C                                                                   
    '-5' = .N                                                                   
    OTHER = (|2.|)                                                              
  ;                                                                             
  INVALUE N3PF                                                                  
    '-99' = .                                                                   
    '-88' = .A                                                                  
    '-66' = .C                                                                  
    OTHER = (|3.|)                                                              
  ;                                                                             
  INVALUE N4PF                                                                  
    '-999' = .                                                                  
    '-888' = .A                                                                 
    '-666' = .C                                                                 
    OTHER = (|4.|)                                                              
  ;                                                                             
  INVALUE N4P1F                                                                 
    '-9.9' = .                                                                  
    '-8.8' = .A                                                                 
    '-6.6' = .C                                                                 
    OTHER = (|4.1|)                                                             
  ;                                                                             
  INVALUE N5PF                                                                  
    '-9999' = .                                                                 
    '-8888' = .A                                                                
    '-6666' = .C                                                                
    OTHER = (|5.|)                                                              
  ;                                                                             
  INVALUE N5P2F                                                                 
    '-9.99' = .                                                                 
    '-8.88' = .A                                                                
    '-6.66' = .C                                                                
    OTHER = (|5.2|)                                                             
  ;                                                                             
  INVALUE N6PF                                                                  
    '-99999' = .                                                                
    '-88888' = .A                                                               
    '-66666' = .C                                                               
    OTHER = (|6.|)                                                              
  ;                                                                             
  INVALUE N6P2F                                                                 
    '-99.99' = .                                                                
    '-88.88' = .A                                                               
    '-66.66' = .C                                                               
    OTHER = (|6.2|)                                                             
  ;                                                                             
  INVALUE N7P2F                                                                 
    '-999.99' = .                                                               
    '-888.88' = .A                                                              
    '-666.66' = .C                                                              
    OTHER = (|7.2|)                                                             
  ;                                                                             
  INVALUE N7P4F                                                                 
    '-9.9999' = .                                                               
    '-8.8888' = .A                                                              
    '-6.6666' = .C                                                              
    OTHER = (|7.4|)                                                             
  ;                                                                             
  INVALUE N8PF                                                                  
    '-9999999' = .                                                              
    '-8888888' = .A                                                             
    '-6666666' = .C                                                             
    OTHER = (|8.|)                                                              
  ;                                                                             
  INVALUE N8P2F                                                                 
    '-9999.99' = .                                                              
    '-8888.88' = .A                                                             
    '-6666.66' = .C                                                             
    OTHER = (|8.2|)                                                             
  ;                                                                             
  INVALUE N9PF                                                                  
    '-99999999' = .                                                             
    '-88888888' = .A                                                            
    '-66666666' = .C                                                            
    OTHER = (|9.|)                                                              
  ;                                                                             
  INVALUE N9P2F                                                                 
    '-99999.99' = .                                                             
    '-88888.88' = .A                                                            
    '-66666.66' = .C                                                            
    OTHER = (|9.2|)                                                             
  ;                                                                             
  INVALUE N10PF                                                                 
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|10.|)                                                             
  ;                                                                             
  INVALUE N10P4F                                                                
    '-9999.9999' = .                                                            
    '-8888.8888' = .A                                                           
    '-6666.6666' = .C                                                           
    OTHER = (|10.4|)                                                            
  ;                                                                             
  INVALUE N10P5F                                                                
    '-999.99999' = .                                                            
    '-888.88888' = .A                                                           
    '-666.66666' = .C                                                           
    OTHER = (|10.5|)                                                            
  ;                                                                             
  INVALUE DATE10F                                                               
    '-999999999' = .                                                            
    '-888888888' = .A                                                           
    '-666666666' = .C                                                           
    OTHER = (|MMDDYY10.|)                                                       
  ;                                                                             
  INVALUE N11PF                                                                 
    '-9999999999' = .                                                           
    '-8888888888' = .A                                                          
    '-6666666666' = .C                                                          
    OTHER = (|11.|)                                                             
  ;                                                                             
  INVALUE N11P2F                                                                
    '-9999999.99' = .                                                           
    '-8888888.88' = .A                                                          
    '-6666666.66' = .C                                                          
    OTHER = (|11.2|)                                                            
  ;                                                                             
  INVALUE N12P2F                                                                
    '-99999999.99' = .                                                          
    '-88888888.88' = .A                                                         
    '-66666666.66' = .C                                                         
    OTHER = (|12.2|)                                                            
  ;                                                                             
  INVALUE N12P5F                                                                
    '-99999.99999' = .                                                          
    '-88888.88888' = .A                                                         
    '-66666.66666' = .C                                                         
    OTHER = (|12.5|)                                                            
  ;                                                                             
  INVALUE N13PF                                                                 
    '-999999999999' = .                                                         
    '-888888888888' = .A                                                        
    '-666666666666' = .C                                                        
    OTHER = (|13.|)                                                             
  ;                                                                             
  INVALUE N15P2F                                                                
    '-99999999999.99' = .                                                       
    '-88888888888.88' = .A                                                      
    '-66666666666.66' = .C                                                      
    OTHER = (|15.2|)                                                            
  ;                                                                             
  RUN;                                                                          
                                                                                
                                                                                
*******************************;                                                
*  Data Step                  *;                                                
*******************************;                                                
DATA CO_SASDC_2015q1q3_CORE;                                                    
INFILE 'CO_SASD_2015q1q3_CORE.ASC' FIRSTOBS=3 LRECL = 1655;                     
                                                                                
*** Variable attribute ***;                                                     
ATTRIB                                                                          
  AGE                        LENGTH=3                                           
  LABEL="Age in years at admission"                                             
                                                                                
  AGEMONTH                   LENGTH=3                                           
  LABEL="Age in months (when age < 11 years)"                                   
                                                                                
  AMONTH                     LENGTH=3                                           
  LABEL="Admission month"                                                       
                                                                                
  ATYPE                      LENGTH=3                                           
  LABEL="Admission type"                                                        
                                                                                
  AWEEKEND                   LENGTH=3                                           
  LABEL="Admission day is a weekend"                                            
                                                                                
  CPT1                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 1"                                            
                                                                                
  CPT2                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 2"                                            
                                                                                
  CPT3                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 3"                                            
                                                                                
  CPT4                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 4"                                            
                                                                                
  CPT5                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 5"                                            
                                                                                
  CPT6                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 6"                                            
                                                                                
  CPT7                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 7"                                            
                                                                                
  CPT8                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 8"                                            
                                                                                
  CPT9                       LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 9"                                            
                                                                                
  CPT10                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 10"                                           
                                                                                
  CPT11                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 11"                                           
                                                                                
  CPT12                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 12"                                           
                                                                                
  CPT13                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 13"                                           
                                                                                
  CPT14                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 14"                                           
                                                                                
  CPT15                      LENGTH=$5                                          
  LABEL="CPT/HCPCS procedure code 15"                                           
                                                                                
  CPTCCS1                    LENGTH=4                                           
  LABEL="CCS: CPT 1"                                                            
                                                                                
  CPTCCS2                    LENGTH=4                                           
  LABEL="CCS: CPT 2"                                                            
                                                                                
  CPTCCS3                    LENGTH=4                                           
  LABEL="CCS: CPT 3"                                                            
                                                                                
  CPTCCS4                    LENGTH=4                                           
  LABEL="CCS: CPT 4"                                                            
                                                                                
  CPTCCS5                    LENGTH=4                                           
  LABEL="CCS: CPT 5"                                                            
                                                                                
  CPTCCS6                    LENGTH=4                                           
  LABEL="CCS: CPT 6"                                                            
                                                                                
  CPTCCS7                    LENGTH=4                                           
  LABEL="CCS: CPT 7"                                                            
                                                                                
  CPTCCS8                    LENGTH=4                                           
  LABEL="CCS: CPT 8"                                                            
                                                                                
  CPTCCS9                    LENGTH=4                                           
  LABEL="CCS: CPT 9"                                                            
                                                                                
  CPTCCS10                   LENGTH=4                                           
  LABEL="CCS: CPT 10"                                                           
                                                                                
  CPTCCS11                   LENGTH=4                                           
  LABEL="CCS: CPT 11"                                                           
                                                                                
  CPTCCS12                   LENGTH=4                                           
  LABEL="CCS: CPT 12"                                                           
                                                                                
  CPTCCS13                   LENGTH=4                                           
  LABEL="CCS: CPT 13"                                                           
                                                                                
  CPTCCS14                   LENGTH=4                                           
  LABEL="CCS: CPT 14"                                                           
                                                                                
  CPTCCS15                   LENGTH=4                                           
  LABEL="CCS: CPT 15"                                                           
                                                                                
  DIED                       LENGTH=3                                           
  LABEL="Died during hospitalization"                                           
                                                                                
  DISP_X                     LENGTH=$2                                          
  LABEL="Disposition of patient (as received from source)"                      
                                                                                
  DISPUB04                   LENGTH=3                                           
  LABEL="Disposition of patient (UB-04 standard coding)"                        
                                                                                
  DISPUNIFORM                LENGTH=3                                           
  LABEL="Disposition of patient (uniform)"                                      
                                                                                
  DMONTH                     LENGTH=3                                           
  LABEL="Discharge month"                                                       
                                                                                
  DQTR                       LENGTH=3                                           
  LABEL="Discharge quarter"                                                     
                                                                                
  DSHOSPID                   LENGTH=$17                                         
  LABEL="Data source hospital identifier"                                       
                                                                                
  DX1                        LENGTH=$7                                          
  LABEL="Diagnosis 1"                                                           
                                                                                
  DX2                        LENGTH=$7                                          
  LABEL="Diagnosis 2"                                                           
                                                                                
  DX3                        LENGTH=$7                                          
  LABEL="Diagnosis 3"                                                           
                                                                                
  DX4                        LENGTH=$7                                          
  LABEL="Diagnosis 4"                                                           
                                                                                
  DX5                        LENGTH=$7                                          
  LABEL="Diagnosis 5"                                                           
                                                                                
  DX6                        LENGTH=$7                                          
  LABEL="Diagnosis 6"                                                           
                                                                                
  DX7                        LENGTH=$7                                          
  LABEL="Diagnosis 7"                                                           
                                                                                
  DX8                        LENGTH=$7                                          
  LABEL="Diagnosis 8"                                                           
                                                                                
  DX9                        LENGTH=$7                                          
  LABEL="Diagnosis 9"                                                           
                                                                                
  DX10                       LENGTH=$7                                          
  LABEL="Diagnosis 10"                                                          
                                                                                
  DX11                       LENGTH=$7                                          
  LABEL="Diagnosis 11"                                                          
                                                                                
  DX12                       LENGTH=$7                                          
  LABEL="Diagnosis 12"                                                          
                                                                                
  DX13                       LENGTH=$7                                          
  LABEL="Diagnosis 13"                                                          
                                                                                
  DX14                       LENGTH=$7                                          
  LABEL="Diagnosis 14"                                                          
                                                                                
  DX15                       LENGTH=$7                                          
  LABEL="Diagnosis 15"                                                          
                                                                                
  DX16                       LENGTH=$7                                          
  LABEL="Diagnosis 16"                                                          
                                                                                
  DX17                       LENGTH=$7                                          
  LABEL="Diagnosis 17"                                                          
                                                                                
  DX18                       LENGTH=$7                                          
  LABEL="Diagnosis 18"                                                          
                                                                                
  DX19                       LENGTH=$7                                          
  LABEL="Diagnosis 19"                                                          
                                                                                
  DX20                       LENGTH=$7                                          
  LABEL="Diagnosis 20"                                                          
                                                                                
  DX21                       LENGTH=$7                                          
  LABEL="Diagnosis 21"                                                          
                                                                                
  DX22                       LENGTH=$7                                          
  LABEL="Diagnosis 22"                                                          
                                                                                
  DX23                       LENGTH=$7                                          
  LABEL="Diagnosis 23"                                                          
                                                                                
  DX24                       LENGTH=$7                                          
  LABEL="Diagnosis 24"                                                          
                                                                                
  DX25                       LENGTH=$7                                          
  LABEL="Diagnosis 25"                                                          
                                                                                
  DX26                       LENGTH=$7                                          
  LABEL="Diagnosis 26"                                                          
                                                                                
  DX27                       LENGTH=$7                                          
  LABEL="Diagnosis 27"                                                          
                                                                                
  DX28                       LENGTH=$7                                          
  LABEL="Diagnosis 28"                                                          
                                                                                
  DX29                       LENGTH=$7                                          
  LABEL="Diagnosis 29"                                                          
                                                                                
  DX30                       LENGTH=$7                                          
  LABEL="Diagnosis 30"                                                          
                                                                                
  DXCCS1                     LENGTH=4                                           
  LABEL="CCS: diagnosis 1"                                                      
                                                                                
  DXCCS2                     LENGTH=4                                           
  LABEL="CCS: diagnosis 2"                                                      
                                                                                
  DXCCS3                     LENGTH=4                                           
  LABEL="CCS: diagnosis 3"                                                      
                                                                                
  DXCCS4                     LENGTH=4                                           
  LABEL="CCS: diagnosis 4"                                                      
                                                                                
  DXCCS5                     LENGTH=4                                           
  LABEL="CCS: diagnosis 5"                                                      
                                                                                
  DXCCS6                     LENGTH=4                                           
  LABEL="CCS: diagnosis 6"                                                      
                                                                                
  DXCCS7                     LENGTH=4                                           
  LABEL="CCS: diagnosis 7"                                                      
                                                                                
  DXCCS8                     LENGTH=4                                           
  LABEL="CCS: diagnosis 8"                                                      
                                                                                
  DXCCS9                     LENGTH=4                                           
  LABEL="CCS: diagnosis 9"                                                      
                                                                                
  DXCCS10                    LENGTH=4                                           
  LABEL="CCS: diagnosis 10"                                                     
                                                                                
  DXCCS11                    LENGTH=4                                           
  LABEL="CCS: diagnosis 11"                                                     
                                                                                
  DXCCS12                    LENGTH=4                                           
  LABEL="CCS: diagnosis 12"                                                     
                                                                                
  DXCCS13                    LENGTH=4                                           
  LABEL="CCS: diagnosis 13"                                                     
                                                                                
  DXCCS14                    LENGTH=4                                           
  LABEL="CCS: diagnosis 14"                                                     
                                                                                
  DXCCS15                    LENGTH=4                                           
  LABEL="CCS: diagnosis 15"                                                     
                                                                                
  DXCCS16                    LENGTH=4                                           
  LABEL="CCS: diagnosis 16"                                                     
                                                                                
  DXCCS17                    LENGTH=4                                           
  LABEL="CCS: diagnosis 17"                                                     
                                                                                
  DXCCS18                    LENGTH=4                                           
  LABEL="CCS: diagnosis 18"                                                     
                                                                                
  DXCCS19                    LENGTH=4                                           
  LABEL="CCS: diagnosis 19"                                                     
                                                                                
  DXCCS20                    LENGTH=4                                           
  LABEL="CCS: diagnosis 20"                                                     
                                                                                
  DXCCS21                    LENGTH=4                                           
  LABEL="CCS: diagnosis 21"                                                     
                                                                                
  DXCCS22                    LENGTH=4                                           
  LABEL="CCS: diagnosis 22"                                                     
                                                                                
  DXCCS23                    LENGTH=4                                           
  LABEL="CCS: diagnosis 23"                                                     
                                                                                
  DXCCS24                    LENGTH=4                                           
  LABEL="CCS: diagnosis 24"                                                     
                                                                                
  DXCCS25                    LENGTH=4                                           
  LABEL="CCS: diagnosis 25"                                                     
                                                                                
  DXCCS26                    LENGTH=4                                           
  LABEL="CCS: diagnosis 26"                                                     
                                                                                
  DXCCS27                    LENGTH=4                                           
  LABEL="CCS: diagnosis 27"                                                     
                                                                                
  DXCCS28                    LENGTH=4                                           
  LABEL="CCS: diagnosis 28"                                                     
                                                                                
  DXCCS29                    LENGTH=4                                           
  LABEL="CCS: diagnosis 29"                                                     
                                                                                
  DXCCS30                    LENGTH=4                                           
  LABEL="CCS: diagnosis 30"                                                     
                                                                                
  DXVER                      LENGTH=3                                           
  LABEL="Diagnosis Version"                                                     
                                                                                
  E_CCS1                     LENGTH=3                                           
  LABEL="CCS: E Code 1"                                                         
                                                                                
  E_CCS2                     LENGTH=3                                           
  LABEL="CCS: E Code 2"                                                         
                                                                                
  E_CCS3                     LENGTH=3                                           
  LABEL="CCS: E Code 3"                                                         
                                                                                
  E_CCS4                     LENGTH=3                                           
  LABEL="CCS: E Code 4"                                                         
                                                                                
  E_CCS5                     LENGTH=3                                           
  LABEL="CCS: E Code 5"                                                         
                                                                                
  E_CCS6                     LENGTH=3                                           
  LABEL="CCS: E Code 6"                                                         
                                                                                
  E_CCS7                     LENGTH=3                                           
  LABEL="CCS: E Code 7"                                                         
                                                                                
  E_CCS8                     LENGTH=3                                           
  LABEL="CCS: E Code 8"                                                         
                                                                                
  E_CCS9                     LENGTH=3                                           
  LABEL="CCS: E Code 9"                                                         
                                                                                
  E_CCS10                    LENGTH=3                                           
  LABEL="CCS: E Code 10"                                                        
                                                                                
  E_CCS11                    LENGTH=3                                           
  LABEL="CCS: E Code 11"                                                        
                                                                                
  E_CCS12                    LENGTH=3                                           
  LABEL="CCS: E Code 12"                                                        
                                                                                
  E_CCS13                    LENGTH=3                                           
  LABEL="CCS: E Code 13"                                                        
                                                                                
  E_CCS14                    LENGTH=3                                           
  LABEL="CCS: E Code 14"                                                        
                                                                                
  E_CCS15                    LENGTH=3                                           
  LABEL="CCS: E Code 15"                                                        
                                                                                
  E_CCS16                    LENGTH=3                                           
  LABEL="CCS: E Code 16"                                                        
                                                                                
  E_CCS17                    LENGTH=3                                           
  LABEL="CCS: E Code 17"                                                        
                                                                                
  E_CCS18                    LENGTH=3                                           
  LABEL="CCS: E Code 18"                                                        
                                                                                
  E_CCS19                    LENGTH=3                                           
  LABEL="CCS: E Code 19"                                                        
                                                                                
  E_CCS20                    LENGTH=3                                           
  LABEL="CCS: E Code 20"                                                        
                                                                                
  E_CCS21                    LENGTH=3                                           
  LABEL="CCS: E Code 21"                                                        
                                                                                
  E_CCS22                    LENGTH=3                                           
  LABEL="CCS: E Code 22"                                                        
                                                                                
  E_CCS23                    LENGTH=3                                           
  LABEL="CCS: E Code 23"                                                        
                                                                                
  E_CCS24                    LENGTH=3                                           
  LABEL="CCS: E Code 24"                                                        
                                                                                
  E_CCS25                    LENGTH=3                                           
  LABEL="CCS: E Code 25"                                                        
                                                                                
  E_CCS26                    LENGTH=3                                           
  LABEL="CCS: E Code 26"                                                        
                                                                                
  E_CCS27                    LENGTH=3                                           
  LABEL="CCS: E Code 27"                                                        
                                                                                
  E_CCS28                    LENGTH=3                                           
  LABEL="CCS: E Code 28"                                                        
                                                                                
  E_CCS29                    LENGTH=3                                           
  LABEL="CCS: E Code 29"                                                        
                                                                                
  E_CCS30                    LENGTH=3                                           
  LABEL="CCS: E Code 30"                                                        
                                                                                
  ECODE1                     LENGTH=$7                                          
  LABEL="E code 1"                                                              
                                                                                
  ECODE2                     LENGTH=$7                                          
  LABEL="E code 2"                                                              
                                                                                
  ECODE3                     LENGTH=$7                                          
  LABEL="E code 3"                                                              
                                                                                
  ECODE4                     LENGTH=$7                                          
  LABEL="E code 4"                                                              
                                                                                
  ECODE5                     LENGTH=$7                                          
  LABEL="E code 5"                                                              
                                                                                
  ECODE6                     LENGTH=$7                                          
  LABEL="E code 6"                                                              
                                                                                
  ECODE7                     LENGTH=$7                                          
  LABEL="E code 7"                                                              
                                                                                
  ECODE8                     LENGTH=$7                                          
  LABEL="E code 8"                                                              
                                                                                
  ECODE9                     LENGTH=$7                                          
  LABEL="E code 9"                                                              
                                                                                
  ECODE10                    LENGTH=$7                                          
  LABEL="E code 10"                                                             
                                                                                
  ECODE11                    LENGTH=$7                                          
  LABEL="E code 11"                                                             
                                                                                
  ECODE12                    LENGTH=$7                                          
  LABEL="E code 12"                                                             
                                                                                
  ECODE13                    LENGTH=$7                                          
  LABEL="E code 13"                                                             
                                                                                
  ECODE14                    LENGTH=$7                                          
  LABEL="E code 14"                                                             
                                                                                
  ECODE15                    LENGTH=$7                                          
  LABEL="E code 15"                                                             
                                                                                
  ECODE16                    LENGTH=$7                                          
  LABEL="E code 16"                                                             
                                                                                
  ECODE17                    LENGTH=$7                                          
  LABEL="E code 17"                                                             
                                                                                
  ECODE18                    LENGTH=$7                                          
  LABEL="E code 18"                                                             
                                                                                
  ECODE19                    LENGTH=$7                                          
  LABEL="E code 19"                                                             
                                                                                
  ECODE20                    LENGTH=$7                                          
  LABEL="E code 20"                                                             
                                                                                
  ECODE21                    LENGTH=$7                                          
  LABEL="E code 21"                                                             
                                                                                
  ECODE22                    LENGTH=$7                                          
  LABEL="E code 22"                                                             
                                                                                
  ECODE23                    LENGTH=$7                                          
  LABEL="E code 23"                                                             
                                                                                
  ECODE24                    LENGTH=$7                                          
  LABEL="E code 24"                                                             
                                                                                
  ECODE25                    LENGTH=$7                                          
  LABEL="E code 25"                                                             
                                                                                
  ECODE26                    LENGTH=$7                                          
  LABEL="E code 26"                                                             
                                                                                
  ECODE27                    LENGTH=$7                                          
  LABEL="E code 27"                                                             
                                                                                
  ECODE28                    LENGTH=$7                                          
  LABEL="E code 28"                                                             
                                                                                
  ECODE29                    LENGTH=$7                                          
  LABEL="E code 29"                                                             
                                                                                
  ECODE30                    LENGTH=$7                                          
  LABEL="E code 30"                                                             
                                                                                
  FEMALE                     LENGTH=3                                           
  LABEL="Indicator of sex"                                                      
                                                                                
  HCUP_ED                    LENGTH=3                                           
  LABEL="HCUP Emergency Department service indicator"                           
                                                                                
  HCUP_OS                    LENGTH=3                                           
  LABEL="HCUP Observation Stay service indicator"                               
                                                                                
  HCUP_SURGERY_BROAD_CPT     LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported CPT procedures that qualify as a surgery using a broad defin
ition"                                                                          
                                                                                
  HCUP_SURGERY_BROAD_I9      LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported ICD-9-CM procedures that qualify as a surgery using a broad 
definition"                                                                     
                                                                                
  HCUP_SURGERY_NARROW_CPT    LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported CPT procedures that qualify as a surgery using a narrow defi
nition"                                                                         
                                                                                
  HCUP_SURGERY_NARROW_I9     LENGTH=3                                           
  LABEL=                                                                        
                                                                                
"Number of reported ICD-9-CM procedures that qualify as a surgery using a narrow
 definition"                                                                    
                                                                                
  Homeless                   LENGTH=3                                           
  LABEL="Indicator that patient is homeless"                                    
                                                                                
  HOSPBRTH                   LENGTH=3                                           
  LABEL="Indicator of birth in this hospital"                                   
                                                                                
  HOSPST                     LENGTH=$2                                          
  LABEL="Hospital state postal code"                                            
                                                                                
  KEY                        LENGTH=8                      FORMAT=Z15.          
  LABEL="HCUP record identifier"                                                
                                                                                
  LOS                        LENGTH=4                                           
  LABEL="Length of stay (cleaned)"                                              
                                                                                
  LOS_X                      LENGTH=4                                           
  LABEL="Length of stay (as received from source)"                              
                                                                                
  MDNUM1_R                   LENGTH=5                                           
  LABEL="Physician 1 number (re-identified)"                                    
                                                                                
  MDNUM2_R                   LENGTH=5                                           
  LABEL="Physician 2 number (re-identified)"                                    
                                                                                
  MEDINCSTQ                  LENGTH=3                                           
  LABEL="Median household income state quartile for patient ZIP Code"           
                                                                                
  MRN_R                      LENGTH=5                                           
  LABEL="Medical record number (re-identified)"                                 
                                                                                
  NCHRONIC                   LENGTH=3                                           
  LABEL="Number of chronic conditions"                                          
                                                                                
  NCPT                       LENGTH=3                                           
  LABEL="Number of CPT/HCPCS procedures for this visit"                         
                                                                                
  NDX                        LENGTH=3                                           
  LABEL="Number of diagnoses on this record"                                    
                                                                                
  NECODE                     LENGTH=3                                           
  LABEL="Number of E codes on this record"                                      
                                                                                
  NEOMAT                     LENGTH=3                                           
  LABEL="Neonatal and/or maternal DX and/or PR"                                 
                                                                                
  NPR                        LENGTH=3                                           
  LABEL="Number of procedures on this record"                                   
                                                                                
  ORPROC                     LENGTH=3                                           
  LABEL="Major operating room procedure indicator"                              
                                                                                
  PAY1                       LENGTH=3                                           
  LABEL="Primary expected payer (uniform)"                                      
                                                                                
  PAY1_X                     LENGTH=$2                                          
  LABEL="Primary expected payer (as received from source)"                      
                                                                                
  PL_CBSA                    LENGTH=3                                           
  LABEL="Patient location: Core Based Statistical Area (CBSA)"                  
                                                                                
  PL_NCHS                    LENGTH=3                                           
  LABEL="Patient Location: NCHS Urban-Rural Code"                               
                                                                                
  PL_RUCC                    LENGTH=3                                           
  LABEL="Patient location: Rural-Urban Continuum Codes(RUCC)"                   
                                                                                
  PL_UIC                     LENGTH=3                                           
  LABEL="Patient location: Urban Influence Codes"                               
                                                                                
  PL_UR_CAT4                 LENGTH=3                                           
  LABEL="Patient Location: Urban-Rural 4 Categories"                            
                                                                                
  PointOfOrigin_X            LENGTH=$1                                          
  LABEL="Point of origin for admission or visit, as received from source"       
                                                                                
  PointOfOriginUB04          LENGTH=$1                                          
  LABEL="Point of origin for admission or visit, UB-04 standard coding"         
                                                                                
  PR1                        LENGTH=$7                                          
  LABEL="Procedure 1"                                                           
                                                                                
  PR2                        LENGTH=$7                                          
  LABEL="Procedure 2"                                                           
                                                                                
  PR3                        LENGTH=$7                                          
  LABEL="Procedure 3"                                                           
                                                                                
  PR4                        LENGTH=$7                                          
  LABEL="Procedure 4"                                                           
                                                                                
  PR5                        LENGTH=$7                                          
  LABEL="Procedure 5"                                                           
                                                                                
  PR6                        LENGTH=$7                                          
  LABEL="Procedure 6"                                                           
                                                                                
  PR7                        LENGTH=$7                                          
  LABEL="Procedure 7"                                                           
                                                                                
  PR8                        LENGTH=$7                                          
  LABEL="Procedure 8"                                                           
                                                                                
  PR9                        LENGTH=$7                                          
  LABEL="Procedure 9"                                                           
                                                                                
  PR10                       LENGTH=$7                                          
  LABEL="Procedure 10"                                                          
                                                                                
  PR11                       LENGTH=$7                                          
  LABEL="Procedure 11"                                                          
                                                                                
  PR12                       LENGTH=$7                                          
  LABEL="Procedure 12"                                                          
                                                                                
  PR13                       LENGTH=$7                                          
  LABEL="Procedure 13"                                                          
                                                                                
  PR14                       LENGTH=$7                                          
  LABEL="Procedure 14"                                                          
                                                                                
  PR15                       LENGTH=$7                                          
  LABEL="Procedure 15"                                                          
                                                                                
  PR16                       LENGTH=$7                                          
  LABEL="Procedure 16"                                                          
                                                                                
  PR17                       LENGTH=$7                                          
  LABEL="Procedure 17"                                                          
                                                                                
  PR18                       LENGTH=$7                                          
  LABEL="Procedure 18"                                                          
                                                                                
  PR19                       LENGTH=$7                                          
  LABEL="Procedure 19"                                                          
                                                                                
  PR20                       LENGTH=$7                                          
  LABEL="Procedure 20"                                                          
                                                                                
  PR21                       LENGTH=$7                                          
  LABEL="Procedure 21"                                                          
                                                                                
  PR22                       LENGTH=$7                                          
  LABEL="Procedure 22"                                                          
                                                                                
  PR23                       LENGTH=$7                                          
  LABEL="Procedure 23"                                                          
                                                                                
  PR24                       LENGTH=$7                                          
  LABEL="Procedure 24"                                                          
                                                                                
  PR25                       LENGTH=$7                                          
  LABEL="Procedure 25"                                                          
                                                                                
  PR26                       LENGTH=$7                                          
  LABEL="Procedure 26"                                                          
                                                                                
  PR27                       LENGTH=$7                                          
  LABEL="Procedure 27"                                                          
                                                                                
  PR28                       LENGTH=$7                                          
  LABEL="Procedure 28"                                                          
                                                                                
  PR29                       LENGTH=$7                                          
  LABEL="Procedure 29"                                                          
                                                                                
  PR30                       LENGTH=$7                                          
  LABEL="Procedure 30"                                                          
                                                                                
  PRCCS1                     LENGTH=3                                           
  LABEL="CCS: procedure 1"                                                      
                                                                                
  PRCCS2                     LENGTH=3                                           
  LABEL="CCS: procedure 2"                                                      
                                                                                
  PRCCS3                     LENGTH=3                                           
  LABEL="CCS: procedure 3"                                                      
                                                                                
  PRCCS4                     LENGTH=3                                           
  LABEL="CCS: procedure 4"                                                      
                                                                                
  PRCCS5                     LENGTH=3                                           
  LABEL="CCS: procedure 5"                                                      
                                                                                
  PRCCS6                     LENGTH=3                                           
  LABEL="CCS: procedure 6"                                                      
                                                                                
  PRCCS7                     LENGTH=3                                           
  LABEL="CCS: procedure 7"                                                      
                                                                                
  PRCCS8                     LENGTH=3                                           
  LABEL="CCS: procedure 8"                                                      
                                                                                
  PRCCS9                     LENGTH=3                                           
  LABEL="CCS: procedure 9"                                                      
                                                                                
  PRCCS10                    LENGTH=3                                           
  LABEL="CCS: procedure 10"                                                     
                                                                                
  PRCCS11                    LENGTH=3                                           
  LABEL="CCS: procedure 11"                                                     
                                                                                
  PRCCS12                    LENGTH=3                                           
  LABEL="CCS: procedure 12"                                                     
                                                                                
  PRCCS13                    LENGTH=3                                           
  LABEL="CCS: procedure 13"                                                     
                                                                                
  PRCCS14                    LENGTH=3                                           
  LABEL="CCS: procedure 14"                                                     
                                                                                
  PRCCS15                    LENGTH=3                                           
  LABEL="CCS: procedure 15"                                                     
                                                                                
  PRCCS16                    LENGTH=3                                           
  LABEL="CCS: procedure 16"                                                     
                                                                                
  PRCCS17                    LENGTH=3                                           
  LABEL="CCS: procedure 17"                                                     
                                                                                
  PRCCS18                    LENGTH=3                                           
  LABEL="CCS: procedure 18"                                                     
                                                                                
  PRCCS19                    LENGTH=3                                           
  LABEL="CCS: procedure 19"                                                     
                                                                                
  PRCCS20                    LENGTH=3                                           
  LABEL="CCS: procedure 20"                                                     
                                                                                
  PRCCS21                    LENGTH=3                                           
  LABEL="CCS: procedure 21"                                                     
                                                                                
  PRCCS22                    LENGTH=3                                           
  LABEL="CCS: procedure 22"                                                     
                                                                                
  PRCCS23                    LENGTH=3                                           
  LABEL="CCS: procedure 23"                                                     
                                                                                
  PRCCS24                    LENGTH=3                                           
  LABEL="CCS: procedure 24"                                                     
                                                                                
  PRCCS25                    LENGTH=3                                           
  LABEL="CCS: procedure 25"                                                     
                                                                                
  PRCCS26                    LENGTH=3                                           
  LABEL="CCS: procedure 26"                                                     
                                                                                
  PRCCS27                    LENGTH=3                                           
  LABEL="CCS: procedure 27"                                                     
                                                                                
  PRCCS28                    LENGTH=3                                           
  LABEL="CCS: procedure 28"                                                     
                                                                                
  PRCCS29                    LENGTH=3                                           
  LABEL="CCS: procedure 29"                                                     
                                                                                
  PRCCS30                    LENGTH=3                                           
  LABEL="CCS: procedure 30"                                                     
                                                                                
  PRDAY1                     LENGTH=4                                           
  LABEL="Number of days from admission to PR1"                                  
                                                                                
  PRDAY2                     LENGTH=4                                           
  LABEL="Number of days from admission to PR2"                                  
                                                                                
  PRDAY3                     LENGTH=4                                           
  LABEL="Number of days from admission to PR3"                                  
                                                                                
  PRDAY4                     LENGTH=4                                           
  LABEL="Number of days from admission to PR4"                                  
                                                                                
  PRDAY5                     LENGTH=4                                           
  LABEL="Number of days from admission to PR5"                                  
                                                                                
  PRDAY6                     LENGTH=4                                           
  LABEL="Number of days from admission to PR6"                                  
                                                                                
  PRDAY7                     LENGTH=4                                           
  LABEL="Number of days from admission to PR7"                                  
                                                                                
  PRDAY8                     LENGTH=4                                           
  LABEL="Number of days from admission to PR8"                                  
                                                                                
  PRDAY9                     LENGTH=4                                           
  LABEL="Number of days from admission to PR9"                                  
                                                                                
  PRDAY10                    LENGTH=4                                           
  LABEL="Number of days from admission to PR10"                                 
                                                                                
  PRDAY11                    LENGTH=4                                           
  LABEL="Number of days from admission to PR11"                                 
                                                                                
  PRDAY12                    LENGTH=4                                           
  LABEL="Number of days from admission to PR12"                                 
                                                                                
  PRDAY13                    LENGTH=4                                           
  LABEL="Number of days from admission to PR13"                                 
                                                                                
  PRDAY14                    LENGTH=4                                           
  LABEL="Number of days from admission to PR14"                                 
                                                                                
  PRDAY15                    LENGTH=4                                           
  LABEL="Number of days from admission to PR15"                                 
                                                                                
  PRDAY16                    LENGTH=4                                           
  LABEL="Number of days from admission to PR16"                                 
                                                                                
  PRDAY17                    LENGTH=4                                           
  LABEL="Number of days from admission to PR17"                                 
                                                                                
  PRDAY18                    LENGTH=4                                           
  LABEL="Number of days from admission to PR18"                                 
                                                                                
  PRDAY19                    LENGTH=4                                           
  LABEL="Number of days from admission to PR19"                                 
                                                                                
  PRDAY20                    LENGTH=4                                           
  LABEL="Number of days from admission to PR20"                                 
                                                                                
  PRDAY21                    LENGTH=4                                           
  LABEL="Number of days from admission to PR21"                                 
                                                                                
  PRDAY22                    LENGTH=4                                           
  LABEL="Number of days from admission to PR22"                                 
                                                                                
  PRDAY23                    LENGTH=4                                           
  LABEL="Number of days from admission to PR23"                                 
                                                                                
  PRDAY24                    LENGTH=4                                           
  LABEL="Number of days from admission to PR24"                                 
                                                                                
  PRDAY25                    LENGTH=4                                           
  LABEL="Number of days from admission to PR25"                                 
                                                                                
  PRDAY26                    LENGTH=4                                           
  LABEL="Number of days from admission to PR26"                                 
                                                                                
  PRDAY27                    LENGTH=4                                           
  LABEL="Number of days from admission to PR27"                                 
                                                                                
  PRDAY28                    LENGTH=4                                           
  LABEL="Number of days from admission to PR28"                                 
                                                                                
  PRDAY29                    LENGTH=4                                           
  LABEL="Number of days from admission to PR29"                                 
                                                                                
  PRDAY30                    LENGTH=4                                           
  LABEL="Number of days from admission to PR30"                                 
                                                                                
  PROCTYPE                   LENGTH=3                                           
  LABEL="Procedure type indicator"                                              
                                                                                
  PRVER                      LENGTH=3                                           
  LABEL="Procedure Version"                                                     
                                                                                
  PSTATE                     LENGTH=$2                                          
  LABEL="Patient State postal code"                                             
                                                                                
  PSTCO                      LENGTH=4                      FORMAT=Z5.           
  LABEL="Patient state/county FIPS code"                                        
                                                                                
  PSTCO2                     LENGTH=4                      FORMAT=Z5.           
  LABEL="Patient state/county FIPS code, possibly derived from ZIP Code"        
                                                                                
  RACE                       LENGTH=3                                           
  LABEL="Race (uniform)"                                                        
                                                                                
  RACE_X                     LENGTH=$1                                          
  LABEL="Race (as received from source)"                                        
                                                                                
  STATE_AS                   LENGTH=3                                           
  LABEL="State Ambulatory Surgery service indicator"                            
                                                                                
  STATE_ED                   LENGTH=3                                           
  LABEL="State Emergency Department service indicator"                          
                                                                                
  STATE_OS                   LENGTH=3                                           
  LABEL="State Observation Stay service indicator"                              
                                                                                
  TOTCHG                     LENGTH=6                                           
  LABEL="Total charges (cleaned)"                                               
                                                                                
  TOTCHG_X                   LENGTH=7                                           
  LABEL="Total charges (as received from source)"                               
                                                                                
  YEAR                       LENGTH=3                                           
  LABEL="Calendar year"                                                         
                                                                                
  ZIP                        LENGTH=$5                                          
  LABEL="Patient ZIP Code"                                                      
                                                                                
  ZIP3                       LENGTH=$3                                          
  LABEL="Patient ZIP Code, first 3 digits"                                      
                                                                                
  ZIPINC_QRTL                LENGTH=3                                           
  LABEL="Median household income national quartile for patient ZIP Code"        
                                                                                
  AYEAR                      LENGTH=3                                           
  LABEL="Admission year"                                                        
                                                                                
  BMONTH                     LENGTH=3                                           
  LABEL="Birth month"                                                           
                                                                                
  BYEAR                      LENGTH=3                                           
  LABEL="Birth year"                                                            
                                                                                
  PRMONTH1                   LENGTH=3                                           
  LABEL="Month of procedure 1"                                                  
                                                                                
  PRMONTH2                   LENGTH=3                                           
  LABEL="Month of procedure 2"                                                  
                                                                                
  PRMONTH3                   LENGTH=3                                           
  LABEL="Month of procedure 3"                                                  
                                                                                
  PRMONTH4                   LENGTH=3                                           
  LABEL="Month of procedure 4"                                                  
                                                                                
  PRMONTH5                   LENGTH=3                                           
  LABEL="Month of procedure 5"                                                  
                                                                                
  PRMONTH6                   LENGTH=3                                           
  LABEL="Month of procedure 6"                                                  
                                                                                
  PRMONTH7                   LENGTH=3                                           
  LABEL="Month of procedure 7"                                                  
                                                                                
  PRMONTH8                   LENGTH=3                                           
  LABEL="Month of procedure 8"                                                  
                                                                                
  PRMONTH9                   LENGTH=3                                           
  LABEL="Month of procedure 9"                                                  
                                                                                
  PRMONTH10                  LENGTH=3                                           
  LABEL="Month of procedure 10"                                                 
                                                                                
  PRMONTH11                  LENGTH=3                                           
  LABEL="Month of procedure 11"                                                 
                                                                                
  PRMONTH12                  LENGTH=3                                           
  LABEL="Month of procedure 12"                                                 
                                                                                
  PRMONTH13                  LENGTH=3                                           
  LABEL="Month of procedure 13"                                                 
                                                                                
  PRMONTH14                  LENGTH=3                                           
  LABEL="Month of procedure 14"                                                 
                                                                                
  PRMONTH15                  LENGTH=3                                           
  LABEL="Month of procedure 15"                                                 
                                                                                
  PRMONTH16                  LENGTH=3                                           
  LABEL="Month of procedure 16"                                                 
                                                                                
  PRMONTH17                  LENGTH=3                                           
  LABEL="Month of procedure 17"                                                 
                                                                                
  PRMONTH18                  LENGTH=3                                           
  LABEL="Month of procedure 18"                                                 
                                                                                
  PRMONTH19                  LENGTH=3                                           
  LABEL="Month of procedure 19"                                                 
                                                                                
  PRMONTH20                  LENGTH=3                                           
  LABEL="Month of procedure 20"                                                 
                                                                                
  PRMONTH21                  LENGTH=3                                           
  LABEL="Month of procedure 21"                                                 
                                                                                
  PRMONTH22                  LENGTH=3                                           
  LABEL="Month of procedure 22"                                                 
                                                                                
  PRMONTH23                  LENGTH=3                                           
  LABEL="Month of procedure 23"                                                 
                                                                                
  PRMONTH24                  LENGTH=3                                           
  LABEL="Month of procedure 24"                                                 
                                                                                
  PRMONTH25                  LENGTH=3                                           
  LABEL="Month of procedure 25"                                                 
                                                                                
  PRMONTH26                  LENGTH=3                                           
  LABEL="Month of procedure 26"                                                 
                                                                                
  PRMONTH27                  LENGTH=3                                           
  LABEL="Month of procedure 27"                                                 
                                                                                
  PRMONTH28                  LENGTH=3                                           
  LABEL="Month of procedure 28"                                                 
                                                                                
  PRMONTH29                  LENGTH=3                                           
  LABEL="Month of procedure 29"                                                 
                                                                                
  PRMONTH30                  LENGTH=3                                           
  LABEL="Month of procedure 30"                                                 
                                                                                
  PRYEAR1                    LENGTH=3                                           
  LABEL="Year of procedure 1"                                                   
                                                                                
  PRYEAR2                    LENGTH=3                                           
  LABEL="Year of procedure 2"                                                   
                                                                                
  PRYEAR3                    LENGTH=3                                           
  LABEL="Year of procedure 3"                                                   
                                                                                
  PRYEAR4                    LENGTH=3                                           
  LABEL="Year of procedure 4"                                                   
                                                                                
  PRYEAR5                    LENGTH=3                                           
  LABEL="Year of procedure 5"                                                   
                                                                                
  PRYEAR6                    LENGTH=3                                           
  LABEL="Year of procedure 6"                                                   
                                                                                
  PRYEAR7                    LENGTH=3                                           
  LABEL="Year of procedure 7"                                                   
                                                                                
  PRYEAR8                    LENGTH=3                                           
  LABEL="Year of procedure 8"                                                   
                                                                                
  PRYEAR9                    LENGTH=3                                           
  LABEL="Year of procedure 9"                                                   
                                                                                
  PRYEAR10                   LENGTH=3                                           
  LABEL="Year of procedure 10"                                                  
                                                                                
  PRYEAR11                   LENGTH=3                                           
  LABEL="Year of procedure 11"                                                  
                                                                                
  PRYEAR12                   LENGTH=3                                           
  LABEL="Year of procedure 12"                                                  
                                                                                
  PRYEAR13                   LENGTH=3                                           
  LABEL="Year of procedure 13"                                                  
                                                                                
  PRYEAR14                   LENGTH=3                                           
  LABEL="Year of procedure 14"                                                  
                                                                                
  PRYEAR15                   LENGTH=3                                           
  LABEL="Year of procedure 15"                                                  
                                                                                
  PRYEAR16                   LENGTH=3                                           
  LABEL="Year of procedure 16"                                                  
                                                                                
  PRYEAR17                   LENGTH=3                                           
  LABEL="Year of procedure 17"                                                  
                                                                                
  PRYEAR18                   LENGTH=3                                           
  LABEL="Year of procedure 18"                                                  
                                                                                
  PRYEAR19                   LENGTH=3                                           
  LABEL="Year of procedure 19"                                                  
                                                                                
  PRYEAR20                   LENGTH=3                                           
  LABEL="Year of procedure 20"                                                  
                                                                                
  PRYEAR21                   LENGTH=3                                           
  LABEL="Year of procedure 21"                                                  
                                                                                
  PRYEAR22                   LENGTH=3                                           
  LABEL="Year of procedure 22"                                                  
                                                                                
  PRYEAR23                   LENGTH=3                                           
  LABEL="Year of procedure 23"                                                  
                                                                                
  PRYEAR24                   LENGTH=3                                           
  LABEL="Year of procedure 24"                                                  
                                                                                
  PRYEAR25                   LENGTH=3                                           
  LABEL="Year of procedure 25"                                                  
                                                                                
  PRYEAR26                   LENGTH=3                                           
  LABEL="Year of procedure 26"                                                  
                                                                                
  PRYEAR27                   LENGTH=3                                           
  LABEL="Year of procedure 27"                                                  
                                                                                
  PRYEAR28                   LENGTH=3                                           
  LABEL="Year of procedure 28"                                                  
                                                                                
  PRYEAR29                   LENGTH=3                                           
  LABEL="Year of procedure 29"                                                  
                                                                                
  PRYEAR30                   LENGTH=3                                           
  LABEL="Year of procedure 30"                                                  
  ;                                                                             
                                                                                
                                                                                
*** Input the variables from the ASCII file ***;                                
INPUT                                                                           
      @1      AGE                           N3PF.                               
      @4      AGEMONTH                      N3PF.                               
      @7      AMONTH                        N2PF.                               
      @9      ATYPE                         N2PF.                               
      @11     AWEEKEND                      N2PF.                               
      @13     CPT1                          $CHAR5.                             
      @18     CPT2                          $CHAR5.                             
      @23     CPT3                          $CHAR5.                             
      @28     CPT4                          $CHAR5.                             
      @33     CPT5                          $CHAR5.                             
      @38     CPT6                          $CHAR5.                             
      @43     CPT7                          $CHAR5.                             
      @48     CPT8                          $CHAR5.                             
      @53     CPT9                          $CHAR5.                             
      @58     CPT10                         $CHAR5.                             
      @63     CPT11                         $CHAR5.                             
      @68     CPT12                         $CHAR5.                             
      @73     CPT13                         $CHAR5.                             
      @78     CPT14                         $CHAR5.                             
      @83     CPT15                         $CHAR5.                             
      @88     CPTCCS1                       N3PF.                               
      @91     CPTCCS2                       N3PF.                               
      @94     CPTCCS3                       N3PF.                               
      @97     CPTCCS4                       N3PF.                               
      @100    CPTCCS5                       N3PF.                               
      @103    CPTCCS6                       N3PF.                               
      @106    CPTCCS7                       N3PF.                               
      @109    CPTCCS8                       N3PF.                               
      @112    CPTCCS9                       N3PF.                               
      @115    CPTCCS10                      N3PF.                               
      @118    CPTCCS11                      N3PF.                               
      @121    CPTCCS12                      N3PF.                               
      @124    CPTCCS13                      N3PF.                               
      @127    CPTCCS14                      N3PF.                               
      @130    CPTCCS15                      N3PF.                               
      @133    DIED                          N2PF.                               
      @135    DISP_X                        $CHAR2.                             
      @137    DISPUB04                      N2PF.                               
      @139    DISPUNIFORM                   N2PF.                               
      @141    DMONTH                        N2PF.                               
      @143    DQTR                          N2PF.                               
      @145    DSHOSPID                      $CHAR17.                            
      @162    DX1                           $CHAR7.                             
      @169    DX2                           $CHAR7.                             
      @176    DX3                           $CHAR7.                             
      @183    DX4                           $CHAR7.                             
      @190    DX5                           $CHAR7.                             
      @197    DX6                           $CHAR7.                             
      @204    DX7                           $CHAR7.                             
      @211    DX8                           $CHAR7.                             
      @218    DX9                           $CHAR7.                             
      @225    DX10                          $CHAR7.                             
      @232    DX11                          $CHAR7.                             
      @239    DX12                          $CHAR7.                             
      @246    DX13                          $CHAR7.                             
      @253    DX14                          $CHAR7.                             
      @260    DX15                          $CHAR7.                             
      @267    DX16                          $CHAR7.                             
      @274    DX17                          $CHAR7.                             
      @281    DX18                          $CHAR7.                             
      @288    DX19                          $CHAR7.                             
      @295    DX20                          $CHAR7.                             
      @302    DX21                          $CHAR7.                             
      @309    DX22                          $CHAR7.                             
      @316    DX23                          $CHAR7.                             
      @323    DX24                          $CHAR7.                             
      @330    DX25                          $CHAR7.                             
      @337    DX26                          $CHAR7.                             
      @344    DX27                          $CHAR7.                             
      @351    DX28                          $CHAR7.                             
      @358    DX29                          $CHAR7.                             
      @365    DX30                          $CHAR7.                             
      @372    DXCCS1                        N4PF.                               
      @376    DXCCS2                        N4PF.                               
      @380    DXCCS3                        N4PF.                               
      @384    DXCCS4                        N4PF.                               
      @388    DXCCS5                        N4PF.                               
      @392    DXCCS6                        N4PF.                               
      @396    DXCCS7                        N4PF.                               
      @400    DXCCS8                        N4PF.                               
      @404    DXCCS9                        N4PF.                               
      @408    DXCCS10                       N4PF.                               
      @412    DXCCS11                       N4PF.                               
      @416    DXCCS12                       N4PF.                               
      @420    DXCCS13                       N4PF.                               
      @424    DXCCS14                       N4PF.                               
      @428    DXCCS15                       N4PF.                               
      @432    DXCCS16                       N4PF.                               
      @436    DXCCS17                       N4PF.                               
      @440    DXCCS18                       N4PF.                               
      @444    DXCCS19                       N4PF.                               
      @448    DXCCS20                       N4PF.                               
      @452    DXCCS21                       N4PF.                               
      @456    DXCCS22                       N4PF.                               
      @460    DXCCS23                       N4PF.                               
      @464    DXCCS24                       N4PF.                               
      @468    DXCCS25                       N4PF.                               
      @472    DXCCS26                       N4PF.                               
      @476    DXCCS27                       N4PF.                               
      @480    DXCCS28                       N4PF.                               
      @484    DXCCS29                       N4PF.                               
      @488    DXCCS30                       N4PF.                               
      @492    DXVER                         N3PF.                               
      @495    E_CCS1                        N4PF.                               
      @499    E_CCS2                        N4PF.                               
      @503    E_CCS3                        N4PF.                               
      @507    E_CCS4                        N4PF.                               
      @511    E_CCS5                        N4PF.                               
      @515    E_CCS6                        N4PF.                               
      @519    E_CCS7                        N4PF.                               
      @523    E_CCS8                        N4PF.                               
      @527    E_CCS9                        N4PF.                               
      @531    E_CCS10                       N4PF.                               
      @535    E_CCS11                       N4PF.                               
      @539    E_CCS12                       N4PF.                               
      @543    E_CCS13                       N4PF.                               
      @547    E_CCS14                       N4PF.                               
      @551    E_CCS15                       N4PF.                               
      @555    E_CCS16                       N4PF.                               
      @559    E_CCS17                       N4PF.                               
      @563    E_CCS18                       N4PF.                               
      @567    E_CCS19                       N4PF.                               
      @571    E_CCS20                       N4PF.                               
      @575    E_CCS21                       N4PF.                               
      @579    E_CCS22                       N4PF.                               
      @583    E_CCS23                       N4PF.                               
      @587    E_CCS24                       N4PF.                               
      @591    E_CCS25                       N4PF.                               
      @595    E_CCS26                       N4PF.                               
      @599    E_CCS27                       N4PF.                               
      @603    E_CCS28                       N4PF.                               
      @607    E_CCS29                       N4PF.                               
      @611    E_CCS30                       N4PF.                               
      @615    ECODE1                        $CHAR7.                             
      @622    ECODE2                        $CHAR7.                             
      @629    ECODE3                        $CHAR7.                             
      @636    ECODE4                        $CHAR7.                             
      @643    ECODE5                        $CHAR7.                             
      @650    ECODE6                        $CHAR7.                             
      @657    ECODE7                        $CHAR7.                             
      @664    ECODE8                        $CHAR7.                             
      @671    ECODE9                        $CHAR7.                             
      @678    ECODE10                       $CHAR7.                             
      @685    ECODE11                       $CHAR7.                             
      @692    ECODE12                       $CHAR7.                             
      @699    ECODE13                       $CHAR7.                             
      @706    ECODE14                       $CHAR7.                             
      @713    ECODE15                       $CHAR7.                             
      @720    ECODE16                       $CHAR7.                             
      @727    ECODE17                       $CHAR7.                             
      @734    ECODE18                       $CHAR7.                             
      @741    ECODE19                       $CHAR7.                             
      @748    ECODE20                       $CHAR7.                             
      @755    ECODE21                       $CHAR7.                             
      @762    ECODE22                       $CHAR7.                             
      @769    ECODE23                       $CHAR7.                             
      @776    ECODE24                       $CHAR7.                             
      @783    ECODE25                       $CHAR7.                             
      @790    ECODE26                       $CHAR7.                             
      @797    ECODE27                       $CHAR7.                             
      @804    ECODE28                       $CHAR7.                             
      @811    ECODE29                       $CHAR7.                             
      @818    ECODE30                       $CHAR7.                             
      @825    FEMALE                        N2PF.                               
      @827    HCUP_ED                       N2PF.                               
      @829    HCUP_OS                       N2PF.                               
      @831    HCUP_SURGERY_BROAD_CPT        N5PF.                               
      @836    HCUP_SURGERY_BROAD_I9         N5PF.                               
      @841    HCUP_SURGERY_NARROW_CPT       N5PF.                               
      @846    HCUP_SURGERY_NARROW_I9        N5PF.                               
      @851    Homeless                      N2PF.                               
      @853    HOSPBRTH                      N3PF.                               
      @856    HOSPST                        $CHAR2.                             
      @858    KEY                           15.                                 
      @873    LOS                           N5PF.                               
      @878    LOS_X                         N6PF.                               
      @884    MDNUM1_R                      N9PF.                               
      @893    MDNUM2_R                      N9PF.                               
      @902    MEDINCSTQ                     N2PF.                               
      @904    MRN_R                         N9PF.                               
      @913    NCHRONIC                      N3PF.                               
      @916    NCPT                          N4PF.                               
      @920    NDX                           N3PF.                               
      @923    NECODE                        N2PF.                               
      @925    NEOMAT                        N2PF.                               
      @927    NPR                           N3PF.                               
      @930    ORPROC                        N2PF.                               
      @932    PAY1                          N2PF.                               
      @934    PAY1_X                        $CHAR2.                             
      @936    PL_CBSA                       N3PF.                               
      @939    PL_NCHS                       N2PF.                               
      @941    PL_RUCC                       N2PF.                               
      @943    PL_UIC                        N2PF.                               
      @945    PL_UR_CAT4                    N2PF.                               
      @947    PointOfOrigin_X               $CHAR1.                             
      @948    PointOfOriginUB04             $CHAR1.                             
      @949    PR1                           $CHAR7.                             
      @956    PR2                           $CHAR7.                             
      @963    PR3                           $CHAR7.                             
      @970    PR4                           $CHAR7.                             
      @977    PR5                           $CHAR7.                             
      @984    PR6                           $CHAR7.                             
      @991    PR7                           $CHAR7.                             
      @998    PR8                           $CHAR7.                             
      @1005   PR9                           $CHAR7.                             
      @1012   PR10                          $CHAR7.                             
      @1019   PR11                          $CHAR7.                             
      @1026   PR12                          $CHAR7.                             
      @1033   PR13                          $CHAR7.                             
      @1040   PR14                          $CHAR7.                             
      @1047   PR15                          $CHAR7.                             
      @1054   PR16                          $CHAR7.                             
      @1061   PR17                          $CHAR7.                             
      @1068   PR18                          $CHAR7.                             
      @1075   PR19                          $CHAR7.                             
      @1082   PR20                          $CHAR7.                             
      @1089   PR21                          $CHAR7.                             
      @1096   PR22                          $CHAR7.                             
      @1103   PR23                          $CHAR7.                             
      @1110   PR24                          $CHAR7.                             
      @1117   PR25                          $CHAR7.                             
      @1124   PR26                          $CHAR7.                             
      @1131   PR27                          $CHAR7.                             
      @1138   PR28                          $CHAR7.                             
      @1145   PR29                          $CHAR7.                             
      @1152   PR30                          $CHAR7.                             
      @1159   PRCCS1                        N3PF.                               
      @1162   PRCCS2                        N3PF.                               
      @1165   PRCCS3                        N3PF.                               
      @1168   PRCCS4                        N3PF.                               
      @1171   PRCCS5                        N3PF.                               
      @1174   PRCCS6                        N3PF.                               
      @1177   PRCCS7                        N3PF.                               
      @1180   PRCCS8                        N3PF.                               
      @1183   PRCCS9                        N3PF.                               
      @1186   PRCCS10                       N3PF.                               
      @1189   PRCCS11                       N3PF.                               
      @1192   PRCCS12                       N3PF.                               
      @1195   PRCCS13                       N3PF.                               
      @1198   PRCCS14                       N3PF.                               
      @1201   PRCCS15                       N3PF.                               
      @1204   PRCCS16                       N3PF.                               
      @1207   PRCCS17                       N3PF.                               
      @1210   PRCCS18                       N3PF.                               
      @1213   PRCCS19                       N3PF.                               
      @1216   PRCCS20                       N3PF.                               
      @1219   PRCCS21                       N3PF.                               
      @1222   PRCCS22                       N3PF.                               
      @1225   PRCCS23                       N3PF.                               
      @1228   PRCCS24                       N3PF.                               
      @1231   PRCCS25                       N3PF.                               
      @1234   PRCCS26                       N3PF.                               
      @1237   PRCCS27                       N3PF.                               
      @1240   PRCCS28                       N3PF.                               
      @1243   PRCCS29                       N3PF.                               
      @1246   PRCCS30                       N3PF.                               
      @1249   PRDAY1                        N5PF.                               
      @1254   PRDAY2                        N5PF.                               
      @1259   PRDAY3                        N5PF.                               
      @1264   PRDAY4                        N5PF.                               
      @1269   PRDAY5                        N5PF.                               
      @1274   PRDAY6                        N5PF.                               
      @1279   PRDAY7                        N5PF.                               
      @1284   PRDAY8                        N5PF.                               
      @1289   PRDAY9                        N5PF.                               
      @1294   PRDAY10                       N5PF.                               
      @1299   PRDAY11                       N5PF.                               
      @1304   PRDAY12                       N5PF.                               
      @1309   PRDAY13                       N5PF.                               
      @1314   PRDAY14                       N5PF.                               
      @1319   PRDAY15                       N5PF.                               
      @1324   PRDAY16                       N5PF.                               
      @1329   PRDAY17                       N5PF.                               
      @1334   PRDAY18                       N5PF.                               
      @1339   PRDAY19                       N5PF.                               
      @1344   PRDAY20                       N5PF.                               
      @1349   PRDAY21                       N5PF.                               
      @1354   PRDAY22                       N5PF.                               
      @1359   PRDAY23                       N5PF.                               
      @1364   PRDAY24                       N5PF.                               
      @1369   PRDAY25                       N5PF.                               
      @1374   PRDAY26                       N5PF.                               
      @1379   PRDAY27                       N5PF.                               
      @1384   PRDAY28                       N5PF.                               
      @1389   PRDAY29                       N5PF.                               
      @1394   PRDAY30                       N5PF.                               
      @1399   PROCTYPE                      N3PF.                               
      @1402   PRVER                         N3PF.                               
      @1405   PSTATE                        $CHAR2.                             
      @1407   PSTCO                         N5PF.                               
      @1412   PSTCO2                        N5PF.                               
      @1417   RACE                          N2PF.                               
      @1419   RACE_X                        $CHAR1.                             
      @1420   STATE_AS                      N2PF.                               
      @1422   STATE_ED                      N2PF.                               
      @1424   STATE_OS                      N2PF.                               
      @1426   TOTCHG                        N10PF.                              
      @1436   TOTCHG_X                      N15P2F.                             
      @1451   YEAR                          N4PF.                               
      @1455   ZIP                           $CHAR5.                             
      @1460   ZIP3                          $CHAR3.                             
      @1463   ZIPINC_QRTL                   N3PF.                               
      @1466   AYEAR                         N4PF.                               
      @1470   BMONTH                        N2PF.                               
      @1472   BYEAR                         N4PF.                               
      @1476   PRMONTH1                      N2PF.                               
      @1478   PRMONTH2                      N2PF.                               
      @1480   PRMONTH3                      N2PF.                               
      @1482   PRMONTH4                      N2PF.                               
      @1484   PRMONTH5                      N2PF.                               
      @1486   PRMONTH6                      N2PF.                               
      @1488   PRMONTH7                      N2PF.                               
      @1490   PRMONTH8                      N2PF.                               
      @1492   PRMONTH9                      N2PF.                               
      @1494   PRMONTH10                     N2PF.                               
      @1496   PRMONTH11                     N2PF.                               
      @1498   PRMONTH12                     N2PF.                               
      @1500   PRMONTH13                     N2PF.                               
      @1502   PRMONTH14                     N2PF.                               
      @1504   PRMONTH15                     N2PF.                               
      @1506   PRMONTH16                     N2PF.                               
      @1508   PRMONTH17                     N2PF.                               
      @1510   PRMONTH18                     N2PF.                               
      @1512   PRMONTH19                     N2PF.                               
      @1514   PRMONTH20                     N2PF.                               
      @1516   PRMONTH21                     N2PF.                               
      @1518   PRMONTH22                     N2PF.                               
      @1520   PRMONTH23                     N2PF.                               
      @1522   PRMONTH24                     N2PF.                               
      @1524   PRMONTH25                     N2PF.                               
      @1526   PRMONTH26                     N2PF.                               
      @1528   PRMONTH27                     N2PF.                               
      @1530   PRMONTH28                     N2PF.                               
      @1532   PRMONTH29                     N2PF.                               
      @1534   PRMONTH30                     N2PF.                               
      @1536   PRYEAR1                       N4PF.                               
      @1540   PRYEAR2                       N4PF.                               
      @1544   PRYEAR3                       N4PF.                               
      @1548   PRYEAR4                       N4PF.                               
      @1552   PRYEAR5                       N4PF.                               
      @1556   PRYEAR6                       N4PF.                               
      @1560   PRYEAR7                       N4PF.                               
      @1564   PRYEAR8                       N4PF.                               
      @1568   PRYEAR9                       N4PF.                               
      @1572   PRYEAR10                      N4PF.                               
      @1576   PRYEAR11                      N4PF.                               
      @1580   PRYEAR12                      N4PF.                               
      @1584   PRYEAR13                      N4PF.                               
      @1588   PRYEAR14                      N4PF.                               
      @1592   PRYEAR15                      N4PF.                               
      @1596   PRYEAR16                      N4PF.                               
      @1600   PRYEAR17                      N4PF.                               
      @1604   PRYEAR18                      N4PF.                               
      @1608   PRYEAR19                      N4PF.                               
      @1612   PRYEAR20                      N4PF.                               
      @1616   PRYEAR21                      N4PF.                               
      @1620   PRYEAR22                      N4PF.                               
      @1624   PRYEAR23                      N4PF.                               
      @1628   PRYEAR24                      N4PF.                               
      @1632   PRYEAR25                      N4PF.                               
      @1636   PRYEAR26                      N4PF.                               
      @1640   PRYEAR27                      N4PF.                               
      @1644   PRYEAR28                      N4PF.                               
      @1648   PRYEAR29                      N4PF.                               
      @1652   PRYEAR30                      N4PF.                               
      ;                                                                         
                                                                                
                                                                                
RUN;
