/*****************************************************************************
 * Stataload_NRD_2013_DX_PR_GRPS.Do
 * This program will load the 2013 NRD CSV DX_PR_GRPS File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NRD_2013_DX_PR_GRPS.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    chron1
      int    chron2
      int    chron3
      int    chron4
      int    chron5
      int    chron6
      int    chron7
      int    chron8
      int    chron9
      int    chron10
      int    chron11
      int    chron12
      int    chron13
      int    chron14
      int    chron15
      int    chron16
      int    chron17
      int    chron18
      int    chron19
      int    chron20
      int    chron21
      int    chron22
      int    chron23
      int    chron24
      int    chron25
      int    chronb1
      int    chronb2
      int    chronb3
      int    chronb4
      int    chronb5
      int    chronb6
      int    chronb7
      int    chronb8
      int    chronb9
      int    chronb10
      int    chronb11
      int    chronb12
      int    chronb13
      int    chronb14
      int    chronb15
      int    chronb16
      int    chronb17
      int    chronb18
      int    chronb19
      int    chronb20
      int    chronb21
      int    chronb22
      int    chronb23
      int    chronb24
      int    chronb25
      str11  dxmccs1
      str11  e_mccs1
      long   hosp_nrd
      double key_nrd
      int    pclass1
      int    pclass2
      int    pclass3
      int    pclass4
      int    pclass5
      int    pclass6
      int    pclass7
      int    pclass8
      int    pclass9
      int    pclass10
      int    pclass11
      int    pclass12
      int    pclass13
      int    pclass14
      int    pclass15
      str8   prmccs1
using NRD_2013_DX_PR_GRPS.csv;

/*  Assign labels to the data elements */
label var chron1                   "Chronic condition indicator 1" ;
label var chron2                   "Chronic condition indicator 2" ;
label var chron3                   "Chronic condition indicator 3" ;
label var chron4                   "Chronic condition indicator 4" ;
label var chron5                   "Chronic condition indicator 5" ;
label var chron6                   "Chronic condition indicator 6" ;
label var chron7                   "Chronic condition indicator 7" ;
label var chron8                   "Chronic condition indicator 8" ;
label var chron9                   "Chronic condition indicator 9" ;
label var chron10                  "Chronic condition indicator 10" ;
label var chron11                  "Chronic condition indicator 11" ;
label var chron12                  "Chronic condition indicator 12" ;
label var chron13                  "Chronic condition indicator 13" ;
label var chron14                  "Chronic condition indicator 14" ;
label var chron15                  "Chronic condition indicator 15" ;
label var chron16                  "Chronic condition indicator 16" ;
label var chron17                  "Chronic condition indicator 17" ;
label var chron18                  "Chronic condition indicator 18" ;
label var chron19                  "Chronic condition indicator 19" ;
label var chron20                  "Chronic condition indicator 20" ;
label var chron21                  "Chronic condition indicator 21" ;
label var chron22                  "Chronic condition indicator 22" ;
label var chron23                  "Chronic condition indicator 23" ;
label var chron24                  "Chronic condition indicator 24" ;
label var chron25                  "Chronic condition indicator 25" ;
label var chronb1                  "Chronic condition body system 1" ;
label var chronb2                  "Chronic condition body system 2" ;
label var chronb3                  "Chronic condition body system 3" ;
label var chronb4                  "Chronic condition body system 4" ;
label var chronb5                  "Chronic condition body system 5" ;
label var chronb6                  "Chronic condition body system 6" ;
label var chronb7                  "Chronic condition body system 7" ;
label var chronb8                  "Chronic condition body system 8" ;
label var chronb9                  "Chronic condition body system 9" ;
label var chronb10                 "Chronic condition body system 10" ;
label var chronb11                 "Chronic condition body system 11" ;
label var chronb12                 "Chronic condition body system 12" ;
label var chronb13                 "Chronic condition body system 13" ;
label var chronb14                 "Chronic condition body system 14" ;
label var chronb15                 "Chronic condition body system 15" ;
label var chronb16                 "Chronic condition body system 16" ;
label var chronb17                 "Chronic condition body system 17" ;
label var chronb18                 "Chronic condition body system 18" ;
label var chronb19                 "Chronic condition body system 19" ;
label var chronb20                 "Chronic condition body system 20" ;
label var chronb21                 "Chronic condition body system 21" ;
label var chronb22                 "Chronic condition body system 22" ;
label var chronb23                 "Chronic condition body system 23" ;
label var chronb24                 "Chronic condition body system 24" ;
label var chronb25                 "Chronic condition body system 25" ;
label var dxmccs1                  "Multi-Level CCS:  Diagnosis 1" ;
label var e_mccs1                  "Multi-Level CCS:  E Code 1" ;
label var hosp_nrd                 "NRD hospital identifier" ;
label var key_nrd                  "NRD record identifier" ;
label var pclass1                  "Procedure class 1" ;
label var pclass2                  "Procedure class 2" ;
label var pclass3                  "Procedure class 3" ;
label var pclass4                  "Procedure class 4" ;
label var pclass5                  "Procedure class 5" ;
label var pclass6                  "Procedure class 6" ;
label var pclass7                  "Procedure class 7" ;
label var pclass8                  "Procedure class 8" ;
label var pclass9                  "Procedure class 9" ;
label var pclass10                 "Procedure class 10" ;
label var pclass11                 "Procedure class 11" ;
label var pclass12                 "Procedure class 12" ;
label var pclass13                 "Procedure class 13" ;
label var pclass14                 "Procedure class 14" ;
label var pclass15                 "Procedure class 15" ;
label var prmccs1                  "Multi-Level CCS:  Procedure 1" ;

/* Convert special values to missing values */
recode chron1                    (-99 -88 -66=.) ;
recode chron2                    (-99 -88 -66=.) ;
recode chron3                    (-99 -88 -66=.) ;
recode chron4                    (-99 -88 -66=.) ;
recode chron5                    (-99 -88 -66=.) ;
recode chron6                    (-99 -88 -66=.) ;
recode chron7                    (-99 -88 -66=.) ;
recode chron8                    (-99 -88 -66=.) ;
recode chron9                    (-99 -88 -66=.) ;
recode chron10                   (-99 -88 -66=.) ;
recode chron11                   (-99 -88 -66=.) ;
recode chron12                   (-99 -88 -66=.) ;
recode chron13                   (-99 -88 -66=.) ;
recode chron14                   (-99 -88 -66=.) ;
recode chron15                   (-99 -88 -66=.) ;
recode chron16                   (-99 -88 -66=.) ;
recode chron17                   (-99 -88 -66=.) ;
recode chron18                   (-99 -88 -66=.) ;
recode chron19                   (-99 -88 -66=.) ;
recode chron20                   (-99 -88 -66=.) ;
recode chron21                   (-99 -88 -66=.) ;
recode chron22                   (-99 -88 -66=.) ;
recode chron23                   (-99 -88 -66=.) ;
recode chron24                   (-99 -88 -66=.) ;
recode chron25                   (-99 -88 -66=.) ;
recode chronb1                   (-99 -88 -66=.) ;
recode chronb2                   (-99 -88 -66=.) ;
recode chronb3                   (-99 -88 -66=.) ;
recode chronb4                   (-99 -88 -66=.) ;
recode chronb5                   (-99 -88 -66=.) ;
recode chronb6                   (-99 -88 -66=.) ;
recode chronb7                   (-99 -88 -66=.) ;
recode chronb8                   (-99 -88 -66=.) ;
recode chronb9                   (-99 -88 -66=.) ;
recode chronb10                  (-99 -88 -66=.) ;
recode chronb11                  (-99 -88 -66=.) ;
recode chronb12                  (-99 -88 -66=.) ;
recode chronb13                  (-99 -88 -66=.) ;
recode chronb14                  (-99 -88 -66=.) ;
recode chronb15                  (-99 -88 -66=.) ;
recode chronb16                  (-99 -88 -66=.) ;
recode chronb17                  (-99 -88 -66=.) ;
recode chronb18                  (-99 -88 -66=.) ;
recode chronb19                  (-99 -88 -66=.) ;
recode chronb20                  (-99 -88 -66=.) ;
recode chronb21                  (-99 -88 -66=.) ;
recode chronb22                  (-99 -88 -66=.) ;
recode chronb23                  (-99 -88 -66=.) ;
recode chronb24                  (-99 -88 -66=.) ;
recode chronb25                  (-99 -88 -66=.) ;
recode hosp_nrd                  (-9999 -8888 -6666=.) ;
recode key_nrd                   (-99999999999999 -88888888888888 -66666666666666=.) ;
recode pclass1                   (-99 -88 -66=.) ;
recode pclass2                   (-99 -88 -66=.) ;
recode pclass3                   (-99 -88 -66=.) ;
recode pclass4                   (-99 -88 -66=.) ;
recode pclass5                   (-99 -88 -66=.) ;
recode pclass6                   (-99 -88 -66=.) ;
recode pclass7                   (-99 -88 -66=.) ;
recode pclass8                   (-99 -88 -66=.) ;
recode pclass9                   (-99 -88 -66=.) ;
recode pclass10                  (-99 -88 -66=.) ;
recode pclass11                  (-99 -88 -66=.) ;
recode pclass12                  (-99 -88 -66=.) ;
recode pclass13                  (-99 -88 -66=.) ;
recode pclass14                  (-99 -88 -66=.) ;
recode pclass15                  (-99 -88 -66=.) ;

describe;

save "NRD_2013_DX_PR_GRPS.dta", replace;
#delimit cr
