/*****************************************************************************
* Stataload_NIS_2004_10Pct_Severity_A.Do
* This program will load the 2004 NIS ASCII 10Pct_Severity_A File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 500m

*** Read data elements from the ASCII file ***
infix double KEY                         1- 14   ///
      long   HOSPID                     15- 19   ///
      int    APRDRG                     20- 23   ///
      byte   APRDRG_Risk_Mortality      24- 25   ///
      byte   APRDRG_Severity            26- 27   ///
      long   APSDRG                     28- 32   ///
      double APSDRG_Charge_Weight       33- 42   ///
      double APSDRG_LOS_Weight          43- 52   ///
      double APSDRG_Mortality_Weight    53- 62   ///
      byte   CM_AIDS                    63- 64   ///
      byte   CM_ALCOHOL                 65- 66   ///
      byte   CM_ANEMDEF                 67- 68   ///
      byte   CM_ARTH                    69- 70   ///
      byte   CM_BLDLOSS                 71- 72   ///
      byte   CM_CHF                     73- 74   ///
      byte   CM_CHRNLUNG                75- 76   ///
      byte   CM_COAG                    77- 78   ///
      byte   CM_DEPRESS                 79- 80   ///
      byte   CM_DM                      81- 82   ///
      byte   CM_DMCX                    83- 84   ///
      byte   CM_DRUG                    85- 86   ///
      byte   CM_HTN_C                   87- 88   ///
      byte   CM_HYPOTHY                 89- 90   ///
      byte   CM_LIVER                   91- 92   ///
      byte   CM_LYMPH                   93- 94   ///
      byte   CM_LYTES                   95- 96   ///
      byte   CM_METS                    97- 98   ///
      byte   CM_NEURO                   99-100   ///
      byte   CM_OBESE                  101-102   ///
      byte   CM_PARA                   103-104   ///
      byte   CM_PERIVASC               105-106   ///
      byte   CM_PSYCH                  107-108   ///
      byte   CM_PULMCIRC               109-110   ///
      byte   CM_RENLFAIL               111-112   ///
      byte   CM_TUMOR                  113-114   ///
      byte   CM_ULCER                  115-116   ///
      byte   CM_VALVE                  117-118   ///
      byte   CM_WGHTLOSS               119-120   ///
      str    DS_DX_Category1           121-125   ///
      byte   DS_LOS_Level              126-127   ///
      double DS_LOS_Scale              128-139   ///
      byte   DS_Mrt_Level              140-141   ///
      double DS_Mrt_Scale              142-153   ///
      byte   DS_RD_Level               154-155   ///
      double DS_RD_Scale               156-167   ///
      float  DS_Stage1                 168-172   ///
      using  "NIS_2004_10Pct_Severity_A.ASC"

***  Assign labels to the data elements ***
label var KEY                      "HCUP record identifier"
label var HOSPID                   "HCUP hospital identification number"
label var APRDRG                   "All Patient Refined DRG"
label var APRDRG_Risk_Mortality    "All Patient Refined DRG: Risk of Mortality Subclass"
label var APRDRG_Severity          "All Patient Refined DRG: Severity of Illness Subclass"
label var APSDRG                   "All-Payer Severity-adjusted DRG"
label var APSDRG_Charge_Weight     "All-Payer Severity-adjusted DRG: Charge Weight"
label var APSDRG_LOS_Weight        "All-Payer Severity-adjusted DRG: Length of Stay Weight"
label var APSDRG_Mortality_Weight  "All-Payer Severity-adjusted DRG: Mortality Weight"
label var CM_AIDS                  "AHRQ comorbidity measure: Acquired immune deficiency syndrome"
label var CM_ALCOHOL               "AHRQ comorbidity measure: Alcohol abuse"
label var CM_ANEMDEF               "AHRQ comorbidity measure: Deficiency anemias"
label var CM_ARTH                  "AHRQ comorbidity measure: Rheumatoid arthritis/collagen vascular diseases"
label var CM_BLDLOSS               "AHRQ comorbidity measure: Chronic blood loss anemia"
label var CM_CHF                   "AHRQ comorbidity measure: Congestive heart failure"
label var CM_CHRNLUNG              "AHRQ comorbidity measure: Chronic pulmonary disease"
label var CM_COAG                  "AHRQ comorbidity measure: Coagulopathy"
label var CM_DEPRESS               "AHRQ comorbidity measure: Depression"
label var CM_DM                    "AHRQ comorbidity measure: Diabetes, uncomplicated"
label var CM_DMCX                  "AHRQ comorbidity measure: Diabetes with chronic complications"
label var CM_DRUG                  "AHRQ comorbidity measure: Drug abuse"
label var CM_HTN_C                 "AHRQ comorbidity measure: Hypertension (combine uncomplicated and complicated)"
label var CM_HYPOTHY               "AHRQ comorbidity measure: Hypothyroidism"
label var CM_LIVER                 "AHRQ comorbidity measure: Liver disease"
label var CM_LYMPH                 "AHRQ comorbidity measure: Lymphoma"
label var CM_LYTES                 "AHRQ comorbidity measure: Fluid and electrolyte disorders"
label var CM_METS                  "AHRQ comorbidity measure: Metastatic cancer"
label var CM_NEURO                 "AHRQ comorbidity measure: Other neurological disorders"
label var CM_OBESE                 "AHRQ comorbidity measure: Obesity"
label var CM_PARA                  "AHRQ comorbidity measure: Paralysis"
label var CM_PERIVASC              "AHRQ comorbidity measure: Peripheral vascular disorders"
label var CM_PSYCH                 "AHRQ comorbidity measure: Psychoses"
label var CM_PULMCIRC              "AHRQ comorbidity measure: Pulmonary circulation disorders"
label var CM_RENLFAIL              "AHRQ comorbidity measure: Renal failure"
label var CM_TUMOR                 "AHRQ comorbidity measure: Solid tumor without metastasis"
label var CM_ULCER                 "AHRQ comorbidity measure: Peptic ulcer disease excluding bleeding"
label var CM_VALVE                 "AHRQ comorbidity measure: Valvular disease"
label var CM_WGHTLOSS              "AHRQ comorbidity measure: Weight loss"
label var DS_DX_Category1          "Disease Staging: Principal Disease Category"
label var DS_LOS_Level             "Disease Staging: Length of Stay Level"
label var DS_LOS_Scale             "Disease Staging: Length of Stay Scale"
label var DS_Mrt_Level             "Disease Staging: Mortality Level"
label var DS_Mrt_Scale             "Disease Staging: Mortality Scale"
label var DS_RD_Level              "Disease Staging: Resource Demand Level"
label var DS_RD_Scale              "Disease Staging: Resource Demand Scale"
label var DS_Stage1                "Disease Staging: Principal Stage"

*** Convert special values to missing values ***
recode APRDRG                    (-999 -888 -666=.)
recode APRDRG_Risk_Mortality     (-9 -8 -6 -5=.)
recode APRDRG_Severity           (-9 -8 -6 -5=.)
recode APSDRG                    (-9999 -8888 -6666=.)
recode APSDRG_Charge_Weight      (-999.99999 -888.88888 -666.66666=.)
recode APSDRG_LOS_Weight         (-999.99999 -888.88888 -666.66666=.)
recode APSDRG_Mortality_Weight   (-999.99999 -888.88888 -666.66666=.)
recode CM_AIDS                   (-9 -8 -6 -5=.)
recode CM_ALCOHOL                (-9 -8 -6 -5=.)
recode CM_ANEMDEF                (-9 -8 -6 -5=.)
recode CM_ARTH                   (-9 -8 -6 -5=.)
recode CM_BLDLOSS                (-9 -8 -6 -5=.)
recode CM_CHF                    (-9 -8 -6 -5=.)
recode CM_CHRNLUNG               (-9 -8 -6 -5=.)
recode CM_COAG                   (-9 -8 -6 -5=.)
recode CM_DEPRESS                (-9 -8 -6 -5=.)
recode CM_DM                     (-9 -8 -6 -5=.)
recode CM_DMCX                   (-9 -8 -6 -5=.)
recode CM_DRUG                   (-9 -8 -6 -5=.)
recode CM_HTN_C                  (-9 -8 -6 -5=.)
recode CM_HYPOTHY                (-9 -8 -6 -5=.)
recode CM_LIVER                  (-9 -8 -6 -5=.)
recode CM_LYMPH                  (-9 -8 -6 -5=.)
recode CM_LYTES                  (-9 -8 -6 -5=.)
recode CM_METS                   (-9 -8 -6 -5=.)
recode CM_NEURO                  (-9 -8 -6 -5=.)
recode CM_OBESE                  (-9 -8 -6 -5=.)
recode CM_PARA                   (-9 -8 -6 -5=.)
recode CM_PERIVASC               (-9 -8 -6 -5=.)
recode CM_PSYCH                  (-9 -8 -6 -5=.)
recode CM_PULMCIRC               (-9 -8 -6 -5=.)
recode CM_RENLFAIL               (-9 -8 -6 -5=.)
recode CM_TUMOR                  (-9 -8 -6 -5=.)
recode CM_ULCER                  (-9 -8 -6 -5=.)
recode CM_VALVE                  (-9 -8 -6 -5=.)
recode CM_WGHTLOSS               (-9 -8 -6 -5=.)
recode DS_LOS_Level              (-9 -8 -6 -5=.)
recode DS_LOS_Scale              (-99999.99999 -88888.88888 -66666.66666=.)
recode DS_Mrt_Level              (-9 -8 -6 -5=.)
recode DS_Mrt_Scale              (-99999.99999 -88888.88888 -66666.66666=.)
recode DS_RD_Level               (-9 -8 -6 -5=.)
recode DS_RD_Scale               (-99999.99999 -88888.88888 -66666.66666=.)
recode DS_Stage1                 (-9.99 -8.88 -6.66=.)

save "NIS_2004_10Pct_Severity_A.dta", replace
