/*****************************************************************************
* SPSSload_NIS_2015Q1Q3_DX_PR_GRPS.SPS
* This program will load the NIS_2015Q1Q3_DX_PR_GRPS ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2015Q1Q3_DX_PR_GRPS.ASC' FIXED / 
    BODYSYSTEM1                1-  3
    BODYSYSTEM2                4-  6
    BODYSYSTEM3                7-  9
    BODYSYSTEM4               10- 12
    BODYSYSTEM5               13- 15
    BODYSYSTEM6               16- 18
    BODYSYSTEM7               19- 21
    BODYSYSTEM8               22- 24
    BODYSYSTEM9               25- 27
    BODYSYSTEM10              28- 30
    BODYSYSTEM11              31- 33
    BODYSYSTEM12              34- 36
    BODYSYSTEM13              37- 39
    BODYSYSTEM14              40- 42
    BODYSYSTEM15              43- 45
    BODYSYSTEM16              46- 48
    BODYSYSTEM17              49- 51
    BODYSYSTEM18              52- 54
    BODYSYSTEM19              55- 57
    BODYSYSTEM20              58- 60
    BODYSYSTEM21              61- 63
    BODYSYSTEM22              64- 66
    BODYSYSTEM23              67- 69
    BODYSYSTEM24              70- 72
    BODYSYSTEM25              73- 75
    BODYSYSTEM26              76- 78
    BODYSYSTEM27              79- 81
    BODYSYSTEM28              82- 84
    BODYSYSTEM29              85- 87
    BODYSYSTEM30              88- 90
    CHRON1                    91- 93
    CHRON2                    94- 96
    CHRON3                    97- 99
    CHRON4                   100-102
    CHRON5                   103-105
    CHRON6                   106-108
    CHRON7                   109-111
    CHRON8                   112-114
    CHRON9                   115-117
    CHRON10                  118-120
    CHRON11                  121-123
    CHRON12                  124-126
    CHRON13                  127-129
    CHRON14                  130-132
    CHRON15                  133-135
    CHRON16                  136-138
    CHRON17                  139-141
    CHRON18                  142-144
    CHRON19                  145-147
    CHRON20                  148-150
    CHRON21                  151-153
    CHRON22                  154-156
    CHRON23                  157-159
    CHRON24                  160-162
    CHRON25                  163-165
    CHRON26                  166-168
    CHRON27                  169-171
    CHRON28                  172-174
    CHRON29                  175-177
    CHRON30                  178-180
    DRG                      181-183
    DRG_NoPOA                184-186
    DRGVER                   187-188
    DX1                      189-195 (A)
    DX2                      196-202 (A)
    DX3                      203-209 (A)
    DX4                      210-216 (A)
    DX5                      217-223 (A)
    DX6                      224-230 (A)
    DX7                      231-237 (A)
    DX8                      238-244 (A)
    DX9                      245-251 (A)
    DX10                     252-258 (A)
    DX11                     259-265 (A)
    DX12                     266-272 (A)
    DX13                     273-279 (A)
    DX14                     280-286 (A)
    DX15                     287-293 (A)
    DX16                     294-300 (A)
    DX17                     301-307 (A)
    DX18                     308-314 (A)
    DX19                     315-321 (A)
    DX20                     322-328 (A)
    DX21                     329-335 (A)
    DX22                     336-342 (A)
    DX23                     343-349 (A)
    DX24                     350-356 (A)
    DX25                     357-363 (A)
    DX26                     364-370 (A)
    DX27                     371-377 (A)
    DX28                     378-384 (A)
    DX29                     385-391 (A)
    DX30                     392-398 (A)
    DXCCS1                   399-402
    DXCCS2                   403-406
    DXCCS3                   407-410
    DXCCS4                   411-414
    DXCCS5                   415-418
    DXCCS6                   419-422
    DXCCS7                   423-426
    DXCCS8                   427-430
    DXCCS9                   431-434
    DXCCS10                  435-438
    DXCCS11                  439-442
    DXCCS12                  443-446
    DXCCS13                  447-450
    DXCCS14                  451-454
    DXCCS15                  455-458
    DXCCS16                  459-462
    DXCCS17                  463-466
    DXCCS18                  467-470
    DXCCS19                  471-474
    DXCCS20                  475-478
    DXCCS21                  479-482
    DXCCS22                  483-486
    DXCCS23                  487-490
    DXCCS24                  491-494
    DXCCS25                  495-498
    DXCCS26                  499-502
    DXCCS27                  503-506
    DXCCS28                  507-510
    DXCCS29                  511-514
    DXCCS30                  515-518
    DXMCCS1                  519-529 (A)
    DXVER                    530-531
    E_CCS1                   532-535
    E_CCS2                   536-539
    E_CCS3                   540-543
    E_CCS4                   544-547
    E_MCCS1                  548-558 (A)
    ECODE1                   559-565 (A)
    ECODE2                   566-572 (A)
    ECODE3                   573-579 (A)
    ECODE4                   580-586 (A)
    HOSP_NIS                 587-591
    HOSPBRTH                 592-593
    KEY_NIS                  594-603
    MDC                      604-605
    MDC_NoPOA                606-607
    NCHRONIC                 608-609
    NDX                      610-611
    NECODE                   612-614
    NEOMAT                   615-616
    NPR                      617-618
    ORPROC                   619-620
    PCLASS1                  621-623
    PCLASS2                  624-626
    PCLASS3                  627-629
    PCLASS4                  630-632
    PCLASS5                  633-635
    PCLASS6                  636-638
    PCLASS7                  639-641
    PCLASS8                  642-644
    PCLASS9                  645-647
    PCLASS10                 648-650
    PCLASS11                 651-653
    PCLASS12                 654-656
    PCLASS13                 657-659
    PCLASS14                 660-662
    PCLASS15                 663-665
    PR1                      666-672 (A)
    PR2                      673-679 (A)
    PR3                      680-686 (A)
    PR4                      687-693 (A)
    PR5                      694-700 (A)
    PR6                      701-707 (A)
    PR7                      708-714 (A)
    PR8                      715-721 (A)
    PR9                      722-728 (A)
    PR10                     729-735 (A)
    PR11                     736-742 (A)
    PR12                     743-749 (A)
    PR13                     750-756 (A)
    PR14                     757-763 (A)
    PR15                     764-770 (A)
    PRCCS1                   771-773
    PRCCS2                   774-776
    PRCCS3                   777-779
    PRCCS4                   780-782
    PRCCS5                   783-785
    PRCCS6                   786-788
    PRCCS7                   789-791
    PRCCS8                   792-794
    PRCCS9                   795-797
    PRCCS10                  798-800
    PRCCS11                  801-803
    PRCCS12                  804-806
    PRCCS13                  807-809
    PRCCS14                  810-812
    PRCCS15                  813-815
    PRDAY1                   816-818
    PRDAY2                   819-821
    PRDAY3                   822-824
    PRDAY4                   825-827
    PRDAY5                   828-830
    PRDAY6                   831-833
    PRDAY7                   834-836
    PRDAY8                   837-839
    PRDAY9                   840-842
    PRDAY10                  843-845
    PRDAY11                  846-848
    PRDAY12                  849-851
    PRDAY13                  852-854
    PRDAY14                  855-857
    PRDAY15                  858-860
    PRMCCS1                  861-868 (A)
    PRVER                    869-870
    SERVICELINE              871-873.

***  Specify write formats  ***.
FORMATS
    BODYSYSTEM1              (F3.0) /
    BODYSYSTEM2              (F3.0) /
    BODYSYSTEM3              (F3.0) /
    BODYSYSTEM4              (F3.0) /
    BODYSYSTEM5              (F3.0) /
    BODYSYSTEM6              (F3.0) /
    BODYSYSTEM7              (F3.0) /
    BODYSYSTEM8              (F3.0) /
    BODYSYSTEM9              (F3.0) /
    BODYSYSTEM10             (F3.0) /
    BODYSYSTEM11             (F3.0) /
    BODYSYSTEM12             (F3.0) /
    BODYSYSTEM13             (F3.0) /
    BODYSYSTEM14             (F3.0) /
    BODYSYSTEM15             (F3.0) /
    BODYSYSTEM16             (F3.0) /
    BODYSYSTEM17             (F3.0) /
    BODYSYSTEM18             (F3.0) /
    BODYSYSTEM19             (F3.0) /
    BODYSYSTEM20             (F3.0) /
    BODYSYSTEM21             (F3.0) /
    BODYSYSTEM22             (F3.0) /
    BODYSYSTEM23             (F3.0) /
    BODYSYSTEM24             (F3.0) /
    BODYSYSTEM25             (F3.0) /
    BODYSYSTEM26             (F3.0) /
    BODYSYSTEM27             (F3.0) /
    BODYSYSTEM28             (F3.0) /
    BODYSYSTEM29             (F3.0) /
    BODYSYSTEM30             (F3.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRON16                  (F3.0) /
    CHRON17                  (F3.0) /
    CHRON18                  (F3.0) /
    CHRON19                  (F3.0) /
    CHRON20                  (F3.0) /
    CHRON21                  (F3.0) /
    CHRON22                  (F3.0) /
    CHRON23                  (F3.0) /
    CHRON24                  (F3.0) /
    CHRON25                  (F3.0) /
    CHRON26                  (F3.0) /
    CHRON27                  (F3.0) /
    CHRON28                  (F3.0) /
    CHRON29                  (F3.0) /
    CHRON30                  (F3.0) /
    DRG                      (F3.0) /
    DRG_NoPOA                (F3.0) /
    DRGVER                   (F2.0) /
    DXCCS1                   (F4.0) /
    DXCCS2                   (F4.0) /
    DXCCS3                   (F4.0) /
    DXCCS4                   (F4.0) /
    DXCCS5                   (F4.0) /
    DXCCS6                   (F4.0) /
    DXCCS7                   (F4.0) /
    DXCCS8                   (F4.0) /
    DXCCS9                   (F4.0) /
    DXCCS10                  (F4.0) /
    DXCCS11                  (F4.0) /
    DXCCS12                  (F4.0) /
    DXCCS13                  (F4.0) /
    DXCCS14                  (F4.0) /
    DXCCS15                  (F4.0) /
    DXCCS16                  (F4.0) /
    DXCCS17                  (F4.0) /
    DXCCS18                  (F4.0) /
    DXCCS19                  (F4.0) /
    DXCCS20                  (F4.0) /
    DXCCS21                  (F4.0) /
    DXCCS22                  (F4.0) /
    DXCCS23                  (F4.0) /
    DXCCS24                  (F4.0) /
    DXCCS25                  (F4.0) /
    DXCCS26                  (F4.0) /
    DXCCS27                  (F4.0) /
    DXCCS28                  (F4.0) /
    DXCCS29                  (F4.0) /
    DXCCS30                  (F4.0) /
    DXVER                    (F2.0) /
    E_CCS1                   (F4.0) /
    E_CCS2                   (F4.0) /
    E_CCS3                   (F4.0) /
    E_CCS4                   (F4.0) /
    HOSP_NIS                 (F5.0) /
    HOSPBRTH                 (F2.0) /
    KEY_NIS                  (F10.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    NCHRONIC                 (F2.0) /
    NDX                      (F2.0) /
    NECODE                   (F3.0) /
    NEOMAT                   (F2.0) /
    NPR                      (F2.0) /
    ORPROC                   (F2.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) /
    PRCCS1                   (F3.0) /
    PRCCS2                   (F3.0) /
    PRCCS3                   (F3.0) /
    PRCCS4                   (F3.0) /
    PRCCS5                   (F3.0) /
    PRCCS6                   (F3.0) /
    PRCCS7                   (F3.0) /
    PRCCS8                   (F3.0) /
    PRCCS9                   (F3.0) /
    PRCCS10                  (F3.0) /
    PRCCS11                  (F3.0) /
    PRCCS12                  (F3.0) /
    PRCCS13                  (F3.0) /
    PRCCS14                  (F3.0) /
    PRCCS15                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRVER                    (F2.0) /
    SERVICELINE              (F3.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    BODYSYSTEM1              "Body system 1"
    BODYSYSTEM2              "Body system 2"
    BODYSYSTEM3              "Body system 3"
    BODYSYSTEM4              "Body system 4"
    BODYSYSTEM5              "Body system 5"
    BODYSYSTEM6              "Body system 6"
    BODYSYSTEM7              "Body system 7"
    BODYSYSTEM8              "Body system 8"
    BODYSYSTEM9              "Body system 9"
    BODYSYSTEM10             "Body system 10"
    BODYSYSTEM11             "Body system 11"
    BODYSYSTEM12             "Body system 12"
    BODYSYSTEM13             "Body system 13"
    BODYSYSTEM14             "Body system 14"
    BODYSYSTEM15             "Body system 15"
    BODYSYSTEM16             "Body system 16"
    BODYSYSTEM17             "Body system 17"
    BODYSYSTEM18             "Body system 18"
    BODYSYSTEM19             "Body system 19"
    BODYSYSTEM20             "Body system 20"
    BODYSYSTEM21             "Body system 21"
    BODYSYSTEM22             "Body system 22"
    BODYSYSTEM23             "Body system 23"
    BODYSYSTEM24             "Body system 24"
    BODYSYSTEM25             "Body system 25"
    BODYSYSTEM26             "Body system 26"
    BODYSYSTEM27             "Body system 27"
    BODYSYSTEM28             "Body system 28"
    BODYSYSTEM29             "Body system 29"
    BODYSYSTEM30             "Body system 30"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRON16                  "Chronic condition indicator 16"
    CHRON17                  "Chronic condition indicator 17"
    CHRON18                  "Chronic condition indicator 18"
    CHRON19                  "Chronic condition indicator 19"
    CHRON20                  "Chronic condition indicator 20"
    CHRON21                  "Chronic condition indicator 21"
    CHRON22                  "Chronic condition indicator 22"
    CHRON23                  "Chronic condition indicator 23"
    CHRON24                  "Chronic condition indicator 24"
    CHRON25                  "Chronic condition indicator 25"
    CHRON26                  "Chronic condition indicator 26"
    CHRON27                  "Chronic condition indicator 27"
    CHRON28                  "Chronic condition indicator 28"
    CHRON29                  "Chronic condition indicator 29"
    CHRON30                  "Chronic condition indicator 30"
    DRG                      "DRG in effect on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DRGVER                   "DRG grouper version used on discharge date"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DX16                     "Diagnosis 16"
    DX17                     "Diagnosis 17"
    DX18                     "Diagnosis 18"
    DX19                     "Diagnosis 19"
    DX20                     "Diagnosis 20"
    DX21                     "Diagnosis 21"
    DX22                     "Diagnosis 22"
    DX23                     "Diagnosis 23"
    DX24                     "Diagnosis 24"
    DX25                     "Diagnosis 25"
    DX26                     "Diagnosis 26"
    DX27                     "Diagnosis 27"
    DX28                     "Diagnosis 28"
    DX29                     "Diagnosis 29"
    DX30                     "Diagnosis 30"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    DXCCS16                  "CCS: diagnosis 16"
    DXCCS17                  "CCS: diagnosis 17"
    DXCCS18                  "CCS: diagnosis 18"
    DXCCS19                  "CCS: diagnosis 19"
    DXCCS20                  "CCS: diagnosis 20"
    DXCCS21                  "CCS: diagnosis 21"
    DXCCS22                  "CCS: diagnosis 22"
    DXCCS23                  "CCS: diagnosis 23"
    DXCCS24                  "CCS: diagnosis 24"
    DXCCS25                  "CCS: diagnosis 25"
    DXCCS26                  "CCS: diagnosis 26"
    DXCCS27                  "CCS: diagnosis 27"
    DXCCS28                  "CCS: diagnosis 28"
    DXCCS29                  "CCS: diagnosis 29"
    DXCCS30                  "CCS: diagnosis 30"
    DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
    DXVER                    "Diagnosis Version"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    E_MCCS1                  "Multi-Level CCS:  E Code 1"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    HOSP_NIS                 "NIS hospital number"
    HOSPBRTH                 "Indicator of birth in this hospital"
    KEY_NIS                  "NIS record number"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    NCHRONIC                 "Number of chronic conditions"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEOMAT                   "Neonatal and/or maternal DX and/or PR"
    NPR                      "Number of procedures on this record"
    ORPROC                   "Major operating room procedure indicator"
    PCLASS1                  "Procedure class 1"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15"
    PR1                      "Procedure 1"
    PR2                      "Procedure 2"
    PR3                      "Procedure 3"
    PR4                      "Procedure 4"
    PR5                      "Procedure 5"
    PR6                      "Procedure 6"
    PR7                      "Procedure 7"
    PR8                      "Procedure 8"
    PR9                      "Procedure 9"
    PR10                     "Procedure 10"
    PR11                     "Procedure 11"
    PR12                     "Procedure 12"
    PR13                     "Procedure 13"
    PR14                     "Procedure 14"
    PR15                     "Procedure 15"
    PRCCS1                   "CCS: procedure 1"
    PRCCS2                   "CCS: procedure 2"
    PRCCS3                   "CCS: procedure 3"
    PRCCS4                   "CCS: procedure 4"
    PRCCS5                   "CCS: procedure 5"
    PRCCS6                   "CCS: procedure 6"
    PRCCS7                   "CCS: procedure 7"
    PRCCS8                   "CCS: procedure 8"
    PRCCS9                   "CCS: procedure 9"
    PRCCS10                  "CCS: procedure 10"
    PRCCS11                  "CCS: procedure 11"
    PRCCS12                  "CCS: procedure 12"
    PRCCS13                  "CCS: procedure 13"
    PRCCS14                  "CCS: procedure 14"
    PRCCS15                  "CCS: procedure 15"
    PRDAY1                   "Number of days from admission to PR1"
    PRDAY2                   "Number of days from admission to PR2"
    PRDAY3                   "Number of days from admission to PR3"
    PRDAY4                   "Number of days from admission to PR4"
    PRDAY5                   "Number of days from admission to PR5"
    PRDAY6                   "Number of days from admission to PR6"
    PRDAY7                   "Number of days from admission to PR7"
    PRDAY8                   "Number of days from admission to PR8"
    PRDAY9                   "Number of days from admission to PR9"
    PRDAY10                  "Number of days from admission to PR10"
    PRDAY11                  "Number of days from admission to PR11"
    PRDAY12                  "Number of days from admission to PR12"
    PRDAY13                  "Number of days from admission to PR13"
    PRDAY14                  "Number of days from admission to PR14"
    PRDAY15                  "Number of days from admission to PR15"
    PRMCCS1                  "Multi-Level CCS:  Procedure 1"
    PRVER                    "Procedure Version"
    SERVICELINE              "Hospital Service Line" .

*** Convert special values to system missing values ***.
RECODE BODYSYSTEM1              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM2              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM3              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM4              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM5              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM6              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM7              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM8              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM9              (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM10             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM11             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM12             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM13             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM14             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM15             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM16             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM17             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM18             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM19             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM20             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM21             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM22             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM23             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM24             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM25             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM26             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM27             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM28             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM29             (-99 -88 -66=SYSMIS).
RECODE BODYSYSTEM30             (-99 -88 -66=SYSMIS).
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRON16                  (-99 -88 -66=SYSMIS).
RECODE CHRON17                  (-99 -88 -66=SYSMIS).
RECODE CHRON18                  (-99 -88 -66=SYSMIS).
RECODE CHRON19                  (-99 -88 -66=SYSMIS).
RECODE CHRON20                  (-99 -88 -66=SYSMIS).
RECODE CHRON21                  (-99 -88 -66=SYSMIS).
RECODE CHRON22                  (-99 -88 -66=SYSMIS).
RECODE CHRON23                  (-99 -88 -66=SYSMIS).
RECODE CHRON24                  (-99 -88 -66=SYSMIS).
RECODE CHRON25                  (-99 -88 -66=SYSMIS).
RECODE CHRON26                  (-99 -88 -66=SYSMIS).
RECODE CHRON27                  (-99 -88 -66=SYSMIS).
RECODE CHRON28                  (-99 -88 -66=SYSMIS).
RECODE CHRON29                  (-99 -88 -66=SYSMIS).
RECODE CHRON30                  (-99 -88 -66=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-999 -888 -666=SYSMIS).
RECODE DXCCS2                   (-999 -888 -666=SYSMIS).
RECODE DXCCS3                   (-999 -888 -666=SYSMIS).
RECODE DXCCS4                   (-999 -888 -666=SYSMIS).
RECODE DXCCS5                   (-999 -888 -666=SYSMIS).
RECODE DXCCS6                   (-999 -888 -666=SYSMIS).
RECODE DXCCS7                   (-999 -888 -666=SYSMIS).
RECODE DXCCS8                   (-999 -888 -666=SYSMIS).
RECODE DXCCS9                   (-999 -888 -666=SYSMIS).
RECODE DXCCS10                  (-999 -888 -666=SYSMIS).
RECODE DXCCS11                  (-999 -888 -666=SYSMIS).
RECODE DXCCS12                  (-999 -888 -666=SYSMIS).
RECODE DXCCS13                  (-999 -888 -666=SYSMIS).
RECODE DXCCS14                  (-999 -888 -666=SYSMIS).
RECODE DXCCS15                  (-999 -888 -666=SYSMIS).
RECODE DXCCS16                  (-999 -888 -666=SYSMIS).
RECODE DXCCS17                  (-999 -888 -666=SYSMIS).
RECODE DXCCS18                  (-999 -888 -666=SYSMIS).
RECODE DXCCS19                  (-999 -888 -666=SYSMIS).
RECODE DXCCS20                  (-999 -888 -666=SYSMIS).
RECODE DXCCS21                  (-999 -888 -666=SYSMIS).
RECODE DXCCS22                  (-999 -888 -666=SYSMIS).
RECODE DXCCS23                  (-999 -888 -666=SYSMIS).
RECODE DXCCS24                  (-999 -888 -666=SYSMIS).
RECODE DXCCS25                  (-999 -888 -666=SYSMIS).
RECODE DXCCS26                  (-999 -888 -666=SYSMIS).
RECODE DXCCS27                  (-999 -888 -666=SYSMIS).
RECODE DXCCS28                  (-999 -888 -666=SYSMIS).
RECODE DXCCS29                  (-999 -888 -666=SYSMIS).
RECODE DXCCS30                  (-999 -888 -666=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE HOSP_NIS                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSPBRTH                 (-9 -8 -6 -5=SYSMIS).
RECODE KEY_NIS                  (-999999999 -888888888 -666666666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE NCHRONIC                 (-9 -8 -6 -5=SYSMIS).
RECODE NDX                      (-9 -8 -6 -5=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEOMAT                   (-9 -8 -6 -5=SYSMIS).
RECODE NPR                      (-9 -8 -6 -5=SYSMIS).
RECODE ORPROC                   (-9 -8 -6 -5=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).
RECODE PRCCS1                   (-99 -88 -66=SYSMIS).
RECODE PRCCS2                   (-99 -88 -66=SYSMIS).
RECODE PRCCS3                   (-99 -88 -66=SYSMIS).
RECODE PRCCS4                   (-99 -88 -66=SYSMIS).
RECODE PRCCS5                   (-99 -88 -66=SYSMIS).
RECODE PRCCS6                   (-99 -88 -66=SYSMIS).
RECODE PRCCS7                   (-99 -88 -66=SYSMIS).
RECODE PRCCS8                   (-99 -88 -66=SYSMIS).
RECODE PRCCS9                   (-99 -88 -66=SYSMIS).
RECODE PRCCS10                  (-99 -88 -66=SYSMIS).
RECODE PRCCS11                  (-99 -88 -66=SYSMIS).
RECODE PRCCS12                  (-99 -88 -66=SYSMIS).
RECODE PRCCS13                  (-99 -88 -66=SYSMIS).
RECODE PRCCS14                  (-99 -88 -66=SYSMIS).
RECODE PRCCS15                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).
RECODE SERVICELINE              (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2015Q1Q3_DX_PR_GRPS.SAV' / COMPRESSED.
