/*****************************************************************************
* SPSSload_NIS_2011_DX_PR_GRPS.SPS
* This program will load the 2011 NIS ASCII DX_PR_GRPS File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'NIS_2011_DX_PR_GRPS.ASC' FIXED / 
    HOSPID                     1-  5
    KEY                        6- 20
    CHRON1                    21- 23
    CHRON2                    24- 26
    CHRON3                    27- 29
    CHRON4                    30- 32
    CHRON5                    33- 35
    CHRON6                    36- 38
    CHRON7                    39- 41
    CHRON8                    42- 44
    CHRON9                    45- 47
    CHRON10                   48- 50
    CHRON11                   51- 53
    CHRON12                   54- 56
    CHRON13                   57- 59
    CHRON14                   60- 62
    CHRON15                   63- 65
    CHRON16                   66- 68
    CHRON17                   69- 71
    CHRON18                   72- 74
    CHRON19                   75- 77
    CHRON20                   78- 80
    CHRON21                   81- 83
    CHRON22                   84- 86
    CHRON23                   87- 89
    CHRON24                   90- 92
    CHRON25                   93- 95
    CHRONB1                   96- 98
    CHRONB2                   99-101
    CHRONB3                  102-104
    CHRONB4                  105-107
    CHRONB5                  108-110
    CHRONB6                  111-113
    CHRONB7                  114-116
    CHRONB8                  117-119
    CHRONB9                  120-122
    CHRONB10                 123-125
    CHRONB11                 126-128
    CHRONB12                 129-131
    CHRONB13                 132-134
    CHRONB14                 135-137
    CHRONB15                 138-140
    CHRONB16                 141-143
    CHRONB17                 144-146
    CHRONB18                 147-149
    CHRONB19                 150-152
    CHRONB20                 153-155
    CHRONB21                 156-158
    CHRONB22                 159-161
    CHRONB23                 162-164
    CHRONB24                 165-167
    CHRONB25                 168-170
    DXMCCS1                  171-181 (A)
    E_MCCS1                  182-192 (A)
    PCLASS1                  193-195
    PCLASS2                  196-198
    PCLASS3                  199-201
    PCLASS4                  202-204
    PCLASS5                  205-207
    PCLASS6                  208-210
    PCLASS7                  211-213
    PCLASS8                  214-216
    PCLASS9                  217-219
    PCLASS10                 220-222
    PCLASS11                 223-225
    PCLASS12                 226-228
    PCLASS13                 229-231
    PCLASS14                 232-234
    PCLASS15                 235-237
    PRMCCS1                  238-245 (A).

***  Specify write formats  ***.
FORMATS
    HOSPID                   (F5.0) /
    KEY                      (F15.0) /
    CHRON1                   (F3.0) /
    CHRON2                   (F3.0) /
    CHRON3                   (F3.0) /
    CHRON4                   (F3.0) /
    CHRON5                   (F3.0) /
    CHRON6                   (F3.0) /
    CHRON7                   (F3.0) /
    CHRON8                   (F3.0) /
    CHRON9                   (F3.0) /
    CHRON10                  (F3.0) /
    CHRON11                  (F3.0) /
    CHRON12                  (F3.0) /
    CHRON13                  (F3.0) /
    CHRON14                  (F3.0) /
    CHRON15                  (F3.0) /
    CHRON16                  (F3.0) /
    CHRON17                  (F3.0) /
    CHRON18                  (F3.0) /
    CHRON19                  (F3.0) /
    CHRON20                  (F3.0) /
    CHRON21                  (F3.0) /
    CHRON22                  (F3.0) /
    CHRON23                  (F3.0) /
    CHRON24                  (F3.0) /
    CHRON25                  (F3.0) /
    CHRONB1                  (F3.0) /
    CHRONB2                  (F3.0) /
    CHRONB3                  (F3.0) /
    CHRONB4                  (F3.0) /
    CHRONB5                  (F3.0) /
    CHRONB6                  (F3.0) /
    CHRONB7                  (F3.0) /
    CHRONB8                  (F3.0) /
    CHRONB9                  (F3.0) /
    CHRONB10                 (F3.0) /
    CHRONB11                 (F3.0) /
    CHRONB12                 (F3.0) /
    CHRONB13                 (F3.0) /
    CHRONB14                 (F3.0) /
    CHRONB15                 (F3.0) /
    CHRONB16                 (F3.0) /
    CHRONB17                 (F3.0) /
    CHRONB18                 (F3.0) /
    CHRONB19                 (F3.0) /
    CHRONB20                 (F3.0) /
    CHRONB21                 (F3.0) /
    CHRONB22                 (F3.0) /
    CHRONB23                 (F3.0) /
    CHRONB24                 (F3.0) /
    CHRONB25                 (F3.0) /
    PCLASS1                  (F3.0) /
    PCLASS2                  (F3.0) /
    PCLASS3                  (F3.0) /
    PCLASS4                  (F3.0) /
    PCLASS5                  (F3.0) /
    PCLASS6                  (F3.0) /
    PCLASS7                  (F3.0) /
    PCLASS8                  (F3.0) /
    PCLASS9                  (F3.0) /
    PCLASS10                 (F3.0) /
    PCLASS11                 (F3.0) /
    PCLASS12                 (F3.0) /
    PCLASS13                 (F3.0) /
    PCLASS14                 (F3.0) /
    PCLASS15                 (F3.0) /
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSPID                   "HCUP hospital identification number"
    KEY                      "HCUP record identifier"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    CHRON16                  "Chronic condition indicator 16"
    CHRON17                  "Chronic condition indicator 17"
    CHRON18                  "Chronic condition indicator 18"
    CHRON19                  "Chronic condition indicator 19"
    CHRON20                  "Chronic condition indicator 20"
    CHRON21                  "Chronic condition indicator 21"
    CHRON22                  "Chronic condition indicator 22"
    CHRON23                  "Chronic condition indicator 23"
    CHRON24                  "Chronic condition indicator 24"
    CHRON25                  "Chronic condition indicator 25"
    CHRONB1                  "Chronic condition body system 1"
    CHRONB2                  "Chronic condition body system 2"
    CHRONB3                  "Chronic condition body system 3"
    CHRONB4                  "Chronic condition body system 4"
    CHRONB5                  "Chronic condition body system 5"
    CHRONB6                  "Chronic condition body system 6"
    CHRONB7                  "Chronic condition body system 7"
    CHRONB8                  "Chronic condition body system 8"
    CHRONB9                  "Chronic condition body system 9"
    CHRONB10                 "Chronic condition body system 10"
    CHRONB11                 "Chronic condition body system 11"
    CHRONB12                 "Chronic condition body system 12"
    CHRONB13                 "Chronic condition body system 13"
    CHRONB14                 "Chronic condition body system 14"
    CHRONB15                 "Chronic condition body system 15"
    CHRONB16                 "Chronic condition body system 16"
    CHRONB17                 "Chronic condition body system 17"
    CHRONB18                 "Chronic condition body system 18"
    CHRONB19                 "Chronic condition body system 19"
    CHRONB20                 "Chronic condition body system 20"
    CHRONB21                 "Chronic condition body system 21"
    CHRONB22                 "Chronic condition body system 22"
    CHRONB23                 "Chronic condition body system 23"
    CHRONB24                 "Chronic condition body system 24"
    CHRONB25                 "Chronic condition body system 25"
    DXMCCS1                  "Multi-Level CCS:  Diagnosis 1"
    E_MCCS1                  "Multi-Level CCS:  E Code 1"
    PCLASS1                  "Procedure class 1"
    PCLASS2                  "Procedure class 2"
    PCLASS3                  "Procedure class 3"
    PCLASS4                  "Procedure class 4"
    PCLASS5                  "Procedure class 5"
    PCLASS6                  "Procedure class 6"
    PCLASS7                  "Procedure class 7"
    PCLASS8                  "Procedure class 8"
    PCLASS9                  "Procedure class 9"
    PCLASS10                 "Procedure class 10"
    PCLASS11                 "Procedure class 11"
    PCLASS12                 "Procedure class 12"
    PCLASS13                 "Procedure class 13"
    PCLASS14                 "Procedure class 14"
    PCLASS15                 "Procedure class 15"
    PRMCCS1                  "Multi-Level CCS:  Procedure 1" .

*** Convert special values to system missing values ***.
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE CHRON16                  (-99 -88 -66=SYSMIS).
RECODE CHRON17                  (-99 -88 -66=SYSMIS).
RECODE CHRON18                  (-99 -88 -66=SYSMIS).
RECODE CHRON19                  (-99 -88 -66=SYSMIS).
RECODE CHRON20                  (-99 -88 -66=SYSMIS).
RECODE CHRON21                  (-99 -88 -66=SYSMIS).
RECODE CHRON22                  (-99 -88 -66=SYSMIS).
RECODE CHRON23                  (-99 -88 -66=SYSMIS).
RECODE CHRON24                  (-99 -88 -66=SYSMIS).
RECODE CHRON25                  (-99 -88 -66=SYSMIS).
RECODE CHRONB1                  (-99 -88 -66=SYSMIS).
RECODE CHRONB2                  (-99 -88 -66=SYSMIS).
RECODE CHRONB3                  (-99 -88 -66=SYSMIS).
RECODE CHRONB4                  (-99 -88 -66=SYSMIS).
RECODE CHRONB5                  (-99 -88 -66=SYSMIS).
RECODE CHRONB6                  (-99 -88 -66=SYSMIS).
RECODE CHRONB7                  (-99 -88 -66=SYSMIS).
RECODE CHRONB8                  (-99 -88 -66=SYSMIS).
RECODE CHRONB9                  (-99 -88 -66=SYSMIS).
RECODE CHRONB10                 (-99 -88 -66=SYSMIS).
RECODE CHRONB11                 (-99 -88 -66=SYSMIS).
RECODE CHRONB12                 (-99 -88 -66=SYSMIS).
RECODE CHRONB13                 (-99 -88 -66=SYSMIS).
RECODE CHRONB14                 (-99 -88 -66=SYSMIS).
RECODE CHRONB15                 (-99 -88 -66=SYSMIS).
RECODE CHRONB16                 (-99 -88 -66=SYSMIS).
RECODE CHRONB17                 (-99 -88 -66=SYSMIS).
RECODE CHRONB18                 (-99 -88 -66=SYSMIS).
RECODE CHRONB19                 (-99 -88 -66=SYSMIS).
RECODE CHRONB20                 (-99 -88 -66=SYSMIS).
RECODE CHRONB21                 (-99 -88 -66=SYSMIS).
RECODE CHRONB22                 (-99 -88 -66=SYSMIS).
RECODE CHRONB23                 (-99 -88 -66=SYSMIS).
RECODE CHRONB24                 (-99 -88 -66=SYSMIS).
RECODE CHRONB25                 (-99 -88 -66=SYSMIS).
RECODE PCLASS1                  (-99 -88 -66=SYSMIS).
RECODE PCLASS2                  (-99 -88 -66=SYSMIS).
RECODE PCLASS3                  (-99 -88 -66=SYSMIS).
RECODE PCLASS4                  (-99 -88 -66=SYSMIS).
RECODE PCLASS5                  (-99 -88 -66=SYSMIS).
RECODE PCLASS6                  (-99 -88 -66=SYSMIS).
RECODE PCLASS7                  (-99 -88 -66=SYSMIS).
RECODE PCLASS8                  (-99 -88 -66=SYSMIS).
RECODE PCLASS9                  (-99 -88 -66=SYSMIS).
RECODE PCLASS10                 (-99 -88 -66=SYSMIS).
RECODE PCLASS11                 (-99 -88 -66=SYSMIS).
RECODE PCLASS12                 (-99 -88 -66=SYSMIS).
RECODE PCLASS13                 (-99 -88 -66=SYSMIS).
RECODE PCLASS14                 (-99 -88 -66=SYSMIS).
RECODE PCLASS15                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NIS_2011_DX_PR_GRPS.SAV' / COMPRESSED.
