/*****************************************************************************
* SASload_NIS_2000_Supplemental.SAS
* This program will load the 2000 NIS ASCII Supplemental File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NIS_2000_Supplemental; 
INFILE 'NIS_2000_Supplemental.ASC' LRECL = 234;

*** Define data element attributes ***;
ATTRIB 
  TRENDWT                    LENGTH=8
  LABEL="Trend weight to discharges in the universe"

  NDX                        LENGTH=3
  LABEL="I:Number of diagnoses on this discharge"

  DXCCS1                     LENGTH=3
  LABEL="CCS: principal diagnosis"

  DXCCS2                     LENGTH=3
  LABEL="CCS: diagnosis 2"

  DXCCS3                     LENGTH=3
  LABEL="CCS: diagnosis 3"

  DXCCS4                     LENGTH=3
  LABEL="CCS: diagnosis 4"

  DXCCS5                     LENGTH=3
  LABEL="CCS: diagnosis 5"

  DXCCS6                     LENGTH=3
  LABEL="CCS: diagnosis 6"

  DXCCS7                     LENGTH=3
  LABEL="CCS: diagnosis 7"

  DXCCS8                     LENGTH=3
  LABEL="CCS: diagnosis 8"

  DXCCS9                     LENGTH=3
  LABEL="CCS: diagnosis 9"

  DXCCS10                    LENGTH=3
  LABEL="CCS: diagnosis 10"

  DXCCS11                    LENGTH=3
  LABEL="CCS: diagnosis 11"

  DXCCS12                    LENGTH=3
  LABEL="CCS: diagnosis 12"

  DXCCS13                    LENGTH=3
  LABEL="CCS: diagnosis 13"

  DXCCS14                    LENGTH=3
  LABEL="CCS: diagnosis 14"

  DXCCS15                    LENGTH=3
  LABEL="CCS: diagnosis 15"

  E_CCS1                     LENGTH=3
  LABEL="CCS: E Code 1"

  E_CCS2                     LENGTH=3
  LABEL="CCS: E Code 2"

  E_CCS3                     LENGTH=3
  LABEL="CCS: E Code 3"

  E_CCS4                     LENGTH=3
  LABEL="CCS: E Code 4"

  ELECTIVE                   LENGTH=3
  LABEL="Elective versus non-elective admission"

  NECODE                     LENGTH=3
  LABEL="Number of E codes on this record"

  ZipInc_Qrtl                LENGTH=3
  LABEL="Median Household Income Quartiles for Patient's ZIP Code"

  TRENDWTcharge              LENGTH=8
  LABEL="Weight to discharges in the universe for total charge estimates"

  KEY                        LENGTH=8            FORMAT=Z14.
  LABEL="HCUP record identifier"

  DX1                        LENGTH=$5
  LABEL="Principal diagnosis"

  DX2                        LENGTH=$5
  LABEL="Diagnosis 2"

  DX3                        LENGTH=$5
  LABEL="Diagnosis 3"

  DX4                        LENGTH=$5
  LABEL="Diagnosis 4"

  DX5                        LENGTH=$5
  LABEL="Diagnosis 5"

  DX6                        LENGTH=$5
  LABEL="Diagnosis 6"

  DX7                        LENGTH=$5
  LABEL="Diagnosis 7"

  DX8                        LENGTH=$5
  LABEL="Diagnosis 8"

  DX9                        LENGTH=$5
  LABEL="Diagnosis 9"

  DX10                       LENGTH=$5
  LABEL="Diagnosis 10"

  DX11                       LENGTH=$5
  LABEL="Diagnosis 11"

  DX12                       LENGTH=$5
  LABEL="Diagnosis 12"

  DX13                       LENGTH=$5
  LABEL="Diagnosis 13"

  DX14                       LENGTH=$5
  LABEL="Diagnosis 14"

  DX15                       LENGTH=$5
  LABEL="Diagnosis 15"

  ECODE1                     LENGTH=$5
  LABEL="E code 1"

  ECODE2                     LENGTH=$5
  LABEL="E code 2"

  ECODE3                     LENGTH=$5
  LABEL="E code 3"

  ECODE4                     LENGTH=$5
  LABEL="E code 4"

  MDNUM1_S                   LENGTH=$16
  LABEL="Physician 1 number (synthetic)"

  MDNUM2_S                   LENGTH=$16
  LABEL="Physician 2 number (synthetic)"
  ;

*** Read data elements from the ASCII file ***;
INPUT 
      @1      TRENDWT                  N11P7F.
      @12     NDX                      N2PF.
      @14     DXCCS1                   N3PF.
      @17     DXCCS2                   N3PF.
      @20     DXCCS3                   N3PF.
      @23     DXCCS4                   N3PF.
      @26     DXCCS5                   N3PF.
      @29     DXCCS6                   N3PF.
      @32     DXCCS7                   N3PF.
      @35     DXCCS8                   N3PF.
      @38     DXCCS9                   N3PF.
      @41     DXCCS10                  N3PF.
      @44     DXCCS11                  N3PF.
      @47     DXCCS12                  N3PF.
      @50     DXCCS13                  N3PF.
      @53     DXCCS14                  N3PF.
      @56     DXCCS15                  N3PF.
      @59     E_CCS1                   N4PF.
      @63     E_CCS2                   N4PF.
      @67     E_CCS3                   N4PF.
      @71     E_CCS4                   N4PF.
      @75     ELECTIVE                 N2PF.
      @77     NECODE                   N3PF.
      @80     ZipInc_Qrtl              N2PF.
      @82     TRENDWTcharge            N11P7F.
      @93     KEY                      15.
      @108    DX1                      $CHAR5.
      @113    DX2                      $CHAR5.
      @118    DX3                      $CHAR5.
      @123    DX4                      $CHAR5.
      @128    DX5                      $CHAR5.
      @133    DX6                      $CHAR5.
      @138    DX7                      $CHAR5.
      @143    DX8                      $CHAR5.
      @148    DX9                      $CHAR5.
      @153    DX10                     $CHAR5.
      @158    DX11                     $CHAR5.
      @163    DX12                     $CHAR5.
      @168    DX13                     $CHAR5.
      @173    DX14                     $CHAR5.
      @178    DX15                     $CHAR5.
      @183    ECODE1                   $CHAR5.
      @188    ECODE2                   $CHAR5.
      @193    ECODE3                   $CHAR5.
      @198    ECODE4                   $CHAR5.
      @203    MDNUM1_S                 $CHAR16.
      @219    MDNUM2_S                 $CHAR16.
      ;
RUN;
