/*****************************************************************************/
/* SPSSload_NEDS_2016_ED.SPS                                          */
/* This program will load the NEDS 2016 ED csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2016_ED.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    CPTCCS1                  F4.0
    CPTCCS2                  F4.0
    CPTCCS3                  F4.0
    CPTCCS4                  F4.0
    CPTCCS5                  F4.0
    CPTCCS6                  F4.0
    CPTCCS7                  F4.0
    CPTCCS8                  F4.0
    CPTCCS9                  F4.0
    CPTCCS10                 F4.0
    CPTCCS11                 F4.0
    CPTCCS12                 F4.0
    CPTCCS13                 F4.0
    CPTCCS14                 F4.0
    CPTCCS15                 F4.0
    NCPT                     F4.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    CPT1                     "CPT/HCPCS procedure code 1"
    CPT2                     "CPT/HCPCS procedure code 2"
    CPT3                     "CPT/HCPCS procedure code 3"
    CPT4                     "CPT/HCPCS procedure code 4"
    CPT5                     "CPT/HCPCS procedure code 5"
    CPT6                     "CPT/HCPCS procedure code 6"
    CPT7                     "CPT/HCPCS procedure code 7"
    CPT8                     "CPT/HCPCS procedure code 8"
    CPT9                     "CPT/HCPCS procedure code 9"
    CPT10                    "CPT/HCPCS procedure code 10"
    CPT11                    "CPT/HCPCS procedure code 11"
    CPT12                    "CPT/HCPCS procedure code 12"
    CPT13                    "CPT/HCPCS procedure code 13"
    CPT14                    "CPT/HCPCS procedure code 14"
    CPT15                    "CPT/HCPCS procedure code 15"
    CPTCCS1                  "CCS: CPT 1"
    CPTCCS2                  "CCS: CPT 2"
    CPTCCS3                  "CCS: CPT 3"
    CPTCCS4                  "CCS: CPT 4"
    CPTCCS5                  "CCS: CPT 5"
    CPTCCS6                  "CCS: CPT 6"
    CPTCCS7                  "CCS: CPT 7"
    CPTCCS8                  "CCS: CPT 8"
    CPTCCS9                  "CCS: CPT 9"
    CPTCCS10                 "CCS: CPT 10"
    CPTCCS11                 "CCS: CPT 11"
    CPTCCS12                 "CCS: CPT 12"
    CPTCCS13                 "CCS: CPT 13"
    CPTCCS14                 "CCS: CPT 14"
    CPTCCS15                 "CCS: CPT 15"
    NCPT                     "Number of CPT/HCPCS procedures for this visit" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE CPTCCS1                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS2                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS3                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS4                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS5                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS6                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS7                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS8                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS9                  (-999 -888 -666=SYSMIS).
RECODE CPTCCS10                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS11                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS12                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS13                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS14                 (-999 -888 -666=SYSMIS).
RECODE CPTCCS15                 (-999 -888 -666=SYSMIS).
RECODE NCPT                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'NEDS_2016_ED.SAV' / COMPRESSED.
