/*****************************************************************************
* SPSSload_NEDS_2007_IP.SPS
* This program will load the 2007 NEDS csv IP File into SPSS.
*****************************************************************************/

*** Read data elements from the csv file ***.
get data /type = txt
    /file = "NEDS_2007_IP.csv"
    /delimiters = ',' 
    /variables = 
    DISCWT                   F11.7
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    DISP_IP                  F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    LOS_IP                   F5.0
    MDC                      F2.0
    NPR_IP                   F3.0
    PCLS_IP1                 F3.0
    PCLS_IP2                 F3.0
    PCLS_IP3                 F3.0
    PCLS_IP4                 F3.0
    PCLS_IP5                 F3.0
    PCLS_IP6                 F3.0
    PCLS_IP7                 F3.0
    PCLS_IP8                 F3.0
    PCLS_IP9                 F3.0
    PR_IP1                   A4
    PR_IP2                   A4
    PR_IP3                   A4
    PR_IP4                   A4
    PR_IP5                   A4
    PR_IP6                   A4
    PR_IP7                   A4
    PR_IP8                   A4
    PR_IP9                   A4
    PRCCSIP1                 F3.0
    PRCCSIP2                 F3.0
    PRCCSIP3                 F3.0
    PRCCSIP4                 F3.0
    PRCCSIP5                 F3.0
    PRCCSIP6                 F3.0
    PRCCSIP7                 F3.0
    PRCCSIP8                 F3.0
    PRCCSIP9                 F3.0
    TOTCHGIP                 F12.2
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    DISCWT                   "Weight to ED Visits in AHA universe"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    DISP_IP                  "Disposition of patient (uniform) from IP"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    LOS_IP                   "Length of stay (cleaned) from IP"
    MDC                      "MDC in effect on discharge date"
    NPR_IP                   "Number of procedures from inpatient discharge record"
    PCLS_IP1                 "Principal procedure class for inpatient procedure"
    PCLS_IP2                 "Procedure class 2 for inpatient procedure"
    PCLS_IP3                 "Procedure class 3 for inpatient procedure"
    PCLS_IP4                 "Procedure class 4 for inpatient procedure"
    PCLS_IP5                 "Procedure class 5 for inpatient procedure"
    PCLS_IP6                 "Procedure class 6 for inpatient procedure"
    PCLS_IP7                 "Procedure class 7 for inpatient procedure"
    PCLS_IP8                 "Procedure class 8 for inpatient procedure"
    PCLS_IP9                 "Procedure class 9 for inpatient procedure"
    PR_IP1                   "Principal procedure from inpatient discharge record"
    PR_IP2                   "Procedure 2 from inpatient discharge record"
    PR_IP3                   "Procedure 3 from inpatient discharge record"
    PR_IP4                   "Procedure 4 from inpatient discharge record"
    PR_IP5                   "Procedure 5 from inpatient discharge record"
    PR_IP6                   "Procedure 6 from inpatient discharge record"
    PR_IP7                   "Procedure 7 from inpatient discharge record"
    PR_IP8                   "Procedure 8 from inpatient discharge record"
    PR_IP9                   "Procedure 9 from inpatient discharge record"
    PRCCSIP1                 "CCS: principal procedure from inpatient discharge record"
    PRCCSIP2                 "CCS: procedure 2 from inpatient discharge record"
    PRCCSIP3                 "CCS: procedure 3 from inpatient discharge record"
    PRCCSIP4                 "CCS: procedure 4 from inpatient discharge record"
    PRCCSIP5                 "CCS: procedure 5 from inpatient discharge record"
    PRCCSIP6                 "CCS: procedure 6 from inpatient discharge record"
    PRCCSIP7                 "CCS: procedure 7 from inpatient discharge record"
    PRCCSIP8                 "CCS: procedure 8 from inpatient discharge record"
    PRCCSIP9                 "CCS: procedure 9 from inpatient discharge record"
    TOTCHGIP                 "Total charge for ED and inpatient services" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE DISP_IP                  (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE LOS_IP                   (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE NPR_IP                   (-99 -88 -66=SYSMIS).
RECODE PCLS_IP1                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP2                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP3                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP4                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP5                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP6                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP7                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP8                 (-99 -88 -66=SYSMIS).
RECODE PCLS_IP9                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP1                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP2                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP3                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP4                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP5                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP6                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP7                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP8                 (-99 -88 -66=SYSMIS).
RECODE PRCCSIP9                 (-99 -88 -66=SYSMIS).
RECODE TOTCHGIP                 (-99999999.99 -88888888.88 -66666666.66=SYSMIS).

SAVE OUTFILE = 'NEDS_2007_IP.SAV' / COMPRESSED.
