/*****************************************************************************/
/* SPSSload_NEDS_2020_Core.SPS                                          */
/* This program will load the NEDS 2020 Core csv File into SPSS.         */
/* created on 09/09/2022.                                    */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2020_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AMONTH                   F2.0
    AWEEKEND                 F2.0
    DIED_VISIT               F2.0
    DISCWT                   F11.7
    DISP_ED                  F2.0
    DQTR                     F2.0
    EDEVENT                  F2.0
    FEMALE                   F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    I10_DX1                  A7
    I10_DX2                  A7
    I10_DX3                  A7
    I10_DX4                  A7
    I10_DX5                  A7
    I10_DX6                  A7
    I10_DX7                  A7
    I10_DX8                  A7
    I10_DX9                  A7
    I10_DX10                 A7
    I10_DX11                 A7
    I10_DX12                 A7
    I10_DX13                 A7
    I10_DX14                 A7
    I10_DX15                 A7
    I10_DX16                 A7
    I10_DX17                 A7
    I10_DX18                 A7
    I10_DX19                 A7
    I10_DX20                 A7
    I10_DX21                 A7
    I10_DX22                 A7
    I10_DX23                 A7
    I10_DX24                 A7
    I10_DX25                 A7
    I10_DX26                 A7
    I10_DX27                 A7
    I10_DX28                 A7
    I10_DX29                 A7
    I10_DX30                 A7
    I10_DX31                 A7
    I10_DX32                 A7
    I10_DX33                 A7
    I10_DX34                 A7
    I10_DX35                 A7
    I10_INJURY               F2.0
    I10_INJURY_CUT           F2.0
    I10_INJURY_DROWN         F2.0
    I10_INJURY_FALL          F2.0
    I10_INJURY_FIRE          F2.0
    I10_INJURY_FIREARM       F2.0
    I10_INJURY_MACHINERY     F2.0
    I10_INJURY_MVT           F2.0
    I10_INJURY_NATURE        F2.0
    I10_INJURY_OVEREXERTION  F2.0
    I10_INJURY_POISON        F2.0
    I10_INJURY_STRUCK        F2.0
    I10_INJURY_SUFFOCATION   F2.0
    I10_INTENT_ASSAULT       F2.0
    I10_INTENT_SELF_HARM     F2.0
    I10_INTENT_UNINTENTIONAL F2.0
    I10_MULTINJURY           F2.0
    I10_NDX                  F3.0
    KEY_ED                   F16.0
    NEDS_STRATUM             F5.0
    PAY1                     F2.0
    PAY2                     F2.0
    PL_NCHS                  F3.0
    RACE                     F2.0
    TOTCHG_ED                F12.2
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED_VISIT               "Died in the ED (1), Died in the hospital (2), did not die (0)"
    DISCWT                   "Weight to ED Visits in AHA universe"
    DISP_ED                  "Disposition of patient (uniform) from ED"
    DQTR                     "Discharge quarter"
    EDEVENT                  "Type of ED Event"
    FEMALE                   "Indicator of sex"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_DX31                 "ICD-10-CM Diagnosis 31"
    I10_DX32                 "ICD-10-CM Diagnosis 32"
    I10_DX33                 "ICD-10-CM Diagnosis 33"
    I10_DX34                 "ICD-10-CM Diagnosis 34"
    I10_DX35                 "ICD-10-CM Diagnosis 35"
    I10_INJURY
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)"
    I10_INJURY_CUT           "Mechanism of injury: cut or pierce"
    I10_INJURY_DROWN         "Mechanism of injury: drowning or submersion"
    I10_INJURY_FALL          "Mechanism of injury: fall"
    I10_INJURY_FIRE          "Mechanism of injury: fire, flame, hot object, or hot substance"
    I10_INJURY_FIREARM       "Mechanism of injury: firearm"
    I10_INJURY_MACHINERY     "Mechanism of injury: machinery"
    I10_INJURY_MVT

"Mechanism of injury: motor vehicle traffic, including the occupant of a car, motorcyclist, pedal cyclist, pedestrian, other, or uns
pecified"
    I10_INJURY_NATURE        "Mechanism of injury: natural or environmental, included venomous and nonvenomous bites and stings"
    I10_INJURY_OVEREXERTION  "Mechanism of injury: overexertion"
    I10_INJURY_POISON        "Mechanism of injury: poisoning, including drugs and nondrugs"
    I10_INJURY_STRUCK        "Mechanism of injury: struck by or against"
    I10_INJURY_SUFFOCATION   "Mechanism of injury: suffocation"
    I10_INTENT_ASSAULT       "Intent of injury: assault"
    I10_INTENT_SELF_HARM     "Intent of injury: intentional self-harm"
    I10_INTENT_UNINTENTIONAL "Intent of injury: unintentional"
    I10_MULTINJURY           "Multiple ICD-10-CM injuries reported on record"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    KEY_ED                   "HCUP NEDS record identifier"
    NEDS_STRATUM             "Stratum used to sample hospital"
    PAY1                     "Primary expected payer (uniform)"
    PAY2                     "Secondary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    RACE                     "Race (uniform)"
    TOTCHG_ED                "Total charge for ED services"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED_VISIT               (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE EDEVENT                  (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE I10_INJURY               (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_CUT           (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_DROWN         (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_FALL          (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_FIRE          (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_FIREARM       (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_MACHINERY     (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_MVT           (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_NATURE        (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_OVEREXERTION  (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_POISON        (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_STRUCK        (-9 -8 -6 -5=SYSMIS).
RECODE I10_INJURY_SUFFOCATION   (-9 -8 -6 -5=SYSMIS).
RECODE I10_INTENT_ASSAULT       (-9 -8 -6 -5=SYSMIS).
RECODE I10_INTENT_SELF_HARM     (-9 -8 -6 -5=SYSMIS).
RECODE I10_INTENT_UNINTENTIONAL (-9 -8 -6 -5=SYSMIS).
RECODE I10_MULTINJURY           (-9 -8 -6 -5=SYSMIS).
RECODE I10_NDX                  (-99 -88 -66=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NEDS_STRATUM             (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG_ED                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NEDS_2020_Core.SAV' / COMPRESSED.
