/*****************************************************************************/
/* SPSSload_NEDS_2018_IP.SPS                                          */
/* This program will load the NEDS 2018 IP csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2018_IP.csv"
    /delimiters = ',' 
    /variables = 
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    DISP_IP                  F2.0
    DRG                      F3.0
    DRGVER                   F2.0
    DRG_NoPOA                F3.0
    I10_NPR_IP               F3.0
    I10_PR_IP1               A7
    I10_PR_IP2               A7
    I10_PR_IP3               A7
    I10_PR_IP4               A7
    I10_PR_IP5               A7
    I10_PR_IP6               A7
    I10_PR_IP7               A7
    I10_PR_IP8               A7
    I10_PR_IP9               A7
    I10_PR_IP10              A7
    I10_PR_IP11              A7
    I10_PR_IP12              A7
    I10_PR_IP13              A7
    I10_PR_IP14              A7
    I10_PR_IP15              A7
    LOS_IP                   F5.0
    MDC                      F2.0
    MDC_NoPOA                F2.0
    TOTCHG_IP                F12.2
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    DISP_IP                  "Disposition of patient (uniform) from IP"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    I10_NPR_IP               "Number of ICD-10-PCS procedures from inpatient discharge record"
    I10_PR_IP1               "ICD-10-PCS Procedure 1 from inpatient discharge record"
    I10_PR_IP2               "ICD-10-PCS Procedure 2 from inpatient discharge record"
    I10_PR_IP3               "ICD-10-PCS Procedure 3 from inpatient discharge record"
    I10_PR_IP4               "ICD-10-PCS Procedure 4 from inpatient discharge record"
    I10_PR_IP5               "ICD-10-PCS Procedure 5 from inpatient discharge record"
    I10_PR_IP6               "ICD-10-PCS Procedure 6 from inpatient discharge record"
    I10_PR_IP7               "ICD-10-PCS Procedure 7 from inpatient discharge record"
    I10_PR_IP8               "ICD-10-PCS Procedure 8 from inpatient discharge record"
    I10_PR_IP9               "ICD-10-PCS Procedure 9 from inpatient discharge record"
    I10_PR_IP10              "ICD-10-PCS Procedure 10 from inpatient discharge record"
    I10_PR_IP11              "ICD-10-PCS Procedure 11 from inpatient discharge record"
    I10_PR_IP12              "ICD-10-PCS Procedure 12 from inpatient discharge record"
    I10_PR_IP13              "ICD-10-PCS Procedure 13 from inpatient discharge record"
    I10_PR_IP14              "ICD-10-PCS Procedure 14 from inpatient discharge record"
    I10_PR_IP15              "ICD-10-PCS Procedure 15 from inpatient discharge record"
    LOS_IP                   "Length of stay (cleaned) from IP"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    TOTCHG_IP                "Total charge for ED and inpatient services" .

/* Convert special values to system missing values */
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE DISP_IP                  (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE I10_NPR_IP               (-99 -88 -66=SYSMIS).
RECODE LOS_IP                   (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG_IP                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).

SAVE OUTFILE = 'NEDS_2018_IP.SAV' / COMPRESSED.
