/*****************************************************************************/
/* SPSSload_NEDS_2015_Core.SPS                                          */
/* This program will load the NEDS 2015 Core csv File into SPSS.         */
/*****************************************************************************/

/* Read data elements from the csv file */
get data /type = txt
    /file = "NEDS_2015_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AMONTH                   F2.0
    AWEEKEND                 F2.0
    DIED_VISIT               F2.0
    DISCWT                   F11.7
    DISP_ED                  F2.0
    DQTR                     F2.0
    EDEVENT                  F2.0
    FEMALE                   F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    NEDS_STRATUM             F5.0
    PAY1                     F2.0
    PAY2                     F2.0
    PL_NCHS                  F3.0
    TOTCHG_ED                F12.2
    YEAR                     F4.0
    ZIPINC_QRTL              F2.0
.

/*  Assign labels to the data elements */
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED_VISIT               "Died in the ED (1), Died in the hospital (2), did not die (0)"
    DISCWT                   "Weight to ED Visits in AHA universe"
    DISP_ED                  "Disposition of patient (uniform) from ED"
    DQTR                     "Discharge quarter"
    EDEVENT                  "Type of ED Event"
    FEMALE                   "Indicator of sex"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    NEDS_STRATUM             "Stratum used to sample hospital"
    PAY1                     "Primary expected payer (uniform)"
    PAY2                     "Secondary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    TOTCHG_ED                "Total charge for ED services"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

/* Convert special values to system missing values */
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED_VISIT               (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE EDEVENT                  (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NEDS_STRATUM             (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE TOTCHG_ED                (-99999999.99 -88888888.88 -66666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NEDS_2015_Core.SAV' / COMPRESSED.
