/*****************************************************************************
* SPSSload_NEDS_2007_Core.SPS
* This program will load the 2007 NEDS csv Core File into SPSS.
*****************************************************************************/

*** Read data elements from the csv file ***.
get data /type = txt
    /file = "NEDS_2007_Core.csv"
    /delimiters = ',' 
    /variables = 
    AGE                      F3.0
    AMONTH                   F2.0
    AWEEKEND                 F2.0
    CHRON1                   F3.0
    CHRON2                   F3.0
    CHRON3                   F3.0
    CHRON4                   F3.0
    CHRON5                   F3.0
    CHRON6                   F3.0
    CHRON7                   F3.0
    CHRON8                   F3.0
    CHRON9                   F3.0
    CHRON10                  F3.0
    CHRON11                  F3.0
    CHRON12                  F3.0
    CHRON13                  F3.0
    CHRON14                  F3.0
    CHRON15                  F3.0
    DIED_VIS                 F2.0
    DISCWT                   F12.7
    DISP_ED                  F2.0
    DQTR                     F2.0
    DX1                      A5
    DX2                      A5
    DX3                      A5
    DX4                      A5
    DX5                      A5
    DX6                      A5
    DX7                      A5
    DX8                      A5
    DX9                      A5
    DX10                     A5
    DX11                     A5
    DX12                     A5
    DX13                     A5
    DX14                     A5
    DX15                     A5
    DXCCS1                   F4.0
    DXCCS2                   F4.0
    DXCCS3                   F4.0
    DXCCS4                   F4.0
    DXCCS5                   F4.0
    DXCCS6                   F4.0
    DXCCS7                   F4.0
    DXCCS8                   F4.0
    DXCCS9                   F4.0
    DXCCS10                  F4.0
    DXCCS11                  F4.0
    DXCCS12                  F4.0
    DXCCS13                  F4.0
    DXCCS14                  F4.0
    DXCCS15                  F4.0
    ECODE1                   A5
    ECODE2                   A5
    ECODE3                   A5
    ECODE4                   A5
    EDEVENT                  F2.0
    E_CCS1                   F4.0
    E_CCS2                   F4.0
    E_CCS3                   F4.0
    E_CCS4                   F4.0
    FEMALE                   F2.0
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    REGION                   F2.0
    INTENT_S                 F2.0
    KEY_ED                   F16.0
    NDX                      F3.0
    NECODE                   F3.0
    NEDS_STR                 F5.0
    PAY1                     F2.0
    PAY2                     F2.0
    PL_NCHS2                 F3.0
    TOTCHGED                 F12.2
    YEAR                     F4.0
    ZIPINC_Q                 F2.0
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    AGE                      "Age in years at admission"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    CHRON1                   "Chronic condition indicator 1"
    CHRON2                   "Chronic condition indicator 2"
    CHRON3                   "Chronic condition indicator 3"
    CHRON4                   "Chronic condition indicator 4"
    CHRON5                   "Chronic condition indicator 5"
    CHRON6                   "Chronic condition indicator 6"
    CHRON7                   "Chronic condition indicator 7"
    CHRON8                   "Chronic condition indicator 8"
    CHRON9                   "Chronic condition indicator 9"
    CHRON10                  "Chronic condition indicator 10"
    CHRON11                  "Chronic condition indicator 11"
    CHRON12                  "Chronic condition indicator 12"
    CHRON13                  "Chronic condition indicator 13"
    CHRON14                  "Chronic condition indicator 14"
    CHRON15                  "Chronic condition indicator 15"
    DIED_VIS                 "Died in the ED (1), Died in the hospital (2), did not die (0)"
    DISCWT                   "Weight to ED Visits in AHA universe"
    DISP_ED                  "Disposition of patient (uniform) from ED"
    DQTR                     "Discharge quarter"
    DX1                      "Diagnosis 1"
    DX2                      "Diagnosis 2"
    DX3                      "Diagnosis 3"
    DX4                      "Diagnosis 4"
    DX5                      "Diagnosis 5"
    DX6                      "Diagnosis 6"
    DX7                      "Diagnosis 7"
    DX8                      "Diagnosis 8"
    DX9                      "Diagnosis 9"
    DX10                     "Diagnosis 10"
    DX11                     "Diagnosis 11"
    DX12                     "Diagnosis 12"
    DX13                     "Diagnosis 13"
    DX14                     "Diagnosis 14"
    DX15                     "Diagnosis 15"
    DXCCS1                   "CCS: diagnosis 1"
    DXCCS2                   "CCS: diagnosis 2"
    DXCCS3                   "CCS: diagnosis 3"
    DXCCS4                   "CCS: diagnosis 4"
    DXCCS5                   "CCS: diagnosis 5"
    DXCCS6                   "CCS: diagnosis 6"
    DXCCS7                   "CCS: diagnosis 7"
    DXCCS8                   "CCS: diagnosis 8"
    DXCCS9                   "CCS: diagnosis 9"
    DXCCS10                  "CCS: diagnosis 10"
    DXCCS11                  "CCS: diagnosis 11"
    DXCCS12                  "CCS: diagnosis 12"
    DXCCS13                  "CCS: diagnosis 13"
    DXCCS14                  "CCS: diagnosis 14"
    DXCCS15                  "CCS: diagnosis 15"
    ECODE1                   "E code 1"
    ECODE2                   "E code 2"
    ECODE3                   "E code 3"
    ECODE4                   "E code 4"
    EDEVENT                  "Type of ED Event"
    E_CCS1                   "CCS: E Code 1"
    E_CCS2                   "CCS: E Code 2"
    E_CCS3                   "CCS: E Code 3"
    E_CCS4                   "CCS: E Code 4"
    FEMALE                   "Indicator of sex"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    REGION                   "Region of hospital"
    INTENT_S                 "Intentional self harm indicated on the record (by diagnosis and/or E codes)"
    KEY_ED                   "HCUP NEDS record identifier"
    NDX                      "Number of diagnoses on this record"
    NECODE                   "Number of E codes on this record"
    NEDS_STR                 "Stratum used to sample hospital"
    PAY1                     "Primary expected payer (uniform)"
    PAY2                     "Secondary expected payer (uniform)"
    PL_NCHS2                 "Patient Location: NCHS Urban-Rural Code (V2006)"
    TOTCHGED                 "Total charge for ED services"
    YEAR                     "Calendar year"
    ZIPINC_Q                 "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE CHRON1                   (-99 -88 -66=SYSMIS).
RECODE CHRON2                   (-99 -88 -66=SYSMIS).
RECODE CHRON3                   (-99 -88 -66=SYSMIS).
RECODE CHRON4                   (-99 -88 -66=SYSMIS).
RECODE CHRON5                   (-99 -88 -66=SYSMIS).
RECODE CHRON6                   (-99 -88 -66=SYSMIS).
RECODE CHRON7                   (-99 -88 -66=SYSMIS).
RECODE CHRON8                   (-99 -88 -66=SYSMIS).
RECODE CHRON9                   (-99 -88 -66=SYSMIS).
RECODE CHRON10                  (-99 -88 -66=SYSMIS).
RECODE CHRON11                  (-99 -88 -66=SYSMIS).
RECODE CHRON12                  (-99 -88 -66=SYSMIS).
RECODE CHRON13                  (-99 -88 -66=SYSMIS).
RECODE CHRON14                  (-99 -88 -66=SYSMIS).
RECODE CHRON15                  (-99 -88 -66=SYSMIS).
RECODE DIED_VIS                 (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-999.9999999 -888.8888888 -666.6666666=SYSMIS).
RECODE DISP_ED                  (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DXCCS1                   (-999 -888 -666=SYSMIS).
RECODE DXCCS2                   (-999 -888 -666=SYSMIS).
RECODE DXCCS3                   (-999 -888 -666=SYSMIS).
RECODE DXCCS4                   (-999 -888 -666=SYSMIS).
RECODE DXCCS5                   (-999 -888 -666=SYSMIS).
RECODE DXCCS6                   (-999 -888 -666=SYSMIS).
RECODE DXCCS7                   (-999 -888 -666=SYSMIS).
RECODE DXCCS8                   (-999 -888 -666=SYSMIS).
RECODE DXCCS9                   (-999 -888 -666=SYSMIS).
RECODE DXCCS10                  (-999 -888 -666=SYSMIS).
RECODE DXCCS11                  (-999 -888 -666=SYSMIS).
RECODE DXCCS12                  (-999 -888 -666=SYSMIS).
RECODE DXCCS13                  (-999 -888 -666=SYSMIS).
RECODE DXCCS14                  (-999 -888 -666=SYSMIS).
RECODE DXCCS15                  (-999 -888 -666=SYSMIS).
RECODE EDEVENT                  (-9 -8 -6 -5=SYSMIS).
RECODE E_CCS1                   (-999 -888 -666=SYSMIS).
RECODE E_CCS2                   (-999 -888 -666=SYSMIS).
RECODE E_CCS3                   (-999 -888 -666=SYSMIS).
RECODE E_CCS4                   (-999 -888 -666=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE REGION                   (-9 -8 -6 -5=SYSMIS).
RECODE INTENT_S                 (-9 -8 -6 -5=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NDX                      (-99 -88 -66=SYSMIS).
RECODE NECODE                   (-99 -88 -66=SYSMIS).
RECODE NEDS_STR                 (-9999 -8888 -6666=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PAY2                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS2                 (-99 -88 -66=SYSMIS).
RECODE TOTCHGED                 (-99999999.99 -88888888.88 -66666666.66=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_Q                 (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'NEDS_2007_Core.SAV' / COMPRESSED.
