/*****************************************************************************
* SPSSload_NEDS_2006_ED.SPS
* This program will load the 2006 NEDS csv ED File into SPSS.
*****************************************************************************/

*** Read data elements from the csv file ***.
get data /type = txt
    /file = "NEDS_2006_ED.csv"
    /delimiters = ',' 
    /variables = 
    DISCWT                   F11.7
    HCUPFILE                 A4
    HOSP_ED                  F5.0
    KEY_ED                   F16.0
    CPT1                     A5
    CPT2                     A5
    CPT3                     A5
    CPT4                     A5
    CPT5                     A5
    CPT6                     A5
    CPT7                     A5
    CPT8                     A5
    CPT9                     A5
    CPT10                    A5
    CPT11                    A5
    CPT12                    A5
    CPT13                    A5
    CPT14                    A5
    CPT15                    A5
    NCPT                     F3.0
    NPR_ED                   F3.0
    PCLS_ED1                 F3.0
    PCLS_ED2                 F3.0
    PCLS_ED3                 F3.0
    PCLS_ED4                 F3.0
    PCLS_ED5                 F3.0
    PCLS_ED6                 F3.0
    PCLS_ED7                 F3.0
    PCLS_ED8                 F3.0
    PCLS_ED9                 F3.0
    PR_ED1                   A4
    PR_ED2                   A4
    PR_ED3                   A4
    PR_ED4                   A4
    PR_ED5                   A4
    PR_ED6                   A4
    PR_ED7                   A4
    PR_ED8                   A4
    PR_ED9                   A4
    PRCCSED1                 F3.0
    PRCCSED2                 F3.0
    PRCCSED3                 F3.0
    PRCCSED4                 F3.0
    PRCCSED5                 F3.0
    PRCCSED6                 F3.0
    PRCCSED7                 F3.0
    PRCCSED8                 F3.0
    PRCCSED9                 F3.0
.

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    DISCWT                   "Weight to ED Visits in AHA universe"
    HCUPFILE                 "Source of HCUP Record (SID or SEDD)"
    HOSP_ED                  "HCUP ED hospital identifier"
    KEY_ED                   "HCUP NEDS record identifier"
    CPT1                     "CPT/HCPCS procedure code 1"
    CPT2                     "CPT/HCPCS procedure code 2"
    CPT3                     "CPT/HCPCS procedure code 3"
    CPT4                     "CPT/HCPCS procedure code 4"
    CPT5                     "CPT/HCPCS procedure code 5"
    CPT6                     "CPT/HCPCS procedure code 6"
    CPT7                     "CPT/HCPCS procedure code 7"
    CPT8                     "CPT/HCPCS procedure code 8"
    CPT9                     "CPT/HCPCS procedure code 9"
    CPT10                    "CPT/HCPCS procedure code 10"
    CPT11                    "CPT/HCPCS procedure code 11"
    CPT12                    "CPT/HCPCS procedure code 12"
    CPT13                    "CPT/HCPCS procedure code 13"
    CPT14                    "CPT/HCPCS procedure code 14"
    CPT15                    "CPT/HCPCS procedure code 15"
    NCPT                     "Number of CPT/HCPCS procedures on this record"
    NPR_ED                   "Number of procedures from ED"
    PCLS_ED1                 "Principal procedure class for ED procedure"
    PCLS_ED2                 "Procedure class 2 for ED procedure"
    PCLS_ED3                 "Procedure class 3 for ED procedure"
    PCLS_ED4                 "Procedure class 4 for ED procedure"
    PCLS_ED5                 "Procedure class 5 for ED procedure"
    PCLS_ED6                 "Procedure class 6 for ED procedure"
    PCLS_ED7                 "Procedure class 7 for ED procedure"
    PCLS_ED8                 "Procedure class 8 for ED procedure"
    PCLS_ED9                 "Procedure class 9 for ED procedure"
    PR_ED1                   "Principal procedure from ED"
    PR_ED2                   "Procedure 2 from ED"
    PR_ED3                   "Procedure 3 from ED"
    PR_ED4                   "Procedure 4 from ED"
    PR_ED5                   "Procedure 5 from ED"
    PR_ED6                   "Procedure 6 from ED"
    PR_ED7                   "Procedure 7 from ED"
    PR_ED8                   "Procedure 8 from ED"
    PR_ED9                   "Procedure 9 from ED"
    PRCCSED1                 "CCS: principal procedure from ED"
    PRCCSED2                 "CCS: procedure 2 from ED"
    PRCCSED3                 "CCS: procedure 3 from ED"
    PRCCSED4                 "CCS: procedure 4 from ED"
    PRCCSED5                 "CCS: procedure 5 from ED"
    PRCCSED6                 "CCS: procedure 6 from ED"
    PRCCSED7                 "CCS: procedure 7 from ED"
    PRCCSED8                 "CCS: procedure 8 from ED"
    PRCCSED9                 "CCS: procedure 9 from ED" .

*** Convert special values to system missing values ***.
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE HOSP_ED                  (-9999 -8888 -6666=SYSMIS).
RECODE KEY_ED                   (-999999999999999 -888888888888888 -666666666666666=SYSMIS).
RECODE NCPT                     (-99 -88 -66=SYSMIS).
RECODE NPR_ED                   (-99 -88 -66=SYSMIS).
RECODE PCLS_ED1                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED2                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED3                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED4                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED5                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED6                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED7                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED8                 (-99 -88 -66=SYSMIS).
RECODE PCLS_ED9                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED1                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED2                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED3                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED4                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED5                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED6                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED7                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED8                 (-99 -88 -66=SYSMIS).
RECODE PRCCSED9                 (-99 -88 -66=SYSMIS).

SAVE OUTFILE = 'NEDS_2006_ED.SAV' / COMPRESSED.
