/*****************************************************************************
* SASload_NEDS_2007_IP.SAS
* This program will load the 2007 NEDS csv IP File into SAS.
*****************************************************************************/

*** Create SAS informats for missing values ***;
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

*** Data Step to load the file ***;
DATA NEDS_2007_IP; 
INFILE 'NEDS_2007_IP.csv' dsd dlm=',' LRECL = 193;                                                                                                                                                                                                    

*** Define data element attributes ***;
ATTRIB 
  DISCWT                     LENGTH=8
  LABEL="Weight to ED Visits in AHA universe"

  HCUPFILE                   LENGTH=$4
  LABEL="Source of HCUP Record (SID or SEDD)"

  HOSP_ED                    LENGTH=4            FORMAT=Z5.
  LABEL="HCUP ED hospital identifier"

  KEY_ED                     LENGTH=8            FORMAT=Z14.
  LABEL="HCUP NEDS record identifier"

  DISP_IP                    LENGTH=3
  LABEL="Disposition of patient (uniform) from IP"

  DRG                        LENGTH=3
  LABEL="DRG in effect on discharge date"

  DRGVER                     LENGTH=3
  LABEL="DRG grouper version used on discharge date"

  LOS_IP                     LENGTH=4
  LABEL="Length of stay (cleaned) from IP"

  MDC                        LENGTH=3
  LABEL="MDC in effect on discharge date"

  NPR_IP                     LENGTH=3
  LABEL="Number of procedures from inpatient discharge record"

  PCLASS_IP1                 LENGTH=3
  LABEL="Principal procedure class for inpatient procedure"

  PCLASS_IP2                 LENGTH=3
  LABEL="Procedure class 2 for inpatient procedure"

  PCLASS_IP3                 LENGTH=3
  LABEL="Procedure class 3 for inpatient procedure"

  PCLASS_IP4                 LENGTH=3
  LABEL="Procedure class 4 for inpatient procedure"

  PCLASS_IP5                 LENGTH=3
  LABEL="Procedure class 5 for inpatient procedure"

  PCLASS_IP6                 LENGTH=3
  LABEL="Procedure class 6 for inpatient procedure"

  PCLASS_IP7                 LENGTH=3
  LABEL="Procedure class 7 for inpatient procedure"

  PCLASS_IP8                 LENGTH=3
  LABEL="Procedure class 8 for inpatient procedure"

  PCLASS_IP9                 LENGTH=3
  LABEL="Procedure class 9 for inpatient procedure"

  PR_IP1                     LENGTH=$4
  LABEL="Principal procedure from inpatient discharge record"

  PR_IP2                     LENGTH=$4
  LABEL="Procedure 2 from inpatient discharge record"

  PR_IP3                     LENGTH=$4
  LABEL="Procedure 3 from inpatient discharge record"

  PR_IP4                     LENGTH=$4
  LABEL="Procedure 4 from inpatient discharge record"

  PR_IP5                     LENGTH=$4
  LABEL="Procedure 5 from inpatient discharge record"

  PR_IP6                     LENGTH=$4
  LABEL="Procedure 6 from inpatient discharge record"

  PR_IP7                     LENGTH=$4
  LABEL="Procedure 7 from inpatient discharge record"

  PR_IP8                     LENGTH=$4
  LABEL="Procedure 8 from inpatient discharge record"

  PR_IP9                     LENGTH=$4
  LABEL="Procedure 9 from inpatient discharge record"

  PRCCS_IP1                  LENGTH=3
  LABEL="CCS: principal procedure from inpatient discharge record"

  PRCCS_IP2                  LENGTH=3
  LABEL="CCS: procedure 2 from inpatient discharge record"

  PRCCS_IP3                  LENGTH=3
  LABEL="CCS: procedure 3 from inpatient discharge record"

  PRCCS_IP4                  LENGTH=3
  LABEL="CCS: procedure 4 from inpatient discharge record"

  PRCCS_IP5                  LENGTH=3
  LABEL="CCS: procedure 5 from inpatient discharge record"

  PRCCS_IP6                  LENGTH=3
  LABEL="CCS: procedure 6 from inpatient discharge record"

  PRCCS_IP7                  LENGTH=3
  LABEL="CCS: procedure 7 from inpatient discharge record"

  PRCCS_IP8                  LENGTH=3
  LABEL="CCS: procedure 8 from inpatient discharge record"

  PRCCS_IP9                  LENGTH=3
  LABEL="CCS: procedure 9 from inpatient discharge record"

  TOTCHG_IP                  LENGTH=6
  LABEL="Total charge for ED and inpatient services"
  ;

*** Read data elements from the CSV file ***;
INPUT 
      DISCWT                   :N11P7F.
      HCUPFILE                 :$CHAR4.
      HOSP_ED                  :5.
      KEY_ED                   :16.
      DISP_IP                  :N2PF.
      DRG                      :N3PF.
      DRGVER                   :N2PF.
      LOS_IP                   :N5PF.
      MDC                      :N2PF.
      NPR_IP                   :N3PF.
      PCLASS_IP1               :N3PF.
      PCLASS_IP2               :N3PF.
      PCLASS_IP3               :N3PF.
      PCLASS_IP4               :N3PF.
      PCLASS_IP5               :N3PF.
      PCLASS_IP6               :N3PF.
      PCLASS_IP7               :N3PF.
      PCLASS_IP8               :N3PF.
      PCLASS_IP9               :N3PF.
      PR_IP1                   :$CHAR4.
      PR_IP2                   :$CHAR4.
      PR_IP3                   :$CHAR4.
      PR_IP4                   :$CHAR4.
      PR_IP5                   :$CHAR4.
      PR_IP6                   :$CHAR4.
      PR_IP7                   :$CHAR4.
      PR_IP8                   :$CHAR4.
      PR_IP9                   :$CHAR4.
      PRCCS_IP1                :N3PF.
      PRCCS_IP2                :N3PF.
      PRCCS_IP3                :N3PF.
      PRCCS_IP4                :N3PF.
      PRCCS_IP5                :N3PF.
      PRCCS_IP6                :N3PF.
      PRCCS_IP7                :N3PF.
      PRCCS_IP8                :N3PF.
      PRCCS_IP9                :N3PF.
      TOTCHG_IP                :N12P2F.
      ;
RUN;
