/*****************************************************************************
* Stataload_NEDS_2006_Hospital.Do
* This program will load the 2006 NEDS CSV Hospital File into Stata.
* Because Stata loads the entire file into memory, it may not be possible
* to load every data element for large files.  If necessary, edit this
* program to change the memory size or to load only selected data elements.
*****************************************************************************/

*** Set available memory size ***
set mem 1100m

*** Read data elements from the csv file ***
insheet      DISCWT                              ///
             HOSPWT                              ///
             CONTROL                             ///
             HOSP_ED                             ///
             REGION                              ///
             TRAUMA                              ///
             URCAT4                              ///
             UR_TEACH                            ///
             NEDS_STR                            ///
             N_DISC_U                            ///
             N_HOSP_U                            ///
             S_DISC_U                            ///
             S_HOSP_U                            ///
             EDVISITS                            ///
             YEAR                                ///
      using  "NEDS_2006_Hospital.csv"

***  Assign labels to the data elements ***
label var discwt                   "Weight to ED Visits in AHA universe"
label var hospwt                   "Weight to hospitals in AHA universe"
label var control                  "Control/ownership of hospital"
label var hosp_ed                  "HCUP ED hospital identifier"
label var region                   "Region of hospital"
label var trauma                   "Trauma level designation"
label var urcat4                   "Hospital urban-rural designation"
label var ur_teach                 "Teaching status of hospital"
label var neds_str                 "Stratum used to sample hospital"
label var n_disc_u                 "Number of AHA universe ED visits in NEDS_STRATUM"
label var n_hosp_u                 "Number of AHA universe hospitals in NEDS_STRATUM"
label var s_disc_u                 "Number of sample discharges in NEDS_STRATUM"
label var s_hosp_u                 "Number of sample hospitals in NEDS_STRATUM"
label var edvisits                 "Total number of ED visits from this hospital in the NEDS"
label var year                     "Calendar Year"

*** Convert special values to missing values ***
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.)
recode hospwt                    (-99.9999999 -88.8888888 -66.6666666=.)
recode control                   (-9 -8 -6 -5=.)
recode hosp_ed                   (-9999 -8888 -6666=.)
recode region                    (-9 -8 -6 -5=.)
recode trauma                    (-9 -8 -6 -5=.)
recode urcat4                    (-9 -8 -6 -5=.)
recode ur_teach                  (-9 -8 -6 -5=.)
recode neds_str                  (-9999 -8888 -6666=.)
recode n_disc_u                  (-9999999 -8888888 -6666666=.)
recode n_hosp_u                  (-999 -888 -666=.)
recode s_disc_u                  (-9999999 -8888888 -6666666=.)
recode s_hosp_u                  (-99999 -88888 -66666=.)
recode edvisits                  (-9999999 -8888888 -6666666=.)
recode year                      (-999 -888 -666=.)

save "NEDS_2006_Hospital.dta", replace
