/*****************************************************************************
 * Stataload_NEDS_2015_Core.Do
 * This program will load the NEDS 2015 Core csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NEDS_2015_Core.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      int    age
      byte   amonth
      byte   aweekend
      byte   died_visit
      double discwt
      byte   disp_ed
      byte   dqtr
      byte   edevent
      byte   female
      str4   hcupfile
      long   hosp_ed
      double key_ed
      long   neds_stratum
      byte   pay1
      byte   pay2
      int    pl_nchs
      double totchg_ed
      int    year
      byte   zipinc_qrtl
using NEDS_2015_Core.csv;

/*  Assign labels to the data elements */
label var age                      "Age in years at admission" ;
label var amonth                   "Admission month" ;
label var aweekend                 "Admission day is a weekend" ;
label var died_visit               "Died in the ED (1), Died in the hospital (2), did not die (0)" ;
label var discwt                   "Weight to ED Visits in AHA universe" ;
label var disp_ed                  "Disposition of patient (uniform) from ED" ;
label var dqtr                     "Discharge quarter" ;
label var edevent                  "Type of ED Event" ;
label var female                   "Indicator of sex" ;
label var hcupfile                 "Source of HCUP Record (SID or SEDD)" ;
label var hosp_ed                  "HCUP ED hospital identifier" ;
label var key_ed                   "HCUP NEDS record identifier" ;
label var neds_stratum             "Stratum used to sample hospital" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pay2                     "Secondary expected payer (uniform)" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var totchg_ed                "Total charge for ED services" ;
label var year                     "Calendar year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode age                       (-99 -88 -66=.) ;
recode amonth                    (-9 -8 -6 -5=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode died_visit                (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode disp_ed                   (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode edevent                   (-9 -8 -6 -5=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode hosp_ed                   (-9999 -8888 -6666=.) ;
recode key_ed                    (-999999999999999 -888888888888888 -666666666666666=.) ;
recode neds_stratum              (-9999 -8888 -6666=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pay2                      (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode totchg_ed                 (-99999999.99 -88888888.88 -66666666.66=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NEDS_2015_Core.dta", replace;
#delimit cr
