/*****************************************************************************
 * Stataload_NASS_2022_Encounter.Do
 * This program will load the NASS 2022 Encounter csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NASS_2022_Encounter.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_nass
      long   key_nass
      int    age
      byte   amonth
      byte   aweekend
      str5   cpt1
      str5   cpt2
      str5   cpt3
      str5   cpt4
      str5   cpt5
      str5   cpt6
      str5   cpt7
      str5   cpt8
      str5   cpt9
      str5   cpt10
      str5   cpt11
      str5   cpt12
      str5   cpt13
      str5   cpt14
      str5   cpt15
      str5   cpt16
      str5   cpt17
      str5   cpt18
      str5   cpt19
      str5   cpt20
      str5   cpt21
      str5   cpt22
      str5   cpt23
      str5   cpt24
      str5   cpt25
      str5   cpt26
      str5   cpt27
      str5   cpt28
      str5   cpt29
      str5   cpt30
      int    cptccs1
      int    cptccs2
      int    cptccs3
      int    cptccs4
      int    cptccs5
      int    cptccs6
      int    cptccs7
      int    cptccs8
      int    cptccs9
      int    cptccs10
      int    cptccs11
      int    cptccs12
      int    cptccs13
      int    cptccs14
      int    cptccs15
      int    cptccs16
      int    cptccs17
      int    cptccs18
      int    cptccs19
      int    cptccs20
      int    cptccs21
      int    cptccs22
      int    cptccs23
      int    cptccs24
      int    cptccs25
      int    cptccs26
      int    cptccs27
      int    cptccs28
      int    cptccs29
      int    cptccs30
      double discwt
      byte   dispuniform
      byte   dqtr
      byte   female
      str7   i10_dx1
      str7   i10_dx2
      str7   i10_dx3
      str7   i10_dx4
      str7   i10_dx5
      str7   i10_dx6
      str7   i10_dx7
      str7   i10_dx8
      str7   i10_dx9
      str7   i10_dx10
      str7   i10_dx11
      str7   i10_dx12
      str7   i10_dx13
      str7   i10_dx14
      str7   i10_dx15
      str7   i10_dx16
      str7   i10_dx17
      str7   i10_dx18
      str7   i10_dx19
      str7   i10_dx20
      str7   i10_dx21
      str7   i10_dx22
      str7   i10_dx23
      str7   i10_dx24
      str7   i10_dx25
      str7   i10_dx26
      str7   i10_dx27
      str7   i10_dx28
      str7   i10_dx29
      str7   i10_dx30
      int    i10_injury
      int    i10_multinjury
      int    i10_ndx
      str2   nass_stratum
      int    ncpt_inscope
      byte   pay1
      int    pl_nchs
      byte   race
      double totchg
      int    year
      byte   zipinc_qrtl
using NASS_2022_Encounter.csv;

/*  Assign labels to the data elements */
label var hosp_nass                "NASS Hospital Number" ;
label var key_nass                 "NASS Record Number" ;
label var age                      "Age in years at admission" ;
label var amonth                   "Admission Month, 1-12" ;
label var aweekend                 "Admission day is a weekend" ;
label var cpt1                     "CPT Procedure 1" ;
label var cpt2                     "CPT Procedure 2" ;
label var cpt3                     "CPT Procedure 3" ;
label var cpt4                     "CPT Procedure 4" ;
label var cpt5                     "CPT Procedure 5" ;
label var cpt6                     "CPT Procedure 6" ;
label var cpt7                     "CPT Procedure 7" ;
label var cpt8                     "CPT Procedure 8" ;
label var cpt9                     "CPT Procedure 9" ;
label var cpt10                    "CPT Procedure 10" ;
label var cpt11                    "CPT Procedure 11" ;
label var cpt12                    "CPT Procedure 12" ;
label var cpt13                    "CPT Procedure 13" ;
label var cpt14                    "CPT Procedure 14" ;
label var cpt15                    "CPT Procedure 15" ;
label var cpt16                    "CPT Procedure 16" ;
label var cpt17                    "CPT Procedure 17" ;
label var cpt18                    "CPT Procedure 18" ;
label var cpt19                    "CPT Procedure 19" ;
label var cpt20                    "CPT Procedure 20" ;
label var cpt21                    "CPT Procedure 21" ;
label var cpt22                    "CPT Procedure 22" ;
label var cpt23                    "CPT Procedure 23" ;
label var cpt24                    "CPT Procedure 24" ;
label var cpt25                    "CPT Procedure 25" ;
label var cpt26                    "CPT Procedure 26" ;
label var cpt27                    "CPT Procedure 27" ;
label var cpt28                    "CPT Procedure 28" ;
label var cpt29                    "CPT Procedure 29" ;
label var cpt30                    "CPT Procedure 30" ;
label var cptccs1                  "CPT 1 Procedure CCS" ;
label var cptccs2                  "CPT 2 Procedure CCS" ;
label var cptccs3                  "CPT 3 Procedure CCS" ;
label var cptccs4                  "CPT 4 Procedure CCS" ;
label var cptccs5                  "CPT 5 Procedure CCS" ;
label var cptccs6                  "CPT 6 Procedure CCS" ;
label var cptccs7                  "CPT 7 Procedure CCS" ;
label var cptccs8                  "CPT 8 Procedure CCS" ;
label var cptccs9                  "CPT 9 Procedure CCS" ;
label var cptccs10                 "CPT 10 Procedure CCS" ;
label var cptccs11                 "CPT 11 Procedure CCS" ;
label var cptccs12                 "CPT 12 Procedure CCS" ;
label var cptccs13                 "CPT 13 Procedure CCS" ;
label var cptccs14                 "CPT 14 Procedure CCS" ;
label var cptccs15                 "CPT 15 Procedure CCS" ;
label var cptccs16                 "CPT 16 Procedure CCS" ;
label var cptccs17                 "CPT 17 Procedure CCS" ;
label var cptccs18                 "CPT 18 Procedure CCS" ;
label var cptccs19                 "CPT 19 Procedure CCS" ;
label var cptccs20                 "CPT 20 Procedure CCS" ;
label var cptccs21                 "CPT 21 Procedure CCS" ;
label var cptccs22                 "CPT 22 Procedure CCS" ;
label var cptccs23                 "CPT 23 Procedure CCS" ;
label var cptccs24                 "CPT 24 Procedure CCS" ;
label var cptccs25                 "CPT 25 Procedure CCS" ;
label var cptccs26                 "CPT 26 Procedure CCS" ;
label var cptccs27                 "CPT 27 Procedure CCS" ;
label var cptccs28                 "CPT 28 Procedure CCS" ;
label var cptccs29                 "CPT 29 Procedure CCS" ;
label var cptccs30                 "CPT 30 Procedure CCS" ;
label var discwt                   "Encounter Weight" ;
label var dispuniform              "Disposition of patient (uniform)" ;
label var dqtr                     "Discharge quarter" ;
label var female                   "Indicator of sex" ;
label var i10_dx1                  "ICD-10-CM Diagnosis 1" ;
label var i10_dx2                  "ICD-10-CM Diagnosis 2" ;
label var i10_dx3                  "ICD-10-CM Diagnosis 3" ;
label var i10_dx4                  "ICD-10-CM Diagnosis 4" ;
label var i10_dx5                  "ICD-10-CM Diagnosis 5" ;
label var i10_dx6                  "ICD-10-CM Diagnosis 6" ;
label var i10_dx7                  "ICD-10-CM Diagnosis 7" ;
label var i10_dx8                  "ICD-10-CM Diagnosis 8" ;
label var i10_dx9                  "ICD-10-CM Diagnosis 9" ;
label var i10_dx10                 "ICD-10-CM Diagnosis 10" ;
label var i10_dx11                 "ICD-10-CM Diagnosis 11" ;
label var i10_dx12                 "ICD-10-CM Diagnosis 12" ;
label var i10_dx13                 "ICD-10-CM Diagnosis 13" ;
label var i10_dx14                 "ICD-10-CM Diagnosis 14" ;
label var i10_dx15                 "ICD-10-CM Diagnosis 15" ;
label var i10_dx16                 "ICD-10-CM Diagnosis 16" ;
label var i10_dx17                 "ICD-10-CM Diagnosis 17" ;
label var i10_dx18                 "ICD-10-CM Diagnosis 18" ;
label var i10_dx19                 "ICD-10-CM Diagnosis 19" ;
label var i10_dx20                 "ICD-10-CM Diagnosis 20" ;
label var i10_dx21                 "ICD-10-CM Diagnosis 21" ;
label var i10_dx22                 "ICD-10-CM Diagnosis 22" ;
label var i10_dx23                 "ICD-10-CM Diagnosis 23" ;
label var i10_dx24                 "ICD-10-CM Diagnosis 24" ;
label var i10_dx25                 "ICD-10-CM Diagnosis 25" ;
label var i10_dx26                 "ICD-10-CM Diagnosis 26" ;
label var i10_dx27                 "ICD-10-CM Diagnosis 27" ;
label var i10_dx28                 "ICD-10-CM Diagnosis 28" ;
label var i10_dx29                 "ICD-10-CM Diagnosis 29" ;
label var i10_dx30                 "ICD-10-CM Diagnosis 30" ;
label var i10_injury
    "Injury ICD-10-CM diagnosis reported on record (1: First-listed injury; 2: Other than first-listed injury; 0: No injury)" ;
label var i10_multinjury           "Multiple ICD-10-CM injuries reported on record" ;
label var i10_ndx                  "ICD-10-CM Number of diagnoses on this record" ;
label var nass_stratum             "NASS Sample Stratum" ;
label var ncpt_inscope             "Number of In-Scope CPTs for this encounter" ;
label var pay1                     "Primary expected payer (uniform)" ;
label var pl_nchs                  "Patient Location: NCHS Urban-Rural Code" ;
label var race                     "Race (uniform)" ;
label var totchg                   "Total charges (cleaned)" ;
label var year                     "Data Year" ;
label var zipinc_qrtl              "Median household income national quartile for patient ZIP Code" ;

/* Convert special values to missing values */
recode hosp_nass                 (-9999 -8888 -6666=.) ;
recode key_nass                  (-9999999 -8888888 -6666666=.) ;
recode age                       (-99 -88 -66=.) ;
recode amonth                    (-9 -8 -6 -5=.) ;
recode aweekend                  (-9 -8 -6 -5=.) ;
recode cptccs1                   (-999 -888 -666=.) ;
recode cptccs2                   (-999 -888 -666=.) ;
recode cptccs3                   (-999 -888 -666=.) ;
recode cptccs4                   (-999 -888 -666=.) ;
recode cptccs5                   (-999 -888 -666=.) ;
recode cptccs6                   (-999 -888 -666=.) ;
recode cptccs7                   (-999 -888 -666=.) ;
recode cptccs8                   (-999 -888 -666=.) ;
recode cptccs9                   (-999 -888 -666=.) ;
recode cptccs10                  (-999 -888 -666=.) ;
recode cptccs11                  (-999 -888 -666=.) ;
recode cptccs12                  (-999 -888 -666=.) ;
recode cptccs13                  (-999 -888 -666=.) ;
recode cptccs14                  (-999 -888 -666=.) ;
recode cptccs15                  (-999 -888 -666=.) ;
recode cptccs16                  (-999 -888 -666=.) ;
recode cptccs17                  (-999 -888 -666=.) ;
recode cptccs18                  (-999 -888 -666=.) ;
recode cptccs19                  (-999 -888 -666=.) ;
recode cptccs20                  (-999 -888 -666=.) ;
recode cptccs21                  (-999 -888 -666=.) ;
recode cptccs22                  (-999 -888 -666=.) ;
recode cptccs23                  (-999 -888 -666=.) ;
recode cptccs24                  (-999 -888 -666=.) ;
recode cptccs25                  (-999 -888 -666=.) ;
recode cptccs26                  (-999 -888 -666=.) ;
recode cptccs27                  (-999 -888 -666=.) ;
recode cptccs28                  (-999 -888 -666=.) ;
recode cptccs29                  (-999 -888 -666=.) ;
recode cptccs30                  (-999 -888 -666=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode dispuniform               (-9 -8 -6 -5=.) ;
recode dqtr                      (-9 -8 -6 -5=.) ;
recode female                    (-9 -8 -6 -5=.) ;
recode i10_injury                (-99 -88 -66=.) ;
recode i10_multinjury            (-99 -88 -66=.) ;
recode i10_ndx                   (-99 -88 -66=.) ;
recode ncpt_inscope              (-99 -88 -66=.) ;
recode pay1                      (-9 -8 -6 -5=.) ;
recode pl_nchs                   (-99 -88 -66=.) ;
recode race                      (-9 -8 -6 -5=.) ;
recode totchg                    (-999999999 -888888888 -666666666=.) ;
recode year                      (-999 -888 -666=.) ;
recode zipinc_qrtl               (-9 -8 -6 -5=.) ;

describe;

save "NASS_2022_Encounter.dta", replace;
#delimit cr
