/*****************************************************************************
 * Stataload_NASS_2021_Hospital.Do
 * This program will load the NASS 2021 Hospital csv File into Stata.
 * Because Stata loads the entire file into memory, it may not be possible
 * to load every data element for large files.  If necessary, edit this
 * program to change the memory size or to load only selected data elements.
 * The Stata INFILE command with the _SKIP option is used to select a subset of variables.
 * _skip (N) tells Stata to skip the next consecutive N variables.
 * Also can use "in" option after "using NASS_2021_Hospital.csv" to read subset of the data.
 *****************************************************************************/

#delimit ;

/* Set available memory size */
set mem 1400m;

/* Read data elements from the csv file */
infile
      long   hosp_nass
      byte   hosp_location
      byte   hosp_locteach
      byte   hosp_region
      byte   hosp_bedsize_cat
      double discwt
      str2   nass_stratum
      long   n_disc_u
      int    n_hosp_u
      long   s_disc_u
      int    s_hosp_u
      long   total_as_encounters
      int    year
using NASS_2021_Hospital.csv;

/*  Assign labels to the data elements */
label var hosp_nass                "NASS Hospital Number" ;
label var hosp_location            "AHA: Location of Hospital, 0:rural, 1:urban" ;
label var hosp_locteach            "NASS: Location/teaching status of hospital" ;
label var hosp_region              "Hospital Census Region, 1:Northeast, 2:Midwest, 3:South, 4:West" ;
label var hosp_bedsize_cat         "Hospital Beds 1:0-99 2:100-299 3:300+" ;
label var discwt                   "Encounter Weight" ;
label var nass_stratum             "NASS sample stratum" ;
label var n_disc_u                 "Total Number of AS Encounters for all Hospitals in NASS_STRATUM" ;
label var n_hosp_u                 "Total Number of Hospitals in NASS_STRATUM" ;
label var s_disc_u                 "Total Number of AS Encounters for Sampled Hospitals in NASS_STRATUM" ;
label var s_hosp_u                 "Total Number of Sampled Hospitals in NASS_STRATUM" ;
label var total_as_encounters      "SASD encounters with >= 1 narrow surgery" ;
label var year                     "Data Year" ;

/* Convert special values to missing values */
recode hosp_nass                 (-9999 -8888 -6666=.) ;
recode hosp_location             (-9 -8 -6 -5=.) ;
recode hosp_locteach             (-9 -8 -6 -5=.) ;
recode hosp_region               (-9 -8 -6 -5=.) ;
recode hosp_bedsize_cat          (-9 -8 -6 -5=.) ;
recode discwt                    (-99.9999999 -88.8888888 -66.6666666=.) ;
recode n_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode n_hosp_u                  (-999 -888 -666=.) ;
recode s_disc_u                  (-9999999 -8888888 -6666666=.) ;
recode s_hosp_u                  (-999 -888 -666=.) ;
recode total_as_encounters       (-9999999 -8888888 -6666666=.) ;
recode year                      (-999 -888 -666=.) ;

describe;

save "NASS_2021_Hospital.dta", replace;
#delimit cr
