/*****************************************************************************
 * SASload_NASS_2016_Encounter.SAS
 * This program will load the NASS 2016 Encounter csv File into SAS.
 *****************************************************************************/

/* Create SAS informats for missing values */
PROC FORMAT;
  INVALUE N2PF
    '-9' = .
    '-8' = .A
    '-6' = .C
    '-5' = .N
    OTHER = (|2.|)
  ;
  INVALUE N3PF
    '-99' = .
    '-88' = .A
    '-66' = .C
    OTHER = (|3.|)
  ;
  INVALUE N4PF
    '-999' = .
    '-888' = .A
    '-666' = .C
    OTHER = (|4.|)
  ;
  INVALUE N4P1F
    '-9.9' = .
    '-8.8' = .A
    '-6.6' = .C
    OTHER = (|4.1|)
  ;
  INVALUE N5PF
    '-9999' = .
    '-8888' = .A
    '-6666' = .C
    OTHER = (|5.|)
  ;
  INVALUE N5P2F
    '-9.99' = .
    '-8.88' = .A
    '-6.66' = .C
    OTHER = (|5.2|)
  ;
  INVALUE N6PF
    '-99999' = .
    '-88888' = .A
    '-66666' = .C
    OTHER = (|6.|)
  ;
  INVALUE N6P2F
    '-99.99' = .
    '-88.88' = .A
    '-66.66' = .C
    OTHER = (|6.2|)
  ;
  INVALUE N7P2F
    '-999.99' = .
    '-888.88' = .A
    '-666.66' = .C
    OTHER = (|7.2|)
  ;
  INVALUE N8PF
    '-9999999' = .
    '-8888888' = .A
    '-6666666' = .C
    OTHER = (|8.|)
  ;
  INVALUE N8P2F
    '-9999.99' = .
    '-8888.88' = .A
    '-6666.66' = .C
    OTHER = (|8.2|)
  ;
  INVALUE N8P4F
    '-99.9999' = .
    '-88.8888' = .A
    '-66.6666' = .C
    OTHER = (|8.4|)
  ;
  INVALUE N10PF
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|10.|)
  ;
  INVALUE N10P4F
    '-9999.9999' = .
    '-8888.8888' = .A
    '-6666.6666' = .C
    OTHER = (|10.4|)
  ;
  INVALUE N10P5F
    '-999.99999' = .
    '-888.88888' = .A
    '-666.66666' = .C
    OTHER = (|10.5|)
  ;
  INVALUE DATE10F
    '-999999999' = .
    '-888888888' = .A
    '-666666666' = .C
    OTHER = (|MMDDYY10.|)
  ;
  INVALUE N11P7F
    '-99.9999999' = .
    '-88.8888888' = .A
    '-66.6666666' = .C
    OTHER = (|11.7|)
  ;
  INVALUE N12P2F
    '-99999999.99' = .
    '-88888888.88' = .A
    '-66666666.66' = .C
    OTHER = (|12.2|)
  ;
  INVALUE N12P5F
    '-99999.99999' = .
    '-88888.88888' = .A
    '-66666.66666' = .C
    OTHER = (|12.5|)
  ;
  INVALUE N13PF
    '-999999999999' = .
    '-888888888888' = .A
    '-666666666666' = .C
    OTHER = (|13.|)
  ;
  INVALUE N15P2F
    '-99999999999.99' = .
    '-88888888888.88' = .A
    '-66666666666.66' = .C
    OTHER = (|15.2|)
  ;
RUN;

/* Data Step to load the file */
DATA Encounter; 
INFILE 'Encounter.csv' dsd dlm=',' LRECL = 590;

/* Define data element attributes */
ATTRIB 
  HOSP_NASS                  LENGTH=4
  LABEL="NASS Hospital Number"

  KEY_NASS                   LENGTH=5            FORMAT=8.
  LABEL="NASS record number"

  DISCWT                     LENGTH=8
  LABEL="Encounter Weight"

  AGE                        LENGTH=3
  LABEL="Age in years at admission"

  FEMALE                     LENGTH=3
  LABEL="Indicator of sex"

  PL_NCHS                    LENGTH=3
  LABEL="Patient Location: NCHS Urban-Rural Code"

  ZIPINC_QRTL                LENGTH=3
  LABEL="Median household income national quartile for patient ZIP Code"

  AMONTH                     LENGTH=3
  LABEL="Admission Month, 1-12"

  AWEEKEND                   LENGTH=3
  LABEL="Admission day is a weekend"

  DQTR                       LENGTH=3
  LABEL="Discharge quarter"

  PAY1                       LENGTH=3
  LABEL="Primary expected payer (uniform)"

  DISPUNIFORM                LENGTH=3
  LABEL="Disposition of patient (uniform)"

  TOTCHG                     LENGTH=6
  LABEL="Total charges (cleaned)"

  YEAR                       LENGTH=8
  LABEL="Data Year"

  NCPT_INSCOPE               LENGTH=8
  LABEL="# In-scope CPTs for this encounter"

  CPTCCS1                    LENGTH=4
  LABEL="CPT 1 Procedure CCS"

  CPTCCS2                    LENGTH=4
  LABEL="CPT 2 Procedure CCS"

  CPTCCS3                    LENGTH=4
  LABEL="CPT 3 Procedure CCS"

  CPTCCS4                    LENGTH=4
  LABEL="CPT 4 Procedure CCS"

  CPTCCS5                    LENGTH=4
  LABEL="CPT 5 Procedure CCS"

  CPTCCS6                    LENGTH=4
  LABEL="CPT 6 Procedure CCS"

  CPTCCS7                    LENGTH=4
  LABEL="CPT 7 Procedure CCS"

  CPTCCS8                    LENGTH=4
  LABEL="CPT 8 Procedure CCS"

  CPTCCS9                    LENGTH=4
  LABEL="CPT 9 Procedure CCS"

  CPTCCS10                   LENGTH=4
  LABEL="CPT 10 Procedure CCS"

  CPTCCS11                   LENGTH=4
  LABEL="CPT 11 Procedure CCS"

  CPTCCS12                   LENGTH=4
  LABEL="CPT 12 Procedure CCS"

  CPTCCS13                   LENGTH=4
  LABEL="CPT 13 Procedure CCS"

  CPTCCS14                   LENGTH=4
  LABEL="CPT 14 Procedure CCS"

  CPTCCS15                   LENGTH=4
  LABEL="CPT 15 Procedure CCS"

  CPTCCS16                   LENGTH=4
  LABEL="CPT 16 Procedure CCS"

  CPTCCS17                   LENGTH=4
  LABEL="CPT 17 Procedure CCS"

  CPTCCS18                   LENGTH=4
  LABEL="CPT 18 Procedure CCS"

  CPTCCS19                   LENGTH=4
  LABEL="CPT 19 Procedure CCS"

  CPTCCS20                   LENGTH=4
  LABEL="CPT 20 Procedure CCS"

  CPTCCS21                   LENGTH=4
  LABEL="CPT 21 Procedure CCS"

  CPTCCS22                   LENGTH=4
  LABEL="CPT 22 Procedure CCS"

  CPTCCS23                   LENGTH=4
  LABEL="CPT 23 Procedure CCS"

  CPTCCS24                   LENGTH=4
  LABEL="CPT 24 Procedure CCS"

  CPTCCS25                   LENGTH=4
  LABEL="CPT 25 Procedure CCS"

  CPTCCS26                   LENGTH=4
  LABEL="CPT 26 Procedure CCS"

  CPTCCS27                   LENGTH=4
  LABEL="CPT 27 Procedure CCS"

  CPTCCS28                   LENGTH=4
  LABEL="CPT 28 Procedure CCS"

  CPTCCS29                   LENGTH=4
  LABEL="CPT 29 Procedure CCS"

  CPTCCS30                   LENGTH=4
  LABEL="CPT 30 Procedure CCS"

  CPT1                       LENGTH=$7
  LABEL="CPT Procedure 1"

  CPT2                       LENGTH=$7
  LABEL="CPT Procedure 2"

  CPT3                       LENGTH=$7
  LABEL="CPT Procedure 3"

  CPT4                       LENGTH=$7
  LABEL="CPT Procedure 4"

  CPT5                       LENGTH=$7
  LABEL="CPT Procedure 5"

  CPT6                       LENGTH=$7
  LABEL="CPT Procedure 6"

  CPT7                       LENGTH=$7
  LABEL="CPT Procedure 7"

  CPT8                       LENGTH=$7
  LABEL="CPT Procedure 8"

  CPT9                       LENGTH=$7
  LABEL="CPT Procedure 9"

  CPT10                      LENGTH=$7
  LABEL="CPT Procedure 10"

  CPT11                      LENGTH=$7
  LABEL="CPT Procedure 11"

  CPT12                      LENGTH=$7
  LABEL="CPT Procedure 12"

  CPT13                      LENGTH=$7
  LABEL="CPT Procedure 13"

  CPT14                      LENGTH=$7
  LABEL="CPT Procedure 14"

  CPT15                      LENGTH=$7
  LABEL="CPT Procedure 15"

  CPT16                      LENGTH=$7
  LABEL="CPT Procedure 16"

  CPT17                      LENGTH=$7
  LABEL="CPT Procedure 17"

  CPT18                      LENGTH=$7
  LABEL="CPT Procedure 18"

  CPT19                      LENGTH=$7
  LABEL="CPT Procedure 19"

  CPT20                      LENGTH=$7
  LABEL="CPT Procedure 20"

  CPT21                      LENGTH=$7
  LABEL="CPT Procedure 21"

  CPT22                      LENGTH=$7
  LABEL="CPT Procedure 22"

  CPT23                      LENGTH=$7
  LABEL="CPT Procedure 23"

  CPT24                      LENGTH=$7
  LABEL="CPT Procedure 24"

  CPT25                      LENGTH=$7
  LABEL="CPT Procedure 25"

  CPT26                      LENGTH=$7
  LABEL="CPT Procedure 26"

  CPT27                      LENGTH=$7
  LABEL="CPT Procedure 27"

  CPT28                      LENGTH=$7
  LABEL="CPT Procedure 28"

  CPT29                      LENGTH=$7
  LABEL="CPT Procedure 29"

  CPT30                      LENGTH=$7
  LABEL="CPT Procedure 30"

  I10_NDX                    LENGTH=3
  LABEL="ICD-10-CM Number of diagnoses on this record"

  I10_DX1                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 1"

  I10_DX2                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 2"

  I10_DX3                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 3"

  I10_DX4                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 4"

  I10_DX5                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 5"

  I10_DX6                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 6"

  I10_DX7                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 7"

  I10_DX8                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 8"

  I10_DX9                    LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 9"

  I10_DX10                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 10"

  I10_DX11                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 11"

  I10_DX12                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 12"

  I10_DX13                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 13"

  I10_DX14                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 14"

  I10_DX15                   LENGTH=$7
  LABEL="ICD-10-CM Diagnosis 15"
  ;

/* Read data elements from the CSV file */
INPUT 
      HOSP_NASS                :N5PF.
      KEY_NASS                 :N8PF.
      DISCWT                   :N11P7F.
      AGE                      :N3PF.
      FEMALE                   :N2PF.
      PL_NCHS                  :N3PF.
      ZIPINC_QRTL              :N2PF.
      AMONTH                   :N2PF.
      AWEEKEND                 :N2PF.
      DQTR                     :N2PF.
      PAY1                     :N2PF.
      DISPUNIFORM              :N2PF.
      TOTCHG                   :N10PF.
      YEAR                     :N4PF.
      NCPT_INSCOPE             :N3PF.
      CPTCCS1                  :N4PF.
      CPTCCS2                  :N4PF.
      CPTCCS3                  :N4PF.
      CPTCCS4                  :N4PF.
      CPTCCS5                  :N4PF.
      CPTCCS6                  :N4PF.
      CPTCCS7                  :N4PF.
      CPTCCS8                  :N4PF.
      CPTCCS9                  :N4PF.
      CPTCCS10                 :N4PF.
      CPTCCS11                 :N4PF.
      CPTCCS12                 :N4PF.
      CPTCCS13                 :N4PF.
      CPTCCS14                 :N4PF.
      CPTCCS15                 :N4PF.
      CPTCCS16                 :N4PF.
      CPTCCS17                 :N4PF.
      CPTCCS18                 :N4PF.
      CPTCCS19                 :N4PF.
      CPTCCS20                 :N4PF.
      CPTCCS21                 :N4PF.
      CPTCCS22                 :N4PF.
      CPTCCS23                 :N4PF.
      CPTCCS24                 :N4PF.
      CPTCCS25                 :N4PF.
      CPTCCS26                 :N4PF.
      CPTCCS27                 :N4PF.
      CPTCCS28                 :N4PF.
      CPTCCS29                 :N4PF.
      CPTCCS30                 :N4PF.
      CPT1                     :$CHAR7.
      CPT2                     :$CHAR7.
      CPT3                     :$CHAR7.
      CPT4                     :$CHAR7.
      CPT5                     :$CHAR7.
      CPT6                     :$CHAR7.
      CPT7                     :$CHAR7.
      CPT8                     :$CHAR7.
      CPT9                     :$CHAR7.
      CPT10                    :$CHAR7.
      CPT11                    :$CHAR7.
      CPT12                    :$CHAR7.
      CPT13                    :$CHAR7.
      CPT14                    :$CHAR7.
      CPT15                    :$CHAR7.
      CPT16                    :$CHAR7.
      CPT17                    :$CHAR7.
      CPT18                    :$CHAR7.
      CPT19                    :$CHAR7.
      CPT20                    :$CHAR7.
      CPT21                    :$CHAR7.
      CPT22                    :$CHAR7.
      CPT23                    :$CHAR7.
      CPT24                    :$CHAR7.
      CPT25                    :$CHAR7.
      CPT26                    :$CHAR7.
      CPT27                    :$CHAR7.
      CPT28                    :$CHAR7.
      CPT29                    :$CHAR7.
      CPT30                    :$CHAR7.
      I10_NDX                  :N3PF.
      I10_DX1                  :$CHAR7.
      I10_DX2                  :$CHAR7.
      I10_DX3                  :$CHAR7.
      I10_DX4                  :$CHAR7.
      I10_DX5                  :$CHAR7.
      I10_DX6                  :$CHAR7.
      I10_DX7                  :$CHAR7.
      I10_DX8                  :$CHAR7.
      I10_DX9                  :$CHAR7.
      I10_DX10                 :$CHAR7.
      I10_DX11                 :$CHAR7.
      I10_DX12                 :$CHAR7.
      I10_DX13                 :$CHAR7.
      I10_DX14                 :$CHAR7.
      I10_DX15                 :$CHAR7.
      ;
RUN;
