/*****************************************************************************
* SPSSload_KID_2022_Hospital.SPS
* This program will load the KID_2022_Hospital ASCII File into SPSS.
* Created on 11/07/2024.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2022_Hospital.ASC' FIXED / 
    HOSP_KID                    1-   5
    N_BRTH_U                    6-  13
    N_DISC_U                   14-  21
    N_HOSP_U                   22-  25
    S_BRTH_U                   26-  33
    S_CHLD_U                   34-  41
    S_CMPB_U                   42-  49
    S_DISC_U                   50-  57
    S_HOSP_U                   58-  61
    S_UNCB_U                   62-  69
    HOSP_LOCTEACH              70-  71
    H_CONTRL                   72-  73
    HOSP_REGION                74-  75
    KID_STRATUM                76-  79
    YEAR                       80-  83
    HOSP_BEDSIZE               84-  85.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    N_BRTH_U                 (F8.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_BRTH_U                 (F8.0) /
    S_CHLD_U                 (F8.0) /
    S_CMPB_U                 (F8.0) /
    S_DISC_U                 (F8.0) /
    S_HOSP_U                 (F4.0) /
    S_UNCB_U                 (F8.0) /
    HOSP_LOCTEACH            (F2.0) /
    H_CONTRL                 (F2.0) /
    HOSP_REGION              (F2.0) /
    KID_STRATUM              (F4.0) /
    YEAR                     (F4.0) /
    HOSP_BEDSIZE             (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    N_BRTH_U                 "Number of universe births in the stratum"
    N_DISC_U                 "Number of universe discharges in the stratum"
    N_HOSP_U                 "Number of universe hospitals in the stratum"
    S_BRTH_U                 "Number of sample births in the stratum"
    S_CHLD_U                 "Number of sample pediatric non-births in the stratum"
    S_CMPB_U                 "Number of sample other newborns in the stratum"
    S_DISC_U                 "Number of sample newborns and children in the stratum"
    S_HOSP_U                 "Number of sample hospitals in the stratum"
    S_UNCB_U                 "Number of sample normal newborns in the stratum"
    HOSP_LOCTEACH            "Location/teaching status of hospital"
    H_CONTRL                 "Control/ownership of hospital"
    HOSP_REGION              "Region of hospital"
    KID_STRATUM              "KID hospital stratum"
    YEAR                     "Calendar year"
    HOSP_BEDSIZE             "Bedsize of hospital" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE N_BRTH_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_BRTH_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_CHLD_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_CMPB_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_UNCB_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2022_Hospital.SAV' / COMPRESSED.
