/*****************************************************************************
* SPSSload_KID_2016_Core.SPS
* This program will load the KID_2016_Core ASCII File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2016_Core.ASC' FIXED / 
    HOSP_KID                   1-  5
    RECNUM                     6- 13
    AGE                       14- 16
    AGE_NEONATE               17- 18
    AMONTH                    19- 20
    AWEEKEND                  21- 22
    DIED                      23- 24
    DISCWT                    25- 35
    DISPUNIFORM               36- 37
    DQTR                      38- 39
    DRG                       40- 42
    DRGVER                    43- 44
    DRG_NoPOA                 45- 47
    DXVER                     48- 49
    ELECTIVE                  50- 51
    FEMALE                    52- 53
    HCUP_ED                   54- 56
    HOSP_REGION               57- 58
    I10_DX1                   59- 65 (A)
    I10_DX2                   66- 72 (A)
    I10_DX3                   73- 79 (A)
    I10_DX4                   80- 86 (A)
    I10_DX5                   87- 93 (A)
    I10_DX6                   94-100 (A)
    I10_DX7                  101-107 (A)
    I10_DX8                  108-114 (A)
    I10_DX9                  115-121 (A)
    I10_DX10                 122-128 (A)
    I10_DX11                 129-135 (A)
    I10_DX12                 136-142 (A)
    I10_DX13                 143-149 (A)
    I10_DX14                 150-156 (A)
    I10_DX15                 157-163 (A)
    I10_DX16                 164-170 (A)
    I10_DX17                 171-177 (A)
    I10_DX18                 178-184 (A)
    I10_DX19                 185-191 (A)
    I10_DX20                 192-198 (A)
    I10_DX21                 199-205 (A)
    I10_DX22                 206-212 (A)
    I10_DX23                 213-219 (A)
    I10_DX24                 220-226 (A)
    I10_DX25                 227-233 (A)
    I10_DX26                 234-240 (A)
    I10_DX27                 241-247 (A)
    I10_DX28                 248-254 (A)
    I10_DX29                 255-261 (A)
    I10_DX30                 262-268 (A)
    I10_ECAUSE1              269-275 (A)
    I10_ECAUSE2              276-282 (A)
    I10_ECAUSE3              283-289 (A)
    I10_ECAUSE4              290-296 (A)
    I10_HOSPBRTH             297-298
    I10_NDX                  299-300
    I10_NECAUSE              301-303
    I10_NPR                  304-305
    I10_PR1                  306-312 (A)
    I10_PR2                  313-319 (A)
    I10_PR3                  320-326 (A)
    I10_PR4                  327-333 (A)
    I10_PR5                  334-340 (A)
    I10_PR6                  341-347 (A)
    I10_PR7                  348-354 (A)
    I10_PR8                  355-361 (A)
    I10_PR9                  362-368 (A)
    I10_PR10                 369-375 (A)
    I10_PR11                 376-382 (A)
    I10_PR12                 383-389 (A)
    I10_PR13                 390-396 (A)
    I10_PR14                 397-403 (A)
    I10_PR15                 404-410 (A)
    I10_UNCBRTH              411-412
    KID_STRATUM              413-416
    LOS                      417-421
    MDC                      422-423
    MDC_NoPOA                424-425
    PAY1                     426-427
    PL_NCHS                  428-430
    PRDAY1                   431-433
    PRDAY2                   434-436
    PRDAY3                   437-439
    PRDAY4                   440-442
    PRDAY5                   443-445
    PRDAY6                   446-448
    PRDAY7                   449-451
    PRDAY8                   452-454
    PRDAY9                   455-457
    PRDAY10                  458-460
    PRDAY11                  461-463
    PRDAY12                  464-466
    PRDAY13                  467-469
    PRDAY14                  470-472
    PRDAY15                  473-475
    PRVER                    476-477
    RACE                     478-479
    TOTCHG                   480-489
    TRAN_IN                  490-491
    TRAN_OUT                 492-493
    YEAR                     494-497
    ZIPINC_QRTL              498-499.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    RECNUM                   (F8.0) /
    AGE                      (F3.0) /
    AGE_NEONATE              (F2.0) /
    AMONTH                   (F2.0) /
    AWEEKEND                 (F2.0) /
    DIED                     (F2.0) /
    DISCWT                   (F11.7) /
    DISPUNIFORM              (F2.0) /
    DQTR                     (F2.0) /
    DRG                      (F3.0) /
    DRGVER                   (F2.0) /
    DRG_NoPOA                (F3.0) /
    DXVER                    (F2.0) /
    ELECTIVE                 (F2.0) /
    FEMALE                   (F2.0) /
    HCUP_ED                  (F3.0) /
    HOSP_REGION              (F2.0) /
    I10_HOSPBRTH             (F2.0) /
    I10_NDX                  (F2.0) /
    I10_NECAUSE              (F3.0) /
    I10_NPR                  (F2.0) /
    I10_UNCBRTH              (F2.0) /
    KID_STRATUM              (F4.0) /
    LOS                      (F5.0) /
    MDC                      (F2.0) /
    MDC_NoPOA                (F2.0) /
    PAY1                     (F2.0) /
    PL_NCHS                  (F3.0) /
    PRDAY1                   (F3.0) /
    PRDAY2                   (F3.0) /
    PRDAY3                   (F3.0) /
    PRDAY4                   (F3.0) /
    PRDAY5                   (F3.0) /
    PRDAY6                   (F3.0) /
    PRDAY7                   (F3.0) /
    PRDAY8                   (F3.0) /
    PRDAY9                   (F3.0) /
    PRDAY10                  (F3.0) /
    PRDAY11                  (F3.0) /
    PRDAY12                  (F3.0) /
    PRDAY13                  (F3.0) /
    PRDAY14                  (F3.0) /
    PRDAY15                  (F3.0) /
    PRVER                    (F2.0) /
    RACE                     (F2.0) /
    TOTCHG                   (F10.0) /
    TRAN_IN                  (F2.0) /
    TRAN_OUT                 (F2.0) /
    YEAR                     (F4.0) /
    ZIPINC_QRTL              (F2.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    RECNUM                   "KID record number"
    AGE                      "Age in years at admission"
    AGE_NEONATE              "Neonatal age (first 28 days after birth) indicator"
    AMONTH                   "Admission month"
    AWEEKEND                 "Admission day is a weekend"
    DIED                     "Died during hospitalization"
    DISCWT                   "KID discharge weight"
    DISPUNIFORM              "Disposition of patient (uniform)"
    DQTR                     "Discharge quarter"
    DRG                      "DRG in effect on discharge date"
    DRGVER                   "DRG grouper version used on discharge date"
    DRG_NoPOA                "DRG in use on discharge date, calculated without POA"
    DXVER                    "Diagnosis Version"
    ELECTIVE                 "Elective versus non-elective admission"
    FEMALE                   "Indicator of sex"
    HCUP_ED                  "HCUP Emergency Department service indicator"
    HOSP_REGION              "Region of hospital"
    I10_DX1                  "ICD-10-CM Diagnosis 1"
    I10_DX2                  "ICD-10-CM Diagnosis 2"
    I10_DX3                  "ICD-10-CM Diagnosis 3"
    I10_DX4                  "ICD-10-CM Diagnosis 4"
    I10_DX5                  "ICD-10-CM Diagnosis 5"
    I10_DX6                  "ICD-10-CM Diagnosis 6"
    I10_DX7                  "ICD-10-CM Diagnosis 7"
    I10_DX8                  "ICD-10-CM Diagnosis 8"
    I10_DX9                  "ICD-10-CM Diagnosis 9"
    I10_DX10                 "ICD-10-CM Diagnosis 10"
    I10_DX11                 "ICD-10-CM Diagnosis 11"
    I10_DX12                 "ICD-10-CM Diagnosis 12"
    I10_DX13                 "ICD-10-CM Diagnosis 13"
    I10_DX14                 "ICD-10-CM Diagnosis 14"
    I10_DX15                 "ICD-10-CM Diagnosis 15"
    I10_DX16                 "ICD-10-CM Diagnosis 16"
    I10_DX17                 "ICD-10-CM Diagnosis 17"
    I10_DX18                 "ICD-10-CM Diagnosis 18"
    I10_DX19                 "ICD-10-CM Diagnosis 19"
    I10_DX20                 "ICD-10-CM Diagnosis 20"
    I10_DX21                 "ICD-10-CM Diagnosis 21"
    I10_DX22                 "ICD-10-CM Diagnosis 22"
    I10_DX23                 "ICD-10-CM Diagnosis 23"
    I10_DX24                 "ICD-10-CM Diagnosis 24"
    I10_DX25                 "ICD-10-CM Diagnosis 25"
    I10_DX26                 "ICD-10-CM Diagnosis 26"
    I10_DX27                 "ICD-10-CM Diagnosis 27"
    I10_DX28                 "ICD-10-CM Diagnosis 28"
    I10_DX29                 "ICD-10-CM Diagnosis 29"
    I10_DX30                 "ICD-10-CM Diagnosis 30"
    I10_ECAUSE1              "ICD-10-CM External cause 1"
    I10_ECAUSE2              "ICD-10-CM External cause 2"
    I10_ECAUSE3              "ICD-10-CM External cause 3"
    I10_ECAUSE4              "ICD-10-CM External cause 4"
    I10_HOSPBRTH             "ICD-10-CM Indicator of birth in this hospital"
    I10_NDX                  "ICD-10-CM Number of diagnoses on this record"
    I10_NECAUSE              "ICD-10-CM Number of External cause codes on this record"
    I10_NPR                  "ICD-10-PCS Number of procedures on this record"
    I10_PR1                  "ICD-10-PCS Procedure 1"
    I10_PR2                  "ICD-10-PCS Procedure 2"
    I10_PR3                  "ICD-10-PCS Procedure 3"
    I10_PR4                  "ICD-10-PCS Procedure 4"
    I10_PR5                  "ICD-10-PCS Procedure 5"
    I10_PR6                  "ICD-10-PCS Procedure 6"
    I10_PR7                  "ICD-10-PCS Procedure 7"
    I10_PR8                  "ICD-10-PCS Procedure 8"
    I10_PR9                  "ICD-10-PCS Procedure 9"
    I10_PR10                 "ICD-10-PCS Procedure 10"
    I10_PR11                 "ICD-10-PCS Procedure 11"
    I10_PR12                 "ICD-10-PCS Procedure 12"
    I10_PR13                 "ICD-10-PCS Procedure 13"
    I10_PR14                 "ICD-10-PCS Procedure 14"
    I10_PR15                 "ICD-10-PCS Procedure 15"
    I10_UNCBRTH              "Normal uncomplicated birth in hospital"
    KID_STRATUM              "Stratum used to sample hospital"
    LOS                      "Length of stay (cleaned)"
    MDC                      "MDC in effect on discharge date"
    MDC_NoPOA                "MDC in use on discharge date, calculated without POA"
    PAY1                     "Primary expected payer (uniform)"
    PL_NCHS                  "Patient Location: NCHS Urban-Rural Code"
    PRDAY1                   "Number of days from admission to I10_PR1"
    PRDAY2                   "Number of days from admission to I10_PR2"
    PRDAY3                   "Number of days from admission to I10_PR3"
    PRDAY4                   "Number of days from admission to I10_PR4"
    PRDAY5                   "Number of days from admission to I10_PR5"
    PRDAY6                   "Number of days from admission to I10_PR6"
    PRDAY7                   "Number of days from admission to I10_PR7"
    PRDAY8                   "Number of days from admission to I10_PR8"
    PRDAY9                   "Number of days from admission to I10_PR9"
    PRDAY10                  "Number of days from admission to I10_PR10"
    PRDAY11                  "Number of days from admission to I10_PR11"
    PRDAY12                  "Number of days from admission to I10_PR12"
    PRDAY13                  "Number of days from admission to I10_PR13"
    PRDAY14                  "Number of days from admission to I10_PR14"
    PRDAY15                  "Number of days from admission to I10_PR15"
    PRVER                    "Procedure Version"
    RACE                     "Race (uniform)"
    TOTCHG                   "Total charges (cleaned)"
    TRAN_IN                  "Transfer in indicator"
    TRAN_OUT                 "Transfer out indicator"
    YEAR                     "Calendar year"
    ZIPINC_QRTL              "Median household income national quartile for patient ZIP Code" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE RECNUM                   (-9999999 -8888888 -6666666=SYSMIS).
RECODE AGE                      (-99 -88 -66=SYSMIS).
RECODE AGE_NEONATE              (-9 -8 -6 -5=SYSMIS).
RECODE AMONTH                   (-9 -8 -6 -5=SYSMIS).
RECODE AWEEKEND                 (-9 -8 -6 -5=SYSMIS).
RECODE DIED                     (-9 -8 -6 -5=SYSMIS).
RECODE DISCWT                   (-99.9999999 -88.8888888 -66.6666666=SYSMIS).
RECODE DISPUNIFORM              (-9 -8 -6 -5=SYSMIS).
RECODE DQTR                     (-9 -8 -6 -5=SYSMIS).
RECODE DRG                      (-99 -88 -66=SYSMIS).
RECODE DRGVER                   (-9 -8 -6 -5=SYSMIS).
RECODE DRG_NoPOA                (-99 -88 -66=SYSMIS).
RECODE DXVER                    (-9 -8 -6 -5=SYSMIS).
RECODE ELECTIVE                 (-9 -8 -6 -5=SYSMIS).
RECODE FEMALE                   (-9 -8 -6 -5=SYSMIS).
RECODE HCUP_ED                  (-99 -88 -66=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE I10_HOSPBRTH             (-9 -8 -6 -5=SYSMIS).
RECODE I10_NDX                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_NECAUSE              (-99 -88 -66=SYSMIS).
RECODE I10_NPR                  (-9 -8 -6 -5=SYSMIS).
RECODE I10_UNCBRTH              (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE LOS                      (-9999 -8888 -6666=SYSMIS).
RECODE MDC                      (-9 -8 -6 -5=SYSMIS).
RECODE MDC_NoPOA                (-9 -8 -6 -5=SYSMIS).
RECODE PAY1                     (-9 -8 -6 -5=SYSMIS).
RECODE PL_NCHS                  (-99 -88 -66=SYSMIS).
RECODE PRDAY1                   (-99 -88 -66=SYSMIS).
RECODE PRDAY2                   (-99 -88 -66=SYSMIS).
RECODE PRDAY3                   (-99 -88 -66=SYSMIS).
RECODE PRDAY4                   (-99 -88 -66=SYSMIS).
RECODE PRDAY5                   (-99 -88 -66=SYSMIS).
RECODE PRDAY6                   (-99 -88 -66=SYSMIS).
RECODE PRDAY7                   (-99 -88 -66=SYSMIS).
RECODE PRDAY8                   (-99 -88 -66=SYSMIS).
RECODE PRDAY9                   (-99 -88 -66=SYSMIS).
RECODE PRDAY10                  (-99 -88 -66=SYSMIS).
RECODE PRDAY11                  (-99 -88 -66=SYSMIS).
RECODE PRDAY12                  (-99 -88 -66=SYSMIS).
RECODE PRDAY13                  (-99 -88 -66=SYSMIS).
RECODE PRDAY14                  (-99 -88 -66=SYSMIS).
RECODE PRDAY15                  (-99 -88 -66=SYSMIS).
RECODE PRVER                    (-9 -8 -6 -5=SYSMIS).
RECODE RACE                     (-9 -8 -6 -5=SYSMIS).
RECODE TOTCHG                   (-999999999 -888888888 -666666666=SYSMIS).
RECODE TRAN_IN                  (-9 -8 -6 -5=SYSMIS).
RECODE TRAN_OUT                 (-9 -8 -6 -5=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).
RECODE ZIPINC_QRTL              (-9 -8 -6 -5=SYSMIS).

SAVE OUTFILE = 'KID_2016_Core.SAV' / COMPRESSED.
