/*****************************************************************************
* SPSSload_KID_2012_Hospital.SPS
* This program will load the 2012 KID ASCII Hospital File into SPSS.
*****************************************************************************/

*** Read data elements from the ASCII file ***.
DATA LIST FILE = 'KID_2012_Hospital.ASC' FIXED / 
    HOSP_KID                   1-  5
    HOSP_BEDSIZE               6-  7
    HOSP_DIVISION              8-  9
    HOSP_LOCTEACH             10- 11
    HOSP_REGION               12- 13
    H_CONTRL                  14- 15
    KID_STRATUM               16- 19
    N_BRTH_U                  20- 27
    N_DISC_U                  28- 35
    N_HOSP_U                  36- 39
    S_BRTH_U                  40- 47
    S_CHLD_U                  48- 55
    S_CMPB_U                  56- 63
    S_DISC_U                  64- 71
    S_HOSP_U                  72- 75
    S_UNCB_U                  76- 83
    YEAR                      84- 87.

***  Specify write formats  ***.
FORMATS
    HOSP_KID                 (F5.0) /
    HOSP_BEDSIZE             (F2.0) /
    HOSP_DIVISION            (F2.0) /
    HOSP_LOCTEACH            (F2.0) /
    HOSP_REGION              (F2.0) /
    H_CONTRL                 (F2.0) /
    KID_STRATUM              (F4.0) /
    N_BRTH_U                 (F8.0) /
    N_DISC_U                 (F8.0) /
    N_HOSP_U                 (F4.0) /
    S_BRTH_U                 (F8.0) /
    S_CHLD_U                 (F8.0) /
    S_CMPB_U                 (F8.0) /
    S_DISC_U                 (F8.0) /
    S_HOSP_U                 (F4.0) /
    S_UNCB_U                 (F8.0) /
    YEAR                     (F4.0) .

***  Assign labels to the data elements ***.
VARIABLE LABELS 
    HOSP_KID                 "KID hospital number"
    HOSP_BEDSIZE             "Bedsize of hospital"
    HOSP_DIVISION            "Census division of hospital"
    HOSP_LOCTEACH            "Location/teaching status of hospital"
    HOSP_REGION              "Region of hospital"
    H_CONTRL                 "Control/ownership of hospital"
    KID_STRATUM              "KID hospital stratum"
    N_BRTH_U                 "Number of universe births in the stratum"
    N_DISC_U                 "Number of universe discharges in the stratum"
    N_HOSP_U                 "Number of universe hospitals in the stratum"
    S_BRTH_U                 "Number of sample births in the stratum"
    S_CHLD_U                 "Number of sample pediatric non-births in the stratum"
    S_CMPB_U                 "Number of sample complicated births in the stratum"
    S_DISC_U                 "Number of sample births and children in the stratum"
    S_HOSP_U                 "Number of sample hospitals in the stratum"
    S_UNCB_U                 "Number of sample uncomplicated births in the stratum"
    YEAR                     "Calendar year" .

*** Convert special values to system missing values ***.
RECODE HOSP_KID                 (-9999 -8888 -6666=SYSMIS).
RECODE HOSP_BEDSIZE             (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_DIVISION            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_LOCTEACH            (-9 -8 -6 -5=SYSMIS).
RECODE HOSP_REGION              (-9 -8 -6 -5=SYSMIS).
RECODE H_CONTRL                 (-9 -8 -6 -5=SYSMIS).
RECODE KID_STRATUM              (-999 -888 -666=SYSMIS).
RECODE N_BRTH_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE N_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_BRTH_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_CHLD_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_CMPB_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_DISC_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE S_HOSP_U                 (-999 -888 -666=SYSMIS).
RECODE S_UNCB_U                 (-9999999 -8888888 -6666666=SYSMIS).
RECODE YEAR                     (-999 -888 -666=SYSMIS).

SAVE OUTFILE = 'KID_2012_Hospital.SAV' / COMPRESSED.
